/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account.hzsb;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.formplugin.account.AbstractAccountingPlugin;

public class HzRolloutFormPlugin
extends AbstractAccountingPlugin
implements HyperLinkClickListener,
TreeNodeQueryListener {
    private static final String treeentryentity = "treeentryentity";
    private static final String FIELD_ACCOUNTING = "accountingamount";
    private static final String FIELD_JZJT_ROLLOUT_AMOUNT = "jzjtrolloutamount";

    public void registerListener(EventObject e) {
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(treeentryentity);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addCellClickListener((TreeNodeQueryListener)this);
    }

    public void initialize() {
        super.initialize();
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(treeentryentity);
        entryGrid.addPackageDataListener(this::packageData);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParams);
        DraftMetaDataInfo rollOut = metaData.getRollOut();
        Object orgid = customParams.get("orgid");
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid.toString()));
        QFilter taxPeriodFilter = new QFilter("startdate", "=", (Object)skssqq).and(new QFilter("enddate", "=", (Object)skssqz));
        QFilter pidFilter = new QFilter("pid", "=", (Object)0);
        QFilter taxpayertypeFilter = new QFilter("taxpayertype", "=", customParams.get("taxpayertype"));
        IDataModel model = this.getModel();
        DynamicObject[] genericObjects = BusinessDataServiceHelper.load((String)rollOut.getAccountMetaDataName(), (String)"id,pid,org,suborg,levelname,declaretype,serialno,rollouttype,description,accountingamount,jzjt,jzjtrolloutamount,startdate,enddate", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, pidFilter, taxpayertypeFilter}, (String)"levelname, suborg,rollouttype");
        if (genericObjects.length > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow(treeentryentity, genericObjects.length);
            int rowIndex = 0;
            for (DynamicObject dynamicObject : genericObjects) {
                model.setValue("id", dynamicObject.get("id"), rowIndex);
                model.setValue("org", dynamicObject.get("org"), rowIndex);
                model.setValue("suborg", dynamicObject.get("suborg"), rowIndex);
                model.setValue("levelname", dynamicObject.get("levelname"), rowIndex);
                model.setValue("declaretype", dynamicObject.get("declaretype"), rowIndex);
                model.setValue("taxperiod", (Object)dynamicObject.getDate("startdate"), rowIndex);
                model.setValue("serialno", dynamicObject.get("serialno"), rowIndex);
                model.setValue("rollouttype", dynamicObject.get("rollouttype"), rowIndex);
                model.setValue("description", dynamicObject.get("description"), rowIndex);
                model.setValue(FIELD_ACCOUNTING, dynamicObject.get(FIELD_ACCOUNTING), rowIndex);
                model.setValue("jzjt", dynamicObject.get("jzjt"), rowIndex);
                model.setValue(FIELD_JZJT_ROLLOUT_AMOUNT, dynamicObject.get(FIELD_JZJT_ROLLOUT_AMOUNT), rowIndex);
                this.markEditCell(model, rowIndex, treeentryentity);
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView(treeentryentity);
        }
        this.getView().setVisible(Boolean.valueOf("zzsybnsr_ybhz".equals(customParams.get("taxpayertype"))), new String[]{"suborg", "declaretype", "orgname"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"taxperiod"});
        boolean readonly = (Boolean)this.getView().getFormShowParameter().getCustomParam("readonly");
        if (readonly) {
            this.getView().setEnable(Boolean.FALSE, new String[]{treeentryentity});
        }
        super.afterCreateData("");
    }

    public void packageData(PackageDataEvent e) {
        if (e.getSource() instanceof DecimalEdit && FIELD_JZJT_ROLLOUT_AMOUNT.equals(((DecimalEdit)e.getSource()).getKey()) && "0".equals(e.getRowData().get("jzjt"))) {
            e.getNoLinkKey().add(((DecimalEdit)e.getSource()).getFieldKey());
        }
    }

    @Override
    protected String getEntityName() {
        return treeentryentity;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String serialno = (String)this.getModel().getValue("serialno", rowIndex);
        String fieldName = evt.getFieldName();
        DynamicObject suborg = (DynamicObject)this.getModel().getValue("suborg", rowIndex);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        Map customParamMap = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParamMap);
        DraftMetaDataInfo rollOut = metaData.getRollOut();
        customParams.put("draftnumber", customParamMap.get("draftnumber"));
        customParams.put("billstatus", customParamMap.get("billstatus"));
        customParams.put("orgid", suborg.get("id"));
        customParams.put("mainorgid", customParamMap.get("orgid"));
        customParams.put("taxpayertype", customParamMap.get("taxpayertype"));
        customParams.put("updateDraft", rollOut.getAccountMetaDataName());
        customParams.put("id", this.getModel().getValue("id", rowIndex));
        customParams.put("description", this.getModel().getValue("description", rowIndex));
        customParams.put("fieldName", fieldName);
        customParams.put("amount", this.getModel().getValue(fieldName, rowIndex));
        customParams.put("taxaccountserialno", serialno);
        customParams.put("drafttype", customParamMap.get("drafttype"));
        customParams.put("draftpurpose", customParamMap.get("draftpurpose"));
        if (FIELD_ACCOUNTING.equals(fieldName)) {
            customParams.put("entry", rollOut.getDetailMetaDataNameMap().get(DraftConstant.YBHZ_ACCOUNTING_DETAIL));
            customParams.put("customCaption", ResManager.loadKDString((String)"\u8fdb\u9879\u8f6c\u51fa\u89c4\u5219\u53d6\u6570\u7ed3\u679c", (String)"HzRolloutFormPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            customParams.put("cellName", ResManager.loadKDString((String)"\u8f6c\u51fa\u7a0e\u989d", (String)"HzRolloutFormPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            customParams.put("jzjt", "");
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcvat_income_invoice_tab", (IFormView)this.getView(), customParams, (IFormPlugin)this);
        } else if (FIELD_JZJT_ROLLOUT_AMOUNT.equals(fieldName)) {
            String jzjt = (String)this.getModel().getValue("jzjt", rowIndex);
            customParams.put("entry", rollOut.getDetailMetaDataNameMap().get(DraftConstant.YBHZ_ACCOUNTING_DETAIL));
            customParams.put("customCaption", ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u8fdb\u9879\u8f6c\u51fa\u989d\u660e\u7ec6", (String)"HzRolloutFormPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            customParams.put("cellName", ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u8f6c\u51fa\u989d", (String)"HzRolloutFormPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
            customParams.put("jzjt", jzjt);
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcvat_income_invoice_tab", (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
    }
}

