/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account.hzsb;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcvat.business.service.account.hzsb.WaitDeductionFormService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.formplugin.account.AbstractAccountingPlugin;

public class HzWaitDeductionFormPlugin
extends AbstractAccountingPlugin
implements HyperLinkClickListener {
    private static final String TREEENTRYENTITY = "treeentryentity";
    private static final String DRAFT_TYPE = "drafttype";
    private static final String ORG_ID = "orgid";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String DEDUCTION_TYPE = "deductiontype";
    private static final String SERIAL_NO = "serialno";
    private static final String COUNT = "count";
    private static final String AMOUNT = "amount";
    private static final String TAX_AMOUNT = "taxamount";
    private WaitDeductionFormService waitDeductionFormService = new WaitDeductionFormService();

    public void registerListener(EventObject e) {
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        entryGrid.summary();
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParams);
        DraftMetaDataInfo waitDeduction = metaData.getWaitDeduction();
        Object orgid = customParams.get(ORG_ID);
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid.toString()));
        QFilter startDateFilter = new QFilter(START_DATE, ">=", (Object)DateUtils.getDayFirst((Date)skssqq));
        QFilter endDateFilter = new QFilter(END_DATE, "<=", (Object)DateUtils.getDayLast((Date)skssqz));
        QFilter taxpayertypeFilter = new QFilter("taxpayertype", "=", customParams.get("taxpayertype"));
        IDataModel model = this.getModel();
        DynamicObjectCollection genericObjects = QueryServiceHelper.query((String)waitDeduction.getAccountMetaDataName(), (String)MetadataUtil.getAllFieldToQuery((String)waitDeduction.getAccountMetaDataName()), (QFilter[])new QFilter[]{orgFilter, startDateFilter, endDateFilter, taxpayertypeFilter}, (String)DEDUCTION_TYPE);
        List summary = genericObjects.stream().filter(obj -> {
            QFilter qFilter = new QFilter("taxaccountserialno", "=", (Object)obj.getString(SERIAL_NO));
            return QueryServiceHelper.exists((String)waitDeduction.getDetailMetaDataNameMap().get(DraftConstant.YBHZ_HZ_WAIT_DEDUCT_DET), (QFilter[])new QFilter[]{qFilter});
        }).collect(Collectors.toList());
        QFilter ddkFilter = new QFilter("group.number", "=", (Object)"VAT_JXDK_DDK");
        DynamicObjectCollection bizDef = QueryServiceHelper.query((String)"tpo_tcvat_bizdef", (String)"id", (QFilter[])new QFilter[]{ddkFilter});
        Set waitDeductSet = bizDef.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        if (summary.size() > 0) {
            int rowIndex = 0;
            model.beginInit();
            for (DynamicObject dynamicObject : summary) {
                long deductionTypeId = dynamicObject.getLong(DEDUCTION_TYPE);
                if (!waitDeductSet.contains(deductionTypeId)) continue;
                model.createNewEntryRow(TREEENTRYENTITY);
                model.setValue("id", dynamicObject.get("id"), rowIndex);
                model.setValue("org", dynamicObject.get("org"), rowIndex);
                model.setValue(SERIAL_NO, dynamicObject.get(SERIAL_NO), rowIndex);
                model.setValue(DEDUCTION_TYPE, (Object)deductionTypeId, rowIndex);
                Object count = dynamicObject.get(COUNT);
                Object amount = dynamicObject.get(AMOUNT);
                Object taxamount = dynamicObject.get(TAX_AMOUNT);
                model.setValue(COUNT, count, rowIndex);
                model.setValue(AMOUNT, amount, rowIndex);
                model.setValue(TAX_AMOUNT, taxamount, rowIndex);
                this.markEditCell(model, rowIndex, TREEENTRYENTITY);
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView(TREEENTRYENTITY);
        }
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        treeEntryGrid.setCollapse(true);
        boolean readonly = (Boolean)this.getView().getFormShowParameter().getCustomParam("readonly");
        if (readonly) {
            this.getView().setEnable(Boolean.FALSE, new String[]{TREEENTRYENTITY});
        }
        super.afterCreateData(null);
    }

    @Override
    protected String getEntityName() {
        return TREEENTRYENTITY;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String entryKey = ((EntryGrid)evt.getSource()).getEntryKey();
        int rowIndex = evt.getRowIndex();
        DynamicObject selectedRow = this.getModel().getEntryRowEntity(entryKey, rowIndex);
        String fieldName = evt.getFieldName();
        Map customParamMap = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParamMap);
        DraftMetaDataInfo waitDeduction = metaData.getWaitDeduction();
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        long deductiontype = selectedRow.getDynamicObject(DEDUCTION_TYPE).getLong("id");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tpo_tcvat_bizdef", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)deductiontype)});
        customParams.put("draftpurpose", customParamMap.get("draftpurpose"));
        customParams.put("updateDraft", waitDeduction.getAccountMetaDataName());
        customParams.put(ORG_ID, customParamMap.get(ORG_ID));
        customParams.put("id", this.getModel().getValue("id", rowIndex));
        customParams.put("fieldName", fieldName);
        customParams.put("type", fieldName);
        customParams.put("draftnumber", customParamMap.get("draftnumber"));
        customParams.put("billstatus", customParamMap.get("billstatus"));
        customParams.put("description", dynamicObject.getString("name"));
        customParams.put(AMOUNT, this.getModel().getValue(fieldName, rowIndex));
        customParams.put(DRAFT_TYPE, customParamMap.get(DRAFT_TYPE));
        customParams.put("taxpayertype", customParamMap.get("taxpayertype"));
        customParams.put("entry", waitDeduction.getDetailMetaDataNameMap().get(DraftConstant.YBHZ_HZ_WAIT_DEDUCT_DET));
        customParams.put("taxaccountserialno", selectedRow.getString(SERIAL_NO));
        customParams.put(DEDUCTION_TYPE, deductiontype);
        customParams.put("cellName", this.waitDeductionFormService.getCellName(fieldName));
        customParams.put("customCaption", String.format(ResManager.loadKDString((String)"%s\u660e\u7ec6\u5217\u8868", (String)"HzWaitDeductionFormPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]), dynamicObject.getString("name")));
        PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcvat_income_invoice_tab", (IFormView)this.getView(), customParams, (IFormPlugin)this);
    }
}

