/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account.hzsb;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.constant.TaxRateConstant;
import kd.taxc.bdtaxr.common.taxdeclare.engine.PartitionSaveTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.utils.IncomeUtils;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.constant.RuleSettingConstant;
import kd.taxc.tcvat.formplugin.account.AbstractAccountingPlugin;

public class YbHzIncomeFormPlugin
extends AbstractAccountingPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParams);
        String orgid = (String)customParams.get("orgid");
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        QFilter SkssqFilter = new QFilter("startdate", "=", (Object)skssqq).and(new QFilter("enddate", "=", (Object)skssqz));
        QFilter taxpayertypeFilter = new QFilter("taxpayertype", "=", customParams.get("taxpayertype"));
        IDataModel model = this.getModel();
        DynamicObject[] genericObjects = BusinessDataServiceHelper.load((String)metaData.getIncome().getAccountMetaDataName(), (String)MetadataUtil.getAllSubFieldString((String)metaData.getIncome().getAccountMetaDataName()), (QFilter[])new QFilter[]{orgFilter, SkssqFilter, taxpayertypeFilter}, (String)"levelname, suborg");
        ArrayList strings = Lists.newArrayList((Object[])new String[]{TaxRateConstant.getExcludeTaxCN(), TaxRateConstant.getExportMsTaxCN(), TaxRateConstant.getExportTsTaxCN()});
        if (genericObjects.length > 0) {
            List<DynamicObject> collect = Arrays.stream(genericObjects).sorted((o1, o2) -> {
                Long o2sub;
                DynamicObject o1Object = o1.getDynamicObject("suborg");
                DynamicObject o2Object = o2.getDynamicObject("suborg");
                Long o1sub = o1Object.getLong("id");
                return o1sub.compareTo(o2sub = Long.valueOf(o2Object.getLong("id"))) == 0 ? (o1.getString("taxmethod").compareTo(o2.getString("taxmethod")) == 0 ? o1.getString("taxrate").compareTo(o2.getString("taxrate")) : o1.getString("taxmethod").compareTo(o2.getString("taxmethod"))) : (o2.getString("levelname").compareTo(o1.getString("levelname")) == 0 ? o1sub.compareTo(o2sub) : o1.getString("levelname").compareTo(o2.getString("levelname")));
            }).collect(Collectors.toList());
            Map<String, Long> serialnoMap = this.getDetailSerialnoMap(collect);
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", genericObjects.length);
            int rowIndex = 0;
            for (DynamicObject dynamicObject : collect) {
                model.setValue("id", dynamicObject.get("id"), rowIndex);
                model.setValue("suborg", (Object)dynamicObject.getDynamicObject("suborg").getLong("id"), rowIndex);
                model.setValue("org", (Object)serialnoMap.get(dynamicObject.getString("serialno")), rowIndex);
                QFilter qFilter = new QFilter("org", "=", (Object)dynamicObject.getDynamicObject("suborg").getLong("id"));
                DynamicObjectCollection taxpayers = QueryServiceHelper.query((String)"bastax_taxorg", (String)"taxpayer", (QFilter[])new QFilter[]{qFilter});
                model.setValue("suborgname", (Object)((DynamicObject)taxpayers.get(0)).getString("taxpayer"), rowIndex);
                model.setValue("levelname", (Object)dynamicObject.getString("levelname"), rowIndex);
                model.setValue("declaretype", (Object)dynamicObject.getString("declaretype"), rowIndex);
                model.setValue("serialno", dynamicObject.get("serialno"), rowIndex);
                model.setValue("jzjt", dynamicObject.get("jzjt"), rowIndex);
                model.setValue("description", dynamicObject.get("description"), rowIndex);
                model.setValue("taxamount", dynamicObject.get("taxamount"), rowIndex);
                model.setValue("accountingamount", dynamicObject.get("accountingamount"), rowIndex);
                model.setValue("invoiceamount", dynamicObject.get("invoiceamount"), rowIndex);
                model.setValue("businessamount", dynamicObject.get("businessamount"), rowIndex);
                model.setValue("taxmethod", dynamicObject.get("taxmethod"), rowIndex);
                if (strings.contains(dynamicObject.getString("taxmethod"))) {
                    model.setValue("taxrate", (Object)TaxRateConstant.getNullDataString(), rowIndex);
                } else {
                    model.setValue("taxrate", dynamicObject.get("taxrate"), rowIndex);
                }
                model.setValue("specialinvoiceamount", dynamicObject.get("specialinvoiceamount"), rowIndex);
                model.setValue("specialtaxamount", dynamicObject.get("specialtaxamount"), rowIndex);
                model.setValue("otherinvoiceamount", dynamicObject.get("otherinvoiceamount"), rowIndex);
                model.setValue("othertaxamount", dynamicObject.get("othertaxamount"), rowIndex);
                model.setValue("initnoneinvoiceamount", dynamicObject.get("initaccountingamount"), rowIndex);
                model.setValue("noneinvoiceamount", dynamicObject.get("accountingamount"), rowIndex);
                model.setValue("nonetaxamount", dynamicObject.get("nonetaxamount"), rowIndex);
                model.setValue("totaltaxamount", dynamicObject.get("totaltaxamount"), rowIndex);
                model.setValue("pricetaxamount", dynamicObject.get("pricetaxamount"), rowIndex);
                model.setValue("totalinvoiceamount", dynamicObject.get("taxamount"), rowIndex);
                model.setValue("ruleid", dynamicObject.get("ruleid"), rowIndex);
                this.markEditCell(model, rowIndex, "entryentity");
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
        super.afterCreateData(null);
    }

    public Map<String, Long> getDetailSerialnoMap(List<DynamicObject> collect) {
        DynamicObjectCollection query2;
        HashMap<String, Long> result = new HashMap<String, Long>();
        Set serialnoSet = collect.stream().map(e -> e.getString("serialno")).collect(Collectors.toSet());
        DynamicObjectCollection query1 = QueryServiceHelper.query((String)DraftConstant.YBHZ_HZ_ACCOUNTING_DETAIL, (String)"taxaccountserialno,suborg", (QFilter[])new QFilter[]{new QFilter("taxaccountserialno", "in", serialnoSet)});
        if (query1 != null && query1.size() > 0) {
            result.putAll(query1.stream().collect(Collectors.toMap(k -> k.getString("taxaccountserialno"), v -> v.getLong("suborg"), (m, n) -> m)));
        }
        if ((query2 = QueryServiceHelper.query((String)DraftConstant.YBHZ_HZ_INVOICE_DETAIL, (String)"taxaccountserialno,suborg", (QFilter[])new QFilter[]{new QFilter("taxaccountserialno", "in", serialnoSet)})) != null && query2.size() > 0) {
            result.putAll(query2.stream().collect(Collectors.toMap(k -> k.getString("taxaccountserialno"), v -> v.getLong("suborg"), (m, n) -> m)));
        }
        return result;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String serialno = (String)this.getModel().getValue("serialno", rowIndex);
        Long ruleid = (Long)this.getModel().getValue("ruleid", rowIndex);
        DynamicObject suborg = (DynamicObject)this.getModel().getValue("suborg", rowIndex);
        String fieldName = evt.getFieldName();
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        Map customParamMap = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParamMap);
        customParams.put("draftpurpose", customParamMap.get("draftpurpose"));
        customParams.put("draftnumber", customParamMap.get("draftnumber"));
        customParams.put("billstatus", customParamMap.get("billstatus"));
        customParams.put("orgid", suborg.getLong("id"));
        customParams.put("mainorgid", customParamMap.get("orgid"));
        customParams.put("taxpayertype", customParamMap.get("taxpayertype"));
        customParams.put("updateDraft", metaData.getIncome().getAccountMetaDataName());
        customParams.put("id", this.getModel().getValue("id", rowIndex));
        customParams.put("description", this.getModel().getValue("description", rowIndex));
        customParams.put("fieldName", fieldName);
        customParams.put("amount", this.getModel().getValue(fieldName, rowIndex));
        customParams.put("taxaccountserialno", serialno);
        customParams.put("drafttype", customParamMap.get("drafttype"));
        customParams.put("entry", DraftConstant.YBHZ_HZ_ACCOUNTING_DETAIL);
        DynamicObject rule = BusinessDataServiceHelper.loadSingle((Object)ruleid, (String)RuleTypeEnum.INCOME.getEntry());
        customParams.put("invoiceseqs", rule != null && rule.getBoolean("invoiceseqs") ? "true" : "false");
        customParams.put("wkpseqs", rule != null && rule.getBoolean("wkpseqs") ? "true" : "false");
        customParams.put("qtfpseqs", rule != null && rule.getBoolean("qtfpseqs") ? "true" : "false");
        switch (fieldName) {
            case "specialinvoiceamount": {
                customParams.put("customCaption", ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u4e0d\u542b\u7a0e\u9500\u552e\u989d\u53d6\u6570\u660e\u7ec6\u5217\u8868", (String)"IncomeFormPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("cellName", ResManager.loadKDString((String)"\u9500\u552e\u989d", (String)"IncomeFormPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("type", RuleSettingConstant.GET_DATE_TYPE_ZYSR);
                customParams.put("entry", DraftConstant.YBHZ_HZ_INVOICE_DETAIL);
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcvat_income_invoice_tab", (IFormView)this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "specialtaxamount": {
                customParams.put("customCaption", ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u7a0e\u989d\u53d6\u6570\u660e\u7ec6\u5217\u8868", (String)"IncomeFormPlugin_00", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("cellName", ResManager.loadKDString((String)"\u7a0e\u989d", (String)"IncomeFormPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("type", RuleSettingConstant.GET_DATE_TYPE_ZYSE);
                customParams.put("entry", DraftConstant.YBHZ_HZ_INVOICE_DETAIL);
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcvat_income_invoice_tab", (IFormView)this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "otherinvoiceamount": {
                customParams.put("customCaption", ResManager.loadKDString((String)"\u5f00\u5177\u5176\u4ed6\u53d1\u7968\u9500\u552e\u989d\u53d6\u6570\u660e\u7ec6\u5217\u8868", (String)"YbHzIncomeFormPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("cellName", ResManager.loadKDString((String)"\u9500\u552e\u989d", (String)"YbHzIncomeFormPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("type", RuleSettingConstant.GET_DATE_TYPE_QTSR);
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcvat_income_invoice_tab", (IFormView)this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "othertaxamount": {
                customParams.put("customCaption", ResManager.loadKDString((String)"\u5f00\u5177\u5176\u4ed6\u53d1\u7968\u7a0e\u989d\u53d6\u6570\u660e\u7ec6\u5217\u8868", (String)"YbHzIncomeFormPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("cellName", ResManager.loadKDString((String)"\u7a0e\u989d", (String)"YbHzIncomeFormPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("type", RuleSettingConstant.GET_DATE_TYPE_QTSE);
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcvat_income_invoice_tab", (IFormView)this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "noneinvoiceamount": {
                customParams.put("customCaption", ResManager.loadKDString((String)"\u672a\u5f00\u7968\u9500\u552e\u989d\u53d6\u6570\u660e\u7ec6\u5217\u8868", (String)"YbHzIncomeFormPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("cellName", ResManager.loadKDString((String)"\u9500\u552e\u989d", (String)"YbHzIncomeFormPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("fieldName", "noneinvoiceamount");
                customParams.put("type", RuleSettingConstant.GET_DATE_TYPE_WKPSR);
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcvat_income_invoice_tab", (IFormView)this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "nonetaxamount": {
                customParams.put("customCaption", ResManager.loadKDString((String)"\u672a\u5f00\u7968\u7a0e\u989d\u53d6\u6570\u660e\u7ec6\u5217\u8868", (String)"YbHzIncomeFormPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("cellName", ResManager.loadKDString((String)"\u7a0e\u989d", (String)"YbHzIncomeFormPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("type", RuleSettingConstant.GET_DATE_TYPE_WKPSE);
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcvat_income_invoice_tab", (IFormView)this.getView(), customParams, (IFormPlugin)this);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("tcvat_income_invoice_tab".endsWith(actionId)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParams);
            String orgidStr = (String)customParams.get("orgid");
            String skssqqStr = (String)customParams.get("skssqq");
            String skssqzStr = (String)customParams.get("skssqz");
            Date skssqq = DateUtils.stringToDate((String)skssqqStr);
            Date skssqz = DateUtils.stringToDate((String)skssqzStr);
            Object deadLine = customParams.get("deadLine");
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgidStr));
            QFilter deadLineFilter = new QFilter("deadline", "=", (Object)(deadLine == null ? "" : deadLine));
            QFilter startdateFilter = new QFilter("startdate", "=", (Object)skssqq);
            QFilter enddateFilter = new QFilter("enddate", "=", (Object)skssqz);
            DynamicObjectCollection genericObjects = QueryServiceHelper.query((String)metaData.getIncome().getAccountMetaDataName(), (String)MetadataUtil.getAllFieldToQuery((String)metaData.getIncome().getAccountMetaDataName()), (QFilter[])new QFilter[]{orgFilter, startdateFilter, enddateFilter});
            if (genericObjects.size() > 0) {
                List<DynamicObject> groupSummaryDataList;
                TcvatEngineModel model = new TcvatEngineModel(orgidStr, skssqqStr, skssqzStr);
                model.getCustom().put("skssqq", skssqq);
                model.getCustom().put("skssqz", skssqz);
                model.getCustom().put("taxPayerType", customParams.get("taxpayertype"));
                model.getCustom().put("deadLine", customParams.get("deadLine"));
                String taxpayerType = (String)customParams.get("taxpayertype");
                QFilter taxPayerTypeFilter = new QFilter("taxpayertype", "in", Arrays.asList(taxpayerType, taxpayerType.replace("zzs", "")));
                model.setDraftMetaDataDTO(DraftMetaDataDTO.getMetaData((String)customParams.get("draftpurpose"), taxpayerType));
                if (taxpayerType != null) {
                    if (taxpayerType.contains("ybnsr")) {
                        DeleteServiceHelper.delete((String)metaData.getIncome().getDetailMetaDataNameMap().get(DraftConstant.YBHZ_HZ_TAX_DEDUCTION_SUM), (QFilter[])new QFilter[]{orgFilter, startdateFilter, enddateFilter, taxPayerTypeFilter});
                    } else {
                        DeleteServiceHelper.delete((String)metaData.getIncome().getDetailMetaDataNameMap().get(DraftConstant.YBHZ_HZ_TAX_DEDUCTION_SUM), (QFilter[])new QFilter[]{orgFilter, startdateFilter, enddateFilter, taxPayerTypeFilter, deadLineFilter});
                    }
                }
                if (!(groupSummaryDataList = IncomeUtils.groupSummaryData(Long.parseLong(orgidStr), model, (List<DynamicObject>)genericObjects)).isEmpty()) {
                    ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(groupSummaryDataList));
                }
            }
        }
    }
}

