/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account.wfrecord;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class AccInvCompareResultListPlugin
extends AbstractListPlugin {
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("bos_org".equals(args.getRefEntityId())) {
            TaxResult listTaxResult = TaxcMainDataServiceHelper.queryTaxcMainOrgIds();
            args.getCustomQFilters().add(new QFilter("id", "in", listTaxResult.getData()));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List cmmFilters = args.getCommonFilterColumns();
        for (FilterColumn cmmFilter : cmmFilters) {
            String fieldName = cmmFilter.getFieldName();
            if (!"org.id".equals(fieldName)) continue;
            cmmFilter.setDefaultValue(null);
        }
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if ("startdate".equals(columnDesc.getKey())) {
            String date = DateUtils.getStartToEndDate((Date)data.getDate("startdate"), (Date)data.getDate("enddate"), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            e.setFormatValue((Object)date);
        } else if ("wfstartdate".equals(columnDesc.getKey())) {
            String date = DateUtils.getStartToEndDate((Date)data.getDate("wfstartdate"), (Date)data.getDate("wfenddate"), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            e.setFormatValue((Object)date);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("exportsheet".equals(operateKey) && operationResult != null && operationResult.isSuccess()) {
            if (StringUtils.isBlank((CharSequence)operationResult.getMessage())) {
                String url = (String)operationResult.getInteractionContext().getCustShowParameter().get("url");
                if (StringUtils.isNotBlank((CharSequence)url)) {
                    this.getView().openUrl(url);
                }
            } else {
                this.getView().showTipNotification(operationResult.getMessage());
            }
        }
    }
}

