/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account.wfrecord;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.TaxDeclarationService;
import kd.taxc.tcvat.business.service.wfrecord.TcvatWfRecordService;
import kd.taxc.tcvat.common.dto.wfrecord.AccInvCompareResultDto;
import kd.taxc.tcvat.common.util.ZzsOrgCheckUtil;

public class InAccInvCompareResultPlugin
extends AbstractBillPlugIn {
    private static final String SAVE = "save";
    private static final String ORG = "org";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String DATACHANGE = "datachange";
    private static final String WRITEOFFTYPEID = "writeofftypeid";
    private static final String WF_START_DATE = "wfstartdate";
    private static final String WF_END_DATE = "wfenddate";
    private static final String ENTRYENTITY = "entryentity";
    private static final String TCVAT_ACC_INV_COMP = "tcvat_in_accinv_comp";
    private TcvatWfRecordService service = new TcvatWfRecordService();

    public void afterCreateNewData(EventObject e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org == null) {
            Long orgId = RequestContext.get().getOrgId();
            TaxResult taxcMainByOrgId = TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)orgId);
            if (Boolean.TRUE.equals(taxcMainByOrgId.getData())) {
                this.getModel().setValue(ORG, (Object)orgId);
            } else {
                TaxResult orgIdTaxResult = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId());
                List orgIdList = (List)orgIdTaxResult.getData();
                Long orgid = null;
                for (Long id : orgIdList) {
                    String failInfo = ZzsOrgCheckUtil.checkOrg(id.toString(), TCVAT_ACC_INV_COMP);
                    if (!StringUtils.isBlank((CharSequence)failInfo)) continue;
                    orgid = id;
                }
                this.getModel().setValue(ORG, orgid);
            }
            org = (DynamicObject)this.getModel().getValue(ORG);
        } else {
            String failInfo = ZzsOrgCheckUtil.checkOrg(org.getString("id"), TCVAT_ACC_INV_COMP);
            if (StringUtils.isNotBlank((CharSequence)failInfo)) {
                this.getView().showErrorNotification(failInfo);
                this.getModel().setValue(ORG, null);
                org = null;
            }
        }
        if (org != null) {
            this.initPeriod(org.getString("id"));
        } else {
            this.initPeriod(null);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (START_DATE.equals(name) || END_DATE.equals(name)) {
            this.invalidData();
            this.getPageCache().put(DATACHANGE, "1");
        } else if (WRITEOFFTYPEID.equals(name) || WF_START_DATE.equals(name) || WF_END_DATE.equals(name)) {
            this.getPageCache().put(DATACHANGE, "1");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String dataChange;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (SAVE.equals(operateKey) && StringUtils.isNotBlank((CharSequence)(dataChange = this.getPageCache().get(DATACHANGE)))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5934\u5b57\u6bb5\u6709\u66f4\u6539\uff0c\u8bf7\u70b9\u51fb\u751f\u6210\u7ed3\u679c\u6309\u94ae\u540e\u518d\u4fdd\u5b58\u3002", (String)"InAccInvCompareResultPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if ("generate".equals(operateKey) && result != null && result.isSuccess()) {
            if (this.invalidData()) {
                return;
            }
            AccInvCompareResultDto request = this.buildDto();
            AccInvCompareResultDto dto = this.service.generateInResult(request);
            this.showEntryData(ENTRYENTITY, dto.getEntry());
            this.showEntryData("entryentity1", dto.getEntry1());
            this.showEntryData("entryentity2", dto.getEntry2());
            this.getPageCache().remove(DATACHANGE);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"InAccInvCompareResultPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    private void showEntryData(String entryName, DynamicObjectCollection entryData) {
        if (StringUtils.isBlank((CharSequence)entryName) || entryData == null) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryName);
        DynamicObjectType dot = entryEntity.getDynamicObjectType();
        String suffix = entryName.replace(ENTRYENTITY, "");
        this.getModel().beginInit();
        this.getModel().deleteEntryData(entryName);
        for (DynamicObject entryDatum : entryData) {
            DataEntityPropertyCollection properties = dot.getProperties();
            int index = this.getModel().createNewEntryRow(entryName);
            for (IDataEntityProperty property : properties) {
                String name = property.getName();
                if ("id".equals(name) || "seq".equals(name)) continue;
                if (name.endsWith("_id")) {
                    this.getModel().setValue(name, entryDatum.get(name.replace(suffix, "").replace("_id", "")), index);
                    continue;
                }
                this.getModel().setValue(name, entryDatum.get(name.replace(suffix, "")), index);
            }
        }
        this.getModel().endInit();
        this.getModel().updateCache();
        this.getView().updateView(entryName);
    }

    private AccInvCompareResultDto buildDto() {
        AccInvCompareResultDto request = new AccInvCompareResultDto();
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        request.setOrgId(org.getLong("id"));
        request.setStartDate((Date)this.getModel().getValue(START_DATE));
        request.setEndDate((Date)this.getModel().getValue(END_DATE));
        DynamicObject writeOffType = (DynamicObject)this.getModel().getValue(WRITEOFFTYPEID);
        request.setWriteoffTypeId(writeOffType.getLong("id"));
        request.setWfStartDate((Date)this.getModel().getValue(WF_START_DATE));
        request.setWfEndDate((Date)this.getModel().getValue(WF_END_DATE));
        return request;
    }

    private void initPeriod(String orgId) {
        if (orgId != null) {
            Map<String, Date> periodMap = PeriodService.preTaxPeriod(orgId, new Date());
            Date startDate = periodMap.get("startDate");
            Date endDate = periodMap.get("endDate");
            this.getModel().setValue(START_DATE, (Object)startDate);
            this.getModel().setValue(END_DATE, (Object)DateUtils.trunc((Date)endDate));
        } else {
            this.getModel().setValue(START_DATE, null);
            this.getModel().setValue(END_DATE, null);
        }
    }

    private boolean invalidData() {
        Date startdate = (Date)this.getModel().getValue(START_DATE);
        Date enddate = (Date)this.getModel().getValue(END_DATE);
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org == null || startdate == null || enddate == null) {
            return true;
        }
        String failInfo = ZzsOrgCheckUtil.checkOrg(org.getString("id"), TCVAT_ACC_INV_COMP);
        if (StringUtils.isNotBlank((CharSequence)failInfo)) {
            this.getView().showErrorNotification(failInfo);
            return true;
        }
        boolean nature = TaxDeclarationService.isNature(startdate, enddate);
        if (!nature) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u9700\u4e3a\u6574\u6708\u6216\u6574\u5b63\u5ea6", (String)"InAccInvCompareResultPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            return true;
        }
        String deadLine = TaxDeclareHelper.getDeadLine("nssb", org.getString("id"), startdate, enddate);
        String taxlimit = null;
        if ("aysb".equals(deadLine)) {
            taxlimit = "month";
        }
        if ("ajsb".equals(deadLine)) {
            taxlimit = "season";
        }
        if (!DateUtils.validDateRange((String)taxlimit, (Date)startdate, (Date)enddate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u671f\u95f4\u4e0e\u7f34\u7eb3\u671f\u9650\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InAccInvCompareResultPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
            return true;
        }
        return false;
    }
}

