/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.apphome;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.formplugin.apphome.abstractOrganization.abstractOrganization;

public class InvoiceMonthlyCardPlugin
extends abstractOrganization {
    private static final String RIM_INVOICE_SUM = "rim_invoice_sum";

    @Override
    public void afterCreateNewData(EventObject e) {
        this.setModelData("0");
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"allinvoice", "commoninvoice", "majorinvoice", "labelap4"});
    }

    public void setModelData(String statisticstype) {
        DynamicObject org;
        this.getView().setStatus(OperationStatus.VIEW);
        long orgId = RequestContext.get().getOrgId();
        if (this.getView().getParentView() != null && (org = (DynamicObject)this.getView().getParentView().getModel().getValue("org")) != null) {
            orgId = org.getLong("id");
        }
        QFilter filter = new QFilter("create_date", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)new Date())).and("org", "=", (Object)orgId);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)RIM_INVOICE_SUM, (String)"id", (QFilter[])filter.toArray());
        int receivedEInvoice = 0;
        int unreceivedEInvoice = 0;
        int receivedPaperInvoice = 0;
        int unreceivedPaperInvoice = 0;
        int authedInvoice = 0;
        int unauthedInvoice = 0;
        DynamicObject[] var10 = objs;
        int var11 = objs.length;
        for (int var12 = 0; var12 < var11; ++var12) {
            DynamicObject obj = var10[var12];
            if (ObjectUtils.isEmpty((Object)obj)) continue;
            obj = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)RIM_INVOICE_SUM);
            Long inputType = obj.getLong("input_invoice_type_id");
            int receivedCount = obj.getInt("received_count");
            int unreceivedCount = obj.getInt("unreceive_count");
            int certifiedCount = obj.getInt("certified_count");
            int uncertifiedCount = obj.getInt("uncertified_count");
            Boolean isEInvoice = 961634333825754112L == inputType || 961639304377984000L == inputType || 961642468384760832L == inputType;
            Boolean isSpecialInvoice = 961640097369875456L == inputType;
            Boolean isVATInvoice = 961639304377984000L == inputType || 961640097369875456L == inputType || 961641829533496320L == inputType || 961642468384760832L == inputType;
            if (isEInvoice.booleanValue()) {
                receivedEInvoice += receivedCount;
                unreceivedEInvoice += unreceivedCount;
            }
            if (isSpecialInvoice.booleanValue()) {
                receivedPaperInvoice += receivedCount;
                unreceivedPaperInvoice += unreceivedCount;
            }
            if (!isVATInvoice.booleanValue()) continue;
            authedInvoice += certifiedCount;
            unauthedInvoice += uncertifiedCount;
        }
        this.getModel().setValue("received_einvoice", (Object)receivedEInvoice);
        this.getModel().setValue("unreceived_einvoice", (Object)unreceivedEInvoice);
        this.getModel().setValue("received_paper_invoice", (Object)receivedPaperInvoice);
        this.getModel().setValue("unreceived_paper_invoice", (Object)unreceivedPaperInvoice);
        this.getModel().setValue("authed_invoice", (Object)authedInvoice);
        this.getModel().setValue("unauthed_invoice", (Object)unauthedInvoice);
    }
}

