/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.apphome;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.dao.declare.DeclareReportDao;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.draft.PeriodService;

public class OverviewCardPlugin
extends AbstractFormPlugin {
    private IPageCache parentPageCache;
    private DeclareReportDao declareReportDao = new DeclareReportDao();

    private IPageCache getParentPageCache() {
        if (this.parentPageCache == null) {
            this.parentPageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        }
        return this.parentPageCache;
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection categoryentryentity;
        TaxResult result;
        String orgid = this.getParentPageCache().get("org");
        if (orgid != null && (result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(Long.parseLong(orgid)))).isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData()) && EmptyCheckUtils.isNotEmpty((Object)(categoryentryentity = ((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity")))) {
            Date perioddate;
            DynamicObject dy = (DynamicObject)categoryentryentity.get(0);
            String taxpayertype = dy.getString("taxpayertype");
            String deadline = dy.getString("deadline");
            QFilter typefilter = null;
            if ("xgmnsr".equals(taxpayertype)) {
                this.xgmCardData(orgid);
                return;
            }
            if ("ybnsr".equals(taxpayertype)) {
                typefilter = new QFilter("type", "=", (Object)"zzsybnsr");
            }
            Date startdate = null;
            Date enddate = null;
            Date lastStartdate = null;
            Date lastEnddate = null;
            if ("ajsb".equals(deadline)) {
                perioddate = DateUtils.addMonth((Date)new Date(), (int)-3);
                startdate = DateUtils.getFirstDateOfSeason((Date)perioddate);
                enddate = DateUtils.getLastDateOfSeason((Date)perioddate);
                lastStartdate = DateUtils.getFirstDateOfSeason((Date)DateUtils.addMonth((Date)perioddate, (int)-3));
                lastEnddate = DateUtils.getLastDateOfSeason((Date)DateUtils.addMonth((Date)perioddate, (int)-3));
            } else {
                perioddate = DateUtils.addMonth((Date)new Date(), (int)-1);
                startdate = DateUtils.getFirstDateOfMonth((Date)perioddate);
                enddate = DateUtils.getLastDateOfMonth((Date)perioddate);
                lastStartdate = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)perioddate, (int)-1));
                lastEnddate = DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)perioddate, (int)-1));
            }
            DynamicObject nsrxx = this.declareReportDao.queryNsrxx(orgid, startdate, enddate, typefilter, deadline);
            BigDecimal rate1 = BigDecimal.ZERO.setScale(2);
            BigDecimal taxAmount1 = BigDecimal.ZERO.setScale(2);
            if (nsrxx != null) {
                DynamicObjectCollection ybnsrZb = this.declareReportDao.queryZzsZb(nsrxx.getString("id"));
                BigDecimal ynsehj = ybnsrZb.stream().map(a -> a.getBigDecimal("ynsehj")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal yssr = ybnsrZb.stream().map(a -> a.getBigDecimal("xse")).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (yssr.compareTo(BigDecimal.ZERO) != 0 && (rate1 = ynsehj.multiply(new BigDecimal(100)).divide(yssr, 2, 5)).compareTo(BigDecimal.ZERO) < 0) {
                    rate1 = BigDecimal.ZERO.setScale(2);
                }
                Label sfl = (Label)this.getControl("sfl");
                sfl.setText(rate1 + "%");
                taxAmount1 = ynsehj.divide(new BigDecimal(10000), 2, RoundingMode.HALF_UP);
                Label depreamount = (Label)this.getControl("depre_amount11");
                depreamount.setText(taxAmount1.toString());
                DynamicObject lastNsrxx = this.declareReportDao.queryNsrxx(orgid, lastStartdate, lastEnddate, typefilter, deadline);
                if (lastNsrxx != null) {
                    DynamicObjectCollection ybnsrZblast = this.declareReportDao.queryZzsZb(lastNsrxx.getString("id"));
                    BigDecimal ynsehjlast = ybnsrZblast.stream().map(a -> a.getBigDecimal("ynsehj")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal yssrlast = ybnsrZblast.stream().map(a -> a.getBigDecimal("xse")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal rate2 = BigDecimal.ZERO;
                    if (yssrlast.compareTo(BigDecimal.ZERO) != 0 && (rate2 = ynsehjlast.multiply(new BigDecimal(100)).divide(yssrlast, 2, 5)).compareTo(BigDecimal.ZERO) < 0) {
                        rate2 = BigDecimal.ZERO.setScale(2);
                    }
                    Label tbbd1 = (Label)this.getControl("tbbh1");
                    tbbd1.setText(rate1.subtract(rate2) + "%");
                    BigDecimal taxAmount2 = ynsehjlast.divide(new BigDecimal(10000), 2, RoundingMode.HALF_UP);
                    Label tbbd2 = (Label)this.getControl("tbbh2");
                    String suffix = ResManager.loadKDString((String)"\u4e07\u5143", (String)"OverviewCardPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]);
                    tbbd2.setText(taxAmount1.subtract(taxAmount2) + suffix);
                }
            }
        }
    }

    private void xgmCardData(String orgid) {
        Date preEndDate;
        Date preStartDate;
        Map<String, Date> preMap = PeriodService.getPreTaxPeriod("nssb", orgid, new Date());
        Date startDate = preMap.get("startDate");
        Date endDate = DateUtils.trunc((Date)preMap.get("endDate"));
        String deadLine = TaxDeclareHelper.getDeadLine("nssb", orgid, startDate, endDate);
        QFilter typefilter = new QFilter("type", "=", (Object)"zzsxgmnsr");
        DynamicObject nsrxx = this.declareReportDao.queryNsrxx(orgid, startDate, endDate, typefilter, deadLine);
        BigDecimal rate1 = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
        BigDecimal rate2 = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
        BigDecimal bqybtse1 = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
        BigDecimal bqybtse2 = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
        if (nsrxx != null) {
            DynamicObjectCollection collection = this.declareReportDao.queryXgmZb(nsrxx.getString("id"));
            bqybtse1 = collection.stream().map(o -> o.getBigDecimal("bqybtse")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal xse = collection.stream().map(o -> o.getBigDecimal("xse")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            if (xse.compareTo(BigDecimal.ZERO) != 0 && (rate1 = bqybtse1.multiply(new BigDecimal(100)).divide(xse, 2, 5)).compareTo(BigDecimal.ZERO) < 0) {
                rate1 = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
            }
        }
        if ("ajsb".equals(deadLine)) {
            preStartDate = DateUtils.addMonth((Date)startDate, (int)-3);
            preEndDate = DateUtils.getLastDateOfSeason((Date)preStartDate);
        } else {
            preStartDate = DateUtils.addMonth((Date)startDate, (int)-1);
            preEndDate = DateUtils.getLastDateOfMonth((Date)preStartDate);
        }
        DynamicObject preNsrxx = this.declareReportDao.queryNsrxx(orgid, preStartDate, preEndDate, typefilter, deadLine);
        if (preNsrxx != null) {
            DynamicObjectCollection collection = this.declareReportDao.queryXgmZb(preNsrxx.getString("id"));
            bqybtse2 = collection.stream().map(o -> o.getBigDecimal("bqybtse")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal xse = collection.stream().map(o -> o.getBigDecimal("xse")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            if (xse.compareTo(BigDecimal.ZERO) != 0 && (rate2 = bqybtse2.multiply(new BigDecimal(100)).divide(xse, 2, 5)).compareTo(BigDecimal.ZERO) < 0) {
                rate2 = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
            }
        }
        Label sfl = (Label)this.getControl("sfl");
        sfl.setText(rate1 + "%");
        Label tbbd1 = (Label)this.getControl("tbbh1");
        tbbd1.setText(rate1.subtract(rate2) + "%");
        Label depreamount = (Label)this.getControl("depre_amount11");
        depreamount.setText(bqybtse1.divide(new BigDecimal(10000), 2, RoundingMode.HALF_UP).toString());
        Label tbbd2 = (Label)this.getControl("tbbh2");
        tbbd2.setText(bqybtse1.subtract(bqybtse2).divide(new BigDecimal(10000), 2, RoundingMode.HALF_UP).toString());
    }
}

