/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.apphome;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.service.apphome.AppHomeService;

public class TcvatAppHomePlugin
extends AbstractFormPlugin {
    private static Map<Integer, String> monthMap = new HashMap<Integer, String>();

    public void afterCreateNewData(EventObject e) {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        List hasPermOrgList = OrgCheckUtil.hasPermOrgList((HasPermOrgResult)hasPermOrgs);
        this.getPageCache().put("orgList", SerializationUtils.toJsonString((Object)hasPermOrgList));
        Object object = this.getModel().getValue("org");
        Long orgid = null;
        if (object == null) {
            orgid = OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)RequestContext.get().getOrgId(), (List)hasPermOrgList);
            if (null == orgid) {
                return;
            }
            if (OrgCheckUtil.check((IFormView)this.getView(), (String)String.valueOf(orgid), (String)"tcvat", (String)"zzs")) {
                orgid = null;
            }
        } else {
            orgid = ((DynamicObject)object).getLong("id");
        }
        this.getModel().setValue("org", (Object)orgid);
        this.refreshCache();
    }

    private void refreshCache() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            this.getPageCache().remove("org");
            return;
        }
        this.getPageCache().put("org", org.getString("id"));
        if (this.getPageCache().get("period_" + org.getPkValue()) != null) {
            return;
        }
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(String.valueOf(org.getPkValue())));
        DynamicObject taxmain = (DynamicObject)result.getData();
        if (taxmain == null || StringUtil.isBlank((CharSequence)taxmain.getString("registeraddress"))) {
            return;
        }
        Map<String, Object> provinceAndCityMap = AppHomeService.getProvinceAndCityid(taxmain.getLong("registeraddress"));
        QFilter provinceFilter = new QFilter("entryentity.provinces", "=", provinceAndCityMap.get("provinceid"));
        QFilter cityFilter = new QFilter("entryentity.city", "=", provinceAndCityMap.get("cityid"));
        QFilter taxtypeFilter = new QFilter("entryentity.taxtype", "=", (Object)"1");
        QFilter methodsFilter = new QFilter("entryentity.methods", "=", (Object)"2");
        Date now = new Date();
        int year = now.getYear() + 1900;
        int month = now.getMonth() + 1;
        QFilter yearFilter = new QFilter("year", "=", (Object)String.valueOf(year));
        DynamicObject dynamicObjects = QueryServiceHelper.queryOne((String)"tpo_tax_calendar", (String)("id, entryentity." + monthMap.get(month) + " as date"), (QFilter[])new QFilter[]{provinceFilter, cityFilter, taxtypeFilter, methodsFilter, yearFilter});
        if (dynamicObjects == null) {
            dynamicObjects = QueryServiceHelper.queryOne((String)"tpo_tax_calendar", (String)("id, entryentity." + monthMap.get(month) + " as date"), (QFilter[])new QFilter[]{provinceFilter, taxtypeFilter, methodsFilter, yearFilter});
        }
        if (dynamicObjects != null) {
            String datestr = dynamicObjects.getString("date");
            String[] split = datestr.split("\\D+");
            StringBuilder dateStringBuilder = new StringBuilder();
            Date date = DateUtils.stringToDate2((String)(dateStringBuilder = dateStringBuilder.append(year).append('-').append(String.format("%02d", Integer.parseInt(split[0]))).append('-').append(String.format("%02d", Integer.parseInt(split[1])))).toString());
            String period = null != date && now.after(date) ? DateUtils.formatMonth((Date)now) : DateUtils.getLastMonthFirstDateStr((String)"yyyy-MM");
            this.getPageCache().put("period_" + org.getPkValue(), period);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("org".equals(e.getProperty().getName())) {
            ChangeData[] changeData = e.getChangeSet();
            if (changeData != null && changeData.length > 0) {
                DynamicObject newOrg = (DynamicObject)changeData[0].getNewValue();
                if (null == newOrg) {
                    this.getView().getModel().setValue("org", (Object)this.getPageCache().get("org"));
                    return;
                }
                String neworgid = newOrg.getString("id");
                String appid = this.getView().getFormShowParameter().getAppId();
                if (OrgCheckUtil.check((IFormView)this.getView(), (String)neworgid, (String)appid, (String)"zzs")) {
                    this.getView().getModel().setValue("org", (Object)this.getPageCache().get("org"));
                }
            }
            this.refreshCache();
            this.refreshView();
        }
    }

    private void refreshView() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap dataMap = new HashMap();
        proxy.invokeControlMethod("gridcontainerap", "trigger", new Object[]{dataMap});
    }

    public void customEvent(CustomEventArgs e) {
        if ("refreshFromGridContainer".equals(e.getKey())) {
            this.refreshView();
        }
    }

    static {
        monthMap.put(1, "january");
        monthMap.put(2, "february");
        monthMap.put(3, "march");
        monthMap.put(4, "april");
        monthMap.put(5, "may");
        monthMap.put(6, "june");
        monthMap.put(7, "july");
        monthMap.put(8, "august");
        monthMap.put(9, "september");
        monthMap.put(10, "october");
        monthMap.put(11, "november");
        monthMap.put(12, "december");
    }
}

