/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.draft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.draft.DraftService;
import kd.taxc.bdtaxr.common.dto.DraftPluginDto;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.AbstractDraftPlugin;
import kd.taxc.bdtaxr.common.taxdeclare.draft.DraftStepsUtils;
import kd.taxc.bdtaxr.common.taxdeclare.draft.org.OrgChangeRecordUtil;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;
import kd.taxc.tcvat.business.dao.draft.DraftDao;
import kd.taxc.tcvat.business.dao.draft.DraftEditDao;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.TcvatDraftService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.strategy.TcvatStrategy;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.task.TcvatDraftEngineCalcTask;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.dto.draft.DraftDto;
import kd.taxc.tcvat.common.enums.StrategyEnum;
import org.apache.commons.lang3.ObjectUtils;

public class TcvatDraftPlugin
extends AbstractDraftPlugin {
    private static final Log logger = LogFactory.getLog(TcvatDraftPlugin.class);
    private static final String check_page = "tcvat_check_rule";
    private static final String TEMPLATE_TYPE = "templatetype";
    private static final String YBNSR_CHECK_PAGE = "tcvat_ybnsr_check_rule";
    private static final String YBQY_CHECK_PAGE = "tcvat_check_rule";
    protected static final String TAXPAYER_TYPE_KEY = "taxPayerType";
    private static final String INCOME_RULE_CHECK_PAGE = "tcvat_income_rule_check";
    private static final String CACHE_UPDATA_CELLID = "updata_cellid";
    private Set<String> checkPageSet = new HashSet<String>(10){
        {
            this.add("tcvat_check_rule");
            this.add(TcvatDraftPlugin.INCOME_RULE_CHECK_PAGE);
            this.add(TcvatDraftPlugin.YBNSR_CHECK_PAGE);
        }
    };
    protected TcvatStrategy strategy;
    protected DraftDto draftDto = new DraftDto();
    protected DraftDao draftDao = new DraftDao();
    protected DraftEditDao draftEditDao = new DraftEditDao();
    protected TcvatDraftService tcvatDraftService = new TcvatDraftService();

    public void initialize() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String taxPayType = null == this.getPageCache().get(TAXPAYER_TYPE_KEY) ? (String)customParams.get(TEMPLATE_TYPE) : this.getPageCache().get(TAXPAYER_TYPE_KEY);
        customParams.put("rulePurpose", customParams.get("draftpurpose"));
        this.draftDto.setDraftPurpose((String)customParams.get("draftpurpose"));
        if (taxPayType != null) {
            taxPayType = taxPayType.replace("draft_", "").replace("_sjjt", "");
            this.getPageCache().put("taxpayertype", taxPayType);
        }
        super.setDeclarePageMap(StrategyEnum.getByTaxPayerType(taxPayType).getStrategy().getDeclareMapAndStatusMap());
    }

    public void afterCreateNewData(EventObject e) {
        String templateType;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("orgid") != null && customParams.get("skssqq") != null && customParams.get("skssqz") != null && ObjectUtils.isNotEmpty((Object)(templateType = this.getTemplateType())) && templateType.startsWith("orgmsg")) {
            this.getView().showErrorNotification(templateType.substring(6));
            return;
        }
        super.afterCreateNewData(e);
    }

    protected boolean doCustomInAfterCreateNewData(String orgId, String skssqq, String skssqz) {
        String templateType = this.getTemplateType();
        if (ObjectUtils.isNotEmpty((Object)templateType) && templateType.startsWith("orgmsg")) {
            this.getView().showErrorNotification(templateType.substring(6));
            this.getPageCache().put("focuspage", "1");
            return false;
        }
        return true;
    }

    protected String getDraftNumber(String draftpurpose, String readNumber, String draftNumberPrefix) {
        return readNumber.replaceAll("X", draftNumberPrefix);
    }

    protected void setButtonVisible(String focuspage) {
        super.setButtonVisible(focuspage);
        if ("B".equals(this.getPageCache().get("cache_billstatus")) || "C".equals(this.getPageCache().get("cache_billstatus"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"createsbb"});
            if ("B".equals(this.getPageCache().get("cache_declarestatus")) || "C".equals(this.getPageCache().get("cache_declarestatus"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"submit", "unsubmit", "audit", "unaudit", "createsbb"});
                if ("3".equals(focuspage)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"createsbb"});
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (this.getModel().getValue("org") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"TcvatDraftPlugin_18", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        if ("edit".equals(operateKey) || "submit".equals(operateKey) || "recalc".equals(operateKey)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            String templateType = this.getTemplateType();
            if (ObjectUtils.isNotEmpty((Object)templateType) && templateType.startsWith("orgmsg")) {
                this.getView().showErrorNotification(templateType.substring(6));
                args.setCancel(true);
            }
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            filterList.add(new QFilter("org", "=", (Object)org.getLong("id")));
            Date startDate = DateUtils.stringToDate((String)this.getPageCache().get("skssqq"));
            Date endDate = DateUtils.stringToDate((String)this.getPageCache().get("skssqz"));
            filterList.add(new QFilter("startdate", "=", (Object)startDate));
            filterList.add(new QFilter("enddate", "=", (Object)endDate));
            filterList.add(new QFilter(TEMPLATE_TYPE, "=", (Object)templateType));
            filterList.add(new QFilter("draftpurpose", "=", (Object)this.getPageCache().get("draftpurpose")));
            DynamicObject draft = this.draftDao.queryOneDraft(filterList);
            if (null != draft && !"A".equals(draft.getString("billstatus"))) {
                String orgName = org.getString("name");
                String statusName = "C".equals(draft.getString("billstatus")) ? ResManager.loadKDString((String)"\u5ba1\u6838", (String)"TcvatDraftPlugin_25", (String)"taxc-tcvat", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"TcvatDraftPlugin_26", (String)"taxc-tcvat", (Object[])new Object[0]);
                String taxlimitStr = DateUtils.getTaxLimitTips((Date)startDate, (Date)endDate);
                String msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f%3$s\u5df2%4$s\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u3002", (String)"TcvatDraftPlugin_27", (String)"taxc-tcvat", (Object[])new Object[0]), orgName, taxlimitStr, ResManager.loadKDString((String)"\u5e95\u7a3f", (String)"TcvatDraftPlugin_28", (String)"taxc-tcvat", (Object[])new Object[0]), statusName);
                this.getView().showTipNotification(msg);
                args.setCancel(true);
            }
        }
    }

    protected void initStartAndEndDate(boolean orgChange) {
        TaxDeclareHelper.initPeriod(this.getModel(), this.getPageCache(), this.getPageCache().get("orgid"), this.getView().getFormShowParameter().getCustomParams(), orgChange);
        this.getView().updateView("skssqq");
        this.getView().updateView("skssqz");
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        Map map = (Map)event.getReturnData();
        if (this.checkPageSet.contains(event.getActionId())) {
            if (map == null || map.isEmpty()) {
                return;
            }
            String orgId = this.getPageCache().get("orgid");
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put("orgid", orgId);
            customParams.put("parent", "1874049518841207808");
            PageShowCommon.showBillList((String)"bos_templatetreelist", (ShowType)ShowType.MainNewTabPage, (String)"tcvat_sbx_rule_config", (IFormView)this.getView(), customParams, null);
            if ("tcvat_check_rule".equals(event.getActionId())) {
                this.getView().close();
            }
        }
    }

    public String getTemplateType() {
        String endDate;
        String startDate;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgId = this.getPageCache().get("orgid");
        if (StringUtils.isBlank((CharSequence)orgId)) {
            orgId = (String)customParams.get("orgid");
        }
        if (StringUtils.isBlank((CharSequence)(startDate = this.getPageCache().get("skssqq")))) {
            startDate = (String)customParams.get("skssqq");
        }
        if (StringUtils.isBlank((CharSequence)(endDate = this.getPageCache().get("skssqz")))) {
            endDate = (String)customParams.get("skssqz");
        }
        if (StringUtils.isBlank((CharSequence)orgId) || StringUtils.isBlank((CharSequence)startDate) || StringUtils.isBlank((CharSequence)endDate)) {
            return "";
        }
        String templateType = this.getCachedTemplateType(orgId, startDate, endDate);
        if (templateType != null) {
            return templateType;
        }
        templateType = this.getPageCache().get(TEMPLATE_TYPE + orgId + this.getPageCache().get(TAXPAYER_TYPE_KEY) + startDate + endDate);
        logger.info("TcvatDraftPlugin getTemplateType templateType:{},orgId:{}", (Object)templateType, (Object)orgId);
        if (StringUtils.isEmpty((CharSequence)templateType)) {
            Map<String, Object> cache = TaxDeclareHelper.getTemplateType("draft", orgId, startDate, endDate, (String)customParams.get("draftpurpose"));
            logger.info("TcvatDraftPlugin getTemplateType cache:{},orgId:{}", cache, (Object)orgId);
            if (null != cache.get("orgmsg")) {
                return "orgmsg" + cache.get("orgmsg");
            }
            String taxPayerType = (String)cache.get("taxpayertype");
            templateType = (String)cache.get(TEMPLATE_TYPE);
            this.getPageCache().put(TAXPAYER_TYPE_KEY, (String)cache.get("taxpayertype"));
            this.getPageCache().put(TEMPLATE_TYPE + orgId + taxPayerType + startDate + endDate, templateType);
            this.getPageCache().put("deadLine", (String)cache.get("deadLine"));
        }
        return templateType;
    }

    protected String getTaxpayerType(String orgId, Date skssqq, Date skssqz) {
        Map<String, Object> taxPayerTypeMap = TaxDeclareHelper.getTaxPayerType(orgId, skssqq, skssqz);
        String taxPayerType = (String)taxPayerTypeMap.get("taxpayertype");
        this.getPageCache().put("nowTaxPayerType", taxPayerType);
        String cachedTaxPayerType = this.getCachedTaxPayerType(orgId, DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz));
        if (cachedTaxPayerType != null) {
            taxPayerType = cachedTaxPayerType;
        }
        this.getPageCache().put("taxpayertype", taxPayerType);
        this.getPageCache().put("deadLine", (String)taxPayerTypeMap.get("deadLine"));
        this.getPageCache().put("planid", (String)taxPayerTypeMap.get("planid"));
        String prelevyrate = (String)taxPayerTypeMap.get("prelevyrate");
        this.getPageCache().put("prelevyrate", prelevyrate);
        this.draftDto.setOrgId(StringUtils.isBlank((CharSequence)orgId) ? 0L : Long.parseLong(orgId));
        this.draftDto.setStartDate(skssqq);
        this.draftDto.setEndDate(skssqz);
        this.draftDto.setDraftPurpose(this.getPageCache().get("draftpurpose"));
        this.draftDto.setTaxPayerType(taxPayerType);
        this.draftDto.setPrelevyrate(prelevyrate);
        this.strategy = TcvatDraftService.getStrategy(this.draftDto);
        if (null == this.getPageCache().get("zzsybnsr_ybfz" + orgId)) {
            this.getPageCache().put("zzsybnsr_ybfz" + orgId, (String)taxPayerTypeMap.get("taxpayertypemsg"));
        }
        return taxPayerType;
    }

    private String getCachedTemplateType(String orgId, String startDate, String endDate) {
        String templateType = this.getPageCache().get(TEMPLATE_TYPE + orgId + this.getPageCache().get(TAXPAYER_TYPE_KEY) + startDate + endDate);
        logger.info("getCachedTemplateType templateType:{}", (Object)templateType);
        if (templateType == null) {
            templateType = this.getPageCache().get(TEMPLATE_TYPE);
            String templateTypeCachedKey = this.getPageCache().get("templateTypeCachedKey");
            logger.info("getCachedTemplateType2 templateType:{},{}", (Object)templateType, (Object)templateTypeCachedKey);
            if (templateTypeCachedKey == null) {
                templateTypeCachedKey = "templateType_" + orgId + "_" + startDate + "_" + endDate;
                this.getPageCache().put("templateTypeCachedKey", templateTypeCachedKey);
                this.getPageCache().put(templateTypeCachedKey, templateType);
            } else {
                templateType = this.getPageCache().get("templateType_" + orgId + "_" + startDate + "_" + endDate);
                logger.info("getCachedTemplateType3 templateType:{}", (Object)templateType);
            }
        }
        return templateType;
    }

    private String getCachedTaxPayerType(String orgId, String startDate, String endDate) {
        String templateType = this.getCachedTemplateType(orgId, startDate, endDate);
        if (templateType != null) {
            templateType = templateType.replace("draft_", "").replace("_sjjt", "");
            this.getPageCache().put(TAXPAYER_TYPE_KEY, templateType);
        }
        return templateType;
    }

    private String getDraftpurpose() {
        return this.getPageCache().get("draftpurpose") != null ? this.getPageCache().get("draftpurpose") : "nssb";
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        if (changeData == null || changeData.length == 0) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (null == org) {
            return;
        }
        String orgname = org.getString("name");
        boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcvat", (String)"zerodeclare", (long)org.getLong("id"));
        String draftpurpose = this.getDraftpurpose();
        this.getView().setVisible(Boolean.valueOf(!zerodeclare), new String[]{"recalc", "next", "forward"});
        if (e.getProperty().getName().equals("org")) {
            if (zerodeclare) {
                if ("sjjt".equals(draftpurpose)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u7f16\u5236\u8ba1\u63d0\u5e95\u7a3f\u3002", (String)"TcvatDraftPlugin_41", (String)"taxc-tcvat", (Object[])new Object[0]), orgname));
                } else {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u7f16\u5236\u7533\u62a5\u5e95\u7a3f\u3002", (String)"TcvatDraftPlugin_29", (String)"taxc-tcvat", (Object[])new Object[0]), orgname));
                }
                DraftStepsUtils.resetSteps((int)this.getDeclarePageMap().size(), (String)"0", (String)"0", (IFormView)this.getView());
                this.getModel().setValue("org", changeData[0].getOldValue());
                return;
            }
            Object object = changeData[0].getNewValue();
            if (StringUtils.isBlank((Object)object) && null != changeData[0].getOldValue()) {
                Boolean checkResult = OrgCheckUtil.withoutLicenseCheck((IFormView)this.getView(), (String)((DynamicObject)changeData[0].getOldValue()).get("id").toString(), (String)"tcvat", (String)TaxAppEnum.getEnumInstanceByAppid((String)"tcvat").getCategoryCode());
                boolean hasLicense = OrgCheckUtil.draftLicenseCheck((IFormView)this.getView(), (String)"", (String)"tcdrs", (String)"");
                if (checkResult.booleanValue() || hasLicense) {
                    return;
                }
                this.getModel().setValue("org", changeData[0].getOldValue());
            }
            String orgid = org.getString("id");
            Boolean checkResult = OrgCheckUtil.withoutLicenseCheck((IFormView)this.getView(), (String)orgid, (String)"tcvat", (String)TaxAppEnum.getEnumInstanceByAppid((String)"tcvat").getCategoryCode());
            boolean hasLicense = OrgCheckUtil.draftLicenseCheck((IFormView)this.getView(), (String)"", (String)"tcdrs", (String)"");
            this.setOrgType(orgid);
            DynamicObject newOrg = (DynamicObject)changeData[0].getNewValue();
            String neworgid = newOrg.getString("id");
            boolean notAuthorize = LicenseCheckServiceHelper.check((Object)neworgid, (IFormView)this.getView(), (String)this.getView().getFormShowParameter().getAppId());
            if (checkResult.booleanValue() || hasLicense || this.strategy.propertyChangedCheck(changeData[0].getNewValue(), this.getPageCache(), this.getView()).booleanValue() || notAuthorize) {
                this.setOrgid(changeData[0]);
            } else {
                this.getPageCache().put("orgid", orgid);
                this.initStartAndEndDate(false);
                this.loadData((Date)this.getModel().getValue("skssqq"), (Date)this.getModel().getValue("skssqz"));
            }
        }
        if (e.getProperty().getName().equals("skssqq")) {
            if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("dateChanged"))) {
                this.getPageCache().remove("dateChanged");
                return;
            }
            if (zerodeclare) {
                if ("sjjt".equals(draftpurpose)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u7f16\u5236\u8ba1\u63d0\u5e95\u7a3f\u3002", (String)"TcvatDraftPlugin_41", (String)"taxc-tcvat", (Object[])new Object[0]), orgname));
                } else {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u7f16\u5236\u7533\u62a5\u5e95\u7a3f\u3002", (String)"TcvatDraftPlugin_29", (String)"taxc-tcvat", (Object[])new Object[0]), orgname));
                }
                DraftStepsUtils.resetSteps((int)this.getDeclarePageMap().size(), (String)"0", (String)"0", (IFormView)this.getView());
                return;
            }
            if (Objects.isNull(changeData[0].getNewValue())) {
                return;
            }
            boolean noValid = this.beforeLoadData((Date)changeData[0].getNewValue());
            if (noValid) {
                return;
            }
            this.loadData((Date)this.getModel().getValue("skssqq"), (Date)this.getModel().getValue("skssqz"));
        }
        if (e.getProperty().getName().equals("skssqz")) {
            if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("dateChanged"))) {
                this.getPageCache().remove("dateChanged");
                return;
            }
            if (zerodeclare) {
                if ("sjjt".equals(draftpurpose)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u7f16\u5236\u8ba1\u63d0\u5e95\u7a3f\u3002", (String)"TcvatDraftPlugin_41", (String)"taxc-tcvat", (Object[])new Object[0]), orgname));
                } else {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u7f16\u5236\u7533\u62a5\u5e95\u7a3f\u3002", (String)"TcvatDraftPlugin_29", (String)"taxc-tcvat", (Object[])new Object[0]), orgname));
                }
                DraftStepsUtils.resetSteps((int)this.getDeclarePageMap().size(), (String)"0", (String)"0", (IFormView)this.getView());
                return;
            }
            if (Objects.isNull(changeData[0].getNewValue())) {
                return;
            }
            boolean noValid = this.beforeLoadData((Date)changeData[0].getNewValue());
            if (noValid) {
                return;
            }
            this.loadData((Date)this.getModel().getValue("skssqq"), (Date)this.getModel().getValue("skssqz"));
        }
    }

    private void setOrgid(ChangeData changeData) {
        DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
        if (oldValue != null) {
            Date startDate = (Date)this.getModel().getValue("skssqq");
            Date endDate = (Date)this.getModel().getValue("skssqz");
            if (null == startDate || null == endDate) {
                this.initStartAndEndDate(false);
                startDate = (Date)this.getModel().getValue("skssqq");
                endDate = (Date)this.getModel().getValue("skssqz");
            }
            if (null != startDate && null != endDate) {
                String oldOrgId = oldValue.getString("id");
                String taxPayerType = this.getTaxpayerType(oldOrgId, startDate, DateUtils.trunc((Date)endDate));
                if (!"zzsybnsr_hz_fzjg".equals(taxPayerType)) {
                    this.getModel().setValue("org", (Object)oldValue);
                } else {
                    this.getModel().setValue("org", null);
                }
            } else {
                this.getModel().setValue("org", null);
            }
        } else {
            this.getModel().setValue("org", null);
        }
    }

    protected void loadData(Date startDate, Date endDate) {
        if (null == this.getModel().getValue("org")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"TcvatDraftPlugin_18", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        this.getPageCache().put("accountorg", org.getString("id"));
        if (this.checkDatas(startDate, endDate).booleanValue()) {
            this.getPageCache().put("skssqq", DateUtils.format((Date)startDate));
            this.getPageCache().put("skssqz", DateUtils.format((Date)endDate));
            this.showInnerTbPage("1", this.getPageCache().get("orgid"));
            this.getPageCache().put("registerType", TaxDeclareHelper.getTaxRegisterType(this.getPageCache().get("orgid")));
        } else {
            this.lightenForStatus("1", "0");
            if (this.getPageCache().get("zzsybnsr_ybfz" + org.getString("id")) != null) {
                this.getView().showConfirm(this.getPageCache().get("zzsybnsr_ybfz" + org.getString("id")), MessageBoxOptions.OK, ConfirmTypes.Save, null);
                this.getPageCache().remove("zzsybnsr_ybfz" + org.getString("id"));
                this.getView().setVisible(Boolean.valueOf(!"zzsybnsr_yz_fzjg".equals(this.getPageCache().get(TAXPAYER_TYPE_KEY)) && !"zzsybnsr_hz_fzjg".equalsIgnoreCase(this.getPageCache().get(TAXPAYER_TYPE_KEY))), new String[]{"recalc", "next"});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"fastsetting"});
        }
    }

    public boolean setOrgType(String orgId) {
        Date startDate = (Date)this.getModel().getValue("skssqq");
        Date endDate = (Date)this.getModel().getValue("skssqz");
        if (null == startDate || null == endDate) {
            startDate = DateUtils.stringToDate((String)this.getPageCache().get("skssqq"));
            endDate = DateUtils.stringToDate((String)this.getPageCache().get("skssqz"));
        }
        Date trunc = endDate != null ? DateUtils.trunc((Date)endDate) : null;
        String taxPayerType = this.getTaxpayerType(orgId, startDate, trunc);
        this.getView().setVisible(Boolean.valueOf(!"zzsybnsr_hz_fzjg".equalsIgnoreCase(taxPayerType) && !"zzsybnsr_yz_fzjg".equalsIgnoreCase(taxPayerType)), new String[]{"recalc"});
        this.getPageCache().put("taxpayertype" + orgId, taxPayerType);
        this.getPageCache().put(TAXPAYER_TYPE_KEY, taxPayerType);
        super.setDeclarePageMap(StrategyEnum.getByTaxPayerType(taxPayerType).getStrategy().getDeclareMapAndStatusMap());
        this.getPageCache().put("skssqq", DateUtils.format((Date)startDate));
        this.getPageCache().put("skssqz", DateUtils.format((Date)endDate));
        this.getPageCache().put("registerType", TaxDeclareHelper.getTaxRegisterType(null == this.getPageCache().get("orgid") ? orgId : this.getPageCache().get("orgid")));
        return "othertype".equals(taxPayerType) || "zzsybnsr_ybfz".equals(taxPayerType) || "zzsybnsr_yz_fzjg".equals(taxPayerType) || "zzsybnsr_hz_fzjg".equals(taxPayerType);
    }

    public void itemClick(ItemClickEvent evt) {
        boolean edit;
        String itemKey = evt.getItemKey();
        if (this.getModel().getValue("org") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"TcvatDraftPlugin_18", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String startDate = this.getPageCache().get("skssqq");
        String endDate = this.getPageCache().get("skssqz");
        String templateType = this.getPageCache().get(TEMPLATE_TYPE + org.getString("id") + this.getPageCache().get(TAXPAYER_TYPE_KEY) + startDate + endDate);
        if ("save".equals(itemKey)) {
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            filterList.add(new QFilter("org", "=", (Object)org.getLong("id")));
            Date startdate = DateUtils.stringToDate((String)this.getPageCache().get("skssqq"));
            Date enddate = DateUtils.stringToDate((String)this.getPageCache().get("skssqz"));
            filterList.add(new QFilter("startdate", "=", (Object)startdate));
            filterList.add(new QFilter("enddate", "=", (Object)enddate));
            filterList.add(new QFilter(TEMPLATE_TYPE, "=", (Object)this.getTemplateType()));
            filterList.add(new QFilter("draftpurpose", "=", (Object)this.getPageCache().get("draftpurpose")));
            DynamicObject draft = this.draftDao.queryOneDraft(filterList);
            if (null != draft && !"A".equals(draft.getString("billstatus"))) {
                String orgName = org.getString("name");
                String statusName = "C".equals(draft.getString("billstatus")) ? ResManager.loadKDString((String)"\u5ba1\u6838", (String)"TcvatDraftPlugin_25", (String)"taxc-tcvat", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"TcvatDraftPlugin_26", (String)"taxc-tcvat", (Object[])new Object[0]);
                String taxlimitStr = DateUtils.getTaxLimitTips((Date)startdate, (Date)enddate);
                String msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f%3$s\u5df2%4$s\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u3002", (String)"TcvatDraftPlugin_27", (String)"taxc-tcvat", (Object[])new Object[0]), orgName, taxlimitStr, ResManager.loadKDString((String)"\u5e95\u7a3f", (String)"TcvatDraftPlugin_28", (String)"taxc-tcvat", (Object[])new Object[0]), statusName);
                this.getView().showTipNotification(msg);
                return;
            }
        }
        boolean bl = edit = "zzsybnsr_ybhz".equals(this.getPageCache().get(TAXPAYER_TYPE_KEY)) || "zzsybnsr_hz_zjg".equals(this.getPageCache().get(TAXPAYER_TYPE_KEY)) || "zzsybnsr_yz_zjg".equals(this.getPageCache().get(TAXPAYER_TYPE_KEY));
        if (edit && (itemKey.equals("edit") || itemKey.equals("save") || itemKey.equals("cancel"))) {
            if (!this.isValidDates((Date)this.getModel().getValue("skssqq"), (Date)this.getModel().getValue("skssqz"))) {
                return;
            }
            this.ybhzItemClick(itemKey);
        } else {
            this.getView().getPageCache().put("edit", "false");
            if ("save".equals(itemKey) && "draft_zzsybnsr".equals(templateType)) {
                String pageid = this.getPageCache().get("declarepageid");
                IFormView childView = this.getView().getView(pageid);
                IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
                Map updateMap = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)CACHE_UPDATA_CELLID, Map.class);
                super.itemClick(evt);
                this.draftDto.setOrgId(org.getLong("id"));
                this.draftDto.setStartDate((Date)this.getModel().getValue("skssqq"));
                this.draftDto.setEndDate((Date)this.getModel().getValue("skssqz"));
                this.draftDto.setTemplateType(templateType);
                this.tcvatDraftService.updateDeclareReport(this.draftDto, updateMap);
            } else {
                super.itemClick(evt);
            }
        }
    }

    private void ybhzItemClick(String itemKey) {
        switch (itemKey) {
            case "edit": {
                IFormView apportionView;
                IFormView assignView;
                this.getView().getPageCache().put("edit", "true");
                this.getView().setVisible(Boolean.FALSE, new String[]{"edit"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"save", "cancel"});
                IFormView calculateView = this.getView().getView(this.getView().getView(this.getPageCache().get("declarepageid")).getPageCache().get("loadtb-taxcalculatetable"));
                if (null != calculateView) {
                    calculateView.setEnable(Boolean.TRUE, 2, new String[]{"ybxm"});
                    calculateView.setEnable(Boolean.TRUE, 6, new String[]{"ybxm", "jzjtxm"});
                    calculateView.setEnable(Boolean.TRUE, 10, new String[]{"ybxm", "jzjtxm"});
                    calculateView.setEnable(Boolean.TRUE, 11, new String[]{"ybxm", "jzjtxm"});
                    calculateView.setEnable(Boolean.TRUE, 15, new String[]{"ybxm", "jzjtxm"});
                    calculateView.setEnable(Boolean.TRUE, 20, new String[]{"ybxm"});
                    calculateView.setEnable(Boolean.TRUE, 23, new String[]{"ybxm", "jzjtxm"});
                    calculateView.setEnable(Boolean.TRUE, 26, new String[]{"jzjtxm"});
                    calculateView.setEnable(Boolean.TRUE, 29, new String[]{"ybxm", "jzjtxm"});
                    this.getView().sendFormAction(calculateView);
                }
                if (null != (assignView = this.getView().getView(this.getView().getView(this.getPageCache().get("declarepageid")).getPageCache().get("loadtb-taxassigntable")))) {
                    int assignIndex = assignView.getModel().getEntryRowCount("entryentity");
                    for (int i = 0; i < assignIndex; ++i) {
                        assignView.setEnable(Boolean.TRUE, i, new String[]{"dktaxamount", "jzse"});
                    }
                    this.getView().sendFormAction(assignView);
                }
                if (null == (apportionView = this.getView().getView(this.getView().getView(this.getPageCache().get("declarepageid")).getPageCache().get("loadtb-taxapportiontable")))) break;
                int index2 = apportionView.getModel().getEntryRowCount("entryentity");
                for (int i = 0; i < index2; ++i) {
                    apportionView.setEnable(Boolean.TRUE, i, new String[]{"ynse"});
                }
                this.getView().sendFormAction(apportionView);
                break;
            }
            case "save": {
                IFormView apportionSaveView3;
                IFormView apportionSaveView;
                IFormView calculateSaveView;
                int i;
                IFormView assignSaveView = this.getView().getView(this.getView().getView(this.getPageCache().get("declarepageid")).getPageCache().get("loadtb-taxassigntable"));
                if (null != assignSaveView) {
                    int index1 = assignSaveView.getModel().getEntryRowCount("entryentity");
                    for (int i2 = 0; i2 < index1; ++i2) {
                        assignSaveView.setEnable(Boolean.FALSE, i2, new String[]{"dktaxamount", "jzse"});
                    }
                    this.getView().sendFormAction(assignSaveView);
                    int assIndex = assignSaveView.getModel().getEntryRowCount("assentryentity");
                    for (i = 0; i < assIndex; ++i) {
                        assignSaveView.setEnable(Boolean.FALSE, i, new String[]{"fpbl", "jzjtfpbl", "ysfwfpbl", "ysfwjzjtfpbl", "fpse", "jzjtfpse", "ysfwfpse", "ysfwjzjtfpse"});
                    }
                    this.getView().sendFormAction(assignSaveView);
                }
                if (null != (calculateSaveView = this.getView().getView(this.getView().getView(this.getPageCache().get("declarepageid")).getPageCache().get("loadtb-taxcalculatetable")))) {
                    int index2 = calculateSaveView.getModel().getEntryRowCount("entryentity");
                    for (i = 0; i < index2; ++i) {
                        calculateSaveView.setEnable(Boolean.FALSE, i, new String[]{"ybxm", "jzjtxm"});
                    }
                    this.getView().sendFormAction(calculateSaveView);
                }
                if (null != (apportionSaveView = this.getView().getView(this.getView().getView(this.getPageCache().get("declarepageid")).getPageCache().get("loadtb-taxapportiontable")))) {
                    int index2 = apportionSaveView.getModel().getEntryRowCount("entryentity");
                    for (int i3 = 0; i3 < index2; ++i3) {
                        apportionSaveView.setEnable(Boolean.FALSE, i3, new String[]{"ynse"});
                    }
                    apportionSaveView.setEnable(Boolean.FALSE, new String[]{"zjgsqqbljxse"});
                    apportionSaveView.invokeOperation("save");
                    this.getView().sendFormAction(apportionSaveView);
                }
                if (null != (apportionSaveView3 = this.getView().getView(this.getView().getView(this.getPageCache().get("declarepageid")).getPageCache().get("loadtb-taxapportiontable3")))) {
                    int index2 = apportionSaveView3.getModel().getEntryRowCount("treeentryentity");
                    for (int i4 = 0; i4 < index2; ++i4) {
                        apportionSaveView3.setEnable(Boolean.FALSE, i4, new String[]{"fpbl1", "jzjtfpbl", "ysfwfpbl", "ysfwjzjtfpbl", "fpse", "jzjtfpse", "ysfwfpse", "ysfwjzjtfpse"});
                    }
                    try {
                        apportionSaveView3.invokeOperation("save");
                        this.getView().sendFormAction(apportionSaveView3);
                    }
                    catch (KDBizException e) {
                        this.getView().showConfirm(e.getMessage(), MessageBoxOptions.OK);
                        return;
                    }
                }
                this.getView().getPageCache().put("edit", "false");
                this.getView().setVisible(Boolean.TRUE, new String[]{"edit"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"save", "cancel"});
                break;
            }
            case "cancel": {
                IFormView apportionCancelView3;
                IFormView apportionCancelView;
                IFormView assignCancelView;
                this.getView().getPageCache().put("edit", "false");
                LocaleString cancelMsg = new LocaleString(ResManager.loadKDString((String)"\u53d6\u6d88\u7f16\u8f91\u4e2d\uff0c\u8bf7\u7a0d\u7b49\uff083S\uff09", (String)"TcvatDraftPlugin_30", (String)"taxc-tcvat", (Object[])new Object[0]));
                IFormView calculateCancelView = this.getView().getView(this.getView().getView(this.getPageCache().get("declarepageid")).getPageCache().get("loadtb-taxcalculatetable"));
                if (null != calculateCancelView) {
                    int index2 = calculateCancelView.getModel().getEntryRowCount("entryentity");
                    for (int i = 0; i < index2; ++i) {
                        calculateCancelView.setEnable(Boolean.FALSE, i, new String[]{"ybxm", "jzjtxm"});
                    }
                    calculateCancelView.invokeOperation("refresh");
                    this.getView().sendFormAction(calculateCancelView);
                }
                if (null != (assignCancelView = this.getView().getView(this.getView().getView(this.getPageCache().get("declarepageid")).getPageCache().get("loadtb-taxassigntable")))) {
                    int index2 = assignCancelView.getModel().getEntryRowCount("entryentity");
                    for (int i = 0; i < index2; ++i) {
                        assignCancelView.setEnable(Boolean.FALSE, i, new String[]{"dktaxamount", "jzse"});
                    }
                    assignCancelView.invokeOperation("refresh");
                    this.getView().sendFormAction(assignCancelView);
                }
                if (null != (apportionCancelView = this.getView().getView(this.getView().getView(this.getPageCache().get("declarepageid")).getPageCache().get("loadtb-taxapportiontable")))) {
                    int index2 = apportionCancelView.getModel().getEntryRowCount("entryentity");
                    for (int i = 0; i < index2; ++i) {
                        apportionCancelView.setEnable(Boolean.FALSE, i, new String[]{"ynse"});
                    }
                    apportionCancelView.invokeOperation("refresh");
                    this.getView().sendFormAction(apportionCancelView);
                }
                if (null != (apportionCancelView3 = this.getView().getView(this.getView().getView(this.getPageCache().get("declarepageid")).getPageCache().get("loadtb-taxapportiontable3")))) {
                    apportionCancelView3.invokeOperation("refresh");
                    this.getView().sendFormAction(apportionCancelView3);
                }
                this.getView().showLoading(cancelMsg, 3000);
                this.getView().setVisible(Boolean.TRUE, new String[]{"edit"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"save", "cancel"});
            }
        }
    }

    public Map<String, Object> createCustomParams(String orgId, String startdate, String enddate, String status, String focuspage) {
        Map customParams1 = this.getView().getFormShowParameter().getCustomParams();
        this.draftDto.setOrgId(Long.parseLong(orgId));
        this.draftDto.setStartDate(DateUtils.stringToDate((String)startdate));
        this.draftDto.setEndDate(DateUtils.stringToDate((String)enddate));
        return this.createCustomParams(this.draftDto, customParams1);
    }

    private Map<String, Object> createCustomParams(DraftDto draftDto, Map<String, Object> customParams1) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        DynamicObject dynamicObject = OrgChangeRecordUtil.loadChangeRecord((String)((Long)draftDto.getOrgId()).toString(), (Date)((Date)draftDto.getEndDate()));
        customParams.put("rulePurpose", customParams1.get("draftpurpose"));
        customParams.put("draftpurpose", customParams1.get("draftpurpose"));
        customParams.put("deadLine", TaxDeclareHelper.getDeadLine((String)customParams.get("draftpurpose"), ((Long)draftDto.getOrgId()).toString(), (Date)draftDto.getStartDate(), (Date)draftDto.getEndDate()));
        customParams.put(TAXPAYER_TYPE_KEY, this.getPageCache().get(TAXPAYER_TYPE_KEY) == null ? (dynamicObject != null ? dynamicObject.getString(TAXPAYER_TYPE_KEY) : null) : this.getPageCache().get(TAXPAYER_TYPE_KEY));
        customParams.put(TEMPLATE_TYPE, this.getTemplateType());
        customParams.put("planid", this.getPageCache().get("planid"));
        customParams.put("deductionrate", this.getPageCache().get("deductionrate"));
        customParams.put("declaremap", this.getPageCache().get("declaremap"));
        customParams.put("prelevyrate", this.getPageCache().get("prelevyrate"));
        customParams.put("needwarn", "false");
        String draftnumber = (String)this.getModel().getValue("draftnumber");
        if (draftnumber != null) {
            customParams.put("draftnumber", draftnumber);
            QFilter qFilter = new QFilter("draftnumber", "=", (Object)draftnumber);
            QFilter isRushModifyFilter = new QFilter("isrefreshmodify", "=", (Object)Boolean.FALSE);
            if (QueryServiceHelper.exists((String)DraftConstant.TCVAT_DRAFT_EDIT, (QFilter[])new QFilter[]{qFilter, isRushModifyFilter})) {
                customParams.put("refresh", "true");
            }
        }
        return customParams;
    }

    protected void runEngineBeforeNextStep(DraftPluginDto draftPluginDto) {
        String focusPage = draftPluginDto.getFocusPage();
        String status = draftPluginDto.getStatus();
        String startdate = draftPluginDto.getStartDate();
        String enddate = draftPluginDto.getEndDate();
        String orgId = draftPluginDto.getOrgId();
        DynamicObjectCollection draftTaskInfo = this.draftDao.queryRunninSchTaskByJobId(this.getJobId());
        if (Integer.parseInt(status) == 1 && "2".equals(focusPage) && draftTaskInfo.size() == 0) {
            HashMap<String, String> params = new HashMap<String, String>(16);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            params.put("orgid", org.getString("id"));
            params.put("orgname", org.getString("name"));
            params.put("startdate", startdate);
            params.put("enddate", enddate);
            params.put("taxpayertype", this.getPageCache().get(TAXPAYER_TYPE_KEY));
            params.put("deadline", this.getPageCache().get("deadLine"));
            params.put("planid", this.getPageCache().get("planid"));
            params.put("prelevyrate", this.getPageCache().get("prelevyrate"));
            String draftpurpose = this.getPageCache().get("draftpurpose");
            params.put("draftpurpose", draftpurpose);
            params.put("focusPage", this.getPageCache().get("focusPage"));
            params.put("refetch", "recalc");
            params.put("jobid", this.getJobId());
            draftPluginDto.setAsyn("1");
            this.dispatch(params);
            new DraftService().setDefaultRiskInfoNoZlb(draftpurpose, orgId, startdate, enddate, this.getTemplateType());
        } else if ("3".equals(focusPage)) {
            String templateType = this.getTemplateType();
            if ("draft_zzsybnsr_hz_zjg".equals(templateType)) {
                templateType = "draft_zzsybnsr_ybhz";
            }
            this.strategy.calculate(orgId, startdate, enddate, templateType, this.getPageCache());
        }
    }

    protected void addCustomParams(Map<String, Object> params) {
        params.put("draftpurpose", this.getPageCache().get("draftpurpose"));
        params.put("taxpayertype", this.getPageCache().get("taxpayertype"));
        params.put("prelevyrate", this.getPageCache().get("prelevyrate"));
        params.put("planid", this.getPageCache().get("planid"));
        params.put("orgname", this.getModel().getValue("org") == null ? "" : ((DynamicObject)this.getModel().getValue("org")).getString("name"));
    }

    protected String getJobName() {
        String draftpurpose = this.getPageCache().get("draftpurpose");
        return String.format(ResManager.loadKDString((String)"\u589e\u503c\u7a0e%1$s\u5e95\u7a3f\u8ba1\u7b97\u4efb\u52a1", (String)"TcvatDraftPlugin_34", (String)"taxc-tcvat", (Object[])new Object[0]), "nssb".equals(draftpurpose) ? ResManager.loadKDString((String)"\u7533\u62a5", (String)"TcvatDraftPlugin_35", (String)"taxc-tcvat", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8ba1\u63d0", (String)"TcvatDraftPlugin_36", (String)"taxc-tcvat", (Object[])new Object[0]));
    }

    protected String getCaption() {
        return this.getJobName();
    }

    protected String getJobId() {
        return (String)this.getModel().getValue("draftnumber");
    }

    protected String getTaskClassName() {
        return TcvatDraftEngineCalcTask.class.getName();
    }

    public void taskEndCallBack(TaskInfo taskInfo) {
        String data = taskInfo.getData();
        Map customs = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
        String message = (String)customs.get("message");
        String calcType = (String)customs.get("calcType");
        String focuspage = (String)customs.get("focuspage");
        this.getPageCache().put("status", "2");
        this.getPageCache().put("focuspage", "1");
        String orgid = (String)customs.get("orgid");
        if (StringUtil.isBlank((CharSequence)orgid)) {
            orgid = (String)customs.get("orgId");
        }
        this.showInnerTbPage("2", orgid);
        this.getView().showMessage(String.format(ResManager.loadKDString((String)"%s\u53d6\u6570\u5b8c\u6210", (String)"TcvatDraftPlugin_38", (String)"taxc-tcvat", (Object[])new Object[0]), message));
    }

    public boolean checkBeforeNextStep(String orgId, String startdate, String enddate, String status, String focusPage) {
        String lastpage = this.getPageCache().get("focuspage");
        if ("3".equals(focusPage) && "2".equals(lastpage) && this.showCalTaskProcess()) {
            return false;
        }
        String orgName = OrgUtils.getOrgNameById((String)orgId);
        String startDate = this.getPageCache().get("skssqq");
        String endDate = this.getPageCache().get("skssqz");
        String taxPayerType = this.getTaxpayerType(orgId, DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate));
        if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)Long.valueOf(orgId)).getData()).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"TcvatDraftPlugin_23", (String)"taxc-tcvat", (Object[])new Object[0]));
            return false;
        }
        if ("zzsybnsr_zjg".equals(this.getPageCache().get(TAXPAYER_TYPE_KEY)) || "zzsybnsr_fzjg".equals(this.getPageCache().get(TAXPAYER_TYPE_KEY))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u822a\u7a7a\u8fd0\u8f93\u4f01\u4e1a\u6682\u4e0d\u652f\u6301\u6c47\u603b\u7533\u62a5", (String)"TcvatDraftPlugin_13", (String)"taxc-tcvat", (Object[])new Object[0]), null);
            return false;
        }
        if (!this.checkDatas((Date)this.getModel().getValue("skssqq"), (Date)this.getModel().getValue("skssqz")).booleanValue()) {
            return false;
        }
        if (OrgCheckUtil.withoutLicenseCheck((IFormView)this.getView(), (String)orgId, (String)"tcvat", (String)TaxAppEnum.getEnumInstanceByAppid((String)"tcvat").getCategoryCode())) {
            return false;
        }
        if (!this.checkIncomeRuleData(orgId, startdate, enddate, focusPage)) {
            return false;
        }
        if (!("zzsybnsr".equals(taxPayerType) || "zzsxgmnsr".equals(taxPayerType) || "zzs".equals(taxPayerType) || this.getPageCache().get("planid") != null && StringUtils.equals((CharSequence)taxPayerType, (CharSequence)this.getPageCache().get("nowTaxPayerType")))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u5728\u3010%2$s\u3011-\u3010%3$s\u3011\u671f\u95f4\u6240\u5c5e\u7684\u6c47\u603b\u65b9\u6848\u72b6\u6001\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u786e\u8ba4\u91cd\u65b0\u751f\u6210\u5e95\u7a3f\u8fd8\u662f\u4fee\u6539\u6c47\u603b\u65b9\u6848\u3002", (String)"TcvatDraftPlugin_31", (String)"taxc-tcvat", (Object[])new Object[0]), orgName, startDate, endDate));
            return false;
        }
        if ("3".equals(focusPage)) {
            this.draftDto.setOrgId(Long.valueOf(orgId));
            this.draftDto.setStartDate((Date)this.getModel().getValue("skssqq"));
            this.draftDto.setEndDate(DateUtils.getLastDateOfMonth((Date)((Date)this.getModel().getValue("skssqz"))));
            this.draftDto.setDraftPurpose(this.getPageCache().get("draftpurpose"));
            this.draftDto.setTaxPayerType(taxPayerType);
            if (this.strategy.validDeductionDraft(this.draftDto).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u3010\u8fdb\u9879\u62b5\u6263\u5e95\u7a3f\u3011\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d\u5e94\u5f53\u5c0f\u4e8e\u6216\u7b49\u4e8e\u7a0e\u989d\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"TcvatDraftPlugin_24", (String)"taxc-tcvat", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    protected void recale() {
        if (this.showCalTaskProcess()) {
            return;
        }
        super.recale();
    }

    private boolean showCalTaskProcess() {
        DynamicObjectCollection draftTaskInfo = this.draftDao.queryRunninSchTaskByJobId(this.getJobId());
        if (draftTaskInfo.size() == 0) {
            return false;
        }
        String taskId = ((DynamicObject)draftTaskInfo.get(0)).getString("id");
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (null == taskInfo.getId() || taskInfo.isTaskEnd()) {
            return false;
        }
        this.showProgressForm(taskInfo);
        return true;
    }

    private void showProgressForm(TaskInfo taskInfo) {
        if (this.isExistProgressForm(taskInfo.getId())) {
            return;
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        FormShowParameter showParameter = this.createFormShowParameter(taskInfo, appId);
        this.getView().showForm(showParameter);
        this.getView().sendFormAction(this.getView());
        new PageCache(showParameter.getPageId()).put("isstart", "true");
        TaskClientProxy.setProgressPageId((String)taskInfo.getId(), (String)showParameter.getPageId());
    }

    protected boolean isExistProgressForm(String taskId) {
        IFormView progressView;
        String progressPageId = TaskClientProxy.getProgressPageId((String)taskId);
        if (StringUtils.isNotBlank((CharSequence)progressPageId) && (progressView = this.getView().getViewNoPlugin(progressPageId)) != null) {
            return false;
        }
        return false;
    }

    private FormShowParameter createFormShowParameter(TaskInfo taskInfo, String appId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("sch_taskprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(this.getJobName());
        showParameter.getCustomParams().put("ServiceAppId", appId);
        JobFormInfo jobFormInfo = this.tcvatDraftService.createJobFormInfo(appId, this.getJobName(), this.getJobId(), this.getTaskClassName(), this.getClickClassName(), null, null);
        jobFormInfo.setParentPageId(this.getView().getPageId());
        jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
        String jobInfoStr = SerializationUtils.toJsonString((Object)jobFormInfo);
        showParameter.getCustomParams().put("sch_clientjobinfo", jobInfoStr);
        showParameter.getCustomParams().put("sch_taskid", taskInfo.getId());
        return showParameter;
    }

    private boolean checkIncomeRuleData(String orgId, String startdate, String enddate, String focusPage) {
        String lastpage = this.getPageCache().get("focuspage");
        if ("3".equals(focusPage) && "2".equals(lastpage)) {
            IFormView incomePage;
            DynamicObjectCollection entryentity;
            String pageId = this.getPageCache().get("declarepageid");
            IFormView tabView = this.getView().getView(pageId);
            String incomePageId = tabView.getPageCache().get("loadtb-income");
            if (incomePageId != null && (entryentity = (incomePage = tabView.getView(incomePageId)).getModel().getEntryEntity("entryentity")) != null && entryentity.size() > 0) {
                ArrayList<Map<String, Object>> invalidOther = new ArrayList<Map<String, Object>>(entryentity.size());
                ArrayList<Map<String, Object>> invalidNone = new ArrayList<Map<String, Object>>(entryentity.size());
                this.tcvatDraftService.getInvalidNone(entryentity, invalidOther, invalidNone);
                if (invalidOther.size() > 0 || invalidNone.size() > 0) {
                    HashMap<String, Object> customParams = new HashMap<String, Object>();
                    customParams.put("orgid", orgId);
                    customParams.put("startdate", startdate);
                    customParams.put("enddate", enddate);
                    customParams.put("invalidOther", invalidOther);
                    customParams.put("invalidNone", invalidNone);
                    PageShowCommon.showForm((ShowType)ShowType.Modal, (String)INCOME_RULE_CHECK_PAGE, (IFormView)this.getView(), customParams, (IFormPlugin)this);
                }
            }
        }
        return true;
    }

    protected boolean beforeShowInnerTbPage(String focuspage, String orgId) {
        String msg;
        if ("1".equals(focuspage) && (msg = this.getPageCache().get("zzsybnsr_ybfz" + orgId)) != null) {
            this.getView().showConfirm(msg, MessageBoxOptions.OK, ConfirmTypes.Save, null);
        }
        String startDate = this.getPageCache().get("skssqq");
        String endDate = this.getPageCache().get("skssqz");
        String taxPayerType = this.getTaxpayerType(orgId, DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate));
        super.setDeclarePageMap(StrategyEnum.getByTaxPayerType(taxPayerType).getStrategy().getDeclareMapAndStatusMap());
        if ("zzsybnsr_zjg".equals(taxPayerType) || "zzsybnsr_fzjg".equals(taxPayerType)) {
            return true;
        }
        String lastpage = this.getPageCache().get("focuspage");
        String startdate = this.getPageCache().get("skssqq");
        String enddate = this.getPageCache().get("skssqz");
        if ("2".equals(focuspage) && "1".equals(lastpage)) {
            if (this.showCalTaskProcess() || "1".equals(this.getPageCache().get("status"))) {
                return true;
            }
            QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(orgId));
            QFilter q2 = new QFilter("skssqq", ">=", (Object)DateUtils.getDayFirst((Date)DateUtils.stringToDate((String)startdate)));
            QFilter q3 = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)DateUtils.stringToDate((String)enddate)));
            QFilter q4 = new QFilter("draftpurpose", "=", (Object)this.getPageCache().get("draftpurpose"));
            boolean ruleFlag = QueryServiceHelper.exists((String)("zzsybnsr".equals(taxPayerType) || "zzsxgmnsr".equals(taxPayerType) ? "tcvat_ybnsr_repeat_invoic" : "tcvat_checkdata_rule"), (QFilter[])new QFilter[]{q1, q2, q3, q4});
            boolean invoiceFlag = QueryServiceHelper.exists((String)("zzsybnsr".equals(taxPayerType) || "zzsxgmnsr".equals(taxPayerType) ? "tcvat_ybnsr_rule_invoice" : "tcvat_checkdata_invoice"), (QFilter[])new QFilter[]{q1, q2, q3, q4});
            if (ruleFlag || invoiceFlag) {
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put("ruleFlag", ruleFlag);
                customParams.put("invoiceFlag", invoiceFlag);
                customParams.put("orgid", orgId);
                customParams.put("startdate", startdate);
                customParams.put("enddate", enddate);
                customParams.put("taxpayertype", taxPayerType);
                customParams.put("draftpurpose", this.getPageCache().get("draftpurpose"));
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)("zzsybnsr".equals(taxPayerType) || "zzsxgmnsr".equals(taxPayerType) ? YBNSR_CHECK_PAGE : "tcvat_check_rule"), (IFormView)this.getView(), customParams, (IFormPlugin)this);
            }
        }
        if ("3".equals(focuspage)) {
            this.draftDto.setOrgId(Long.valueOf(orgId));
            this.draftDto.setStartDate((Date)this.getModel().getValue("skssqq"));
            this.draftDto.setEndDate((Date)this.getModel().getValue("skssqz"));
            this.draftDto.setDraftPurpose(this.getPageCache().get("draftpurpose"));
            this.draftDto.setTaxPayerType(this.getPageCache().get("taxpayertype"));
            if (this.strategy.validDeductionDraft(this.draftDto).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u3010\u8fdb\u9879\u62b5\u6263\u5e95\u7a3f\u3011\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d\u5e94\u5f53\u5c0f\u4e8e\u6216\u7b49\u4e8e\u7a0e\u989d\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"TcvatDraftPlugin_24", (String)"taxc-tcvat", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public Boolean checkDatas(Date startDate, Date endDate) {
        if (!this.isValidDates(startDate, endDate)) {
            this.getPageCache().remove("zzsybnsr_ybfz" + this.getPageCache().get("orgid"));
            return Boolean.FALSE;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        this.draftDto.setOrgId(org.getLong("id"));
        this.draftDto.setStartDate(startDate);
        this.draftDto.setEndDate(endDate);
        if (!TaxDeclareHelper.validByTaxLimit(this.draftDto)) {
            this.getPageCache().remove("zzsybnsr_ybfz" + this.getPageCache().get("orgid"));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u671f\u95f4\u4e0e\u7f34\u7eb3\u671f\u9650\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TcvatDraftPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (this.setOrgType(this.getPageCache().get("orgid"))) {
            return Boolean.FALSE;
        }
        String deadLine = this.getPageCache().get("deadLine");
        String planid = this.getPageCache().get("planid");
        if ("ajsb".equals(deadLine) && StringUtils.isNotBlank((CharSequence)planid)) {
            this.getPageCache().remove("zzsybnsr_ybfz" + this.getPageCache().get("orgid"));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5b63\u5ea6\u6c47\u603b\u7533\u62a5\uff0c\u8bf7\u8c03\u6574\u7a0e\u79cd\u5361\u7247\u7684\u57fa\u7840\u4fe1\u606f\u3002", (String)"TcvatDraftPlugin_32", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"recalc", "next", "fastsetting"});
            return Boolean.FALSE;
        }
        Boolean success = Boolean.TRUE;
        String taxpayertype = this.getTemplateType();
        List<DraftDto> draftCollect = this.getDraftByCondition(startDate, endDate);
        List object = draftCollect.stream().filter(o -> !o.getTemplateType().equals(taxpayertype) || ((Date)o.getStartDate()).compareTo(startDate) != 0 || ((Date)o.getEndDate()).compareTo(endDate) != 0).collect(Collectors.toList());
        if (object.size() > 0) {
            logger.info("draft is deplicate,taxpayertype={},object={}", (Object)taxpayertype, (Object)SerializationUtils.toJsonString(object.get(0)));
            success = Boolean.FALSE;
            String orgName = OrgUtils.getOrgNameById((String)this.getPageCache().get("orgid"));
            String draftType = (String)TemplateTypeConstant.getNsrtypemap().get(((DraftDto)object.get(0)).getTemplateType());
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%1$s\u3011\u5df2\u5b58\u5728\u5c5e\u671f\u4e3a\u3010%2$s\u3011\u81f3\u3010%3$s\u3011\u7684\u3010%4$s\u3011\u5e95\u7a3f,\u65e0\u9700\u751f\u6210\u3002", (String)"TcvatDraftPlugin_19", (String)"taxc-tcvat", (Object[])new Object[0]), orgName, DateUtils.format((Date)((Date)((DraftDto)object.get(0)).getStartDate())), DateUtils.format((Date)((Date)((DraftDto)object.get(0)).getEndDate())), draftType));
        }
        return success;
    }

    protected List<DraftDto> getDraftByCondition(Date startDate, Date endDate) {
        return this.tcvatDraftService.getAllNssbDraftByCondition(this.getPageCache().get("orgid"), startDate, endDate);
    }

    protected String[] getTaxLimits() {
        return new String[]{"season", "month"};
    }

    protected DynamicObject queryDynamicObject(String focuspage, String templateType, String orgId, String startdate, String enddate) {
        if ("1".equals(focuspage)) {
            String taxpayerType = this.getTaxpayerType(orgId, DateUtils.stringToDate((String)startdate), DateUtils.stringToDate((String)enddate));
            return TcvatDraftService.queryPolicyConfirmId("nssb", taxpayerType, templateType, orgId, startdate, enddate, this.getPageCache().get("planid"));
        }
        return null;
    }

    protected void deleteAllDraftData(String templateType, String orgId, String startdate, String enddate) {
        String draftpurpose = this.getPageCache().get("draftpurpose");
        new DraftService().setDefaultRiskInfoNoZlb(draftpurpose, orgId, startdate, enddate, templateType);
    }

    protected String getMsg() {
        return ResManager.loadKDString((String)"\u91cd\u7f6e\u5e95\u7a3f\u5c06\u5bfc\u81f4\u539f\u6709\u5e95\u7a3f\u6570\u636e\u88ab\u6e05\u7a7a\u4e14\u91cd\u65b0\u8ba1\u7b97\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"TcvatDraftPlugin_33", (String)"taxc-tcvat", (Object[])new Object[0]);
    }

    protected String getReFetchMsg() {
        return ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570\u4f1a\u3010\u4fdd\u7559\u624b\u5de5\u8c03\u6574\u6570\u503c\u3011\uff0c\u53d6\u6570\u89c4\u5219\u53ca\u5355\u5143\u683c\u95f4\u8ba1\u7b97\u516c\u5f0f\u5c06\u91cd\u65b0\u8ba1\u7b97\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"TcvatDraftPlugin_40", (String)"taxc-tcvat", (Object[])new Object[0]);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (this.getModel().getValue("org") == null) {
            return;
        }
        String itemKey = afterDoOperationEventArgs.getOperateKey();
        if ("recalc".equals(itemKey)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            String orgId = org.getString("id");
            String orgName = OrgUtils.getOrgNameById((String)orgId);
            String startDate = this.getPageCache().get("skssqq");
            String endDate = this.getPageCache().get("skssqz");
            String taxPayerType = this.getTaxpayerType(orgId, DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate));
            if (!("zzsybnsr".equals(taxPayerType) || "zzsxgmnsr".equals(taxPayerType) || "zzs".equals(taxPayerType) || this.getPageCache().get("planid") != null)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u5728\u3010%2$s\u3011-\u3010%3$s\u3011\u671f\u95f4\u6240\u5c5e\u7684\u6c47\u603b\u65b9\u6848\u72b6\u6001\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u786e\u8ba4\u91cd\u65b0\u751f\u6210\u5e95\u7a3f\u8fd8\u662f\u4fee\u6539\u6c47\u603b\u65b9\u6848\u3002", (String)"TcvatDraftPlugin_31", (String)"taxc-tcvat", (Object[])new Object[0]), orgName, startDate, endDate));
                return;
            }
        }
        if ("fastsetting".equals(itemKey)) {
            String orgId = this.getPageCache().get("orgid");
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put("orgid", orgId);
            customParams.put("parent", "1874049518841207808");
            PageShowCommon.showBillList((String)"bos_templatetreelist", (ShowType)ShowType.MainNewTabPage, (String)"tcvat_sbx_rule_config", (IFormView)this.getView(), customParams, null);
        }
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public String getAttachmentFieldName() {
        return "attachmentpanelap";
    }

    public String getAttachmentPanelName() {
        return "flexpanelapat";
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    protected void markEditStatus() {
        QFilter qFilter = new QFilter("draftnumber", "=", this.getModel().getValue("draftnumber"));
        QFilter isRushModifyFilter = new QFilter("isrefreshmodify", "=", (Object)Boolean.FALSE);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(2);
        filterList.add(qFilter);
        filterList.add(isRushModifyFilter);
        DynamicObject[] updateData = this.draftEditDao.loadAllDraft(filterList);
        Arrays.stream(updateData).forEach(e -> e.set("isrefreshmodify", (Object)Boolean.TRUE));
        SaveServiceHelper.update((DynamicObject[])updateData);
    }

    protected boolean beforeLoadData(Date newValue) {
        String deadLine = TaxBaseDataUtils.getDeadLine((Long)Long.parseLong(this.getPageCache().get("orgid")), (String)"zzs", (Date)newValue);
        if (StringUtils.isBlank((CharSequence)deadLine)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7a0e\u52a1\u7ec4\u7ec7\u5728\u6b64\u201c\u6240\u5c5e\u7a0e\u671f\u201d\u671f\u95f4\u5185\u672a\u542f\u7528\u589e\u503c\u7a0e\u7a0e\u79cd\u5361\u7247\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u201c\u6240\u5c5e\u7a0e\u671f\u8d77/\u6b62\u201d\u3002", (String)"TcvatDraftPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            return true;
        }
        Map<String, Date> nssbDate = PeriodService.nowProvisionPeriod(newValue, deadLine);
        this.getPageCache().put("dateChanged", "true");
        this.getModel().setValue("skssqq", (Object)nssbDate.get("startDate"));
        this.getPageCache().put("dateChanged", "true");
        this.getModel().setValue("skssqz", (Object)nssbDate.get("endDate"));
        this.getPageCache().remove("dateChanged");
        String templateType = this.getTemplateType();
        if (ObjectUtils.isNotEmpty((Object)templateType) && templateType.startsWith("orgmsg")) {
            this.getView().showErrorNotification(templateType.substring(6));
            return true;
        }
        return false;
    }

    protected EngineModel getEngineModel(String orgId, String startdate, String enddate, String draftpurpose) {
        EngineModel model = super.getEngineModel(orgId, startdate, enddate, draftpurpose);
        TcvatEngineModel tcvatEngineModel = new TcvatEngineModel(orgId, startdate, enddate);
        tcvatEngineModel.getCustom().putAll(model.getCustom());
        tcvatEngineModel.setDraftMetaDataDTO(DraftMetaDataDTO.getMetaData(draftpurpose, this.getPageCache().get(TAXPAYER_TYPE_KEY)));
        return tcvatEngineModel;
    }
}

