/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.draft;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.service.rule.RuleService;
import org.apache.commons.lang3.StringUtils;

public class TcvatPolicyRulesPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String INCOME_RULE_TAB = "incomeruletab";
    private static final String ROLLOUT_RULE_TAB = "rolloutruletab";
    private static final String INPUT_DEDUCT_RULE_TAB = "inputdeductrulelab";
    private static final String JZJTJXSE_TAB = "jzjtjxsetab";
    private static final String DIFF_RULE_TAB = "diffruletab";
    private static final String PERPRE_RULE_TAB = "perpreruletab";
    private static final String DEDUCT_RULE_TAB = "deductruletab";
    private static final String MDTS_RULE_TAB = "mdtsruletab";
    private static final String TCVAT_RULE_JZJT_JXSE = "tcvat_rule_jzjt_jxse";
    private RuleService ruleService = new RuleService();

    public void registerListener(EventObject e) {
        Tab tabap = (Tab)this.getControl("tabap");
        tabap.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.getView().setVisible(Boolean.valueOf(!"xgmnsr".equals(params.get("taxpayertype"))), new String[]{ROLLOUT_RULE_TAB, INPUT_DEDUCT_RULE_TAB, JZJTJXSE_TAB, PERPRE_RULE_TAB, MDTS_RULE_TAB});
        String datas = (String)params.get("ruledata");
        if (StringUtils.isNotBlank((CharSequence)datas)) {
            JSONObject ruledata = JSONObject.parseObject((String)datas);
            this.loadincomerules(ruledata);
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        if (StringUtils.isEmpty((CharSequence)tabKey) || this.isLoaded(tabKey)) {
            return;
        }
        String flag = "loadtb-" + tabKey;
        this.getPageCache().put(flag, tabKey);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String datas = (String)params.get("ruledata");
        if (StringUtil.isNotBlank((CharSequence)datas)) {
            JSONObject ruledata = JSON.parseObject((String)datas);
            switch (tabKey) {
                case "incomeruletab": {
                    this.loadincomerules(ruledata);
                    break;
                }
                case "rolloutruletab": {
                    this.loadrolloutrules(ruledata);
                    break;
                }
                case "inputdeductrulelab": {
                    this.loaddeductrule(ruledata);
                    break;
                }
                case "jzjtjxsetab": {
                    this.loadJzjtJxserule(ruledata);
                    break;
                }
                case "diffruletab": {
                    this.loaddiffrules(ruledata);
                    break;
                }
                case "perpreruletab": {
                    this.loadperprerules(ruledata);
                    break;
                }
                case "deductruletab": {
                    this.loaddeductrules(ruledata);
                    break;
                }
                case "mdtsruletab": {
                    this.loadmdtsrules(ruledata);
                    break;
                }
            }
        }
    }

    private void loadJzjtJxserule(JSONObject ruledata) {
        String jzjtseentity = "jzjtseentity";
        if (this.getModel().getDataEntityType().getProperty(jzjtseentity) != null) {
            this.getModel().beginInit();
            this.getModel().deleteEntryData(jzjtseentity);
            Map jzjtMap = MetadataUtil.getComboItemsMap((String)TCVAT_RULE_JZJT_JXSE, (String)"jzjtlx");
            JSONArray rules = ruledata.getJSONArray(RuleTypeEnum.JZJTSE.name());
            for (int i = 0; i < rules.size(); ++i) {
                JSONObject rule = rules.getJSONObject(i);
                int row = this.getModel().createNewEntryRow(jzjtseentity);
                this.getModel().setValue("jzjtseid", rule.get((Object)"id"), row);
                this.getModel().setValue("jzjtserulename", (Object)rule.getJSONObject("name").getString("zh_CN"), row);
                this.getModel().setValue("jzjtsemodifydate", rule.get((Object)"modifytime"), row);
                this.getModel().setValue("jzjtseenable", rule.get((Object)"enable"), row);
                String ruletype = rule.getString("ruletype");
                this.getModel().setValue("jzjtseruletype", (Object)ruletype, row);
                this.getModel().setValue("jzjtlx", jzjtMap.get(rule.getString("jzjtlx")), row);
                this.getModel().setValue("jzjtserulepurpose", (Object)this.ruleService.getRulePurposeName(TCVAT_RULE_JZJT_JXSE, rule.getString("rulepurpose")), row);
                this.setBackgroundAndImage(row, "jzjtse", rule.getString("taxpayertype"));
            }
            this.getModel().endInit();
            this.getView().updateView(jzjtseentity);
        }
    }

    private void loadincomerules(JSONObject ruledata) {
        this.getModel().deleteEntryData("incomeentity");
        JSONArray rules = ruledata.getJSONArray(RuleTypeEnum.INCOME.name());
        this.getView().setVisible(Boolean.valueOf(0 == rules.size()), new String[]{"incomeimage"});
        Map jzjtMap = MetadataUtil.getComboItemsMap((String)"tcvat_rule_income", (String)"jzjt");
        CardEntry incomeentity = (CardEntry)this.getControl("incomeentity");
        this.getModel().beginInit();
        for (int i = 0; i < rules.size(); ++i) {
            JSONObject rule = rules.getJSONObject(i);
            int row = this.getModel().createNewEntryRow("incomeentity");
            this.getModel().setValue("incomerulename", (Object)rule.getJSONObject("name").getString("zh_CN"), row);
            this.getModel().setValue("incomemodifydate", (Object)rule.getDate("modifytime"), row);
            this.getModel().setValue("jzjt", jzjtMap.get(rule.getString("jzjt")), row);
            this.getModel().setValue("taxrate", (Object)rule.getJSONObject("taxrate").getJSONObject("name").getString("zh_CN"), row);
            this.getModel().setValue("ruletaxation", (Object)rule.getJSONObject("taxation").getJSONObject("name").getString("zh_CN"), row);
            this.getModel().setValue("incomerulepurpose", (Object)this.ruleService.getRulePurposeName("tcvat_rule_income", rule.getString("rulepurpose")), row);
            if ("xgmnsr".equals(rule.getString("taxpayertype"))) {
                incomeentity.setChildVisible(false, row, new String[]{"cardflexpanelap4"});
                this.getModel().setValue("income_label1", (Object)ResManager.loadKDString((String)"\u5c0f\u89c4\u6a21", (String)"TcvatPolicyRulesPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]), row);
            }
            this.setBackgroundAndImage(row, "income", rule.getString("taxpayertype"));
        }
        this.getModel().endInit();
        this.getView().updateView("incomeentity");
    }

    private void loaddeductrule(JSONObject ruledata) {
        if (this.getModel().getDataEntityType().getProperty("deductentity") != null) {
            this.getModel().beginInit();
            this.getModel().deleteEntryData("deductentity");
            Map jzjtMap = MetadataUtil.getComboItemsMap((String)"tcvat_rule_deduct", (String)"jzjt");
            JSONArray rules = ruledata.getJSONArray(RuleTypeEnum.DEDUCT.name());
            for (int i = 0; i < rules.size(); ++i) {
                JSONObject rule = rules.getJSONObject(i);
                int row = this.getModel().createNewEntryRow("deductentity");
                this.getModel().setValue("deductid", rule.get((Object)"id"), row);
                this.getModel().setValue("deductrulename", (Object)rule.getJSONObject("name").getString("zh_CN"), row);
                this.getModel().setValue("deductmodifydate", rule.get((Object)"modifytime"), row);
                this.getModel().setValue("deductenable", rule.get((Object)"enable"), row);
                String ruletype = rule.getString("ruletype");
                this.getModel().setValue("deductruletype", (Object)ruletype, row);
                this.getModel().setValue("deducttype", (Object)rule.getJSONObject("deducttype").getJSONObject("name").getString("zh_CN"), row);
                this.getModel().setValue("deductjzjt", jzjtMap.get(rule.getString("jzjt")), row);
                this.getModel().setValue("deductrulepurpose", (Object)this.ruleService.getRulePurposeName("tcvat_rule_deduct", rule.getString("rulepurpose")), row);
                this.setBackgroundAndImage(row, "deduct", rule.getString("taxpayertype"));
            }
            this.getModel().endInit();
            this.getView().updateView("deductentity");
        }
    }

    private void loadrolloutrules(JSONObject ruledata) {
        JSONArray rules = ruledata.getJSONArray(RuleTypeEnum.ROLL_OUT.name());
        this.getView().setVisible(Boolean.valueOf(0 == rules.size()), new String[]{"rolloutimage"});
        Map jzjtMap = MetadataUtil.getComboItemsMap((String)"tcvat_rule_rollout", (String)"jzjt");
        this.getModel().beginInit();
        for (int i = 0; i < rules.size(); ++i) {
            JSONObject rule = rules.getJSONObject(i);
            int row = this.getModel().createNewEntryRow("rolloutentity");
            this.getModel().setValue("rolloutrulename", (Object)rule.getJSONObject("name").getString("zh_CN"), row);
            this.getModel().setValue("rolloutmodifydate", (Object)rule.getDate("modifytime"), row);
            this.getModel().setValue("rollouttype", (Object)rule.getJSONObject("rollouttype").getString("value"), row);
            this.getModel().setValue("jzjt1", jzjtMap.get(rule.getString("jzjt")), row);
            this.getModel().setValue("rolloutrulepurpose", (Object)this.ruleService.getRulePurposeName("tcvat_rule_rollout", rule.getString("rulepurpose")), row);
            this.setBackgroundAndImage(row, "rollout", rule.getString("taxpayertype"));
        }
        this.getModel().endInit();
        this.getView().updateView("rolloutentity");
    }

    private void loaddiffrules(JSONObject ruledata) {
        JSONArray rules = ruledata.getJSONArray(RuleTypeEnum.DIFF.name());
        this.getView().setVisible(Boolean.valueOf(0 == rules.size()), new String[]{"diffimage"});
        Map jzjtMap = MetadataUtil.getComboItemsMap((String)"tcvat_rule_diff", (String)"deductproject");
        CardEntry diffentity = (CardEntry)this.getControl("diffentity");
        this.getModel().beginInit();
        for (int i = 0; i < rules.size(); ++i) {
            JSONObject rule = rules.getJSONObject(i);
            int row = this.getModel().createNewEntryRow("diffentity");
            this.getModel().setValue("diffrulename", (Object)rule.getJSONObject("name").getString("zh_CN"), row);
            this.getModel().setValue("diffmodifydate", (Object)rule.getDate("modifytime"), row);
            this.getModel().setValue("difftype", (Object)rule.getJSONObject("difftype").getString("value"), row);
            this.getModel().setValue("deductproject", jzjtMap.get(rule.getString("deductproject")), row);
            this.getModel().setValue("diffrulepurpose", (Object)this.ruleService.getRulePurposeName("tcvat_rule_diff", rule.getString("rulepurpose")), row);
            if ("xgmnsr".equals(rule.getString("taxpayertype"))) {
                diffentity.setChildVisible(false, row, new String[]{"cardflexpanelap42"});
                this.getModel().setValue("diff_label1", (Object)ResManager.loadKDString((String)"\u5c0f\u89c4\u6a21", (String)"TcvatPolicyRulesPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]), row);
            }
            this.setBackgroundAndImage(row, "diff", rule.getString("taxpayertype"));
        }
        this.getModel().endInit();
        this.getView().updateView("diffentity");
        if ("xgmnsr".equals(this.getPageCache().get("taxpayertype"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"cardflexpanelap4"});
        }
    }

    private void loadperprerules(JSONObject ruledata) {
        RuleService ruleService = new RuleService();
        JSONArray rules = ruledata.getJSONArray(RuleTypeEnum.PERPRE.name());
        this.getModel().beginInit();
        for (int i = 0; i < rules.size(); ++i) {
            JSONObject rule = rules.getJSONObject(i);
            int row = this.getModel().createNewEntryRow("perpreentity");
            this.getModel().setValue("perprerulename", (Object)rule.getJSONObject("name").getString("zh_CN"), row);
            this.getModel().setValue("perpremodifydate", (Object)rule.getDate("modifytime"), row);
            this.getModel().setValue("perpreproject", (Object)rule.getJSONObject("perpreproduct").getString("value"), row);
            this.getModel().setValue("perprerulepurpose", (Object)ruleService.getRulePurposeName("tcvat_rule_perpre", rule.getString("rulepurpose")), row);
            this.setBackgroundAndImage(row, "perpre", rule.getString("taxpayertype"));
        }
        this.getModel().endInit();
        this.getView().updateView("perpreentity");
    }

    private void loadmdtsrules(JSONObject ruledata) {
        RuleService ruleService = new RuleService();
        JSONArray rules = ruledata.getJSONArray(RuleTypeEnum.MDTS.name());
        ComboProp mdTypeProp = (ComboProp)MetadataServiceHelper.getDataEntityType((String)"tcvat_rule_mdts").getProperty("mdtype");
        this.getModel().beginInit();
        for (int i = 0; i < rules.size(); ++i) {
            JSONObject rule = rules.getJSONObject(i);
            int row = this.getModel().createNewEntryRow("mdtsentity");
            this.getModel().setValue("mdtsrulename", (Object)rule.getJSONObject("name").getString("zh_CN"), row);
            this.getModel().setValue("mdtsmodifydate", (Object)rule.getDate("modifytime"), row);
            this.getModel().setValue("mdtype", (Object)mdTypeProp.getItemByName(rule.getString("mdtype")), row);
            this.getModel().setValue("mdtsrulepurpose", (Object)ruleService.getRulePurposeName("tcvat_rule_mdts", rule.getString("rulepurpose")), row);
            this.setBackgroundAndImage(row, "mdts", rule.getString("taxpayertype"));
        }
        this.getModel().endInit();
        this.getView().updateView("mdtsentity");
    }

    private void loaddeductrules(JSONObject ruledata) {
        JSONArray rules = ruledata.getJSONArray(RuleTypeEnum.REDUCE.name());
        this.getView().setVisible(Boolean.valueOf(0 == rules.size()), new String[]{"deductimage"});
        CardEntry deductentity = (CardEntry)this.getControl("deductionentity");
        this.getModel().beginInit();
        for (int i = 0; i < rules.size(); ++i) {
            JSONObject rule = rules.getJSONObject(i);
            int row = this.getModel().createNewEntryRow("deductionentity");
            this.getModel().setValue("deductionrulename", (Object)rule.getJSONObject("name").getString("zh_CN"), row);
            this.getModel().setValue("deductionmodifydate", (Object)rule.getDate("modifytime"), row);
            this.getModel().setValue("deductiontype", (Object)rule.getString("reductiontype"), row);
            this.getModel().setValue("deductionrulepurpose", (Object)this.ruleService.getRulePurposeName("tcvat_rule_deduction", rule.getString("rulepurpose")), row);
            if ("xgmnsr".equals(rule.getString("taxpayertype"))) {
                deductentity.setChildVisible(false, row, new String[]{"cardflexpanelap421"});
                this.getModel().setValue("deduction_label1", (Object)ResManager.loadKDString((String)"\u5c0f\u89c4\u6a21", (String)"TcvatPolicyRulesPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]), row);
            }
            this.setBackgroundAndImage(row, "deduction", rule.getString("taxpayertype"));
        }
        this.getModel().endInit();
        this.getView().updateView("deductionentity");
        if ("xgmnsr".equals(this.getPageCache().get("taxpayertype"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"cardflexpanelap4"});
        }
    }

    private void setBackgroundAndImage(int row, String type, String taxPayerType) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>(16);
        HashMap<String, String> propertiesMap1 = new HashMap<String, String>(16);
        HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>(16);
        if ("xgmnsr".equals(taxPayerType)) {
            propertiesMap.put("bc", "rgba(255,246,239,1)");
            propertiesMap1.put("bgik", "linear-gradient(337deg,rgba(250,201,134,0.15) 0%,rgba(245,145,64,0.15) 100%)");
            propertiesMap1.put("fc", "#FF903D");
        } else {
            propertiesMap.put("bc", "rgba(241,247,255,1)");
            propertiesMap1.put("bgik", "linear-gradient(327deg,rgba(100,171,255,0.15) 0%,rgba(52,140,242,0.15) 100%)");
            propertiesMap1.put("fc", "#55A0F5");
        }
        pmap.put(type + "_flex", propertiesMap);
        pmap.put(type + "_image", propertiesMap);
        pmap.put(type + "_bc", propertiesMap1);
        ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        client.invokeControlMethod(type + "entity", "setCustomProperties", new Object[]{row, pmap});
    }

    private boolean isLoaded(String tabKey) {
        return null != this.getPageCache().get("loadtb-" + tabKey);
    }
}

