/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.draft.rta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportMultiQueryListPlugin;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.draft.vatrta.VatRtaService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class VatRtaListPlugin
extends AbstractDeclareReportMultiQueryListPlugin {
    private VatRtaService service = new VatRtaService();

    public void filterContainerInit(FilterContainerInitArgs args) {
        List filterColumnList = args.getCommonFilterColumns();
        for (FilterColumn column : filterColumnList) {
            String orgid;
            long orgId;
            if (!"org.name".equals(column.getFieldName())) continue;
            long userId = RequestContext.get().getCurrUserId();
            String entityid = ((ListView)this.getView()).getBillFormId();
            String appid = this.getView().getFormShowParameter().getAppId();
            List<Long> orgIds = this.service.queryYbnsrOrgIdsWithPerm(userId, appid, entityid);
            if (orgIds.contains(orgId = RequestContext.get().getOrgId())) {
                orgid = String.valueOf(orgId);
                column.setDefaultValue(orgid);
                this.getPageCache().put("orgid", orgid);
                continue;
            }
            if (!CollectionUtils.isNotEmpty(orgIds)) continue;
            orgid = String.valueOf(orgIds.get(0));
            column.setDefaultValue(orgid);
            this.getPageCache().put("orgid", orgid);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if ("org.id".equalsIgnoreCase(args.getFieldName())) {
            long userId = RequestContext.get().getCurrUserId();
            String entityid = ((ListView)this.getView()).getBillFormId();
            String appid = this.getView().getFormShowParameter().getAppId();
            List<Long> orgIds = this.service.queryYbnsrOrgIdsWithPerm(userId, appid, entityid);
            QFilter orgQfilter = new QFilter("id", "in", orgIds);
            args.getQfilters().add(orgQfilter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey = evt.getOperateKey();
        BillList billList = (BillList)this.getControl("billlistap");
        if ("viewjtdraft".equals(operateKey) || "viewsbb".equals(operateKey) || "viewsjjnd".equals(operateKey)) {
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.size() != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"VatRtaListPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            Long primaryKeyValue = (Long)billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            DynamicObject vatRta = this.service.loadSingleVatRta(primaryKeyValue);
            if (vatRta == null) {
                return;
            }
            DynamicObject org = vatRta.getDynamicObject("org");
            Date skssqq = vatRta.getDate("skssqq");
            Date skssqz = vatRta.getDate("skssqz");
            if (org == null || skssqq == null || skssqz == null) {
                return;
            }
            Map<String, Object> taxPayerTypeMap = TaxDeclareHelper.getTaxPayerType(org.getString("id"), skssqq, skssqz);
            String taxpayertype = (String)taxPayerTypeMap.get("taxpayertype");
            if (StringUtils.isNotBlank((CharSequence)taxpayertype)) {
                if ("viewjtdraft".equals(operateKey)) {
                    String templatetype = "draft_" + taxpayertype + "_sjjt";
                    List<Long> ids = this.service.querySjjtDraftIds(org.getLong("id"), templatetype, skssqq, skssqz);
                    HashMap<String, Object> cusMap = new HashMap<String, Object>();
                    cusMap.put("draftpurpose", "sjjt");
                    cusMap.put("templatetype", templatetype);
                    this.showJointSearch("tcvat_sjjt_draft_query", ids, cusMap);
                } else if ("viewsbb".equals(operateKey)) {
                    List<Long> ids = this.service.querySbbIds(org.getLong("id"), taxpayertype, skssqq, skssqz);
                    this.showJointSearch("tcvat_zzs_declare_list", ids, Collections.emptyMap());
                } else {
                    List<Long> ids = this.service.queryPayRecordIds(org.getLong("id"), taxpayertype, skssqq, skssqz);
                    HashMap<String, Object> customParams = new HashMap<String, Object>();
                    customParams.put("menu", "pay");
                    this.showJointSearch("bdtaxr_pay_record", ids, customParams);
                }
            }
        } else if ("newjtd".equals(evt.getOperateKey()) && evt.getOperationResult().isSuccess()) {
            String entityId = ((Donothing)evt.getSource()).getEntityId();
            String operateName = ((Donothing)evt.getSource()).getOperateName().getLocaleValue();
            OperationResult operationResult = evt.getOperationResult();
            String msg = this.service.processJtdMsg(operationResult, entityId, operateName);
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                this.getView().showSuccessNotification(msg);
            }
        } else if ("deletejtd".equals(operateKey) && evt.getOperationResult().isSuccess()) {
            String entityId = ((Donothing)evt.getSource()).getEntityId();
            String operateName = ((Donothing)evt.getSource()).getOperateName().getLocaleValue();
            OperationResult operationResult = evt.getOperationResult();
            String msg = this.service.processJtdMsg(operationResult, entityId, operateName);
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                this.getView().showSuccessNotification(msg);
            }
        } else if (StringUtil.equals((CharSequence)operateKey, (CharSequence)"checkjtd") && evt.getOperationResult().isSuccess()) {
            String entityId = ((Donothing)evt.getSource()).getEntityId();
            String operateName = ((Donothing)evt.getSource()).getOperateName().getLocaleValue();
            Map billNosMap = evt.getOperationResult().getBillNos();
            Collection billNos = billNosMap.values();
            ArrayList resultbillNos = new ArrayList(billNos);
            List ids = evt.getOperationResult().getSuccessPkIds();
            if (ObjectUtils.isNotEmpty((Object)ids)) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle(ids.get(0), (String)entityId);
                String appid = this.getView().getFormShowParameter().getAppId();
                ListShowParameter parameter = this.service.getProvistonBillPageParameter(appid, dynamicObject.getString("org.id"), dynamicObject.getString("taxsystem.id"), dynamicObject.getString("billno"), dynamicObject.getString("taxtype.number"));
                this.getView().showForm((FormShowParameter)parameter);
                String billEntity = dynamicObject.getDataEntityType().getName();
                if (resultbillNos.size() > 0) {
                    String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801:%s\u67e5\u770b\u8ba1\u63d0\u5355\u6210\u529f\u3002", (String)"VatRtaListPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]), resultbillNos.get(0));
                    OperatorDialogUtils.operateDialog((String)"zzs", (String)billEntity, (String)operateName, (String)operateDescription);
                }
            } else if (resultbillNos.size() > 0) {
                String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801:%s\u67e5\u770b\u8ba1\u63d0\u5355\u5931\u8d25\u3002", (String)"VatRtaListPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]), resultbillNos.get(0));
                OperatorDialogUtils.operateDialog((String)"zzs", (String)entityId, (String)operateName, (String)operateDescription);
            }
        } else if (!("submit".equals(operateKey) || "unsubmit".equals(operateKey) || "audit".equals(operateKey) || "unaudit".equals(operateKey))) {
            super.afterDoOperation(evt);
        }
        billList.refresh();
    }

    private void showJointSearch(String entityName, List<Long> linkQueryPkIds, Map<String, Object> customParams) {
        if (CollectionUtils.isNotEmpty(linkQueryPkIds)) {
            this.getView().showForm((FormShowParameter)this.service.getJointSearchParameter(entityName, linkQueryPkIds, customParams));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u65e0\u6570\u636e\u3002", (String)"VatRtaListPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    protected void setExtendCustomParams(Map<String, Object> customParams, DynamicObject object) {
    }

    public String getModelNumber() {
        return MultiTableEnum.TSD001.getModel();
    }

    protected List<String> getTemplateTypeList() {
        return Collections.singletonList("VAT_RTA");
    }
}

