/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.identification;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.service.OrgService;
import kd.taxc.tcvat.business.service.identification.InvoiceSignRptService;
import kd.taxc.tcvat.business.service.prepay.PrepayProjectService;

public class InputInvoiceSignRptPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String BUTTON_UNSIGN_KEY = "cancelprojectsign";
    private static final String BUTTON_SIGN_KEY = "projectsign";
    public static final String BUTTON_SPLIT_KEY = "splitinvoice";
    public static final String BUTTON_UNSPLIT_KEY = "cancelsplitinvoice";
    public static final String BUTTON_DEVIDE_KEY = "devide";
    public static final String BUTTON_UNDEVIDE_KEY = "canceldevide";
    public static final String PROJECT_SELECT_FORM = "tcvat_prepay_project_sele";
    public static final String PROJECT_ENTITY = "tcvat_prepay_project_info";
    public static final String REPORTLISTAP = "reportlistap";
    public static final String TOOLBARAP = "toolbarap";
    public static final String TCVAT_DEVIDE_DETAIL = "tcvat_devide_detail";
    public static final String INVOICEID = "invoiceid";
    public static final String TYPE_COUNT = "count";
    public static final String INVOICENO = "invoiceno";
    public static final String PROJECTID = "projectid";
    public static final String COMMA = ",";
    public static final String ID = "id";
    public static final String TYPE = "type";
    public static final String NEW_INVOICE_TYPE = "baseinvoicetype.number";
    public static final String DEVIDESTATE = "devidestate";
    public static final String PROJECTNAME = "projectname";
    public static final String ENTITY_PROJECT_DEVIDE = "tcvat_project_devide";
    public static final String PROJECT = "project";
    public static final String SPLITSIGN = "splitsign";
    public static final String ENTITY_INVOICE_PROJECT = "tcvat_in_invoice_project";
    public static final String FIDS = "fids";
    public static final String DEVIDEID = "devideid";
    public static final String SPLIT = "split";
    public static final String SPLIT_DO = "true";
    public static final String SPLIT_UNDO = "false";
    public static final String DEVIDESTATE_DEVIDED = "1";

    public void registerListener(EventObject e) {
        ReportList reportlist = (ReportList)this.getView().getControl(REPORTLISTAP);
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{TOOLBARAP});
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("bos_org".equals(args.getRefEntityId())) {
            HasPermOrgResult result = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            if (result == null || result.hasAllOrgPerm()) {
                return;
            }
            HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            if (EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm()) {
                List orgList = hasPermOrgResult.getHasPermOrgs();
                QFilter idsFilter = new QFilter(ID, "in", (Object)orgList).and("fisaccounting", "=", (Object)DEVIDESTATE_DEVIDED);
                args.getCustomQFilters().add(idsFilter);
            }
        }
    }

    public void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        Long orgId = RequestContext.get().getOrgId();
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        List orgList = hasPermOrgResult.getHasPermOrgs();
        List commonFilters = contInitEvent.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilters) {
            if (!filterColumn.getFieldName().startsWith("orgs")) continue;
            if (hasPermOrgResult.hasAllOrgPerm()) {
                filterColumn.setDefaultValue(String.valueOf(orgId));
                break;
            }
            List<Long> accountingOrg = OrgService.getAccountingOrg(orgList);
            if (!accountingOrg.contains(orgId)) continue;
            filterColumn.setDefaultValue(String.valueOf(orgId));
            break;
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        DynamicObject rowData = hyperLinkClickEvent.getRowData();
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        String id = rowData.getString(ID);
        String type = rowData.getString(TYPE);
        if (!TYPE_COUNT.equals(type)) {
            QFilter qFilter = new QFilter(INVOICEID, "=", (Object)id).and(new QFilter(NEW_INVOICE_TYPE, "=", (Object)type));
            DynamicObject devideDetails = BusinessDataServiceHelper.loadSingle((String)TCVAT_DEVIDE_DETAIL, (String)ID, (QFilter[])new QFilter[]{qFilter});
            if (devideDetails == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u6570\u636e\u884c\u4e0d\u5b58\u5728\u5206\u644a\u660e\u7ec6", (String)"InputInvoiceSignRptPlugin_23", (String)"taxc-tcvat", (Object[])new Object[0]));
            } else {
                PageShowCommon.showBill((ShowType)ShowType.Modal, (String)TCVAT_DEVIDE_DETAIL, (Object)devideDetails.getPkValue(), (IFormView)this.getView(), (Map)customMap, (OperationStatus)OperationStatus.VIEW);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        ReportList reportlist;
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"selectall")) {
            reportlist = (ReportList)this.getControl(REPORTLISTAP);
            int size = reportlist.getReportModel().getRowCount();
            if (size <= 0) {
                return;
            }
            reportlist.selectRows(IntStream.range(0, size).toArray(), 1);
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"cancelall")) {
            reportlist = (ReportList)this.getControl(REPORTLISTAP);
            reportlist.clearEntryState();
        }
        List<DynamicObject> selectRowsData = InvoiceSignRptService.getSelectRowDatas((ReportList)this.getView().getControl(REPORTLISTAP));
        if (selectRowsData.size() == 0) {
            if (StringUtils.equals((CharSequence)itemKey, (CharSequence)BUTTON_UNSIGN_KEY) || StringUtils.equals((CharSequence)itemKey, (CharSequence)BUTTON_UNDEVIDE_KEY)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6807\u8bc6\u7684\u6570\u636e\u884c", (String)"InputInvoiceSignRptPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)BUTTON_SIGN_KEY) || StringUtils.equals((CharSequence)itemKey, (CharSequence)BUTTON_DEVIDE_KEY) || StringUtils.equals((CharSequence)itemKey, (CharSequence)BUTTON_SPLIT_KEY) || StringUtils.equals((CharSequence)itemKey, (CharSequence)BUTTON_UNSPLIT_KEY)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"InputInvoiceSignRptPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
            return;
        }
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)BUTTON_SIGN_KEY)) {
            Set orgs = selectRowsData.stream().map(obj -> obj.getLong("org.id")).collect(Collectors.toSet());
            if (orgs.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u52ff\u8de8\u7ec4\u7ec7\u9009\u62e9\u6570\u636e\u3002", (String)"InputInvoiceSignRptPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            for (DynamicObject selectRowData : selectRowsData) {
                String invoiceno = selectRowData.getString(INVOICENO);
                if (StringUtil.equals((CharSequence)DEVIDESTATE_DEVIDED, (CharSequence)selectRowData.getString(DEVIDESTATE))) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u53d1\u7968\u5df2\u7ecf\u5206\u644a\uff0c\u8bf7\u5148\u53d6\u6d88\u5206\u644a\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InputInvoiceSignRptPlugin_24", (String)"taxc-tcvat", (Object[])new Object[0]), invoiceno));
                    return;
                }
                if (!StringUtil.equals((CharSequence)SPLIT_DO, (CharSequence)selectRowData.getString(SPLITSIGN))) continue;
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u53d1\u7968\u5df2\u7ecf\u5206\u5305\uff0c\u8bf7\u5148\u53d6\u6d88\u5206\u5305\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InputInvoiceSignRptPlugin_21", (String)"taxc-tcvat", (Object[])new Object[0]), invoiceno));
                return;
            }
            boolean isSame = PrepayProjectService.isSameProjects(selectRowsData);
            if (!isSame) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6279\u91cf\u64cd\u4f5c\u8bf7\u9009\u62e9\u76f8\u540c\u9879\u76ee\u4fe1\u606f\u7684\u6570\u636e\u3002", (String)"InputInvoiceSignRptPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            DynamicObject dynamicObject = selectRowsData.get(0);
            String projectid = dynamicObject.getString(PROJECTID);
            List projectids = Arrays.stream(projectid.split(COMMA)).filter(a -> StringUtil.isNotEmpty((CharSequence)a)).map(b -> Long.valueOf(b)).collect(Collectors.toList());
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(PROJECT_SELECT_FORM);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BUTTON_SIGN_KEY));
            HashMap customParams = new HashMap();
            customParams.put("row_org", Lists.newArrayList((Object[])orgs.toArray()));
            customParams.put("row_project", projectids);
            parameter.setCustomParams(customParams);
            this.getView().showForm(parameter);
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)BUTTON_UNSIGN_KEY)) {
            for (DynamicObject selectRowData : selectRowsData) {
                if (!StringUtil.isEmpty((CharSequence)selectRowData.getString(PROJECTNAME))) continue;
                String invoiceno = selectRowData.getString(INVOICENO);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u672a\u6807\u8bc6\uff0c\u65e0\u9700\u53d6\u6d88\u6807\u8bc6", (String)"InputInvoiceSignRptPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]), invoiceno));
                return;
            }
            this.showConfirm(BUTTON_UNSIGN_KEY, ResManager.loadKDString((String)"\u53d6\u6d88\u6807\u8bc6\u540e\uff0c\u6240\u9009\u6570\u636e\u7684\u9879\u76ee\u6807\u8bc6\u53ca\u5206\u644a\u6570\u636e\u5c06\u88ab\u6e05\u7a7a\uff0c\u786e\u8ba4\u53d6\u6d88\u6807\u8bc6\u5417\uff1f", (String)"InputInvoiceSignRptPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)BUTTON_DEVIDE_KEY)) {
            List devideStates = selectRowsData.stream().filter(s -> "".equals(s.getString(DEVIDESTATE))).collect(Collectors.toList());
            if (devideStates.size() > 0) {
                String projectname = devideStates.stream().map(obj -> obj.getString(PROJECTNAME)).reduce((a, b) -> a + COMMA + b).get();
                if (StringUtil.isEmpty((CharSequence)projectname)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u7ecf\u9879\u76ee\u6807\u8bc6\u7684\u6570\u636e\u3002", (String)"InputInvoiceSignRptPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]));
                } else {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u9879\u76ee\u4e3a\u5355\u4e00\u9879\u76ee\uff0c\u65e0\u9700\u5206\u644a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"InputInvoiceSignRptPlugin_9", (String)"taxc-tcvat", (Object[])new Object[0]), projectname));
                }
                return;
            }
            boolean isSame = PrepayProjectService.isSameProjects(selectRowsData);
            if (!isSame) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5f52\u5c5e\u4e8e\u4e0d\u540c\u7684\u9879\u76ee\uff0c\u8bf7\u52ff\u540c\u65f6\u64cd\u4f5c\u3002", (String)"InputInvoiceSignRptPlugin_10", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(ENTITY_PROJECT_DEVIDE);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BUTTON_DEVIDE_KEY));
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            String projectid = selectRowsData.get(0).getString(PROJECTID);
            BigDecimal selectSumTax = InvoiceSignRptService.getSelectSumTax(selectRowsData);
            customParams.put("selectsumtax", selectSumTax);
            customParams.put(PROJECTID, projectid);
            customParams.put("invoices", selectRowsData);
            parameter.setCustomParams(customParams);
            this.getView().showForm(parameter);
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)BUTTON_UNDEVIDE_KEY)) {
            for (DynamicObject selectRowData : selectRowsData) {
                if (StringUtil.equals((CharSequence)DEVIDESTATE_DEVIDED, (CharSequence)selectRowData.getString(DEVIDESTATE))) continue;
                String invoiceno = selectRowData.getString(INVOICENO);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u53d1\u7968\u4e0d\u5b58\u5728\u5206\u644a\u6570\u636e\uff0c\u65e0\u9700\u53d6\u6d88\u5206\u644a", (String)"InputInvoiceSignRptPlugin_11", (String)"taxc-tcvat", (Object[])new Object[0]), invoiceno));
                return;
            }
            this.showConfirm(BUTTON_UNDEVIDE_KEY, ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u644a\u540e\uff0c\u6240\u9009\u6570\u636e\u7684\u5206\u644a\u660e\u7ec6\u6570\u636e\u5c06\u88ab\u6e05\u7a7a\uff0c\u786e\u8ba4\u53d6\u6d88\u5206\u644a\u5417\uff1f", (String)"InputInvoiceSignRptPlugin_12", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)BUTTON_SPLIT_KEY)) {
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(selectRowsData.size());
            for (DynamicObject data : selectRowsData) {
                String projectid = data.getString(PROJECTID);
                String invoiceno = data.getString(INVOICENO);
                if (StringUtil.isEmpty((CharSequence)projectid)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u53d1\u7968\u672a\u8fdb\u884c\u9879\u76ee\u6807\u8bc6\uff0c\u8bf7\u5148\u6807\u8bc6\u9884\u7f34\u9879\u76ee\u540d\u79f0", (String)"InputInvoiceSignRptPlugin_13", (String)"taxc-tcvat", (Object[])new Object[0]), invoiceno));
                    return;
                }
                if (projectid.contains(COMMA)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u53d1\u7968\u7528\u4e8e\u591a\u4e2a\u9879\u76ee\uff0c\u4e0d\u652f\u6301\u5206\u5305\u6807\u8bc6", (String)"InputInvoiceSignRptPlugin_14", (String)"taxc-tcvat", (Object[])new Object[0]), invoiceno));
                    return;
                }
                String splitsign = data.getString(SPLITSIGN);
                if (splitsign.equals(SPLIT_DO)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u6240\u9009\u62e9\u9879\u76ee\u5df2\u6807\u8bc6\u5206\u5305\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c", (String)"InputInvoiceSignRptPlugin_15", (String)"taxc-tcvat", (Object[])new Object[0]), invoiceno));
                    return;
                }
                DynamicObject project = QueryServiceHelper.queryOne((String)PROJECT_ENTITY, (String)"split,id", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)Long.valueOf(projectid))});
                if (project != null && StringUtil.equals((CharSequence)project.getString(SPLIT), (CharSequence)"0")) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u64cd\u4f5c\u5931\u8d25\uff0c\u6240\u5173\u8054\u9879\u76ee\u4e0d\u652f\u6301\u5206\u5305", (String)"InputInvoiceSignRptPlugin_22", (String)"taxc-tcvat", (Object[])new Object[0]), invoiceno));
                    return;
                }
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ENTITY_INVOICE_PROJECT, (String)"id,split", (QFilter[])new QFilter[]{new QFilter(INVOICEID, "=", (Object)data.get(ID).toString()).and(new QFilter(NEW_INVOICE_TYPE, "=", data.get(TYPE))).and(new QFilter(PROJECT, "=", (Object)Long.valueOf(projectid)))});
                dynamicObject.set(SPLIT, (Object)SPLIT_DO);
                list.add(dynamicObject);
            }
            if (list.size() > 0) {
                SaveServiceHelper.update((DynamicObject[])list.toArray(new DynamicObject[list.size()]));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"InputInvoiceSignRptPlugin_16", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.getView().refresh();
            }
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)BUTTON_UNSPLIT_KEY)) {
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(selectRowsData.size());
            for (DynamicObject data : selectRowsData) {
                if (SPLIT_UNDO.equals(data.getString(SPLITSIGN))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u9879\u76ee\u672a\u6807\u8bc6\u5206\u5305\uff0c\u65e0\u9700\u53d6\u6d88\u5206\u5305", (String)"InputInvoiceSignRptPlugin_17", (String)"taxc-tcvat", (Object[])new Object[0]));
                    return;
                }
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ENTITY_INVOICE_PROJECT, (String)"id,split", (QFilter[])new QFilter[]{new QFilter(INVOICEID, "=", (Object)data.get(ID).toString()).and(new QFilter(NEW_INVOICE_TYPE, "=", data.get(TYPE))).and(new QFilter(PROJECT, "=", (Object)Long.valueOf(data.getString(PROJECTID))))});
                dynamicObject.set(SPLIT, (Object)SPLIT_UNDO);
                list.add(dynamicObject);
            }
            if (list.size() > 0) {
                SaveServiceHelper.update((DynamicObject[])list.toArray(new DynamicObject[list.size()]));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6210\u529f\u3002", (String)"InputInvoiceSignRptPlugin_18", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.getView().refresh();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (BUTTON_UNSIGN_KEY.equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                List<DynamicObject> selectRowDatas = InvoiceSignRptService.getSelectRowDatas((ReportList)this.getView().getControl(REPORTLISTAP));
                ArrayList invoiceProjectIds = new ArrayList();
                for (DynamicObject rowData : selectRowDatas) {
                    String fids = rowData.getString(FIDS);
                    String[] split = fids.split(COMMA);
                    List collect = Arrays.stream(split).map(a -> Long.valueOf(a)).collect(Collectors.toList());
                    invoiceProjectIds.addAll(collect);
                }
                InvoiceSignRptService.deleteDivideDetails(selectRowDatas);
                DeleteServiceHelper.delete((String)ENTITY_INVOICE_PROJECT, (QFilter[])new QFilter[]{new QFilter(ID, "in", invoiceProjectIds)});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6210\u529f\u3002", (String)"InputInvoiceSignRptPlugin_18", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.getView().refresh();
            }
        } else if (BUTTON_UNDEVIDE_KEY.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            InvoiceSignRptService.deleteDivideDetails(InvoiceSignRptService.getSelectRowDatas((ReportList)this.getView().getControl(REPORTLISTAP)));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6210\u529f\u3002", (String)"InputInvoiceSignRptPlugin_18", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.getView().refresh();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (BUTTON_SIGN_KEY.equals(closedCallBackEvent.getActionId())) {
            if (closedCallBackEvent.getReturnData() != null) {
                Map map = (Map)closedCallBackEvent.getReturnData();
                List primaryKeyValues = (List)map.get(PROJECT);
                List<DynamicObject> selectRowDatas = InvoiceSignRptService.getSelectRowDatas((ReportList)this.getView().getControl(REPORTLISTAP));
                InvoiceSignRptService.buildInvoiceProjectRelate(primaryKeyValues, selectRowDatas);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"InputInvoiceSignRptPlugin_16", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.getView().refresh();
            }
        } else if (BUTTON_DEVIDE_KEY.equals(closedCallBackEvent.getActionId()) && "save_success".equals(closedCallBackEvent.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"InputInvoiceSignRptPlugin_16", (String)"taxc-tcvat", (Object[])new Object[0]), Integer.valueOf(3000));
            this.getView().refresh();
        }
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        List list = event.getColumns();
        for (AbstractReportColumn abstractReportColumn : list) {
            ReportColumn reportColumn;
            if (!(abstractReportColumn instanceof ReportColumn) || !(reportColumn = (ReportColumn)abstractReportColumn).getFieldKey().equals(PROJECTID) && !reportColumn.getFieldKey().equals(FIDS) && !reportColumn.getFieldKey().equals(DEVIDEID) && !reportColumn.getFieldKey().equals(ID)) continue;
            reportColumn.setHide(true);
        }
    }

    private void showConfirm(String btnName, String msg) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(btnName, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"InputInvoiceSignRptPlugin_19", (String)"taxc-tcvat", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"InputInvoiceSignRptPlugin_20", (String)"taxc-tcvat", (Object[])new Object[0]));
        this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }
}

