/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.identification.output;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.adapter.ReportListAdapter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.identification.output.OuputInvoiceJzjtSignListService;
import kd.taxc.tcvat.common.enums.OutputJzjtSignFieldEnum;
import org.apache.commons.lang3.ObjectUtils;

public class OuputInvoiceJzjtSignListPlugin
extends AbstractReportFormPlugin {
    private static Log logger = LogFactory.getLog(OuputInvoiceJzjtSignListPlugin.class);
    private static final String TCVAT_OUTPUT_SIGN_DIALOG = "tcvat_output_sign_dialog";
    private static final String TCVAT_OUTPUT_AUTOSIGN_DLG = "tcvat_output_autosign_dlg";
    private static final String TCVAT_JZJT_PRODUCT = "tcvat_jzjt_product";
    private static final String BTN_AUTOSIGN = "autosign";
    private static final String BTN_SIGN = "sign";
    private static final String BTN_UNDOSIGN = "undosign";
    private OuputInvoiceJzjtSignListService ouputInvoiceJzjtSignListService = new OuputInvoiceJzjtSignListService();

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void getComboItems(String fieldKey, List<ValueMapItem> items) {
        super.getComboItems(fieldKey, items);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if ("bos_org".equals(args.getRefEntityId())) {
            List list = new ArrayList();
            List<Long> permOrgs = this.ouputInvoiceJzjtSignListService.getAllPermOrgs();
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgIdsAndIsTaxpayerAndIsYbnsr(permOrgs);
            if (result.isSuccess() && !ObjectUtils.isEmpty((Object)result.getData())) {
                list = (List)result.getData();
            }
            args.getCustomQFilters().add(new QFilter("id", "in", list));
        }
    }

    public void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        List<Long> permOrgs = this.ouputInvoiceJzjtSignListService.getAllPermOrgs();
        List<DynamicObject> ybnsrOrgs = this.ouputInvoiceJzjtSignListService.getYbnsrOrgs(permOrgs);
        ArrayList<Map<String, String>> orgItems = new ArrayList<Map<String, String>>();
        ybnsrOrgs.stream().forEach(v -> {
            HashMap<String, String> item = new HashMap<String, String>(16);
            item.put("id", v.getString("id"));
            item.put("number", v.getString("number"));
            item.put("name", v.getString("name"));
            orgItems.add(item);
        });
        List<ComboItem> comboItems = OuputInvoiceJzjtSignListService.getComboItems(orgItems);
        List commonFilterColumns = contInitEvent.getCommonFilterColumns();
        for (int i = 0; i < commonFilterColumns.size(); ++i) {
            CommonFilterColumn commFilter = (CommonFilterColumn)commonFilterColumns.get(i);
            String fieldName = commFilter.getFieldName();
            if (!"taxorg".equals(fieldName)) continue;
            commFilter.setComboItems(comboItems);
            if (!ObjectUtils.isNotEmpty(comboItems)) break;
            commFilter.setDefaultValue(comboItems.get(0).getValue());
            break;
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFiterList = (List)filterValues.get("customfilter");
        this.getPageCache().remove("defaultTaxorg");
        if (ObjectUtils.isNotEmpty((Object)customFiterList)) {
            Map taxorgField = customFiterList.stream().filter(e -> "taxorg.id".equals(((List)e.get("FieldName")).get(0))).findFirst().get();
            this.getPageCache().put("defaultTaxorg", (String)((List)taxorgField.get("Value")).get(0));
        }
        StringBuilder sb = new StringBuilder();
        for (QFilter qFilter : args.getFilterParameter().getQFilters()) {
            String field = qFilter.getProperty();
            OutputJzjtSignFieldEnum fieldEnum = OutputJzjtSignFieldEnum.getInstance(field);
            if (!(qFilter.getValue() instanceof QEmptyValue) || OutputJzjtSignFieldEnum.DEFAULT == fieldEnum || fieldEnum.hasSchemeEmptyFilter()) continue;
            String fieldmsg = "[" + fieldEnum.getName().getDescription() + "]";
            sb.append(fieldmsg);
        }
        if (sb.length() > 0) {
            sb.append(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u652f\u6301\u201c\u4e3a\u7a7a\u201d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"OuputInvoiceJzjtSignListPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.getView().showErrorNotification(sb.toString());
            return;
        }
        super.filterContainerSearchClick(args);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"selectall")) {
            ReportList reportlist = (ReportList)this.getControl("reportlistap");
            int size = reportlist.getReportModel().getRowCount();
            if (size <= 0) {
                return;
            }
            reportlist.selectRows(IntStream.rangeClosed(1, size).toArray(), 1);
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"cancelall")) {
            ReportList reportlist = (ReportList)this.getControl("reportlistap");
            reportlist.clearSelection();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        logger.info("===OuputInvoiceJzjtSignListPlugin:beforeDoOperation===starttime:" + System.currentTimeMillis());
        if (args.getSource() instanceof Donothing) {
            String key = ((AbstractOperate)args.getSource()).getOperateKey();
            ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
            int[] rows = reportlist.getEntryState().getSelectedRows();
            if ((BTN_SIGN.equals(key) || BTN_UNDOSIGN.equals(key)) && (rows.length < 1 || rows[0] == 0)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e", (String)"OuputInvoiceJzjtSignListPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (BTN_SIGN.equals(key)) {
                DynamicObjectCollection rowCollection = ReportListAdapter.getSelectedRow((ReportList)reportlist);
                long taxorg = ((DynamicObject)rowCollection.get(0)).getDynamicObject("field_taxorg").getLong("id");
                for (DynamicObject dynamicObject : rowCollection) {
                    if (taxorg == dynamicObject.getDynamicObject("field_taxorg").getLong("id")) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u7a0e\u52a1\u7ec4\u7ec7\u7684\u6570\u636e", (String)"OuputInvoiceJzjtSignListPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
        }
        logger.info("===OuputInvoiceJzjtSignListPlugin:beforeDoOperation===endtime:" + System.currentTimeMillis());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        logger.info("===OuputInvoiceJzjtSignListPlugin:afterDoOperation===starttime:" + System.currentTimeMillis());
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        IReportListModel model = reportlist.getReportModel();
        int[] rows = reportlist.getEntryState().getSelectedRows();
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (BTN_AUTOSIGN.equals(key)) {
            this.autoSign();
        } else if (BTN_SIGN.equals(key)) {
            this.sign(model.getRowData(rows[0]).getDynamicObject("field_taxorg").getLong("id"), this.getSelectedInvoiceList());
        } else if (BTN_UNDOSIGN.equals(key)) {
            this.undoSign(this.getSelectedInvoiceList());
        }
        logger.info("===OuputInvoiceJzjtSignListPlugin:afterDoOperation===endtime:" + System.currentTimeMillis());
    }

    private Map<Long, Long> getSelectedInvoiceList() {
        logger.info("===OuputInvoiceJzjtSignListPlugin:getSelectedInvoiceList===starttime:" + System.currentTimeMillis());
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        DynamicObjectCollection rowCollection = ReportListAdapter.getSelectedRow((ReportList)reportlist);
        Map<Long, Long> invoiceidMap = rowCollection.stream().collect(Collectors.toMap(k -> k.getLong("field_subid"), v -> v.getLong("field_mainid"), (m, n) -> m));
        logger.info("===OuputInvoiceJzjtSignListPlugin:getSelectedInvoiceList===endtime:" + System.currentTimeMillis());
        return invoiceidMap;
    }

    private void showResult(FormShowParameter formShowParameter, String msg) {
        if (ObjectUtils.isNotEmpty((Object)formShowParameter)) {
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "generateMessage"));
            this.getView().showForm(formShowParameter);
        } else {
            this.getView().showSuccessNotification(msg);
            this.getView().refresh();
        }
    }

    private void autoSign() {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId(TCVAT_OUTPUT_AUTOSIGN_DLG);
        parameters.setShowTitle(true);
        parameters.setCaption(ResManager.loadKDString((String)"\u81ea\u52a8\u6807\u8bc6", (String)"OuputInvoiceJzjtSignListPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
        parameters.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_AUTOSIGN));
        parameters.setCustomParam("taxorg", (Object)this.getPageCache().get("defaultTaxorg"));
        this.getView().showForm(parameters);
    }

    private void sign(Long taxorg, Map<Long, Long> invoiceidMap) {
        QFilter qFilter = new QFilter("orgid", "=", (Object)taxorg).and("enable", "=", (Object)"1").and("status", "=", (Object)"C");
        boolean exists = QueryServiceHelper.exists((String)TCVAT_JZJT_PRODUCT, (QFilter[])new QFilter[]{qFilter});
        if (exists) {
            FormShowParameter parameters = new FormShowParameter();
            parameters.getOpenStyle().setShowType(ShowType.Modal);
            parameters.setFormId(TCVAT_OUTPUT_SIGN_DIALOG);
            parameters.setShowTitle(true);
            parameters.setCaption(ResManager.loadKDString((String)"\u624b\u5de5\u6807\u8bc6", (String)"OuputInvoiceJzjtSignListPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]));
            parameters.setCustomParam("taxorg", (Object)taxorg);
            parameters.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_SIGN));
            this.getView().showForm(parameters);
        } else {
            FormShowParameter formShowParameter = this.ouputInvoiceJzjtSignListService.getSignFormShowParameter(invoiceidMap, null);
            this.showResult(formShowParameter, ResManager.loadKDString((String)"\u624b\u5de5\u6807\u8bc6\u6210\u529f", (String)"OuputInvoiceJzjtSignListPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    private void undoSign(Map<Long, Long> mainInvoiceList) {
        FormShowParameter formShowParameter = this.ouputInvoiceJzjtSignListService.getUndosignFormShowParameter(mainInvoiceList);
        this.showResult(formShowParameter, ResManager.loadKDString((String)"\u53d6\u6d88\u6807\u8bc6\u6210\u529f", (String)"OuputInvoiceJzjtSignListPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (BTN_SIGN.equals(evt.getActionId())) {
            if (ObjectUtils.isNotEmpty((Object)evt.getReturnData())) {
                Map<Long, Long> invoiceidList = this.getSelectedInvoiceList();
                DynamicObject jzjtproduct = (DynamicObject)evt.getReturnData();
                FormShowParameter formShowParameter = this.ouputInvoiceJzjtSignListService.getSignFormShowParameter(invoiceidList, jzjtproduct);
                this.showResult(formShowParameter, ResManager.loadKDString((String)"\u624b\u5de5\u6807\u8bc6\u6210\u529f", (String)"OuputInvoiceJzjtSignListPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        } else if (BTN_AUTOSIGN.equals(evt.getActionId())) {
            if (ObjectUtils.isNotEmpty((Object)evt.getReturnData())) {
                HashMap map = (HashMap)evt.getReturnData();
                Long org = (Long)map.get("org");
                Date startdate = (Date)map.get("startdate");
                Date enddate = DateUtils.getDayLast((Date)((Date)map.get("enddate")));
                FormShowParameter formShowParameter = this.ouputInvoiceJzjtSignListService.getAutosignFormShowParameter(org, startdate, enddate);
                this.showResult(formShowParameter, ResManager.loadKDString((String)"\u81ea\u52a8\u6807\u8bc6\u6210\u529f", (String)"OuputInvoiceJzjtSignListPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        } else if ("generateMessage".equals(evt.getActionId())) {
            this.getView().refresh();
        }
    }
}

