/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.identification.output;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.identification.output.OuputInvoiceJzjtSignListService;
import org.apache.commons.lang3.ObjectUtils;

public class OutputAutosignDlgPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final String BTN_OK = "btnok";
    private OuputInvoiceJzjtSignListService ouputInvoiceJzjtSignListService = new OuputInvoiceJzjtSignListService();

    public void registerListener(EventObject e) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("org");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String defaultTaxorg = (String)customParams.get("taxorg");
        if (ObjectUtils.isNotEmpty((Object)defaultTaxorg)) {
            this.getModel().setValue("org", (Object)Long.valueOf(defaultTaxorg));
        }
        Date date = DateUtils.addMonth((Date)new Date(), (int)-1);
        this.getModel().setValue("startdate", (Object)DateUtils.getFirstDateOfMonth((Date)date));
        this.getModel().setValue("enddate", (Object)DateUtils.getLastDateOfMonth((Date)date));
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        List list = new ArrayList();
        List<Long> permOrgs = this.ouputInvoiceJzjtSignListService.getAllPermOrgs();
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgIdsAndIsTaxpayerAndIsYbnsr(permOrgs);
        if (result.isSuccess() && !ObjectUtils.isEmpty((Object)result.getData())) {
            list = (List)result.getData();
        }
        evt.getCustomQFilters().add(new QFilter("id", "in", list));
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (BTN_OK.equals(control.getKey())) {
            Date enddate;
            Date startdate = (Date)this.getModel().getValue("startdate");
            if (ObjectUtils.allNotNull((Object[])new Object[]{startdate, enddate = (Date)this.getModel().getValue("enddate")}) && DateUtils.getDayDiff((Date)startdate, (Date)enddate) > 61) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u7968\u671f\u95f4\u4e0d\u80fd\u8d85\u8fc7\u4e24\u4e2a\u6708\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"OutputAutosignDlgPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("org", ((DynamicObject)this.getModel().getValue("org")).getLong("id"));
            map.put("startdate", this.getModel().getValue("startdate"));
            map.put("enddate", this.getModel().getValue("enddate"));
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }
}

