/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.invoice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.tcvat.business.service.prepay.PrepayProjectService;

public class OutputInvoiceSignListPlugin
extends AbstractListPlugin {
    public static final String PROJECT_SIGN_BTN = "projectsignbtn";
    public static final String PROJECT_SIGN_CANCEL_BTN = "cancelsignbtn";
    public static final String OUTPUT_SIGN_ENTITY = "tcvat_output_sign";
    public static final String TCVAT_PREPAY_PROJECT_INFO = "tcvat_prepay_project_info";
    public static final String SIM_VATINVOICE_OUTPUT_SIG = "sim_vatinvoice_output_sig";
    public static final String ORG = "org";
    public static final String ID = "id";
    public static final int FIRST_INDEX = 0;
    public static final String PROJECT_FIELDS = "id,project";
    public static final String PROJECT = "project";
    public static final int NOT_ROWS = 0;
    public static final int ONE_ORG = 1;
    public static final int ONE_SELECTION = 1;
    public static final Long ZERO = 0L;

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumnList) {
            String fieldName = filterColumn.getFieldName();
            if (!"invoicestatus".equals(fieldName)) continue;
            CommonFilterColumn column = (CommonFilterColumn)filterColumn;
            column.setComboItems(column.getComboItems().stream().filter(c -> Arrays.asList("0", "3").contains(c.getValue())).collect(Collectors.toList()));
        }
        List schemeFilterColumns = args.getSchemeFilterColumns();
        for (FilterColumn filterColumn : schemeFilterColumns) {
            String fieldName = filterColumn.getFieldName();
            if (!"invoicestatus".equals(fieldName)) continue;
            SchemeFilterColumn column = (SchemeFilterColumn)filterColumn;
            column.setComboItems(column.getComboItems().stream().filter(c -> Arrays.asList("0", "3").contains(c.getValue())).collect(Collectors.toList()));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{PROJECT_SIGN_BTN, PROJECT_SIGN_CANCEL_BTN});
    }

    public void setFilter(SetFilterEvent e) {
        QFilter mainOrgQFilter = e.getMainOrgQFilter();
        if (mainOrgQFilter != null) {
            List orgList = null;
            Object value = mainOrgQFilter.getValue();
            if (value instanceof List) {
                orgList = (List)mainOrgQFilter.getValue();
            } else if (value.getClass().isArray()) {
                orgList = Lists.newArrayList((Object[])((Long[])value));
            }
            if (orgList != null) {
                e.setMainOrgQFilter(new QFilter(mainOrgQFilter.getProperty(), "in", (Object)orgList));
            }
        }
        e.getQFilters().add(new QFilter("invoicestatus", "in", Arrays.asList("0", "3")));
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
    }

    public void beforeBindData(EventObject e) {
        this.getPageCache().put("hasImcMd", MetadataUtil.metaIsExist((String)"sim_invoice_show").toString());
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        if ("invoiceno".equals(args.getFieldName())) {
            if ("false".equals(this.getPageCache().get("hasImcMd"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u7968\u67e5\u770b\u5931\u8d25\uff0c\u8bf7\u66f4\u65b0\u53d1\u7968\u4e91\u5143\u6570\u636e\u3002", (String)"OutputInvoiceSignListPlugin_10", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            Object pkid = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("sim_invoice_show");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            HashMap map = Maps.newHashMapWithExpectedSize((int)1);
            map.put(ID, pkid);
            formShowParameter.setCustomParams((Map)map);
            this.getView().showForm(formShowParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BillList billList;
        ListSelectedRowCollection listSelectedRows;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (PROJECT_SIGN_BTN.equals(operate.getOperateKey())) {
            BillList billList2 = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection listSelectedRows2 = billList2.getSelectedRows();
            if (listSelectedRows2.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"OutputInvoiceSignListPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (listSelectedRows2.size() == 1) {
                ArrayList<Long> orgList = new ArrayList<Long>();
                Object id = listSelectedRows2.get(0).getPrimaryKeyValue();
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)OUTPUT_SIGN_ENTITY, (String)ORG, (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)Long.valueOf(String.valueOf(id)))});
                orgList.add(null != dynamicObject ? Long.valueOf(dynamicObject.getLong(ORG)) : Long.valueOf("0"));
            } else {
                ArrayList ids = new ArrayList();
                listSelectedRows2.forEach(row -> ids.add(Long.valueOf(String.valueOf(row.getPrimaryKeyValue()))));
                DynamicObjectCollection collection = QueryServiceHelper.query((String)OUTPUT_SIGN_ENTITY, (String)ORG, (QFilter[])new QFilter[]{new QFilter(ID, "in", ids)});
                List orgList = collection.stream().map(obj -> obj.getLong(ORG)).distinct().collect(Collectors.toList());
                if (orgList.size() > 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u52ff\u8de8\u7ec4\u7ec7\u9009\u62e9\u6570\u636e", (String)"OutputInvoiceSignListPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
        } else if (PROJECT_SIGN_CANCEL_BTN.equals(operate.getOperateKey()) && (listSelectedRows = (billList = (BillList)this.getControl("billlistap")).getSelectedRows()).size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u53d6\u6d88\u6807\u8bc6\u7684\u6570\u636e\u884c", (String)"OutputInvoiceSignListPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        super.afterDoOperation(afterDoOperationEventArgs);
        if (PROJECT_SIGN_BTN.equals(operate.getOperateKey())) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
            DynamicObjectCollection projects = QueryServiceHelper.query((String)SIM_VATINVOICE_OUTPUT_SIG, (String)"orgid,project", (QFilter[])new QFilter[]{new QFilter(ID, "in", (Object)listSelectedRows.getPrimaryKeyValues())});
            long distinctCount = projects.stream().map(e -> e.getLong("orgid")).distinct().count();
            if (distinctCount > 1L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u76f8\u540c\u7684\u9884\u7f34\u9879\u76ee\u9500\u9879\u53d1\u7968", (String)"OutputInvoiceSignListPlugin_9", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            List project = projects.stream().filter(e -> !ZERO.equals(e.getLong(PROJECT))).collect(Collectors.toList());
            if (!project.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u6709\u53d1\u7968\u5df2\u5f52\u96c6\u81f3\u9879\u76ee\uff0c\u8bf7\u52ff\u91cd\u590d\u5f52\u96c6", (String)"OutputInvoiceSignListPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            ListShowParameter parameter = PrepayProjectService.openProjectList(listSelectedRows.getPrimaryKeyValues());
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PROJECT_SIGN_BTN));
            this.getView().showForm((FormShowParameter)parameter);
        } else if (PROJECT_SIGN_CANCEL_BTN.equals(operate.getOperateKey())) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
            int emptyRows = 0;
            int notEmptyRows = 0;
            int successRows = 0;
            int failRows = 0;
            ArrayList ids = new ArrayList();
            ArrayList<DynamicObject> cacelIds = new ArrayList<DynamicObject>();
            listSelectedRows.forEach(row -> ids.add(Long.valueOf(String.valueOf(row.getPrimaryKeyValue()))));
            DynamicObject[] collection = BusinessDataServiceHelper.load((String)SIM_VATINVOICE_OUTPUT_SIG, (String)PROJECT_FIELDS, (QFilter[])new QFilter[]{new QFilter(ID, "in", ids)});
            for (int i = 0; i < collection.length; ++i) {
                DynamicObject dynamicObject = collection[i];
                if (dynamicObject.get(PROJECT) != null) {
                    dynamicObject.set(PROJECT, (Object)0);
                    cacelIds.add(dynamicObject);
                    ++notEmptyRows;
                    continue;
                }
                ++emptyRows;
            }
            SaveServiceHelper.update((DynamicObject[])cacelIds.toArray(new DynamicObject[cacelIds.size()]));
            if (emptyRows == 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6210\u529f", (String)"OutputInvoiceSignListPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
                OperatorDialogUtils.operateDialog((String)"zzs", (String)SIM_VATINVOICE_OUTPUT_SIG, (String)ResManager.loadKDString((String)"\u53d6\u6d88\u5f52\u96c6", (String)"OutputInvoiceSignListPlugin_13", (String)"taxc-tcvat", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u9884\u7f34\u9879\u76ee\u9500\u9879\u53d1\u7968\u53d6\u6d88\u5f52\u96c6\u6210\u529f", (String)"OutputInvoiceSignListPlugin_11", (String)"taxc-tcvat", (Object[])new Object[0]));
            } else {
                successRows = notEmptyRows;
                failRows = emptyRows;
                String msg = String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u6210\u529f%1$d\u884c,\u53d6\u6d88\u5931\u8d25%2$d\u884c", (String)"OutputInvoiceSignListPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]), successRows, failRows);
                this.getView().showMessage(msg);
                OperatorDialogUtils.operateDialog((String)"zzs", (String)SIM_VATINVOICE_OUTPUT_SIG, (String)ResManager.loadKDString((String)"\u53d6\u6d88\u5f52\u96c6", (String)"OutputInvoiceSignListPlugin_13", (String)"taxc-tcvat", (Object[])new Object[0]), (String)msg);
            }
            billList.refreshData();
            billList.clearSelection();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)e.getReturnData();
        if (CollectionUtils.isEmpty((Collection)returnData)) {
            return;
        }
        if (PROJECT_SIGN_BTN.equals(actionId)) {
            ListSelectedRow row = returnData.get(0);
            Long primaryKeyValue = (Long)row.getPrimaryKeyValue();
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)SIM_VATINVOICE_OUTPUT_SIG));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)TCVAT_PREPAY_PROJECT_INFO, (String)"id,name", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)primaryKeyValue)});
            for (DynamicObject o : load) {
                o.set(PROJECT, (Object)dynamicObject.getLong(ID));
            }
            SaveServiceHelper.save((DynamicObject[])load);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"OutputInvoiceSignListPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
            OperatorDialogUtils.operateDialog((String)"zzs", (String)SIM_VATINVOICE_OUTPUT_SIG, (String)ResManager.loadKDString((String)"\u5f52\u96c6\u81f3\u9879\u76ee", (String)"OutputInvoiceSignListPlugin_14", (String)"taxc-tcvat", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u9884\u7f34\u9879\u76ee\u9500\u9879\u53d1\u7968\u5f52\u96c6\u81f3\u9879\u76ee\u3010%1$s\u3011\u6210\u529f", (String)"OutputInvoiceSignListPlugin_12", (String)"taxc-tcvat", (Object[])new Object[0]), dynamicObject.getString("name")));
            billList.refresh();
            billList.clearSelection();
        }
    }
}

