/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.invoice;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcvat.business.service.prepay.application.PrepayApplicationService;
import kd.taxc.tcvat.business.service.prepay.invoice.PrepayInvoiceService;
import org.apache.commons.collections.CollectionUtils;

public class PrepayInputInvoiceListPlugin
extends AbstractListPlugin {
    private static final String TCVAT_PREPAY_PROJECT_INFO = "tcvat_prepay_project_info";
    private static final String RIM_INV_ELECTRIC = "rim_inv_electric";
    private static final Long NO_PROJECT = 0L;
    private static final String CONFIRM_SPLIT = "true";
    private static final String CANCEL_SPILIT = "false";
    private static final String BTN_SIGN_KEY = "projectsign";
    private static final String BTN_UNSIGN_KEY = "cancelprojectsign";
    private static final String BTN_SPLIT_KEY = "splitinvoice";
    private static final String BTN_CANCEL_SPLIT_KEY = "cancelsplitinvoice";
    private Map<String, Map<String, Object>> invoiceMap = new HashMap<String, Map<String, Object>>();
    private static final String ORDINARY_SELECT_FIELD = "serial_no,total_deduct,remain_deduct,split";
    private static final String SPECIAL_SELECT_FIELD = "serial_no,total_deduct,remain_deduct,split";
    private static final String ELECTRIC_SELECT_FIELD = "serial_no,total_deduct,remain_deduct,split";
    private PrepayInvoiceService prepayInvoiceService = new PrepayInvoiceService();

    public void setFilter(SetFilterEvent evt) {
        HashSet invoiceTypeList = Sets.newHashSet((Object[])new String[]{"1", "2", "3", "4", "26", "27"});
        evt.getQFilters().add(new QFilter("invoice_type.number", "in", (Object)invoiceTypeList));
        evt.getQFilters().add(new QFilter("delete", "=", (Object)"1"));
        List<String> serialNo = PrepayApplicationService.queryDeductedCanceledInvoiceSerialNo();
        evt.getQFilters().add(new QFilter("invoice_status", "!=", (Object)"2").or(new QFilter("serial_no", "in", serialNo)));
    }

    private void addInvoiceMap(String invoiceType, DynamicObjectCollection collection) {
        boolean isSplit = false;
        if ("rim_inv_ordinary".equals(invoiceType) || "rim_inv_special".equals(invoiceType) || RIM_INV_ELECTRIC.equals(invoiceType)) {
            isSplit = true;
        }
        boolean finalIsSplit = isSplit;
        collection.stream().forEach(e -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("total_deduct", e.getBigDecimal("total_deduct"));
            map.put("remain_deduct", e.getBigDecimal("remain_deduct"));
            if (finalIsSplit) {
                map.put("split", e.getString("split"));
            }
            this.invoiceMap.put(e.getString("serial_no"), map);
        });
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (CollectionUtils.isNotEmpty((Collection)rows)) {
                    List ids = rows.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
                    PrepayInputInvoiceListPlugin.this.getInvoiceMap(ids);
                }
                return rows;
            }
        });
    }

    private void getInvoiceMap(List<Long> list) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tcvat_prepay_in_invoice", (String)"serial_no", (QFilter[])new QFilter[]{new QFilter("id", "in", list)});
        List serialNoList = query.stream().map(e -> e.getString("serial_no")).collect(Collectors.toList());
        DynamicObjectCollection ordinaryCollection = QueryServiceHelper.query((String)"rim_inv_ordinary", (String)"serial_no,total_deduct,remain_deduct,split", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", serialNoList)});
        DynamicObjectCollection specialCollection = QueryServiceHelper.query((String)"rim_inv_special", (String)"serial_no,total_deduct,remain_deduct,split", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", serialNoList)});
        DynamicObjectCollection electricCollection = QueryServiceHelper.query((String)RIM_INV_ELECTRIC, (String)"serial_no,total_deduct,remain_deduct,split", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", serialNoList)});
        this.invoiceMap.clear();
        this.addInvoiceMap("rim_inv_ordinary", ordinaryCollection);
        this.addInvoiceMap("rim_inv_special", specialCollection);
        this.addInvoiceMap(RIM_INV_ELECTRIC, electricCollection);
    }

    public void packageData(PackageDataEvent e) {
        String serialNo = e.getRowData().getString("serial_no");
        Map<String, Object> map = this.invoiceMap.get(serialNo);
        if (null != map) {
            AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
            if ("total_deduct".equals(columnDesc.getKey())) {
                e.setFormatValue((Object)BigDecimalUtil.format((Object)map.get("total_deduct"), (String)",##0.00#"));
            } else if ("remain_deduct".equals(columnDesc.getKey())) {
                e.setFormatValue((Object)BigDecimalUtil.format((Object)map.get("remain_deduct"), (String)",##0.00#"));
            } else if ("split".equals(columnDesc.getKey())) {
                e.setFormatValue(map.get("split"));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BillList billlist = (BillList)this.getControl("billlistap");
        List<Object> list = billlist.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        DynamicObject[] selectRows = BusinessDataServiceHelper.load((String)"tcvat_prepay_in_invoice", (String)"id,org,org.id,project,invoice_type.number,invoice_type,invoice_code,invoice_no,serial_no", (QFilter[])new QFilter[]{new QFilter("id", "in", list)});
        boolean isAllEmpty = this.prepayInvoiceService.isAllEmptyProject(selectRows);
        if ("exportlist_expt".equals(((FormOperate)args.getSource()).getOperateKey()) && CollectionUtils.isEmpty(list)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PrepayInputInvoiceListPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (selectRows.length <= 0 && !(args.getSource() instanceof Refresh)) {
            args.setCancel(true);
            return;
        }
        if (args.getSource() instanceof Donothing && BTN_SIGN_KEY.equals(((Donothing)args.getSource()).getOperateKey())) {
            boolean isSame = this.prepayInvoiceService.isSame(selectRows, "org");
            if (!isSame) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u52ff\u8de8\u7ec4\u7ec7\u9009\u62e9\u6570\u636e\u3002", (String)"PrepayInputInvoiceListPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!isAllEmpty) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u6709\u53d1\u7968\u5df2\u5f52\u96c6\u81f3\u9879\u76ee\uff0c\u8bf7\u52ff\u91cd\u590d\u5f52\u96c6\u3002", (String)"PrepayInputInvoiceListPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (args.getSource() instanceof Donothing && BTN_UNSIGN_KEY.equals(((Donothing)args.getSource()).getOperateKey())) {
            if (Arrays.stream(selectRows).anyMatch(e -> null == e.getDynamicObject("project")) || Arrays.stream(selectRows).filter(e -> NO_PROJECT.longValue() == e.getDynamicObject("project").getLong("id")).count() > 0L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u6570\u636e\u672a\u88ab\u5f52\u96c6\u81f3\u9884\u7f34\u9879\u76ee\uff0c\u65e0\u9700\u201c\u53d6\u6d88\u5f52\u96c6\u201d\u3002", (String)"PrepayInputInvoiceListPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (this.prepayInvoiceService.isPushPrepayApplication(list)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u7968\u5df2\u5728\u9884\u7f34\u7533\u8bf7\u5355\u4e2d\u6263\u9664\uff0c\u4e0d\u652f\u6301\u53d6\u6d88\u5f52\u96c6\u3002", (String)"PrepayInputInvoiceListPlugin_16", (String)"taxc-tcvat", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            List<String> splitList = this.prepayInvoiceService.containsSplit(selectRows);
            if (!splitList.isEmpty() && splitList.contains(CONFIRM_SPLIT)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u53d1\u7968\u201c\u5206\u5305\u6807\u8bc6\u201d=\u201c\u662f\u201d\uff0c\u8bf7\u5148\u201c\u53d6\u6d88\u5206\u5305\u201d\u3002", (String)"PrepayInputInvoiceListPlugin_32", (String)"taxc-tcvat", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (args.getSource() instanceof Donothing && BTN_SPLIT_KEY.equals(((Donothing)args.getSource()).getOperateKey())) {
            boolean isSame = this.prepayInvoiceService.isSame(selectRows, "project");
            if (!isSame) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u7684\u201c\u9884\u7f34\u9879\u76ee\u540d\u79f0\u201d\u7684\u53d1\u7968\u6570\u636e\u3002", (String)"PrepayInputInvoiceListPlugin_11", (String)"taxc-tcvat", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (isAllEmpty) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5c06\u6240\u9009\u7684\u53d1\u7968\u201c\u5f52\u96c6\u81f3\u9879\u76ee\u201d\u3002", (String)"PrepayInputInvoiceListPlugin_30", (String)"taxc-tcvat", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            List<String> splitList = this.prepayInvoiceService.containsSplit(selectRows);
            if (!splitList.isEmpty() && splitList.contains(CONFIRM_SPLIT)) {
                if (selectRows.length == 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u53d1\u7968\u5df2\u6807\u8bc6\u5206\u5305\u3002", (String)"PrepayInputInvoiceListPlugin_28", (String)"taxc-tcvat", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u90e8\u5206\u53d1\u7968\u5df2\u6807\u8bc6\u5206\u5305\uff0c\u6279\u91cf\u9009\u62e9\u53d1\u7968\u65f6\uff0c\u8bf7\u53ea\u9009\u62e9\u672a\u88ab\u201c\u5206\u5305\u6807\u8bc6\u201d\u7684\u53d1\u7968\u3002", (String)"PrepayInputInvoiceListPlugin_27", (String)"taxc-tcvat", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (Arrays.stream(selectRows).filter(e -> NO_PROJECT.longValue() == e.getDynamicObject("project").getLong("id")).count() > 0L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u53d1\u7968\u672a\u8fdb\u884c\u9879\u76ee\u6807\u8bc6\uff0c\u8bf7\u5148\u6807\u8bc6\u9879\u76ee", (String)"PrepayInputInvoiceListPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            long prepayProjectId = selectRows[0].getDynamicObject("project").getLong("id");
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)TCVAT_PREPAY_PROJECT_INFO, (String)"split", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)prepayProjectId)});
            if (null == dynamicObject) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6240\u9009\u53d1\u7968\u7684\u9879\u76ee\u662f\u5426\u4e3a\u5728\u7528\u7684\u9884\u7f34\u9879\u76ee", (String)"PrepayInputInvoiceListPlugin_12", (String)"taxc-tcvat", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!"1".equals(dynamicObject.getString("split"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u53d1\u7968\u5f52\u5c5e\u7684\u9879\u76ee\u4e0d\u652f\u6301\u5206\u5305\uff0c\u5982\u9700\u5206\u5305\uff0c\u8bf7\u5230\u201c\u9884\u7f34\u9879\u76ee\u4fe1\u606f\u201d\u91cd\u65b0\u9009\u62e9\u201c\u662f\u5426\u5bf9\u5916\u5206\u5305\u201d\u3002", (String)"PrepayInputInvoiceListPlugin_13", (String)"taxc-tcvat", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (args.getSource() instanceof Donothing && BTN_CANCEL_SPLIT_KEY.equals(((Donothing)args.getSource()).getOperateKey())) {
            boolean isSame = this.prepayInvoiceService.isSame(selectRows, "project");
            if (!isSame) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u7684\u201c\u9884\u7f34\u9879\u76ee\u540d\u79f0\u201d\u7684\u53d1\u7968\u6570\u636e\u3002", (String)"PrepayInputInvoiceListPlugin_11", (String)"taxc-tcvat", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            List<String> splitList = this.prepayInvoiceService.containsSplit(selectRows);
            if (selectRows.length == 1 && !splitList.contains(CONFIRM_SPLIT)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u53d1\u7968\u672a\u6807\u8bc6\u5206\u5305\uff0c\u65e0\u9700\u53d6\u6d88\u5206\u5305\u3002", (String)"PrepayInputInvoiceListPlugin_31", (String)"taxc-tcvat", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (selectRows.length > 1 && !splitList.stream().allMatch(CONFIRM_SPLIT::equals)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u53d1\u7968\u5b58\u5728\u672a\u88ab\u6807\u8bc6\u5206\u5305\u7684\u53d1\u7968\uff0c\u8bf7\u9009\u62e9\u5df2\u88ab\u201c\u5206\u5305\u6807\u8bc6\u201d\u7684\u53d1\u7968\u3002", (String)"PrepayInputInvoiceListPlugin_33", (String)"taxc-tcvat", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            List<Object> idList = Arrays.stream(selectRows).filter(e -> 961639304377984000L == e.getDynamicObject("invoice_type").getLong("id") || 961640097369875456L == e.getDynamicObject("invoice_type").getLong("id") || 961634333825754112L == e.getDynamicObject("invoice_type").getLong("id") || 961639799666521088L == e.getDynamicObject("invoice_type").getLong("id") || 1376129501813207040L == e.getDynamicObject("invoice_type").getLong("id") || 1376129725579325440L == e.getDynamicObject("invoice_type").getLong("id")).map(e -> e.getLong("id")).collect(Collectors.toList());
            if (this.prepayInvoiceService.isPushPrepayApplication(idList)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u7968\u5df2\u5728\u9884\u7f34\u7533\u8bf7\u5355\u4e2d\u6263\u9664\uff0c\u4e0d\u652f\u6301\u53d6\u6d88\u5206\u5305\u3002", (String)"PrepayInputInvoiceListPlugin_17", (String)"taxc-tcvat", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        BillList billlist = (BillList)this.getControl("billlistap");
        List list = billlist.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        if (args.getSource() instanceof Donothing && BTN_SIGN_KEY.equals(((Donothing)args.getSource()).getOperateKey())) {
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)TCVAT_PREPAY_PROJECT_INFO, (boolean)false, (int)0);
            DynamicObjectCollection selectRows = QueryServiceHelper.query((String)"tcvat_prepay_in_invoice", (String)"org,org.id,project", (QFilter[])new QFilter[]{new QFilter("id", "in", list)});
            List ids = selectRows.stream().map(e -> e.getLong("org.id")).collect(Collectors.toList());
            QFilter idFliter = new QFilter("org", "in", ids).and("projectstatus", "!=", (Object)"close");
            ListFilterParameter filterParameter = new ListFilterParameter(Collections.singletonList(idFliter), null);
            parameter.setListFilterParameter(filterParameter);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_SIGN_KEY));
            this.getView().showForm((FormShowParameter)parameter);
        } else if (args.getSource() instanceof Donothing && BTN_UNSIGN_KEY.equals(((Donothing)args.getSource()).getOperateKey())) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(BTN_UNSIGN_KEY, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u53d6\u6d88\u5f52\u96c6\u540e\uff0c\u6240\u9009\u6570\u636e\u7684\u9884\u7f34\u9879\u76ee\u540d\u79f0\u5c06\u88ab\u6e05\u7a7a\uff0c\u8bf7\u786e\u8ba4\u53d6\u6d88\u5f52\u96c6\u5417\uff1f", (String)"PrepayInputInvoiceListPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
        } else if (args.getSource() instanceof Donothing && BTN_SPLIT_KEY.equals(((Donothing)args.getSource()).getOperateKey())) {
            DynamicObjectCollection selectRows = QueryServiceHelper.query((String)"tcvat_prepay_in_invoice", (String)"invoice_type,invoice_code,invoice_no,serial_no", (QFilter[])new QFilter[]{new QFilter("id", "in", list)});
            this.prepayInvoiceService.setInvoiceSplit(selectRows, CONFIRM_SPLIT);
            this.getView().invokeOperation("refresh");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"PrepayInputInvoiceListPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
            OperatorDialogUtils.operateDialog((String)"zzs", (String)"tcvat_prepay_in_invoice", (String)ResManager.loadKDString((String)"\u5206\u5305\u6807\u8bc6", (String)"PrepayInputInvoiceListPlugin_19", (String)"taxc-tcvat", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u9884\u7f34\u9879\u76ee\u8fdb\u9879\u53d1\u7968\u5206\u5305\u6807\u8bc6\u6210\u529f", (String)"PrepayInputInvoiceListPlugin_18", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else if (args.getSource() instanceof Donothing && BTN_CANCEL_SPLIT_KEY.equals(((Donothing)args.getSource()).getOperateKey())) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(BTN_CANCEL_SPLIT_KEY, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u5305\u540e\uff0c\u6240\u9009\u6570\u636e\u7684\u5206\u5305\u6807\u8bc6\u5c06\u88ab\u6e05\u7a7a\uff0c\u786e\u8ba4\u53d6\u6d88\u5206\u5305\u5417\uff1f", (String)"PrepayInputInvoiceListPlugin_10", (String)"taxc-tcvat", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        ListSelectedRowCollection returnData;
        String itemKey = evt.getActionId();
        if (BTN_SIGN_KEY.equals(itemKey) && null != (returnData = (ListSelectedRowCollection)evt.getReturnData())) {
            DynamicObject prepayProject = QueryServiceHelper.queryOne((String)TCVAT_PREPAY_PROJECT_INFO, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "=", returnData.get(0).getPrimaryKeyValue())});
            BillList billlist = (BillList)this.getControl("billlistap");
            List<Object> list = billlist.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            this.prepayInvoiceService.updateInvoiceOfProject(list, prepayProject.getLong("id"));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"PrepayInputInvoiceListPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
            OperatorDialogUtils.operateDialog((String)"zzs", (String)"tcvat_prepay_in_invoice", (String)ResManager.loadKDString((String)"\u5f52\u96c6\u81f3\u9879\u76ee", (String)"PrepayInputInvoiceListPlugin_24", (String)"taxc-tcvat", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u9884\u7f34\u9879\u76ee\u8fdb\u9879\u53d1\u7968\u5f52\u96c6\u81f3\u9879\u76ee\u3010%1$s\u3011\u6210\u529f", (String)"PrepayInputInvoiceListPlugin_25", (String)"taxc-tcvat", (Object[])new Object[0]), prepayProject.getString("name")));
            this.getView().invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (BTN_UNSIGN_KEY.equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                BillList billlist = (BillList)this.getControl("billlistap");
                List<Object> list = billlist.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
                this.prepayInvoiceService.updateInvoiceOfProject(list, NO_PROJECT);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6210\u529f", (String)"PrepayInputInvoiceListPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
                OperatorDialogUtils.operateDialog((String)"zzs", (String)"tcvat_prepay_in_invoice", (String)ResManager.loadKDString((String)"\u53d6\u6d88\u5f52\u96c6", (String)"PrepayInputInvoiceListPlugin_20", (String)"taxc-tcvat", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u9884\u7f34\u9879\u76ee\u8fdb\u9879\u53d1\u7968\u53d6\u6d88\u5f52\u96c6\u6210\u529f", (String)"PrepayInputInvoiceListPlugin_21", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
        } else if (BTN_CANCEL_SPLIT_KEY.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            BillList billlist = (BillList)this.getControl("billlistap");
            List list = billlist.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            DynamicObjectCollection selectRows = QueryServiceHelper.query((String)"tcvat_prepay_in_invoice", (String)"serial_no", (QFilter[])new QFilter[]{new QFilter("id", "in", list)});
            this.prepayInvoiceService.setInvoiceSplit(selectRows, CANCEL_SPILIT);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6210\u529f", (String)"PrepayInputInvoiceListPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
            OperatorDialogUtils.operateDialog((String)"zzs", (String)"tcvat_prepay_in_invoice", (String)ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u5305", (String)"PrepayInputInvoiceListPlugin_22", (String)"taxc-tcvat", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u9884\u7f34\u9879\u76ee\u8fdb\u9879\u53d1\u7968\u53d6\u6d88\u5206\u5305\u6210\u529f", (String)"PrepayInputInvoiceListPlugin_23", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }
}

