/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.jzjt;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.fieldtip.DeleteRule;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportMultiPlugin;
import kd.taxc.tcvat.business.service.jzjt.JzjtService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class TssqbEditMultiPlugin
extends AbstractDeclareReportMultiPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(TssqbEditMultiPlugin.class);
    private static final String AUDIT_KEY = "audit";
    private static final String ID = "id";
    private static final String ORG = "org";
    private static final String DRAFT = "draft";
    private JzjtService jzjtService = new JzjtService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getView().getControl(ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit draft = (BasedataEdit)this.getView().getControl(DRAFT);
        draft.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"edit", "recalc", "save", "cancel", "submit", AUDIT_KEY});
        super.afterCreateNewData(e);
    }

    protected void setExtendsControlsByBillstatus(String billstatus) {
        if (StringUtils.isNotBlank((CharSequence)billstatus) && !"new".equals(billstatus)) {
            this.getModel().setValue("billstatus", (Object)billstatus);
        }
    }

    protected void beforeLoadFromHyperLinkClick(Map<String, Object> customParams) {
        super.beforeLoadFromHyperLinkClick(customParams);
        this.updateDraft(customParams);
    }

    protected void doAfterSuccessSave() {
        super.doAfterSuccessSave();
        this.getView().invokeOperation("saveattachment");
    }

    protected void setExtendControllsStatus(String operationType) {
        this.getPageCache().put("operation", operationType);
        this.getView().invokeOperation("showattachment");
    }

    public String getSubmitMainTable() {
        return "tcvat_tssqb_query";
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (ORG.equals(name)) {
            long userId = RequestContext.get().getCurrUserId();
            String entityid = this.getView().getEntityId();
            String appid = this.getView().getFormShowParameter().getAppId();
            List<Long> orgList = this.jzjtService.queryYbnsrJzjtFilingTaxMainOrgIdsWithPerm(userId, appid, entityid);
            evt.getCustomQFilters().add(new QFilter(ID, "in", orgList));
        } else if (DRAFT.equals(name)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"TssqbEditMultiPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                FieldTip fieldTip = new FieldTip(FieldTip.FieldTipsLevel.Error, FieldTip.FieldTipsTypes.others, ORG, ResManager.loadKDString((String)"\u503c\u4e0d\u5f97\u4e3a\u7a7a", (String)"TssqbEditMultiPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                DeleteRule deleteRule = new DeleteRule();
                deleteRule.setAction("notnull");
                deleteRule.setFields(Collections.singletonList(ORG));
                fieldTip.setDeleteRule(deleteRule);
                this.getView().showFieldTip(fieldTip);
                evt.setCancel(true);
                return;
            }
            List<Long> draftIds = this.jzjtService.queryDraftIdSqbShow(org.getLong(ID));
            QFilter id = new QFilter(ID, "in", draftIds);
            DynamicObjectCollection jzjtdraft = (DynamicObjectCollection)this.getModel().getValue(DRAFT);
            if (CollectionUtils.isNotEmpty((Collection)jzjtdraft)) {
                id.or(new QFilter(ID, "in", jzjtdraft.stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList())));
            }
            evt.addCustomQFilter(id);
        }
    }

    public void initPeriod(IDataModel getModel, IPageCache getPageCache, String orgId, Map<String, Object> customParams) {
        Date date = new Date();
        Date skssqq = DateUtils.getDayFirst((Date)date);
        this.getModel().setValue("skssqq", (Object)skssqq);
        this.getPageCache().put("skssqq", DateUtils.format((Date)skssqq));
        this.getModel().setValue("skssqz", (Object)skssqq);
        this.getPageCache().put("skssqz", DateUtils.format((Date)skssqq));
    }

    protected boolean checkArgsBeforeOpenInnerPage() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.updateDraft(customParams);
        if (customParams.containsKey("draftIds") && this.getModel().getValue("skssqq") != null && this.getModel().getValue("skssqz") != null) {
            this.getDraftNumber(DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqq")), DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqz")));
        }
        return true;
    }

    protected boolean isDefaultOrg() {
        return false;
    }

    public boolean checkOrgTaxConfig(String orgid, String skssqq, String skssqz) {
        DynamicObjectCollection draft = (DynamicObjectCollection)this.getModel().getValue(DRAFT);
        return orgid != null && skssqq != null && skssqz != null && CollectionUtils.isNotEmpty((Collection)draft);
    }

    protected String getModelNumber() {
        return MultiTableEnum.TSD001.getModel();
    }

    protected String[] getTaxLimits() {
        return new String[]{"count"};
    }

    public void init() {
        if (StringUtils.isBlank((Object)this.getModel().getValue("billno")) && this.getModel().getValue("skssqq") != null && this.getModel().getValue("skssqz") != null) {
            this.getDraftNumber(DateUtils.format((Date)((Date)this.getModel().getValue("skssqq"))), DateUtils.format((Date)((Date)this.getModel().getValue("skssqz"))));
        }
    }

    protected String getUniKey() {
        return (String)this.getModel().getValue("billno");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        ChangeData[] changeData = e.getChangeSet();
        if (appid == null || changeData == null || changeData.length == 0) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (null == org) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"TssqbEditMultiPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        if (e.getProperty().getName().equals(ORG)) {
            if (this.getModel().getDataEntity().getDate("skssqq") == null || this.getModel().getDataEntity().getDate("skssqz") == null) {
                this.getPageCache().put("orgid", this.getModel().getDataEntity().getString("org.id"));
                return;
            }
            Object object = changeData[0].getNewValue();
            String orgid = StringUtils.isBlank((Object)object) && null != changeData[0].getOldValue() ? ((DynamicObject)changeData[0].getOldValue()).get(ID).toString() : org.getString(ID);
            boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, (String)TaxAppEnum.getEnumInstanceByAppid((String)appid).getCategoryCode());
            if (checkResult) {
                this.getModel().beginInit();
                this.getModel().setValue(ORG, null);
                this.getModel().endInit();
                this.getView().updateView(ORG);
                return;
            }
            orgid = org.getString(ID);
            this.getPageCache().put("orgid", orgid);
            DynamicObject oldValueObj = (DynamicObject)changeData[0].getOldValue();
            this.getPageCache().put("oldorgid", null == oldValueObj ? null : oldValueObj.getString(ID));
            this.getModel().setValue(DRAFT, null);
            this.getModel().setValue("billstatus", (Object)"A");
            if (this.getModel().getValue("skssqq") != null && this.getModel().getValue("skssqz") != null) {
                this.getDraftNumber(DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqq")), DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqz")));
                this.loadData(this.getModel().getDataEntity().getDate("skssqq"), this.getModel().getDataEntity().getDate("skssqz"), Boolean.FALSE, Boolean.FALSE);
            }
        }
        if (e.getProperty().getName().equals("skssqq") && this.getModel().getValue("skssqq") != null && this.getModel().getValue("skssqz") != null) {
            this.getDraftNumber(DateUtils.format((Date)((Date)this.getModel().getValue("skssqq"))), DateUtils.format((Date)((Date)this.getModel().getValue("skssqz"))));
            this.loadData(this.getModel().getDataEntity().getDate("skssqq"), this.getModel().getDataEntity().getDate("skssqz"), Boolean.FALSE, Boolean.FALSE);
        }
        if (e.getProperty().getName().equals("skssqz") && this.getModel().getValue("skssqq") != null && this.getModel().getValue("skssqz") != null) {
            this.getDraftNumber(DateUtils.format((Date)((Date)this.getModel().getValue("skssqq"))), DateUtils.format((Date)((Date)this.getModel().getValue("skssqz"))));
            this.loadData(this.getModel().getDataEntity().getDate("skssqq"), this.getModel().getDataEntity().getDate("skssqz"), Boolean.FALSE, Boolean.FALSE);
        }
        if (e.getProperty().getName().equals(DRAFT) && this.getModel().getValue(DRAFT) != null) {
            this.getDraftNumber(DateUtils.format((Date)((Date)this.getModel().getValue("skssqq"))), DateUtils.format((Date)((Date)this.getModel().getValue("skssqz"))));
            this.loadData(this.getModel().getDataEntity().getDate("skssqq"), this.getModel().getDataEntity().getDate("skssqz"), Boolean.FALSE, Boolean.TRUE);
        }
        this.init();
    }

    private void getDraftNumber(String sksqq, String sksqz) {
        String billno = this.getBillNumber(sksqq, sksqz);
        this.getModel().setValue("billno", (Object)billno);
        this.getModel().setDataChanged(false);
        this.getPageCache().put("billno", billno);
    }

    public String getTaxType() {
        return null;
    }

    public String getTemplateType() {
        return "jzjt_tssqb";
    }

    public void clientCallBackMethod(Map<String, String> dataMap, String sheetid) {
    }

    protected Map<String, String> getBizParams() {
        HashMap<String, String> bizParamsMap = new HashMap<String, String>(1);
        bizParamsMap.put("billno", this.getModel().getDataEntity().getString("billno"));
        bizParamsMap.put("draftIds", this.getModel().getDataEntity().getDynamicObjectCollection(DRAFT).stream().map(d -> d.getString("fbasedataid.id")).collect(Collectors.joining(",")));
        return bizParamsMap;
    }

    protected DeclareRequestModel setRequestModel(DeclareRequestModel requestModel) {
        HashMap<String, String> extendParams = requestModel.getExtendParams();
        this.getPageCache().put("operation", requestModel.getOperation());
        Long id = requestModel.getId();
        this.getPageCache().put("sbbid", id == null ? "0" : id.toString());
        this.getView().invokeOperation("showattachment");
        if (extendParams == null) {
            extendParams = new HashMap<String, String>(1);
        }
        extendParams.putAll(this.getBizParams());
        requestModel.setExtendParams(extendParams);
        return requestModel;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        super.afterDoOperation(args);
    }

    public void submit(String operationKey) {
        if ("unaudit".equals(operationKey)) {
            String tssqdBillno = (String)this.getModel().getValue("billno");
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tpo", (String)"TaxRefundInfoService", (String)"deleteTaxRefundInfo", (Object[])new Object[]{Collections.singletonList(tssqdBillno)});
            Map<Object, Object> resultMap = this.jzjtService.getResultMessage(result, operationKey);
            if (resultMap.size() > 0) {
                this.getView().showErrorNotification((String)resultMap.get(tssqdBillno));
                return;
            }
        }
        super.submit(operationKey);
    }

    protected Long getCustomOrg(Map<String, Object> customParams) {
        String orgIdStr = (String)customParams.get("orgId");
        if (StringUtils.isNotBlank((CharSequence)orgIdStr)) {
            return Long.parseLong(orgIdStr);
        }
        IFormView view = this.getView();
        Long orgId = RequestContext.get().getOrgId();
        long userId = RequestContext.get().getCurrUserId();
        String entityid = view.getEntityId();
        String appid = view.getFormShowParameter().getAppId();
        List<Long> orgList = this.jzjtService.queryYbnsrJzjtFilingTaxMainOrgIdsWithPerm(userId, appid, entityid);
        if (CollectionUtils.isNotEmpty(orgList)) {
            if (orgList.contains(orgId)) {
                return orgId;
            }
            return orgList.get(0);
        }
        return null;
    }

    protected Map<String, Object> paraCustomParams(Map<String, Object> customParams) {
        String billno = customParams.get("billno") == null ? null : customParams.get("billno").toString();
        this.getModel().setValue("billno", (Object)billno);
        this.getPageCache().put("billno", billno);
        return customParams;
    }

    protected QFilter getDeclareMainQueryParams() {
        DynamicObjectCollection jzjtdraft = (DynamicObjectCollection)this.getModel().getValue(DRAFT);
        List<Long> tssqbIdList = this.jzjtService.getTssqbId(jzjtdraft);
        if (tssqbIdList.isEmpty()) {
            return QFilter.isNull((String)ID);
        }
        return new QFilter(ID, "in", tssqbIdList);
    }

    protected boolean viewDialog() {
        return false;
    }

    protected void customEvent(String orgId, String startDate, String endDate, String operationKey) {
        String sbbid;
        if ("unaudit".equals(operationKey) && StringUtils.isNotBlank((CharSequence)(sbbid = this.getPageCache().get("sbbid")))) {
            this.jzjtService.updateTssqbBljdbs(Long.parseLong(sbbid), "wsq");
        }
    }

    private void updateDraft(Map<String, Object> customParams) {
        Object draftIds = customParams.get("draftIds");
        if (draftIds != null) {
            Object[] draftIdArr = Stream.of(draftIds.toString().split(",")).map(Long::parseLong).toArray();
            DynamicObject[] drafts = this.jzjtService.loadTsjsDraft(draftIdArr);
            DynamicObjectCollection draftCollection = this.getModel().getDataEntity().getDynamicObjectCollection(DRAFT);
            draftCollection.clear();
            for (DynamicObject draft : drafts) {
                DynamicObject object = draftCollection.addNew();
                object.set("fbasedataid", (Object)draft);
            }
            this.getModel().updateCache();
            this.getView().updateView(DRAFT);
        }
    }

    private String getBillNumber(String skssqq, String skssqz) {
        DynamicObject dynamicObject = this.checkRecordIsExist(MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), this.getPageCache().get("orgid"), this.getTemplateType(), skssqq, skssqz);
        if (dynamicObject == null) {
            return this.createNumber();
        }
        return dynamicObject.getString("billno");
    }

    private String createNumber() {
        return DeclareServiceHelper.generateSBBNo((String)"tcvat_tssqb_query");
    }

    private DynamicObject checkRecordIsExist(String maintable, String orgid, String type, String startDate, String endDate) {
        if (ObjectUtils.anyNull((Object[])new Object[]{maintable, orgid, type, startDate, endDate})) {
            return null;
        }
        return YbnsrService.queryMultiDeclareMain((String)maintable, (long)Long.parseLong(orgid), (String)type, (String)startDate, (String)endDate, (QFilter)this.getDeclareMainQueryParams());
    }
}

