/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.jzjt;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportMultiQueryListPlugin;
import kd.taxc.tcvat.business.service.jzjt.JzjtService;
import org.apache.commons.collections4.CollectionUtils;

public class TssqbListPlugin
extends AbstractDeclareReportMultiQueryListPlugin {
    private JzjtService jzjtService = new JzjtService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List filterColumnList = args.getCommonFilterColumns();
        for (FilterColumn column : filterColumnList) {
            if (!"org.name".equals(column.getFieldName())) continue;
            long userId = RequestContext.get().getCurrUserId();
            String entityid = ((ListView)this.getView()).getBillFormId();
            String appid = this.getView().getFormShowParameter().getAppId();
            List<DynamicObject> taxpayers = this.jzjtService.queryYbnsrOrgIdsWithPerm(userId, appid, entityid);
            Set<Long> orgIdSet = taxpayers.stream().map(o -> o.getLong("orgid.id")).collect(Collectors.toSet());
            CommonFilterColumn typeColumn = (CommonFilterColumn)column;
            List comboItems = typeColumn.getComboItems();
            List<ComboItem> comboItemList = this.jzjtService.buildOrgComboItems(comboItems, taxpayers, orgIdSet);
            typeColumn.setComboItems(comboItemList);
            long orgId = RequestContext.get().getOrgId();
            if (orgIdSet.contains(orgId)) {
                column.setDefaultValue(String.valueOf(orgId));
                break;
            }
            if (!CollectionUtils.isNotEmpty(taxpayers)) break;
            column.setDefaultValue(String.valueOf(taxpayers.get(0).getLong("orgid.id")));
            break;
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if ("org.id".equalsIgnoreCase(args.getFieldName())) {
            long userId = RequestContext.get().getCurrUserId();
            String entityid = ((ListView)this.getView()).getBillFormId();
            String appid = this.getView().getFormShowParameter().getAppId();
            List<DynamicObject> taxpayers = this.jzjtService.queryYbnsrOrgIdsWithPerm(userId, appid, entityid);
            QFilter orgQfilter = new QFilter("id", "in", (Object)taxpayers.stream().map(o -> o.getLong("orgid.id")).toArray());
            args.getQfilters().add(orgQfilter);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        for (QFilter qFilter : qFilters) {
            if (!"bljd1".equals(qFilter.getProperty())) continue;
            qFilter.__setProperty("entryentity.bljd");
        }
    }

    protected void setExtendCustomParams(Map<String, Object> customParams, DynamicObject object) {
        DynamicObject jzjtObject = this.jzjtService.loadSingleTssqb(object.getPkValue());
        DynamicObjectCollection jzjtdraft = jzjtObject.getDynamicObjectCollection("jzjtdraft");
        if (CollectionUtils.isNotEmpty((Collection)jzjtdraft)) {
            customParams.put("draftIds", jzjtdraft.stream().map(o -> o.getString("fbasedataid.id")).collect(Collectors.joining(",")));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (("unapply".equals(operateKey) || "apply".equals(operateKey) || "done".equals(operateKey)) && args.getListSelectedData().size() > 1) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u5355\u884c\u8fdb\u884c\u6807\u8bc6\u3002", (String)"TssqbListPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        super.beforeDoOperation(args);
    }

    public String getModelNumber() {
        return MultiTableEnum.TSD001.getModel();
    }

    protected List<String> getTemplateTypeList() {
        return Collections.singletonList("jzjt_tssqb");
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey = evt.getOperateKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billList.getSelectedRows();
        if ("new".equals(operateKey)) {
            String querytype = this.getQuerytype(evt.getOperateKey());
            HashMap<String, String> custom = new HashMap<String, String>(16);
            custom.put("type", querytype);
            this.showDeclarePage(querytype, custom, null, null);
        } else if ("viewflowchart".equals(evt.getOperateKey()) || "export".equals(evt.getOperateKey())) {
            super.afterDoOperation(evt);
        }
        billList.refresh();
        if ("viewtaxrefund".equals(operateKey)) {
            Set collect = Arrays.stream(list.getPrimaryKeyValues()).collect(Collectors.toSet());
            if (collect.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"TssqbListPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            Object pkId = list.get(0).getPrimaryKeyValue();
            DynamicObject declare = this.jzjtService.loadSingleTssqb(pkId);
            if (declare != null) {
                QFilter filter = new QFilter("declarenum", "=", (Object)declare.getString("billno")).and("taxcategory", "=", (Object)1L);
                boolean exists = QueryServiceHelper.exists((String)"tpo_tax_refund_info", (QFilter[])new QFilter[]{filter});
                if (!exists) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u672a\u751f\u6210\u9000\u7a0e\u5355\u3002", (String)"TssqbListPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, String> customerParams = new HashMap<String, String>();
                customerParams.put("declaretype", "jzjt_tssqb");
                customerParams.put("startdate", "");
                customerParams.put("declarenum", declare.getString("billno"));
                QFilter billListFilter = new QFilter("declaretype", "=", (Object)"jzjt_tssqb").and(new QFilter("declarenum", "=", (Object)declare.getString("billno")));
                PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)"tpo_tax_refund_info", (IFormView)this.getView(), customerParams, null, (QFilter)billListFilter);
            }
        }
    }
}

