/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.ncp;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.business.TaxcCombineBusiness;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.tcvat.common.util.TcvatCommonUtil;

public class NcpDeclareNamePlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit base = (BasedataEdit)this.getView().getControl("orgid");
        base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DateEdit endDateEdit = (DateEdit)this.getView().getControl("enddate");
        endDateEdit.setMinDate((Date)this.getModel().getValue("startdate"));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultOrgidAndDate();
    }

    void setDefaultOrgidAndDate() {
        DateEdit endDateEdit = (DateEdit)this.getView().getControl("enddate");
        Date startDate = (Date)this.getModel().getValue("startdate");
        endDateEdit.setMaxDate(startDate);
        DynamicObject org = (DynamicObject)this.getModel().getValue("orgid");
        if (null == org) {
            return;
        }
        Long orgid = TcvatCommonUtil.getInstance().getDefaultOrg(org.getLong("id"));
        this.getModel().setValue("orgid", (Object)orgid);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        TaxResult listTaxResult = TaxcCombineBusiness.queryTaxcOrgIdByTaxationsysId((Long)RequestContext.get().getCurrUserId(), (Long)1L);
        event.getCustomQFilters().add(new QFilter("id", "in", listTaxResult.getData()));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Date changeDate;
        ChangeData[] changeSet = e.getChangeSet();
        String name = e.getProperty().getName();
        if ("startdate".equals(name)) {
            changeDate = (Date)changeSet[0].getNewValue();
            changeDate = DateUtils.getFirstDateOfMonth((Date)changeDate);
            this.getModel().setValue("startdate", (Object)changeDate);
            DateEdit endDateEdit = (DateEdit)this.getView().getControl("enddate");
            endDateEdit.setMinDate(changeDate);
        }
        if ("enddate".equals(name)) {
            changeDate = (Date)changeSet[0].getNewValue();
            changeDate = DateUtils.getLastDateOfMonth((Date)changeDate);
            this.getModel().setValue("enddate", (Object)changeDate);
        }
        this.checkDateRange(name, this.getModel().getValue("startdate"), this.getModel().getValue("enddate"));
    }

    private boolean checkDateRange(String propertyName, Object startDate, Object endDate) {
        if (EmptyCheckUtils.isAnyEmpty((Object[])new Object[]{startDate, endDate})) {
            return true;
        }
        if (((Date)startDate).after((Date)endDate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6709\u6548\u671f\u8d77\u201d\u9700\u5c0f\u4e8e\u201c\u6709\u6548\u671f\u6b62\u201d\u3002", (String)"NcpDeclareNamePlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.getModel().setValue(propertyName, null);
            return true;
        }
        return false;
    }
}

