/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.prepay;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.taxc.tcvat.business.service.prepay.project.ProjectService;
import org.apache.commons.collections.CollectionUtils;

public class ProjectListPlugin
extends AbstractListPlugin {
    private static final Set<String> f7ShowColumns = new LinkedHashSet<String>(Arrays.asList("name", "number", "baseproject.name", "baseproject.number", "projectstatus", "prepaytype", "levytype", "address"));
    public static final String F7 = "f7";

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        if (this.isF7Page()) {
            List listColumns = args.getListColumns();
            listColumns.removeIf(column -> !f7ShowColumns.contains(column.getListFieldKey()));
            args.setListColumns(listColumns);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List fastFilterColumns;
        if (this.isF7Page() && CollectionUtils.isNotEmpty(fastFilterColumns = args.getFastFilterColumns().stream().filter(filter -> "org.name".equals(filter.getFieldName()) || "taxorg.name".equals(filter.getFieldName())).collect(Collectors.toList()))) {
            args.getFastFilterColumns().removeAll(fastFilterColumns);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        ProjectService.beforeCreateListDataProvider(args);
    }

    private boolean isF7Page() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String formId = listShowParameter.getFormId();
        return formId.contains(F7);
    }

    public void setFilter(SetFilterEvent e) {
        Map map;
        Object orgid;
        super.setFilter(e);
        if (null == e) {
            return;
        }
        List qFilterList = e.getQFilters();
        IFormView view = this.getView().getParentView();
        if (null != view && null != (orgid = (map = view.getFormShowParameter().getCustomParams()).get("orgid"))) {
            qFilterList.add(new QFilter("org", "=", (Object)Long.valueOf(String.valueOf(orgid))));
            qFilterList.add(new QFilter("projectstatus", "!=", (Object)"close"));
        }
    }
}

