/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.prepay.account;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.BillList;
import kd.bos.list.DecimalListColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.PrepayStatusService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.account.AbstractAccountService;
import kd.taxc.tcvat.business.service.prepay.PrepayAccountListService;
import kd.taxc.tcvat.formplugin.account.AbstractAccountingPlugin;

public class PrepayAccountListPugin
extends AbstractAccountingPlugin
implements HyperLinkClickListener {
    private static final String ORGID_KEY = "orgid";
    private static final String BTN_FASTSETTING = "btnfastsetting";
    private static final String BTN_FASTSETTING_AP = "vectorap";
    private static final String PREPAY_APPLICATION = "tcvat_prepay_application";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_FASTSETTING});
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void initialize() {
        BillList billList = (BillList)this.getControl("billlistap");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        billList.setFilter(this.getFilter());
        boolean isApplication = PrepayAccountListService.havePrepayApplication(customParams);
        this.getView().setVisible(Boolean.valueOf(isApplication), new String[]{"applicationno"});
        DecimalListColumn salesAmountColumn = (DecimalListColumn)this.getView().getControl("salesamount");
        salesAmountColumn.setHyperlink(!isApplication);
        DecimalListColumn deductionAmountColumn = (DecimalListColumn)this.getView().getControl("deductionamount");
        deductionAmountColumn.setHyperlink(!isApplication);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getView().setVisible(Boolean.valueOf(customParams.get("from") == null), new String[]{BTN_FASTSETTING, BTN_FASTSETTING_AP});
        this.initDatas(customParams);
        String prapaytype = (String)customParams.get("prepaytype");
        if ("VAT_YJXMLX_003".equals(prapaytype) || "VAT_YJXMLX_005".equals(prapaytype)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"deductionamount"});
        }
        if ("VAT_YJXMLX_004".equals(prapaytype) || "VAT_YJXMLX_005".equals(prapaytype)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"licensecode"});
        }
        BillList billList = (BillList)this.getControl("billlistap");
        DynamicObject prepayObj = QueryServiceHelper.queryOne((String)"tcvat_project_account", (String)"id", (QFilter[])new QFilter[]{this.getFilter()});
        if (null != prepayObj) {
            AbstractAccountService.markEditCell(billList, prepayObj.getLong("id"), "tcvat_project_accountlist", 0);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
    }

    private QFilter getFilter() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object projectid = customParams.get("projectid");
        String declareserialno = (String)customParams.get("declareserialno");
        QFilter filter = new QFilter("projectid", "=", (Object)Long.parseLong(projectid == null ? "0" : String.valueOf(projectid))).and(new QFilter(ORGID_KEY, "=", (Object)Long.parseLong((String)customParams.get(ORGID_KEY)))).and(new QFilter("startdate", "=", (Object)DateUtils.stringToDate((String)customParams.get("skssqq").toString()))).and(new QFilter("enddate", "=", (Object)DateUtils.stringToDate((String)customParams.get("skssqz").toString()))).and(new QFilter("declareserialno", "=", (Object)declareserialno));
        return filter;
    }

    public void initDatas(Map<String, Object> customParams) {
        if (null == customParams.get("projectid")) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.clearData();
            return;
        }
        String orgid = customParams.get(ORGID_KEY) != null ? (String)customParams.get(ORGID_KEY) : "0";
        String status = new PrepayStatusService().getStatus(orgid, (String)customParams.get("skssqq"), (String)customParams.get("skssqz"), (String)customParams.get("projectid"), (String)customParams.get("declareserialno"));
        if ("0".equals(status)) {
            Date start = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
            Date end = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
            PrepayAccountListService.initAccount(start, end, orgid, customParams, this.getView());
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        BillList list = (BillList)evt.getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"tcvat_project_account");
        String serialno = object.getString("serialno");
        String fieldName = evt.getFieldName();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        boolean isApplication = PrepayAccountListService.havePrepayApplication(customParams);
        if (!isApplication) {
            Map customParamMap = this.getView().getFormShowParameter().getCustomParams();
            String caption = "salesamount".equals(fieldName) ? ResManager.loadKDString((String)"\u9500\u552e\u989d\u53d6\u6570\u660e\u7ec6\u5217\u8868", (String)"PrepayAccountListPugin_0", (String)"taxc-tcvat", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6263\u9664\u91d1\u989d\u53d6\u6570\u660e\u7ec6\u5217\u8868", (String)"PrepayAccountListPugin_1", (String)"taxc-tcvat", (Object[])new Object[0]);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCustomParam("taxpayertype", (Object)"zzsyjskb");
            parameter.setCustomParam("taxaccountserialno", (Object)serialno);
            parameter.setCustomParam("updateDraft", (Object)"tcvat_project_account");
            parameter.setCustomParam(ORGID_KEY, customParamMap.get(ORGID_KEY));
            parameter.setCustomParam("id", currentSelectedRowInfo.getPrimaryKeyValue());
            parameter.setCustomParam("fieldName", (Object)fieldName);
            parameter.setCustomParam("cellName", (Object)("salesamount".equals(fieldName) ? ResManager.loadKDString((String)"\u9500\u552e\u989d", (String)"PrepayAccountListPugin_2", (String)"taxc-tcvat", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6263\u9664\u91d1\u989d", (String)"PrepayAccountListPugin_3", (String)"taxc-tcvat", (Object[])new Object[0])));
            parameter.setCustomParam("description", (Object)object.getString("name"));
            parameter.setCustomParam("amount", (Object)object.getBigDecimal(fieldName));
            parameter.setCustomParam("draftnumber", customParamMap.get("declareserialno"));
            parameter.setCustomParam("drafttype", (Object)"tcvat_project_accountlist");
            parameter.setCustomParam("detailtype", (Object)("salesamount".equals(fieldName) ? "sales" : "deduction"));
            parameter.setCustomParam("entry", (Object)"tcvat_prepay_account_deta");
            parameter.setCaption(caption);
            parameter.setFormId("tcvat_income_invoice_tab");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(parameter);
        }
        if ("applicationno".equals(fieldName)) {
            BillShowParameter param = new BillShowParameter();
            param.setFormId(PREPAY_APPLICATION);
            param.setStatus(OperationStatus.EDIT);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            String applicationNo = object.getString(fieldName);
            DynamicObject application = QueryServiceHelper.queryOne((String)PREPAY_APPLICATION, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)applicationNo)});
            param.setPkId(application.get("id"));
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Button && ((Button)evt.getSource()).getKey().equals(BTN_FASTSETTING)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            BillShowParameter billParam = new BillShowParameter();
            billParam.setFormId("tcvat_rule_prepay");
            billParam.setStatus(OperationStatus.EDIT);
            billParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billParam.setCustomParams(customParams);
            this.getView().showForm((FormShowParameter)billParam);
        }
    }
}

