/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.prepay.application;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.dao.prepay.application.PrepayApplicationDao;
import kd.taxc.tcvat.business.service.prepay.application.PrepayApplicationService;

public class PrepayApplicationFormPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(PrepayApplicationFormPlugin.class);
    private static final String ORG = "org";
    private static final String TAX_ORG = "taxorg";
    private static final String PREPAY_PROJECT = "prepayproject";
    private static final String START_DATE = "startdate";
    private static final String ENF_DATE = "enddate";
    private static final String ADD_SALES = "addsales";
    private static final String DELETE_SALES = "deletesalesentry";
    private static final String DELETE_DEDUCT = "deletedeductentry";
    private static final String ADD_DEDUCT = "adddeduct";
    private static final String TAX_SALES_DETAIL = "tcvat_prepay_taxsales_det";
    private static final String TAX_DEDUCT_DETAIL = "tcvat_prepay_deduct_det";
    private PrepayApplicationService prepayApplicationService = new PrepayApplicationService();
    private PrepayApplicationDao prepayApplicationDao = new PrepayApplicationDao();

    public void registerListener(EventObject e) {
        BasedataEdit listener = (BasedataEdit)this.getControl(PREPAY_PROJECT);
        BasedataEdit taxOrgListener = (BasedataEdit)this.getControl(TAX_ORG);
        listener.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        taxOrgListener.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterBindData(EventObject e) {
        boolean notAuthorize;
        super.afterBindData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue(TAX_ORG);
        if (org != null && (notAuthorize = LicenseCheckServiceHelper.check((Object)org.getLong("id"), (IFormView)this.getView(), (String)this.getView().getFormShowParameter().getAppId()))) {
            this.getModel().setValue(TAX_ORG, null);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.getPageCache().put("propertyChanged", "true");
        DynamicObjectCollection deductentry = (DynamicObjectCollection)this.getModel().getValue("deductentry");
        DynamicObjectCollection historyCollection = this.prepayApplicationService.getDeductInvoiceCollection((String)this.getModel().getValue("billno"));
        List<Long> historyList = historyCollection.stream().map(o -> o.getLong("dinvoiceid")).collect(Collectors.toList());
        DynamicObjectCollection collection = PrepayApplicationService.queryInvoiceData(historyList, historyList, historyList);
        this.changedDeduct(deductentry, collection);
    }

    private void changedDeduct(DynamicObjectCollection deductentry, DynamicObjectCollection invoiceDatas) {
        block0: for (int i = 0; i < deductentry.size(); ++i) {
            long dinvoiceid = ((DynamicObject)deductentry.get(i)).getLong("dinvoiceid");
            BigDecimal dcurrentdeduct = ((DynamicObject)deductentry.get(i)).getBigDecimal("dcurrentdeduct");
            BigDecimal dtotalamount = ((DynamicObject)deductentry.get(i)).getBigDecimal("dtotalamount");
            this.getModel().setValue("davaildeduct", (Object)dcurrentdeduct, i);
            for (DynamicObject invoiceData : invoiceDatas) {
                long invoiceid = invoiceData.getLong("id");
                if (dinvoiceid != invoiceid) continue;
                BigDecimal totaldeduct = this.prepayApplicationDao.getTotaldeduct(dinvoiceid);
                this.getModel().setValue("davaildeduct", (Object)BigDecimalUtil.addObject((Object)BigDecimalUtil.subtractObject((Object)dtotalamount, (Object)totaldeduct), (Object)dcurrentdeduct), i);
                this.getModel().setValue("dremaindeduct", (Object)BigDecimalUtil.subtractObject((Object)dtotalamount, (Object)totaldeduct), i);
                this.getModel().setValue("dtotaldeduct", (Object)totaldeduct, i);
                continue block0;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put("propertyChanged", "false");
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        DynamicObject org1 = (DynamicObject)this.getModel().getValue(TAX_ORG);
        if (null == org) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PrepayApplicationFormPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcvat", (String)"zerodeclare", (long)org.getLong("id"));
        if (zerodeclare) {
            this.getView().setEnable(Boolean.FALSE, new String[]{TAX_ORG, PREPAY_PROJECT, START_DATE, ENF_DATE, "zzs", "othertax", "salesdetail", "deductdetail", "forminfo"});
            this.getView().setEnable(Boolean.TRUE, new String[]{ORG});
            String orgName = OrgUtils.getOrgNameById((String)org.getString("id"));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u7f16\u5236\u9884\u7f34\u7533\u8bf7\u5355\u3002", (String)"PrepayApplicationFormPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]), orgName));
            return;
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{TAX_ORG, PREPAY_PROJECT, START_DATE, ENF_DATE, "zzs", "othertax", "salesdetail", "deductdetail", "forminfo"});
        boolean success = this.setProject();
        if (success) {
            this.init();
        }
        this.getPageCache().put("propertyChanged", "true");
    }

    private void init() {
        this.setCrossInfo();
        this.salesEntry();
        this.deductEntry();
        this.setPrepayZZS();
        this.prepayOther();
    }

    private void setCrossInfo() {
        QFilter filter1 = new QFilter("baseproject", "=", (Object)((DynamicObject)this.getModel().getValue(PREPAY_PROJECT)).getLong("id"));
        Date startdate = (Date)this.getModel().getValue(START_DATE);
        Date enddate = (Date)this.getModel().getValue(ENF_DATE);
        QFilter dateFilter = new QFilter("datestart", "<=", (Object)DateUtils.getLastDateOfMonth((Date)startdate)).and(new QFilter("dateend", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)enddate)));
        DynamicObject cross = BusinessDataServiceHelper.loadSingle((String)"tcvat_cross_tax_report", (String)"checkno, contractentry.contractno", (QFilter[])new QFilter[]{filter1, dateFilter});
        if (null != cross) {
            this.getModel().setValue("crossnumber", (Object)cross.getString("checkno"));
            BigDecimal reduce = ((DynamicObject)cross.getDynamicObjectCollection("contractentry").get(0)).getDynamicObject("contractno").getBigDecimal("amount");
            this.getModel().setValue("amount", (Object)reduce);
        } else {
            this.getModel().setValue("crossnumber", null);
            this.getModel().setValue("amount", null);
        }
    }

    private boolean setProject() {
        this.getModel().setValue(START_DATE, (Object)DateUtils.getFirstDateOfMonth((Date)new Date()));
        this.getModel().setValue(ENF_DATE, (Object)DateUtils.getLastDateOfMonth((Date)new Date()));
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (null == org) {
            this.getModel().setValue(TAX_ORG, null);
            this.getModel().setValue(PREPAY_PROJECT, null);
            return false;
        }
        TaxResult taxcOrgs = OrgRelationDataServiceHelper.getTaxOrgByAccountingOrgId((Long)org.getLong("id"));
        logger.info("PrepayApplicationFormPlugin query result:{},param orgid={}", (Object)SerializationUtils.toJsonString((Object)taxcOrgs), (Object)org.getLong("id"));
        Long newTaxOrgId = null;
        if (taxcOrgs.isSuccess() && !CollectionUtils.isEmpty((Collection)((Collection)taxcOrgs.getData()))) {
            List<Long> defaultOrgIds;
            List<Long> defaultOrgId = ((List)taxcOrgs.getData()).stream().filter(map -> map.containsKey("isDefault") && Boolean.TRUE.equals(map.get("isDefault"))).map(map -> (Long)map.get("orgId")).collect(Collectors.toList());
            List<Long> allOrgIds = ((List)taxcOrgs.getData()).stream().filter(map -> map.containsKey("orgId")).map(map -> (Long)map.get("orgId")).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(defaultOrgId) && !CollectionUtils.isEmpty(defaultOrgIds = this.checkPrePayOrg(defaultOrgId))) {
                newTaxOrgId = defaultOrgIds.get(0);
            }
            this.getView().setEnable(Boolean.valueOf(false), new String[]{TAX_ORG});
            if (!CollectionUtils.isEmpty(allOrgIds)) {
                defaultOrgIds = this.checkPrePayOrg(allOrgIds);
                if (!CollectionUtils.isEmpty(defaultOrgIds) && Objects.isNull(newTaxOrgId)) {
                    newTaxOrgId = defaultOrgIds.get(0);
                }
                this.getView().setEnable(Boolean.valueOf(defaultOrgIds.size() > 1), new String[]{TAX_ORG});
            }
        }
        if (Objects.isNull(newTaxOrgId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u786e\u8ba4\u201c\u9884\u7f34\u9879\u76ee\u201d\u7684\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u72b6\u6001\u3002", (String)"PrepayApplicationFormPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{TAX_ORG});
            return false;
        }
        this.getModel().setValue(TAX_ORG, newTaxOrgId);
        String taxOrgId = Optional.ofNullable((DynamicObject)this.getModel().getValue(TAX_ORG)).map(s -> s.getString("id")).orElseGet(() -> "0");
        boolean notAuthorize = LicenseCheckServiceHelper.check((Object)taxOrgId, (IFormView)this.getView(), (String)"tcvat");
        if (notAuthorize) {
            this.getModel().setValue(ORG, null);
            this.getModel().setValue(TAX_ORG, null);
            this.getModel().setValue(PREPAY_PROJECT, null);
            return false;
        }
        if (Objects.isNull(newTaxOrgId)) {
            return false;
        }
        QFilter filter = new QFilter(ORG, "=", (Object)org.getLong("id")).and(new QFilter(TAX_ORG, "=", (Object)newTaxOrgId)).and(new QFilter("projectstatus", "=", (Object)"going")).and(new QFilter("prepaytype", "in", Arrays.asList("VAT_YJXMLX_001", "VAT_YJXMLX_002", "VAT_YJXMLX_005"))).and(new QFilter("status", "=", (Object)"C")).and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] projectInfo = BusinessDataServiceHelper.load((String)"tcvat_prepay_project_info", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"createtime desc", (int)1);
        if (projectInfo.length == 0) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u6ca1\u6709\u6b63\u5728\u8fdb\u884c\u4e2d\u7684\u9879\u76ee, \u8bf7\u524d\u5f80\u9884\u7f34\u9879\u76ee\u8fdb\u884c\u7ef4\u62a4", (String)"PrepayApplicationFormPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]), org.getString("name")));
            return false;
        }
        this.getModel().setValue(PREPAY_PROJECT, (Object)projectInfo[0].getLong("id"));
        this.getPageCache().put("project", ((DynamicObject)this.getModel().getValue(PREPAY_PROJECT)).getString("id"));
        return true;
    }

    private void prepayOther() {
        BigDecimal prepayrate;
        BigDecimal bigRate;
        DynamicObject project = (DynamicObject)this.getModel().getValue(PREPAY_PROJECT);
        DynamicObject projectInfo = BusinessDataServiceHelper.loadSingle((Object)project.getLong("id"), (String)"tcvat_prepay_project_info");
        DynamicObject taxorg = (DynamicObject)this.getModel().getValue(TAX_ORG);
        this.clearEntry("entryentity");
        IDataModel model = this.getModel();
        BigDecimal taxBase = (BigDecimal)this.getModel().getValue("zzsprepay");
        Date startDate = (Date)this.getModel().getValue(START_DATE);
        Date endDate = (Date)this.getModel().getValue(ENF_DATE);
        String rate = "";
        BigDecimal taxAmount = BigDecimal.ZERO;
        DynamicObject category = OrgCheckUtil.getFJSFCategory((Long)taxorg.getLong("id"));
        if ("true".equals(projectInfo.getString("cswhjss"))) {
            if (null != category && Objects.equals("1", category.getString("cswhjssenable"))) {
                bigRate = PrepayApplicationService.getTaxRate("CSWHJSS", project.getString("zone"), startDate, endDate);
                if (null != bigRate) {
                    taxAmount = taxBase.multiply(bigRate).divide(new BigDecimal(100), 2, 4);
                    rate = bigRate.setScale(2, 4).toString() + "%";
                }
            } else {
                rate = "0.00%";
                taxAmount = BigDecimal.ZERO;
            }
            this.createTaxTypeList(model, "cswhjss", taxBase, rate, taxAmount);
        }
        if ("true".equals(projectInfo.getString("edufjsf"))) {
            if (null != category && Objects.equals("2", category.getString("jyffjenable"))) {
                DynamicObject assist = PrepayApplicationService.queryAssistData("JYFFJ", new Date(), new Date());
                if (null != assist) {
                    BigDecimal bigRate2 = assist.getBigDecimal("entryentity.fvalue1");
                    taxAmount = taxBase.multiply(bigRate2).divide(new BigDecimal(100), 2, 4);
                    rate = bigRate2.setScale(2, 4).toString() + "%";
                }
            } else {
                rate = "0.00%";
                taxAmount = BigDecimal.ZERO;
            }
            this.createTaxTypeList(model, "edufjsf", taxBase, rate, taxAmount);
        }
        if ("true".equals(projectInfo.getString("localedufjsfs"))) {
            if (null != category && Objects.equals("3", category.getString("dfjyffjenable"))) {
                bigRate = PrepayApplicationService.getTaxRate("DFJYFJ", project.getString("zone"), startDate, endDate);
                if (null != bigRate) {
                    taxAmount = taxBase.multiply(bigRate).divide(new BigDecimal(100), 2, 4);
                    rate = bigRate.setScale(2, 4).toString() + "%";
                }
            } else {
                rate = "0.00%";
                taxAmount = BigDecimal.ZERO;
            }
            this.createTaxTypeList(model, "localedufjsfs", taxBase, rate, taxAmount);
        }
        if ("true".equals(projectInfo.getString("tccit"))) {
            this.createTaxTypeList(model, "tccit", taxBase, "0.20%", taxBase.multiply(new BigDecimal("0.002")));
        }
        if ("true".equals(projectInfo.getString("yhs"))) {
            prepayrate = project.getBigDecimal("yhsratio").setScale(2, 4);
            this.createTaxTypeList(model, "yhs", taxBase, prepayrate.toString() + "%", taxBase.multiply(prepayrate).divide(new BigDecimal(100), 2, 4));
        }
        if ("true".equals(projectInfo.getString("personaltax"))) {
            prepayrate = project.getBigDecimal("personalratio").setScale(2, 4);
            this.createTaxTypeList(model, "personaltax", taxBase, prepayrate.toString() + "%", taxBase.multiply(prepayrate).divide(new BigDecimal(100), 2, 4));
        }
        if ("true".equals(projectInfo.getString("ghjf"))) {
            prepayrate = project.getBigDecimal("ghjfratio").setScale(2, 4);
            this.createTaxTypeList(model, "ghjf", taxBase, prepayrate.toString() + "%", taxBase.multiply(prepayrate).divide(new BigDecimal(100), 2, 4));
        }
        if ("true".equals(projectInfo.getString("hjbhs"))) {
            prepayrate = project.getBigDecimal("hjbhsratio").setScale(2, 4);
            this.createTaxTypeList(model, "hjbhs", taxBase, prepayrate.toString() + "%", taxBase.multiply(prepayrate).divide(new BigDecimal(100), 2, 4));
        }
        if ("true".equals(projectInfo.getString("sljsjj"))) {
            prepayrate = project.getBigDecimal("sljsjjratio").setScale(2, 4);
            this.createTaxTypeList(model, "sljsjj", taxBase, prepayrate.toString() + "%", taxBase.multiply(prepayrate).divide(new BigDecimal(100), 2, 4));
        }
        this.getView().updateView("entryentity");
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        BigDecimal zzsprepay = (BigDecimal)model.getValue("zzsprepay");
        for (int i = 0; i < entryentity.size(); ++i) {
            zzsprepay = this.setBasetax(model, project, entryentity, zzsprepay, i);
            String rateStr = (String)model.getValue("rate", i);
            BigDecimal rateAmount = PrepayApplicationService.getRateAmount(rateStr);
            model.setValue("taxamount", (Object)BigDecimalUtil.multiplyObject((Object)zzsprepay, (Object)rateAmount, (int)2, (int)4), i);
        }
    }

    private BigDecimal setBasetax(IDataModel model, DynamicObject project, DynamicObjectCollection entryentity, BigDecimal zzsprepay, int i) {
        DynamicObject object = (DynamicObject)entryentity.get(i);
        String taxtype = object.getString("taxtype");
        BigDecimal salesamount = (BigDecimal)model.getValue("salesamount");
        String taxrate = (String)model.getValue("taxrate");
        if ("yhs".equals(taxtype)) {
            String yhstaxbasis = project.getString("yhstaxbasis");
            if ("0".equals(yhstaxbasis)) {
                BigDecimal divide = salesamount.divide(BigDecimal.ONE.add(new BigDecimal(taxrate)), 2, RoundingMode.HALF_UP);
                model.setValue("basetax", (Object)divide, i);
                zzsprepay = divide;
            } else {
                model.setValue("basetax", (Object)salesamount, i);
            }
        } else if ("sljsjj".equals(taxtype)) {
            String sljsjjbillingbasis = project.getString("sljsjjbillingbasis");
            if ("0".equals(sljsjjbillingbasis)) {
                BigDecimal divide = salesamount.divide(BigDecimal.ONE.add(new BigDecimal(taxrate)), 2, RoundingMode.HALF_UP);
                model.setValue("basetax", (Object)divide, i);
                zzsprepay = divide;
            } else {
                model.setValue("basetax", (Object)zzsprepay, i);
            }
        } else {
            model.setValue("basetax", (Object)zzsprepay, i);
        }
        return zzsprepay;
    }

    private void createTaxTypeList(IDataModel model, String taxType, BigDecimal baseTax, String rate, BigDecimal TaxAmount) {
        int index = model.createNewEntryRow("entryentity");
        model.setValue("taxtype", (Object)taxType, index);
        model.setValue("rate", (Object)rate, index);
    }

    private void salesEntry() {
        DynamicObject project = (DynamicObject)this.getModel().getValue(PREPAY_PROJECT);
        QFilter projectFilter = new QFilter("project", "=", (Object)project.getLong("id"));
        QFilter statusFilter = new QFilter("advancepaymentstatus", "in", Arrays.asList("20", " ", null));
        QFilter invoicestatusFilter = new QFilter("invoicestatus", "in", Arrays.asList("0", "3"));
        DynamicObject[] simVatinvoice = BusinessDataServiceHelper.load((String)"sim_vatinvoice_output_sig", (String)"id,invoicecode,invoiceno,taxorg,baseinvoicetype,issuetime,buyername,invoiceamount,totaltax,totalamount,remark,advancepaymentstatus", (QFilter[])new QFilter[]{projectFilter, statusFilter, invoicestatusFilter});
        this.clearEntry("salesentry");
        this.setSalesEntry(simVatinvoice);
    }

    private void setSalesEntry(DynamicObject[] simVatinvoice) {
        if (simVatinvoice.length <= 0) {
            this.getModel().setValue("salesamount", (Object)BigDecimal.ZERO);
            return;
        }
        int salesentrySize = this.getModel().getEntryEntity("salesentry").size();
        IDataModel model = this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("salesentry", simVatinvoice.length);
        int invoiceIndex = 0;
        int entryIndex = salesentrySize;
        while (invoiceIndex < simVatinvoice.length) {
            DynamicObject object = simVatinvoice[invoiceIndex];
            model.setValue("sinvoiceid", (Object)object.getLong("id"), entryIndex);
            model.setValue("sinvoicecode", (Object)object.getString("invoicecode"), entryIndex);
            model.setValue("sinvoiceno", (Object)object.getString("invoiceno"), entryIndex);
            model.setValue("staxorg", (Object)(null != object.getDynamicObject(TAX_ORG) ? object.getDynamicObject(TAX_ORG).getLong("id") : 0L), entryIndex);
            model.setValue("sinvoicetype", (Object)(null != object.getDynamicObject("baseinvoicetype") ? object.getDynamicObject("baseinvoicetype").getLong("id") : 0L), entryIndex);
            model.setValue("sissuetime", (Object)object.getDate("issuetime"), entryIndex);
            model.setValue("sbuyername", (Object)object.getString("buyername"), entryIndex);
            model.setValue("sinvoiceamount", (Object)object.getBigDecimal("invoiceamount"), entryIndex);
            model.setValue("stotaltax", (Object)object.getBigDecimal("totaltax"), entryIndex);
            model.setValue("stotalamount", (Object)object.getBigDecimal("totalamount"), entryIndex);
            model.setValue("sremark", (Object)object.getString("remark"), entryIndex);
            model.setValue("sadvancepaymentstatus", (Object)object.getString("advancepaymentstatus"), entryIndex);
            ++invoiceIndex;
            ++entryIndex;
        }
        model.endInit();
        this.getView().getModel().updateCache();
        this.getView().updateView("salesentry");
        this.getModel().setValue("salesamount", (Object)PrepayApplicationService.getSalesOrDeductionAmount(this.getView(), "salesentry", "stotalamount"));
    }

    private void deductEntry() {
        ArrayList<Long> specialList = new ArrayList<Long>();
        ArrayList<Long> ordinaryList = new ArrayList<Long>();
        ArrayList<Long> electricList = new ArrayList<Long>();
        this.getDeductByProject(specialList, ordinaryList, electricList);
        this.clearEntry("deductentry");
        DynamicObjectCollection invoiceCollection = PrepayApplicationService.queryDeductEntryData(specialList, ordinaryList, electricList);
        this.setDeductEntry(invoiceCollection);
    }

    private void getDeductByProject(List<Long> specialList, List<Long> ordinaryList, List<Long> electricList) {
        DynamicObject project = (DynamicObject)this.getModel().getValue(PREPAY_PROJECT);
        QFilter projectFilter = new QFilter("project", "=", (Object)project.getLong("id"));
        DynamicObject[] invoiceProject = BusinessDataServiceHelper.load((String)"rim_invoice", (String)"serial_no,invoice_type", (QFilter[])new QFilter[]{projectFilter});
        List serials = Arrays.stream(invoiceProject).map(e -> e.getString("serial_no")).collect(Collectors.toList());
        DynamicObjectCollection specialInvoices = QueryServiceHelper.query((String)"rim_inv_special", (String)"id", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", serials)});
        DynamicObjectCollection ordinaryInvoices = QueryServiceHelper.query((String)"rim_inv_ordinary", (String)"id", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", serials)});
        DynamicObjectCollection electricInvoices = QueryServiceHelper.query((String)"rim_inv_electric", (String)"id", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", serials)});
        specialList.addAll(specialInvoices.stream().map(e -> e.getLong("id")).collect(Collectors.toList()));
        ordinaryList.addAll(ordinaryInvoices.stream().map(e -> e.getLong("id")).collect(Collectors.toList()));
        electricList.addAll(electricInvoices.stream().map(e -> e.getLong("id")).collect(Collectors.toList()));
        this.getPageCache().put("specialList", JsonUtil.toJson(specialList));
        this.getPageCache().put("ordinaryList", JsonUtil.toJson(ordinaryList));
        this.getPageCache().put("electricOrdinaryList", JsonUtil.toJson(electricList));
    }

    private void setDeductEntry(DynamicObjectCollection invoiceCollection) {
        IDataModel model = this.getModel();
        if (invoiceCollection.size() <= 0) {
            this.getModel().setValue("deductionamount", (Object)BigDecimal.ZERO);
            return;
        }
        ArrayList<Long> specialidList = new ArrayList<Long>();
        ArrayList<Long> ordinaryidList = new ArrayList<Long>();
        ArrayList<Long> electricList = new ArrayList<Long>();
        int deductentrySize = this.getModel().getEntryEntity("deductentry").size();
        model.beginInit();
        model.batchCreateNewEntryRow("deductentry", invoiceCollection.size());
        int invoiceIndex = 0;
        int entryIndex = deductentrySize;
        while (invoiceIndex < invoiceCollection.size()) {
            DynamicObject object = (DynamicObject)invoiceCollection.get(invoiceIndex);
            String invoiceid = object.getDynamicObject("invoice_type").getString("id");
            if ("961639304377984000".equals(invoiceid) || "961640097369875456".equals(invoiceid)) {
                specialidList.add(object.getLong("id"));
            }
            if ("961634333825754112".equals(invoiceid) || "961639799666521088".equals(invoiceid)) {
                ordinaryidList.add(object.getLong("id"));
            }
            if ("1376129501813207040".equals(invoiceid) || "1376129725579325440".equals(invoiceid)) {
                electricList.add(object.getLong("id"));
            }
            model.setValue("dinvoiceid", (Object)object.getLong("id"), entryIndex);
            if ("26".equals(object.getDynamicObject("invoice_type").getString("number")) || "27".equals(object.getDynamicObject("invoice_type").getString("number"))) {
                model.setValue("dinvoicecode", null, entryIndex);
            } else {
                model.setValue("dinvoicecode", (Object)object.getString("invoice_code"), entryIndex);
            }
            model.setValue("dinvoiceno", (Object)object.getString("invoice_no"), entryIndex);
            model.setValue("dissuetime", (Object)object.getDate("invoice_date"), entryIndex);
            model.setValue("dsalername", (Object)object.getString("saler_name"), entryIndex);
            model.setValue("maingoodsname", (Object)object.getString("main_goods_name"), entryIndex);
            model.setValue("dinvoicetype", (Object)object.getDynamicObject("invoice_type").getLong("id"), entryIndex);
            model.setValue("dinvoiceamount", (Object)object.getBigDecimal("invoice_amount"), entryIndex);
            model.setValue("dtotaltaxamount", (Object)object.getBigDecimal("total_tax_amount"), entryIndex);
            model.setValue("dtotalamount", (Object)object.getBigDecimal("total_amount"), entryIndex);
            model.setValue("dtotaldeduct", (Object)object.getBigDecimal("total_amount"), entryIndex);
            model.setValue("davaildeduct", (Object)object.getBigDecimal("avail_deduct"), entryIndex);
            model.setValue("dcurrentdeduct", (Object)object.getBigDecimal("remain_deduct"), entryIndex);
            model.setValue("dremaindeduct", (Object)BigDecimal.ZERO, entryIndex);
            model.setValue("dremark", (Object)object.getString("remark"), entryIndex);
            ++invoiceIndex;
            ++entryIndex;
        }
        model.endInit();
        this.getView().getModel().updateCache();
        this.getView().updateView("deductentry");
        this.getPageCache().put("entrySpecialList", JsonUtil.toJson(specialidList));
        this.getPageCache().put("entryOrdinaryList", JsonUtil.toJson(ordinaryidList));
        this.getPageCache().put("entryElectricList", JsonUtil.toJson(electricList));
        this.getModel().setValue("deductionamount", (Object)PrepayApplicationService.getSalesOrDeductionAmount(this.getView(), "deductentry", "dcurrentdeduct"));
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
        if ("salesentry".equals(e.getEntryProp().getName())) {
            this.getModel().setValue("salesamount", (Object)PrepayApplicationService.getSalesOrDeductionAmount(this.getView(), "salesentry", "stotalamount"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject project = (DynamicObject)this.getModel().getValue(PREPAY_PROJECT);
        if (null == project && !(args.getSource() instanceof Refresh)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9884\u7f34\u9879\u76ee\u3002", (String)"PrepayApplicationFormPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String itemKey = afterDoOperationEventArgs.getOperateKey();
        if (ADD_SALES.equals(itemKey)) {
            long id = this.getModel().getDataEntity().getLong("id");
            List<Long> existData = PrepayApplicationService.getExistData(id);
            Map<String, Object> params = this.getSalesPageParam("salesentry", "sinvoiceid");
            params.put("existData", existData);
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)TAX_SALES_DETAIL, (IFormView)this.getView(), params, (IFormPlugin)this);
        }
        if (DELETE_SALES.equals(itemKey)) {
            this.getModel().setValue("salesamount", (Object)PrepayApplicationService.getSalesOrDeductionAmount(this.getView(), "salesentry", "stotalamount"));
        }
        if (ADD_DEDUCT.equals(itemKey)) {
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)TAX_DEDUCT_DETAIL, (IFormView)this.getView(), this.getDeductPageParam("deductentry", "dinvoiceid"), (IFormPlugin)this);
        }
        if (DELETE_DEDUCT.equals(itemKey)) {
            this.getModel().setValue("deductionamount", (Object)PrepayApplicationService.getSalesOrDeductionAmount(this.getView(), "deductentry", "dcurrentdeduct"));
        }
    }

    private Map<String, Object> getSalesPageParam(String entry, String invoiceid) {
        Map<String, Object> commonParam = this.getCommonParam();
        DynamicObjectCollection entryCollection = this.getModel().getEntryEntity(entry);
        List invoiceIdList = entryCollection.parallelStream().map(s -> s.getLong(invoiceid)).collect(Collectors.toList());
        commonParam.put("invoiceIdList", invoiceIdList);
        return commonParam;
    }

    private Map<String, Object> getDeductPageParam(String entry, String invoiceid) {
        Map<String, Object> commonParam = this.getCommonParam();
        DynamicObjectCollection entryCollection = this.getModel().getEntryEntity(entry);
        this.getDeductByProject(new ArrayList<Long>(), new ArrayList<Long>(), new ArrayList<Long>());
        DynamicObjectCollection historyCollection = this.prepayApplicationService.getDeductInvoiceCollection((String)this.getModel().getValue("billno"));
        Map<String, String> nowData = this.getNowData(historyCollection, entryCollection);
        List historyList = historyCollection.stream().map(e -> e.getLong("dinvoiceid")).collect(Collectors.toList());
        List specialList = JsonUtil.fromJsonList((String)this.getPageCache().get("specialList"), Long.class);
        List ordinaryList = JsonUtil.fromJsonList((String)this.getPageCache().get("ordinaryList"), Long.class);
        List electricList = JsonUtil.fromJsonList((String)this.getPageCache().get("electricOrdinaryList"), Long.class);
        entryCollection.stream().forEach(e -> {
            historyList.remove(e.getLong(invoiceid));
            specialList.remove(e.getLong(invoiceid));
            ordinaryList.remove(e.getLong(invoiceid));
            electricList.remove(e.getLong(invoiceid));
        });
        commonParam.put("historyIdList", historyList);
        commonParam.put("specialIdList", specialList);
        commonParam.put("ordinaryIdList", ordinaryList);
        commonParam.put("electricIdList", electricList);
        commonParam.put("nowData", nowData);
        return commonParam;
    }

    private Map<String, String> getNowData(DynamicObjectCollection historyCollection, DynamicObjectCollection entryCollection) {
        HashMap<String, String> result = new HashMap<String, String>();
        Set dinvoiceids = entryCollection.stream().map(o -> o.getLong("dinvoiceid")).collect(Collectors.toSet());
        for (DynamicObject his : historyCollection) {
            long dinvoiceid = his.getLong("dinvoiceid");
            if (dinvoiceids.contains(dinvoiceid)) continue;
            result.put(his.getString("dinvoiceid"), his.getString("dcurrentdeduct"));
        }
        return result;
    }

    private Map<String, Object> getCommonParam() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        DynamicObject project = (DynamicObject)this.getModel().getValue(PREPAY_PROJECT);
        if (null == project) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u6b63\u5728\u8fdb\u884c\u4e2d\u7684\u9879\u76ee, \u8bf7\u524d\u5f80\u9884\u7f34\u9879\u76ee\u8fdb\u884c\u7ef4\u62a4", (String)"PrepayApplicationFormPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            return params;
        }
        params.put("project", project.getLong("id"));
        return params;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map callBackMap;
        if (closedCallBackEvent.getActionId().equals(TAX_SALES_DETAIL) && closedCallBackEvent.getReturnData() != null) {
            callBackMap = (Map)closedCallBackEvent.getReturnData();
            Object[] pkid = (Object[])callBackMap.get("pkid");
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice");
            DynamicObject[] simVatinvoice = BusinessDataServiceHelper.load((Object[])pkid, (DynamicObjectType)type);
            this.setSalesEntry(simVatinvoice);
        }
        if (closedCallBackEvent.getActionId().equals(TAX_DEDUCT_DETAIL) && closedCallBackEvent.getReturnData() != null) {
            callBackMap = (Map)closedCallBackEvent.getReturnData();
            List specialList = (List)callBackMap.get("specialList");
            List ordinaryList = (List)callBackMap.get("ordinaryList");
            List electricList = (List)callBackMap.get("electricList");
            DynamicObjectCollection invoiceCollection = PrepayApplicationService.queryInvoiceData(specialList, ordinaryList, electricList);
            this.prepayApplicationService.deductentryHandle((String)this.getModel().getValue("billno"), invoiceCollection);
            this.setDeductEntry(invoiceCollection);
        }
    }

    private void setPrepayZZS() {
        IDataModel model = this.getModel();
        DynamicObject prepayproject = (DynamicObject)model.getValue(PREPAY_PROJECT);
        if (prepayproject == null) {
            return;
        }
        Object salesamount = model.getValue("salesamount");
        Object deductionamount = model.getValue("deductionamount");
        BigDecimal taxbase = BigDecimalUtil.subtractObject((Object)salesamount, (Object)deductionamount).setScale(2, RoundingMode.HALF_UP);
        model.setValue("taxbase", (Object)BigDecimalUtil.subtractObject((Object)salesamount, (Object)deductionamount));
        String prepaytype = prepayproject.getString("prepaytype");
        String levytype = prepayproject.getString("levytype");
        List<String> prepaytypeList = Arrays.asList("VAT_YJXMLX_001", "VAT_YJXMLX_002");
        String taxrateStr = null;
        String prepayrateStr = null;
        if (prepaytypeList.contains(prepaytype) && "normal".equals(levytype)) {
            taxrateStr = "0.09";
            prepayrateStr = "0.02";
        } else if ("VAT_YJXMLX_005".equals(prepaytype)) {
            if ("normal".equals(levytype)) {
                taxrateStr = "0.09";
                prepayrateStr = "0.03";
            } else {
                taxrateStr = "0.05";
                prepayrateStr = "0.05";
            }
        } else {
            taxrateStr = "0.03";
            prepayrateStr = "0.03";
        }
        model.setValue("taxrate", (Object)taxrateStr);
        model.setValue("prepayrate", (Object)prepayrateStr);
        BigDecimal taxrate = BigDecimalUtil.toBigDecimal((Object)taxrateStr);
        BigDecimal prepayrate = BigDecimalUtil.toBigDecimal((Object)prepayrateStr);
        BigDecimal zzsprepay = taxbase.divide(BigDecimal.ONE.add(taxrate), 2, 4).multiply(prepayrate).setScale(2, RoundingMode.HALF_UP);
        model.setValue("zzsprepay", (Object)zzsprepay);
        this.validDeductionAmount();
    }

    private void validDeductionAmount() {
        BigDecimal taxbase = (BigDecimal)this.getModel().getValue("taxbase");
        String message = this.prepayApplicationService.validDeductionAmount(taxbase, BigDecimal.ZERO);
        if (null != message) {
            this.getView().showErrorNotification(message);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (PREPAY_PROJECT.equals(name)) {
            this.setPrepayProjectFilter(evt);
        } else if (TAX_ORG.equals(name)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            if (null == org) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7", (String)"PrepayApplicationFormPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Date startdate = (Date)this.getModel().getValue(START_DATE);
            List<Long> taxOrgList = TaxOrgTakeRelationServiceHelper.getTaxOrgByAccountingOrg((Long)org.getLong("id"), (Date)startdate);
            logger.info("PrepayApplicationFormPlugin F7query result:{},param orgid={}", (Object)SerializationUtils.toJsonString((Object)taxOrgList), (Object)org.getLong("id"));
            taxOrgList = this.checkPrePayOrg(taxOrgList);
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", taxOrgList));
        }
    }

    private List<Long> checkPrePayOrg(List<Long> taxorgs) {
        TaxResult taxResult;
        ArrayList result = Lists.newArrayList();
        TaxResult listTaxResult = TaxcMainDataServiceHelper.queryTaxcMainOrgIdsByOrgIdsForZzs(taxorgs);
        if (listTaxResult != null && listTaxResult.isSuccess() && !CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData())) && (taxResult = TaxcLicenseCheckDataServiceHelper.checkBatch((List)((List)listTaxResult.getData()), (String)"tcvat")) != null && taxResult.isSuccess() && taxResult.getData() != null) {
            Map data = (Map)taxResult.getData();
            result.addAll(data.entrySet().stream().filter(one -> (Boolean)one.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toSet()));
        }
        return result;
    }

    private void setPrepayProjectFilter(BeforeF7SelectEvent evt) {
        DynamicObject accountOrg = (DynamicObject)this.getModel().getValue(ORG);
        DynamicObject taxOrg = (DynamicObject)this.getModel().getValue(TAX_ORG);
        if (ObjectUtils.isEmpty((Object)accountOrg) || ObjectUtils.isEmpty((Object)taxOrg)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u548c\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"PrepayApplicationFormPlugin_9", (String)"taxc-tcvat", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        QFilter filter = new QFilter(ORG, "=", (Object)accountOrg.getLong("id")).and(new QFilter(TAX_ORG, "=", (Object)taxOrg.getLong("id"))).and(new QFilter("projectstatus", "=", (Object)"going")).and(new QFilter("prepaytype", "in", Arrays.asList("VAT_YJXMLX_001", "VAT_YJXMLX_002", "VAT_YJXMLX_005")));
        formShowParameter.getListFilterParameter().setFilter(filter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject project;
        String propertyChanged;
        String name = e.getProperty().getName();
        if (name.equals(ENF_DATE)) {
            this.getModel().setValue(ENF_DATE, (Object)DateUtils.getLastDateOfMonth((Date)((Date)e.getChangeSet()[0].getNewValue())));
        }
        if (name.equals(START_DATE)) {
            this.getModel().setValue(START_DATE, (Object)DateUtils.getFirstDateOfMonth((Date)((Date)e.getChangeSet()[0].getNewValue())));
        }
        if (name.equals(START_DATE) || name.equals(ENF_DATE)) {
            Date end = (Date)this.getModel().getValue(ENF_DATE);
            Date start = (Date)this.getModel().getValue(START_DATE);
            if (start != null && end != null && !DateUtils.validDateRange((String)"month", (Date)start, (Date)end)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u8d77/\u6b62\u5fc5\u987b\u4e3a\u6574\u6708", (String)"PrepayApplicationFormPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
        }
        if (TAX_ORG.equals(name)) {
            Object org = this.getModel().getValue(ORG);
            DynamicObject newTaxOrg = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newTaxOrg == null || Objects.isNull(org)) {
                return;
            }
            QFilter filter = new QFilter(ORG, "=", (Object)((DynamicObject)org).getLong("id")).and(new QFilter(TAX_ORG, "=", (Object)newTaxOrg.getLong("id"))).and(new QFilter("projectstatus", "=", (Object)"going")).and(new QFilter("prepaytype", "in", Arrays.asList("VAT_YJXMLX_001", "VAT_YJXMLX_002", "VAT_YJXMLX_005"))).and(new QFilter("status", "=", (Object)"C")).and(new QFilter("enable", "=", (Object)"1"));
            DynamicObject[] projectInfo = BusinessDataServiceHelper.load((String)"tcvat_prepay_project_info", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"createtime desc", (int)1);
            if (projectInfo.length == 0) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u6ca1\u6709\u6b63\u5728\u8fdb\u884c\u4e2d\u7684\u9879\u76ee, \u8bf7\u524d\u5f80\u9884\u7f34\u9879\u76ee\u8fdb\u884c\u7ef4\u62a4", (String)"PrepayApplicationFormPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]), ((DynamicObject)org).getString("name")));
                this.getModel().setValue(PREPAY_PROJECT, null);
                return;
            }
            this.getModel().setValue(PREPAY_PROJECT, (Object)projectInfo[0].getLong("id"));
        }
        if ("true".equals(propertyChanged = this.getPageCache().get("propertyChanged"))) {
            String message;
            if ((name.equals(PREPAY_PROJECT) || ENF_DATE.equals(name) || START_DATE.equals(name)) && null != (project = (DynamicObject)this.getModel().getValue(PREPAY_PROJECT))) {
                this.clearEntry("deductentry");
                this.clearEntry("salesentry");
                this.init();
            }
            if (name.equals("salesamount")) {
                BigDecimal stotalamount;
                String message2;
                DynamicObjectCollection salesentryCollection = this.getView().getModel().getEntryEntity("salesentry");
                if (salesentryCollection.size() > 0 && null != (message2 = this.prepayApplicationService.validSalesAmount(stotalamount = PrepayApplicationService.getSalesOrDeductionAmount(this.getView(), "salesentry", "stotalamount"), (BigDecimal)e.getChangeSet()[0].getNewValue()))) {
                    this.getModel().setValue("salesamount", e.getChangeSet()[0].getOldValue());
                    this.getView().showErrorNotification(message2);
                }
                DynamicObject project2 = (DynamicObject)this.getModel().getValue(PREPAY_PROJECT);
                IDataModel model = this.getModel();
                DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
                for (int i = 0; i < entryentity.size(); ++i) {
                    this.setBasetax(model, project2, entryentity, (BigDecimal)model.getValue("zzsprepay"), i);
                }
            }
            if (name.equals("predeductamount")) {
                project = (DynamicObject)this.getModel().getValue(PREPAY_PROJECT);
                IDataModel model = this.getModel();
                DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
                for (int i = 0; i < entryentity.size(); ++i) {
                    this.setBasetax(model, project, entryentity, (BigDecimal)model.getValue("zzsprepay"), i);
                }
            }
            if (name.equals("taxbase") && null != (message = this.prepayApplicationService.validDeductionAmount((BigDecimal)this.getModel().getValue("taxbase"), BigDecimal.ZERO))) {
                this.getView().showErrorNotification(message);
            }
            if (name.equals("dremaindeduct")) {
                if (((BigDecimal)e.getChangeSet()[0].getNewValue()).compareTo(BigDecimal.ZERO) < 0) {
                    String seq = e.getChangeSet()[0].getDataEntity().getString("seq");
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5206\u5305\u6263\u9664\u660e\u7ec6\u7b2c\u3010%s\u3011\u884c,\u5269\u4f59\u6263\u9664\u989d\u4e0d\u80fd\u4e3a\u8d1f\u6570, \u8bf7\u91cd\u65b0\u4fee\u6539", (String)"PrepayApplicationFormPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]), seq));
                }
                this.getModel().setValue("deductionamount", (Object)PrepayApplicationService.getSalesOrDeductionAmount(this.getView(), "deductentry", "dcurrentdeduct"));
            }
        }
        if (PREPAY_PROJECT.equals(name) && (project = (DynamicObject)this.getModel().getValue(PREPAY_PROJECT)) != null && "VAT_YJXMLX_005".equals(project.getString("prepaytype"))) {
            this.getModel().setValue("predeductamount", (Object)0);
            this.getModel().setValue("deductionamount", (Object)0);
        }
    }

    private void clearEntry(String entryName) {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(entryName);
        entryentity.clear();
        this.getModel().deleteEntryData(entryName);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if (key.equals("bar_close")) {
            Object billno = this.getModel().getValue("billno");
            DynamicObject[] prepayApplications = BusinessDataServiceHelper.load((String)"tcvat_prepay_application", (String)"salesamount,predeductamount,deductentry.dinvoicecode,deductentry.dinvoiceno,deductentry.dcurrentdeduct", (QFilter[])new QFilter[]{new QFilter("billno", "=", billno)});
            if (prepayApplications != null && prepayApplications.length > 0) {
                DynamicObject object = prepayApplications[0];
                StringBuilder mes = new StringBuilder();
                if (!Objects.equals(BigDecimalUtil.setScale((Object)this.getModel().getValue("salesamount"), (int)10), BigDecimalUtil.setScale((Object)object.getBigDecimal("salesamount"), (int)10))) {
                    mes.append(ResManager.loadKDString((String)"\u672c\u6b21\u5e94\u7a0e\u9500\u552e\u989d\uff08\u542b\u7a0e\uff09\uff0c", (String)"PrepayApplicationFormPlugin_10", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
                if (!Objects.equals(BigDecimalUtil.setScale((Object)this.getModel().getValue("predeductamount"), (int)2), BigDecimalUtil.setScale((Object)object.getBigDecimal("predeductamount"), (int)2))) {
                    mes.append(ResManager.loadKDString((String)"\u9884\u6536\u6b3e\u6263\u9664\u989d\uff0c", (String)"PrepayApplicationFormPlugin_11", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
                DynamicObjectCollection deductentry = object.getDynamicObjectCollection("deductentry");
                DynamicObjectCollection entity = this.getModel().getEntryEntity("deductentry");
                if (deductentry.size() == entity.size()) {
                    for (int i = 0; i < deductentry.size(); ++i) {
                        String filed1 = ((DynamicObject)deductentry.get(i)).getString("dinvoicecode") + ((DynamicObject)deductentry.get(i)).getString("dinvoiceno");
                        String filed2 = ((DynamicObject)entity.get(i)).getString("dinvoicecode") + ((DynamicObject)entity.get(i)).getString("dinvoiceno");
                        boolean equals = Objects.equals(BigDecimalUtil.setScale((Object)((DynamicObject)deductentry.get(i)).getBigDecimal("dcurrentdeduct"), (int)2), BigDecimalUtil.setScale((Object)((DynamicObject)entity.get(i)).getBigDecimal("dcurrentdeduct"), (int)2));
                        if (filed1.equals(filed2) && equals) continue;
                        mes.append(ResManager.loadKDString((String)"\u5206\u5305\u6263\u9664\u989d\u660e\u7ec6\uff0c", (String)"PrepayApplicationFormPlugin_12", (String)"taxc-tcvat", (Object[])new Object[0]));
                        break;
                    }
                } else {
                    mes.append(ResManager.loadKDString((String)"\u5206\u5305\u6263\u9664\u989d\u660e\u7ec6\uff0c", (String)"PrepayApplicationFormPlugin_12", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
                String mesStr = mes.toString();
                if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{mesStr})) {
                    mesStr = String.format(ResManager.loadKDString((String)"\u53d8\u52a8\u5185\u5bb9\uff1a%s", (String)"PrepayApplicationFormPlugin_13", (String)"taxc-tcvat", (Object[])new Object[0]), mesStr.substring(0, mesStr.length() - 1));
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("bar_close", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"PrepayApplicationFormPlugin_14", (String)"taxc-tcvat", (Object[])new Object[0]), mesStr, MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBackListener);
                    evt.setCancel(true);
                }
            } else if (this.getModel().getDataChanged()) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("bar_close", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"PrepayApplicationFormPlugin_14", (String)"taxc-tcvat", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBackListener);
                evt.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("bar_close".equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().close();
        }
    }
}

