/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.prepay.crosstax;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.AttachmentMarkListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.tcvat.business.service.OrgService;
import kd.taxc.tcvat.business.service.crosstax.CrossTaxService;
import kd.taxc.tcvat.common.constant.CrossTaxConstant;
import org.apache.commons.lang3.ObjectUtils;

public class CrossTaxFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener,
ClickListener,
UploadListener,
AttachmentMarkListener,
CrossTaxConstant {
    private static final String QUERY_CONTRACT_ENTRYID = "select a.fentryid as entryid from t_tcvat_contract_info a where a.fid = ";

    public void registerListener(EventObject e) {
        pops.forEach(s -> {
            BasedataEdit type = (BasedataEdit)this.getControl((String)s);
            type.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            type.addAfterF7SelectListener((AfterF7SelectListener)this);
        });
        BasedataEdit taxorg = (BasedataEdit)this.getControl("taxorg");
        taxorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxation = (BasedataEdit)this.getControl("baseproject");
        taxation.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.fillTaxorg();
        this.checkOrg();
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String itemKey;
        switch (itemKey = evt.getOperateKey()) {
            case "check": {
                this.check();
                break;
            }
            case "cancel_check": {
                this.cancelCheck();
                break;
            }
            case "feedback": {
                this.feedback();
                break;
            }
            case "cancel_feedback": {
                this.cancelFeedback();
                break;
            }
            case "delay": {
                this.delay();
                break;
            }
            case "cancel_delay": {
                this.cancelDelay();
                break;
            }
            case "trash": {
                this.trash();
                break;
            }
            case "cancel_trash": {
                this.cancelTrash();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BigDecimal oldCurrentAmount;
        BigDecimal currentAmount;
        Object source = args.getSource();
        if (source instanceof Save && (currentAmount = (BigDecimal)this.getModel().getValue("currentamount")).compareTo(oldCurrentAmount = CrossTaxService.getOldCurrentAmount(this.getModel().getValue("id"))) != 0) {
            DynamicObject contractInfo = (DynamicObject)this.getModel().getValue("contractno");
            contractInfo.set("totalamount", (Object)contractInfo.getBigDecimal("totalamount").subtract(oldCurrentAmount).add(currentAmount));
            SaveServiceHelper.update((DynamicObject)contractInfo);
        }
        super.beforeDoOperation(args);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "org": {
                this.fillTaxorg();
                break;
            }
            case "taxorg": {
                this.checkOrg();
                break;
            }
            case "checkstatus": {
                this.openCheckFields();
                break;
            }
            case "datestart": {
                this.setDateRange();
                break;
            }
            case "dateend": {
                this.setDateRange();
                this.cpDateEnd();
                break;
            }
            case "newdateend": {
                this.checkDelayDate();
                break;
            }
            case "currentamount": {
                this.checkCurrentAmount(e);
            }
        }
    }

    private void setDateRange() {
        Date datestart = (Date)this.getModel().getValue("datestart");
        Date dateend = (Date)this.getModel().getValue("dateend");
        if (ObjectUtils.isNotEmpty((Object)datestart)) {
            ((DateEdit)this.getControl("dateend")).setMinDate(datestart);
        }
        if (ObjectUtils.isNotEmpty((Object)dateend)) {
            ((DateEdit)this.getControl("datestart")).setMaxDate(dateend);
        }
    }

    private void checkOrg() {
        Long orgid;
        boolean notAuthorize;
        DynamicObject org = (DynamicObject)this.getModel().getValue("taxorg");
        if (org != null && (notAuthorize = LicenseCheckServiceHelper.check((Object)(orgid = Long.valueOf(org.getLong("id"))), (IFormView)this.getView(), (String)"tcvat"))) {
            this.getModel().setValue("taxorg", null);
            return;
        }
    }

    private void checkCurrentAmount(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contractno");
        if (ObjectUtils.isEmpty((Object)contract)) {
            this.getModel().setValue("currentamount", (Object)BigDecimal.ZERO);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5408\u540c\u7f16\u53f7", (String)"CrossTaxFormPlugin_28", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        BigDecimal oldcurrentamount = CrossTaxService.getOldCurrentAmount(this.getModel().getValue("id"));
        BigDecimal currentamount = (BigDecimal)changeSet[0].getNewValue();
        if (currentamount.compareTo(BigDecimal.ZERO) < 0) {
            this.getModel().setValue("currentamount", (Object)oldcurrentamount);
            return;
        }
        BigDecimal subtract = currentamount.subtract(oldcurrentamount);
        BigDecimal amount = contract.getBigDecimal("amount");
        BigDecimal totalamount = contract.getBigDecimal("totalamount");
        if (subtract.add(totalamount).compareTo(amount) > 0) {
            this.getModel().setValue("currentamount", (Object)oldcurrentamount);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u3010\u672c\u6b21\u62a5\u9a8c\u5408\u540c\u91d1\u989d\u3011\u4e0d\u5f97\u8d85\u8fc7\u3010\u5408\u540c\u7b7e\u8ba2\u91d1\u989d\u3011", (String)"CrossTaxFormPlugin_29", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    public void afterBindData(EventObject e) {
        this.getView().setEnable(Boolean.FALSE, new String[]{"newdateend"});
        this.setDateRange();
        String checkStatus = (String)this.getModel().getValue("checkstatus");
        if ("checked".equals(checkStatus) || "feedback".equals(checkStatus)) {
            this.isMustInput(Boolean.TRUE, "checkno", "datestart", "dateend");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("baseproject".equals(name)) {
            this.baseProjectListener(evt);
        } else if ("contractno".equals(name)) {
            this.contractNoListener(evt);
        } else if ("taxorg".equals(name)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            OrgService.addFilterByConditionBeforeF7Select(evt, this.getView(), org);
        }
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        BasedataEdit source = (BasedataEdit)evt.getSource();
        String key = source.getKey();
        if ("contractno".equals(key)) {
            ListSelectedRow listSelectedRow = evt.getListSelectedRow();
            QFilter filter = null;
            if (null != listSelectedRow) {
                filter = new QFilter("id", "=", listSelectedRow.getPrimaryKeyValue());
            }
            if (evt.getInputValues().size() > 0) {
                List idList = evt.getInputValues().stream().map(v -> Long.valueOf(v.toString())).collect(Collectors.toList());
                filter = new QFilter("id", "in", idList);
            }
            if (null != filter) {
                DynamicObject contractInfo = QueryServiceHelper.queryOne((String)"tcvat_base_contract_info", (String)"amount,totalamount", (QFilter[])new QFilter[]{filter});
                BigDecimal amount = contractInfo.getBigDecimal("amount");
                BigDecimal totalamount = contractInfo.getBigDecimal("totalamount");
                this.getModel().setValue("currentamount", (Object)amount.subtract(totalamount));
            }
        }
    }

    private void fillTaxorg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            List taxOrgID = TaxOrgTakeRelationServiceHelper.getTaxOrgByAccountingOrg((Long)org.getLong("id"), (Date)new Date());
            if (!CollectionUtils.isEmpty((Collection)taxOrgID)) {
                List<Long> taxOrgIds = this.checkOrgPerm(taxOrgID);
                if (!CollectionUtils.isEmpty(taxOrgIds)) {
                    this.getModel().setValue("taxorg", (Object)taxOrgIds.get(0));
                } else if (taxOrgID.size() > 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5408\u9002\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5efa\u7acb\u4e86\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\u6216\u8005\u7a0e\u52a1\u7ec4\u7ec7\u662f\u5426\u5f00\u542f\u4e86\u589e\u503c\u7a0e\u5361\u7247\u3002", (String)"ProjectFormPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u4e1a\u52a1\u5355\u5143\u534f\u4f5c\u4e2d\u7ef4\u62a4\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"ProjectFormPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        }
    }

    private List<Long> checkOrgPerm(List<Long> taxorgs) {
        Boolean flag = org.apache.commons.collections4.CollectionUtils.isNotEmpty(taxorgs) && taxorgs.size() == 1;
        ArrayList result = Lists.newArrayList();
        taxorgs.forEach(taxorg -> {
            Boolean license = LicenseCheckServiceHelper.check((Object)taxorg, (IFormView)this.getView(), (String)"tcvat");
            if (flag.booleanValue() && license.booleanValue()) {
                return;
            }
            TaxResult isTaxcMainOrg = TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)taxorg);
            Boolean isEnableOrApprove = (Boolean)isTaxcMainOrg.getData() == false;
            if (isEnableOrApprove.booleanValue() && flag.booleanValue()) {
                String msg = TaxcErrorCode.TAXC_STATUS_CODE.getCode().equals(isTaxcMainOrg.getCode()) ? ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u201c\u7a0e\u52a1\u7ec4\u7ec7\u72b6\u6001\u201d=\u201c\u53ef\u7528\u201d\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"ProjectFormPlugin_10", (String)"taxc-tcvat", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u7a0e\u52a1\u7ec4\u7ec7\u662f\u5426\u5ba1\u6838\u901a\u8fc7\u3002", (String)"ProjectFormPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                return;
            }
            boolean taxCategoryEnable = OrgCheckUtil.taxCategoryEnable((String)String.valueOf(taxorg), (IFormView)this.getView(), (String)"tcvat", (String)"zzs", (boolean)false);
            if (taxCategoryEnable && flag.booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u542f\u7528\u4e86\u589e\u503c\u7a0e\u5361\u7247\u7684\u7a0e\u52a1\u7ec4\u7ec7", (String)"ProjectFormPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            if (!(license.booleanValue() || isEnableOrApprove.booleanValue() || taxCategoryEnable)) {
                result.add(taxorg);
            }
        });
        return result;
    }

    private void contractNoListener(BeforeF7SelectEvent evt) {
        DynamicObject baseproject = (DynamicObject)this.getModel().getValue("baseproject");
        if (baseproject == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9884\u7f34\u9879\u76ee", (String)"CrossTaxFormPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        Long masterid = baseproject.getLong("masterid");
        String querySql = QUERY_CONTRACT_ENTRYID + masterid;
        List contractList = DBUtils.query((String)querySql);
        ListShowParameter ls = (ListShowParameter)evt.getFormShowParameter();
        if (!CollectionUtils.isEmpty((Collection)contractList)) {
            List entryIds = contractList.stream().map(a -> {
                Optional first = a.values().stream().findFirst();
                return first.orElse("");
            }).collect(Collectors.toList());
            ls.getListFilterParameter().setFilter(new QFilter("id", "in", entryIds));
        } else {
            ls.getListFilterParameter().setFilter(new QFilter("id", "in", null));
        }
    }

    private void baseProjectListener(BeforeF7SelectEvent evt) {
        Object org = this.getModel().getValue("org");
        if (StringUtils.isBlank((Object)org)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7", (String)"CrossTaxFormPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)org;
        ListShowParameter ls = (ListShowParameter)evt.getFormShowParameter();
        ls.getListFilterParameter().setFilter(new QFilter("org", "=", (Object)dynamicObject.getLong("id")));
        ls.getListFilterParameter().setFilter(new QFilter("projectstatus", "=", (Object)"going"));
    }

    private void cpDateEnd() {
        this.getModel().setValue("newdateend", this.getModel().getValue("dateend"));
    }

    private void checkDelayDate() {
        Date dateEnd = (Date)this.getModel().getValue("dateend");
        Date newDateEnd = (Date)this.getModel().getValue("newdateend");
        if (dateEnd == null || newDateEnd == null) {
            return;
        }
        if (dateEnd.after(newDateEnd)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6700\u65b0\u6709\u6548\u671f\u6b62\u201d\u4e0d\u5f97\u5c0f\u4e8e\u201c\u6709\u6548\u671f\u6b62\u201d", (String)"CrossTaxFormPlugin_18", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.cpDateEnd();
        }
    }

    private void openCheckFields() {
        String checkStatus = (String)this.getModel().getValue("checkstatus");
        if ("checked".equals(checkStatus) || "feedback".equals(checkStatus)) {
            this.isMustInput(Boolean.TRUE, "checkno", "datestart", "dateend");
        } else {
            this.isMustInput(Boolean.FALSE, "checkno", "datestart", "dateend");
        }
        if ("trash".equals(checkStatus)) {
            this.isMustInput(Boolean.TRUE, "remark");
        } else {
            this.isMustInput(Boolean.FALSE, "remark");
        }
    }

    private void isMustInput(Boolean must, String ... inputs) {
        for (String input : inputs) {
            FieldEdit control = (FieldEdit)this.getControl(input);
            control.setMustInput(must.booleanValue());
        }
    }

    private void check() {
        String checkStatus = (String)this.getModel().getValue("checkstatus");
        if ("checked".equals(checkStatus)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62a5\u9a8c\u72b6\u6001\u4e3a\u5df2\u62a5\u9a8c\uff0c\u8bf7\u52ff\u91cd\u590d\u62a5\u9a8c", (String)"CrossTaxFormPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else {
            this.getModel().setValue("checkstatus", (Object)"checked");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u62a5\u9a8c\u6210\u529f", (String)"CrossTaxFormPlugin_20", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    private void cancelCheck() {
        String checkStatus = (String)this.getModel().getValue("checkstatus");
        if ("checked".equals(checkStatus)) {
            this.getModel().setValue("checkstatus", (Object)"nocheck");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u62a5\u9a8c\u6210\u529f", (String)"CrossTaxFormPlugin_21", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u62a5\u9a8c\u65f6\uff0c\u62a5\u9a8c\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u62a5\u9a8c", (String)"CrossTaxFormPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    private boolean checkMustInput() {
        Object checkNo = this.getModel().getValue("checkno");
        Object dateStart = this.getModel().getValue("datestart");
        Object dateEnd = this.getModel().getValue("dateend");
        if (checkNo != null && dateStart != null && dateEnd != null) {
            return true;
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62a5\u9a8c\u6216\u5ef6\u671f\u65f6\uff0c\u201c\u62a5\u9a8c\u7ba1\u7406\u7f16\u53f7\u201d\u3001\u201c\u6709\u6548\u671f\u8d77\u201d\u3001\u201c\u6709\u6548\u671f\u6b62\u201d\u5fc5\u5f55\u3002", (String)"CrossTaxFormPlugin_30", (String)"taxc-tcvat", (Object[])new Object[0]));
        return false;
    }

    private void delay() {
        String checkStatus = (String)this.getModel().getValue("checkstatus");
        if ("checked".equals(checkStatus)) {
            if (!this.checkMustInput()) {
                return;
            }
            this.getModel().setValue("checkstatus", (Object)"delay");
            this.getView().setEnable(Boolean.TRUE, new String[]{"newdateend"});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5ef6\u671f\u6210\u529f", (String)"CrossTaxFormPlugin_22", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else {
            if (checkStatus.equals("delay")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62a5\u9a8c\u72b6\u6001\u4e3a\u5df2\u5ef6\u671f\uff0c\u8bf7\u52ff\u91cd\u590d\u5ef6\u671f", (String)"CrossTaxFormPlugin_10", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5ef6\u671f\u65f6\uff0c\u62a5\u9a8c\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u62a5\u9a8c", (String)"CrossTaxFormPlugin_9", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    private void cancelDelay() {
        String checkStatus = (String)this.getModel().getValue("checkstatus");
        if ("delay".equals(checkStatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"newdateend"});
            this.getModel().setValue("checkstatus", (Object)"checked");
            this.cpDateEnd();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5ef6\u671f\u6210\u529f", (String)"CrossTaxFormPlugin_23", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5ef6\u671f\u65f6\uff0c\u62a5\u9a8c\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ef6\u671f", (String)"CrossTaxFormPlugin_11", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    private void feedback() {
        String checkStatus = (String)this.getModel().getValue("checkstatus");
        if ("checked".equals(checkStatus) || "delay".equals(checkStatus)) {
            if (!this.checkMustInput()) {
                return;
            }
            this.getModel().setValue("checkstatus", (Object)"feedback");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u9988\u6210\u529f", (String)"CrossTaxFormPlugin_24", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else {
            if (checkStatus.equals("feedback")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62a5\u9a8c\u72b6\u6001\u4e3a\u5df2\u53cd\u9988\uff0c\u8bf7\u52ff\u91cd\u590d\u53cd\u9988", (String)"CrossTaxFormPlugin_13", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53cd\u9988\u65f6\uff0c\u62a5\u9a8c\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ef6\u671f\u6216\u5df2\u62a5\u9a8c", (String)"CrossTaxFormPlugin_12", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    private void cancelFeedback() {
        String checkStatus = (String)this.getModel().getValue("checkstatus");
        if ("feedback".equals(checkStatus)) {
            Date dateEnd = (Date)this.getModel().getValue("dateend");
            Date newDateEnd = (Date)this.getModel().getValue("newdateend");
            if (dateEnd == null || newDateEnd == null) {
                return;
            }
            this.getModel().setValue("checkstatus", (Object)(dateEnd.equals(newDateEnd) ? "checked" : "delay"));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u53cd\u9988\u6210\u529f", (String)"CrossTaxFormPlugin_25", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u53cd\u9988\u65f6\uff0c\u62a5\u9a8c\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u53cd\u9988", (String)"CrossTaxFormPlugin_14", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    private void trash() {
        String checkStatus = (String)this.getModel().getValue("checkstatus");
        if ("delay".equals(checkStatus) || "checked".equals(checkStatus)) {
            if (!this.checkMustInput()) {
                return;
            }
            this.getModel().setValue("checkstatus", (Object)"trash");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4f5c\u5e9f\u6210\u529f", (String)"CrossTaxFormPlugin_26", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else {
            if ("trash".equals(checkStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62a5\u9a8c\u72b6\u6001\u4e3a\u5df2\u4f5c\u5e9f\uff0c\u8bf7\u52ff\u91cd\u590d\u4f5c\u5e9f", (String)"CrossTaxFormPlugin_16", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f5c\u5e9f\u65f6\uff0c\u62a5\u9a8c\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ef6\u671f\u6216\u5df2\u62a5\u9a8c", (String)"CrossTaxFormPlugin_15", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    private void cancelTrash() {
        String checkStatus = (String)this.getModel().getValue("checkstatus");
        if ("trash".equals(checkStatus)) {
            Date dateEnd = (Date)this.getModel().getValue("dateend");
            Date newDateEnd = (Date)this.getModel().getValue("newdateend");
            if (dateEnd == null || newDateEnd == null) {
                return;
            }
            this.getModel().setValue("checkstatus", (Object)(dateEnd.equals(newDateEnd) ? "checked" : "delay"));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u4f5c\u5e9f\u6210\u529f", (String)"CrossTaxFormPlugin_27", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u4f5c\u5e9f\u65f6\uff0c\u62a5\u9a8c\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u4f5c\u5e9f", (String)"CrossTaxFormPlugin_31", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }
}

