/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.prepay.declare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.taxdeclare.AbstractDeclarePlugin;
import kd.taxc.bdtaxr.common.taxdeclare.DeclareStepsUtils;
import kd.taxc.bdtaxr.common.taxdeclare.IStatusService;
import kd.taxc.bdtaxr.common.taxdeclare.PrepayStatusService;
import kd.taxc.bdtaxr.common.taxdeclare.TaxStepsConstant;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcvat.business.dao.prepay.PrepayDeclareDao;
import kd.taxc.tcvat.business.dao.prepay.project.PrepayProjectDao;
import kd.taxc.tcvat.business.service.dispatchservice.dto.PrepayDeclareDTO;
import kd.taxc.tcvat.business.service.draft.TaxDeclarationService;
import kd.taxc.tcvat.business.service.prepay.PrepayAccountListService;
import kd.taxc.tcvat.business.service.prepay.declare.CheckDraftService;
import kd.taxc.tcvat.business.service.prepay.declare.PrepayDeclareService;

public class PrepayDeclarationPlugin
extends AbstractDeclarePlugin
implements BeforeF7SelectListener {
    private static final String ORGID_KEY = "orgid";
    private static final String EDIT_KEY = "edit";
    private static final String SAVE_KEY = "save";
    private static final String CANCEL_KEY = "cancel";
    private static final String SUBMIT_KEY = "submit";
    private static final String ORG_SEL = "org";
    private static final String check_page = "tcvat_check_rule";
    private static final String TAXPAYER_TYPE_KEY = "taxpayertype";
    private static final String TAXPAYER_PROJECT_ID = "projectid";
    private static final String TAXPAYER_PROJECT = "prepayproject";
    private static final String DECLARESERIALNO = "declareserialno";
    protected static final String DECLARE_PAGE_ENTITY = "bdtaxr_declare_old";
    private PrepayProjectDao prepayProjectDao = new PrepayProjectDao();
    private PrepayDeclareDao prepayDeclareDao = new PrepayDeclareDao();

    public void initialize() {
        super.setDeclarePageMap(TaxStepsConstant.getTcvatPrepay());
        super.setStatusService((IStatusService)new PrepayStatusService());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit prepayproject = (BasedataEdit)this.getControl(TAXPAYER_PROJECT);
        prepayproject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"forward", EDIT_KEY, SUBMIT_KEY, SAVE_KEY, CANCEL_KEY, "audit"});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String readNumber = (String)customParams.get(DECLARESERIALNO);
        String applyid = (String)customParams.get("applyid");
        this.initPeriod(customParams);
        String orgid = null;
        orgid = !ObjectUtils.isEmpty(customParams.get(ORGID_KEY)) ? (String)customParams.get(ORGID_KEY) : String.valueOf(RequestContext.get().getOrgId());
        boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcvat", (String)"zerodeclare", (long)Long.parseLong(orgid));
        if ("hyperlink".equals(customParams.get("datasource")) || "history".equals(customParams.get("from"))) {
            if (zerodeclare) {
                this.getView().setVisible(Boolean.valueOf(!zerodeclare), new String[]{EDIT_KEY, "recalc"});
                String orgName = OrgUtils.getOrgNameById((String)orgid);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u7f16\u5236\u9884\u7f34\u7533\u62a5\u8868\u3002", (String)"PrepayDeclarationPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]), orgName));
            }
        } else {
            if (zerodeclare) {
                this.getView().setVisible(Boolean.valueOf(!zerodeclare), new String[]{EDIT_KEY, "recalc"});
                String orgName = OrgUtils.getOrgNameById((String)orgid);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u7f16\u5236\u9884\u7f34\u7533\u62a5\u8868\u3002", (String)"PrepayDeclarationPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]), orgName));
                DeclareStepsUtils.resetSteps((int)this.getDeclarePageMap().size(), (String)"0", (String)"0", (IFormView)this.getView());
                return;
            }
            PrepayDeclareDTO prepayDeclareDTO = new PrepayDeclareDTO(null, null, null, null, applyid);
            readNumber = CheckDraftService.getDeclareSerialno(prepayDeclareDTO);
        }
        this.getModel().setValue(DECLARESERIALNO, (Object)readNumber);
        if (!ObjectUtils.isEmpty(customParams.get(ORGID_KEY))) {
            DynamicObject dynamicObject;
            orgid = (String)customParams.get(ORGID_KEY);
            Object projectid = customParams.get(TAXPAYER_PROJECT_ID);
            if (projectid == null && (dynamicObject = QueryServiceHelper.queryOne((String)"tcvat_prepay_declare_bill", (String)"prepayproject,declareserialno", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", customParams.get("sbbid"))})) != null) {
                projectid = dynamicObject.getLong(TAXPAYER_PROJECT);
                this.getModel().setValue(DECLARESERIALNO, (Object)dynamicObject.getString(DECLARESERIALNO));
            }
            this.getModel().setValue(TAXPAYER_PROJECT, projectid);
            this.getPageCache().put(TAXPAYER_PROJECT_ID, String.valueOf(projectid));
            Object selected_taxorgid = customParams.get("selected_taxorgid");
            Boolean checkResult = this.orgCheck(Objects.nonNull(selected_taxorgid) ? (String)selected_taxorgid : orgid, Objects.nonNull(selected_taxorgid));
            if (checkResult.booleanValue()) {
                this.getModel().setValue(ORG_SEL, (Object)orgid);
                this.beforeOpenInnerPage(orgid);
            }
        } else {
            orgid = String.valueOf(RequestContext.get().getOrgId());
            if (StringUtils.isNotBlank((CharSequence)orgid)) {
                Boolean checkResult = this.orgCheck(orgid, false);
                if (checkResult.booleanValue()) {
                    this.getModel().setValue(ORG_SEL, (Object)orgid);
                    boolean haveProject = this.setDefaultProject(orgid);
                    if (!haveProject) {
                        return;
                    }
                    this.beforeOpenInnerPage(orgid);
                }
            } else {
                DeclareStepsUtils.resetSteps((int)this.getDeclarePageMap().size(), (String)"0", (String)"0", (IFormView)this.getView());
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599\u8fdb\u884c\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PrepayDeclarationPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        }
    }

    protected void setButtonVisible(String focuspage) {
        super.setButtonVisible(focuspage);
        if ("1".equals(focuspage)) {
            if ("A".equals(this.getPageCache().get("cache_billstatus"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"print"});
            }
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"print"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (key = afterDoOperationEventArgs.getOperateKey()) {
            case "print": {
                this.print();
                break;
            }
            case "fastsetting": {
                this.openPrepayRule();
                break;
            }
            case "unsubmit": 
            case "unaudit": {
                this.setBtnStatus();
            }
        }
    }

    private void setBtnStatus() {
        if ("1".equals(this.getPageCache().get("focuspage"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"print"});
        }
    }

    private void openPrepayRule() {
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG_SEL);
        HashMap<String, String> customParams = new HashMap<String, String>();
        if (org != null) {
            customParams.put(ORGID_KEY, org.getString("id"));
        }
        BillShowParameter billParam = new BillShowParameter();
        billParam.setFormId("tcvat_rule_prepay");
        billParam.setStatus(OperationStatus.EDIT);
        billParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billParam.setCustomParams(customParams);
        this.getView().showForm((FormShowParameter)billParam);
    }

    protected void print() {
        DynamicObject perpayDeclare;
        HashMap<String, Object> params = new HashMap<String, Object>();
        FormShowParameter showParameter = new FormShowParameter();
        params.put("templateId", TemplateUtils.getOldTemplateIdByType((String)this.getTemplateType()));
        params.put("templateType", this.getTemplateType());
        String sbbid = this.getPageCache().get("cache_sbbid");
        if (null == sbbid && null != (perpayDeclare = this.prepayDeclareDao.queryPerpayDeclareByDeclareSerialno((String)this.getModel().getValue(DECLARESERIALNO)))) {
            sbbid = perpayDeclare.getString("sbbid");
        }
        params.put("sbbid", sbbid);
        showParameter.setFormId("bdtaxr_declare_print");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    private void beforeOpenInnerPage(String orgid) {
        Map map = this.chooseDeclareFormByDataType(this.getPageCache().get(ORGID_KEY), "zzsyjskb", this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"));
        if (((Boolean)map.get("flag")).booleanValue()) {
            if (StringUtils.equals((CharSequence)"declared", (CharSequence)((String)map.get("declarestatus")))) {
                this.openReadOnlyFormByType(this.getPageCache().get(ORGID_KEY), "zzsyjskb", this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"));
            } else {
                this.openDeclareEditingForm(this.getPageCache().get(ORGID_KEY), "zzsyjskb", this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"));
            }
        } else {
            this.showInnerTbPage("1", orgid);
        }
    }

    protected void openDeclareEditingForm(String orgid, String type, String startDate, String endDate) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put(ORGID_KEY, orgid);
        params.put("type", type);
        params.put("skssqq", startDate);
        params.put("skssqz", endDate);
        params.put("templatetype", type);
        params.put("refresh", Boolean.FALSE);
        PrepayDeclarationPlugin.showDeclareEditingForm((String)type, (String)"bdtaxr_declare_edit", (IFormView)this.getView(), params);
    }

    protected String openReadOnlyFormByType(String orgid, String type, String startDate, String endDate) {
        FormShowParameter param = new FormShowParameter();
        HashMap<String, String> customParams = new HashMap<String, String>(16);
        customParams.put(ORGID_KEY, orgid);
        customParams.put("skssqq", startDate);
        customParams.put("skssqz", endDate);
        customParams.put("templatetype", type);
        Map formShowParas = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("apanage", (String)formShowParas.get("apanage"));
        param.setFormId(DECLARE_PAGE_ENTITY);
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey("tabcontent");
        param.setCustomParams(customParams);
        this.getView().showForm(param);
        return param.getPageId();
    }

    private boolean setDefaultProject(String orgid) {
        String projectid;
        DynamicObjectCollection projectInfo = this.prepayProjectDao.queryProjectByOrg(Long.valueOf(orgid));
        String string = projectid = projectInfo.size() > 0 ? ((DynamicObject)projectInfo.get(0)).getString("id") : null;
        if (null == projectid) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6ca1\u6709\u6b63\u5728\u8fdb\u884c\u4e2d\u7684\u9879\u76ee, \u8bf7\u524d\u5f80\u9884\u7f34\u9879\u76ee\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"PrepayDeclarationPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
            return false;
        }
        this.getModel().setValue(TAXPAYER_PROJECT, (Object)projectid);
        this.getPageCache().put(TAXPAYER_PROJECT_ID, projectid);
        return true;
    }

    private Boolean orgCheck(String orgID, boolean isInit) {
        String queryTaxOrg = null;
        if (isInit) {
            queryTaxOrg = orgID;
        } else {
            DynamicObject taxOrg = this.getTaxOrg(orgID);
            if (null == taxOrg) {
                return Boolean.FALSE;
            }
            queryTaxOrg = taxOrg.getString("taxorg");
        }
        if (orgID.equals(queryTaxOrg)) {
            orgID = queryTaxOrg;
            this.getPageCache().put("taxorg", queryTaxOrg);
            DynamicObjectCollection org = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"id", (Object)orgID));
            if (OrgCheckUtil.orgAuth((String)orgID, (IFormView)this.getView(), (DynamicObjectCollection)org)) {
                return Boolean.FALSE;
            }
            if (OrgCheckUtil.orgEnable((IFormView)this.getView(), (DynamicObjectCollection)org, (boolean)true)) {
                return Boolean.FALSE;
            }
            if (!PrepayDeclareService.checkCard(orgID, this.getView(), this.getPageCache()).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u57fa\u7840\u8d44\u6599-\u7a0e\u52a1\u4fe1\u606f\u4e2d\u5b8c\u5584\u7a0e\u52a1\u4fe1\u606f\u3002", (String)"PrepayDeclarationPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
        } else {
            orgID = queryTaxOrg;
            this.getPageCache().put("taxorg", queryTaxOrg);
            if (!PrepayDeclareService.checkCard(orgID, this.getView(), this.getPageCache()).booleanValue()) {
                return Boolean.FALSE;
            }
        }
        this.getPageCache().put(ORGID_KEY, queryTaxOrg);
        return Boolean.TRUE;
    }

    private DynamicObject getTaxOrg(String orgID) {
        DynamicObject taxOrgObject = OrgCheckUtil.getTaxOrgInfo((Long)Long.parseLong(orgID), (Date)DateUtils.stringToDate((String)this.getPageCache().get("skssqq")), (Date)DateUtils.stringToDate((String)this.getPageCache().get("skssqz")));
        if (Objects.isNull(taxOrgObject)) {
            QFilter orgIdFilter = new QFilter("id", "in", (Object)Long.valueOf(orgID));
            DynamicObject[] ordDynamicObjects = BusinessDataServiceHelper.load((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{orgIdFilter});
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u5f53\u524d\u7533\u62a5\u5c5e\u671f\u5185\u4e0d\u5b58\u5728\u6709\u6548\u7684\u53d6\u6570\u5173\u7cfb\uff0c\u5982\u9700\u7533\u62a5\uff0c\u8bf7\u524d\u5f80\u7a0e\u52a1\u4e91\u57fa\u7840\u8d44\u6599\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"PrepayDeclarationPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]), ordDynamicObjects.length > 0 ? ordDynamicObjects[0].getString("name") : ""));
            return null;
        }
        return taxOrgObject;
    }

    private void initPeriod(Map<String, Object> customParams) {
        Date endDate;
        Date startDate;
        if (Boolean.TRUE.equals(customParams.get("readonly"))) {
            startDate = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
            endDate = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        } else {
            Date lastMonth = DateUtils.addMonth((Date)new Date(), (int)-1);
            startDate = DateUtils.getFirstDateOfMonth((Date)lastMonth);
            endDate = DateUtils.getLastDateOfMonth((Date)lastMonth);
        }
        this.getModel().setValue("skssqq", (Object)startDate);
        this.getModel().setValue("skssqz", (Object)endDate);
        this.getPageCache().put("skssqq", DateUtils.format((Date)startDate));
        this.getPageCache().put("skssqz", DateUtils.format((Date)endDate));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        this.getPageCache().put("propertychanged", name);
        ChangeData[] changeData = e.getChangeSet();
        if (changeData == null || 0 == changeData.length) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG_SEL);
        if (null == org) {
            return;
        }
        String orgname = org.getString("name");
        boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcvat", (String)"zerodeclare", (long)org.getLong("id"));
        if (name.equals(ORG_SEL)) {
            String orgid;
            Boolean checkResult;
            if (zerodeclare) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u7f16\u5236\u9884\u7f34\u7533\u62a5\u8868\u3002", (String)"PrepayDeclarationPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]), orgname));
                this.getModel().setValue(ORG_SEL, changeData[0].getOldValue());
                return;
            }
            Object object = changeData[0].getNewValue();
            if (StringUtils.isBlank((Object)object) && null != changeData[0].getOldValue()) {
                Boolean checkResult2 = this.orgCheck(((DynamicObject)changeData[0].getOldValue()).get("id").toString(), false);
                if (checkResult2.booleanValue()) {
                    this.getModel().setValue(ORG_SEL, changeData[0].getOldValue());
                } else {
                    return;
                }
            }
            if ((checkResult = this.orgCheck(orgid = org.getString("id"), false)).booleanValue()) {
                this.setDefaultProject(orgid);
                PrepayDeclareService.deletePrepayDeclareAccount((String)this.getModel().getValue(DECLARESERIALNO));
            } else {
                this.getModel().setValue(ORG_SEL, changeData[0].getOldValue());
            }
        }
        if (name.equals("skssqq")) {
            if (null == this.getModel().getValue(ORG_SEL)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PrepayDeclarationPlugin_17", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            this.checkDate((Date)changeData[0].getNewValue(), (Date)this.getModel().getValue("skssqz"));
        }
        if (name.equals("skssqz")) {
            if (null == this.getModel().getValue(ORG_SEL)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PrepayDeclarationPlugin_17", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            this.checkDate((Date)this.getModel().getValue("skssqq"), (Date)changeData[0].getNewValue());
        }
        if (name.equals(TAXPAYER_PROJECT) || name.equals(DECLARESERIALNO)) {
            if (null == this.getModel().getValue(ORG_SEL)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PrepayDeclarationPlugin_17", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            if (changeData[0].getNewValue() != null) {
                this.loadData((Date)this.getModel().getValue("skssqq"), (Date)this.getModel().getValue("skssqz"));
            }
        }
    }

    private void checkDate(Date startDate, Date endDate) {
        if (!TaxDeclarationService.isNature(startDate, endDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u9700\u4e3a\u6574\u6708\u6216\u6574\u5b63\u5ea6\u3002", (String)"PrepayDeclarationPlugin_9", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        this.loadData(startDate, endDate);
    }

    public void loadData(Date startDate, Date endDate) {
        if (PrepayDeclareService.checkDeclareSerialno((String)this.getModel().getValue(DECLARESERIALNO)).booleanValue()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("recreateserialno");
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"PrepayDeclarationPlugin_13", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"PrepayDeclarationPlugin_14", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u7f16\u7801\u4e3a%s\u7684\u7533\u62a5\u8868, \u5c06\u91cd\u65b0\u751f\u6210\u7f16\u7801\u3002", (String)"PrepayDeclarationPlugin_15", (String)"taxc-tcvat", (Object[])new Object[0]), this.getModel().getValue(DECLARESERIALNO)), "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        } else {
            this.getPageCache().put("skssqq", DateUtils.format((Date)startDate));
            this.getPageCache().put("skssqz", DateUtils.format((Date)endDate));
            this.showInnerTbPage("1", ((DynamicObject)this.getModel().getValue(ORG_SEL)).getString("id"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if ("recalc".equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            String orgid = "0";
            if (this.getModel().getValue(ORG_SEL) == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PrepayDeclarationPlugin_17", (String)"taxc-tctb-common", (Object[])new Object[0]));
                return;
            }
            orgid = ((DynamicObject)this.getModel().getValue(ORG_SEL)).getString("id");
            boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcvat", (String)"zerodeclare", (long)Long.parseLong(orgid));
            if (zerodeclare) {
                String orgName = OrgUtils.getOrgNameById((String)orgid);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u7f16\u5236\u9884\u7f34\u7533\u62a5\u8868\u3002", (String)"PrepayDeclarationPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]), orgName));
                return;
            }
            if (null == this.getPageCache().get(TAXPAYER_PROJECT_ID)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6ca1\u6709\u6b63\u5728\u8fdb\u884c\u4e2d\u7684\u9879\u76ee, \u8bf7\u524d\u5f80\u9884\u7f34\u9879\u76ee\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"PrepayDeclarationPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            Boolean checkResult = this.orgCheck(orgid, false);
            if (checkResult.booleanValue()) {
                new PrepayStatusService().delete(orgid, this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), this.getPageCache().get(TAXPAYER_PROJECT_ID), (String)this.getModel().getValue(DECLARESERIALNO));
                TemplateUtils.deleteReport((Boolean)(!orgid.equals(this.getTaxOrg(orgid)) ? 1 : 0), (String)((String)this.getModel().getValue(DECLARESERIALNO)), (Long)Long.parseLong(orgid), (String)this.getTemplateType(), (Date)DateUtils.stringToDate((String)this.getPageCache().get("skssqq")), (Date)DateUtils.stringToDate((String)this.getPageCache().get("skssqz")));
                this.showInnerTbPage("1", orgid);
                return;
            }
        }
        if ("recreateserialno".equals(e.getCallBackId())) {
            if (e.getResult() == MessageBoxResult.Yes) {
                String readNumber = PrepayDeclareService.createCodeNumber();
                this.getModel().setValue(DECLARESERIALNO, (Object)readNumber);
            } else {
                String propertychanged = this.getPageCache().get("propertychanged");
                if (propertychanged != null) {
                    this.getModel().setValue(propertychanged, null);
                }
            }
        }
        super.confirmCallBack(e);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map map = (Map)event.getReturnData();
        if (check_page.equals(event.getActionId())) {
            if (map == null || map.isEmpty()) {
                return;
            }
            String orgId = ((DynamicObject)this.getModel().getValue(ORG_SEL)).getString("id");
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put(ORGID_KEY, orgId);
            PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)"tcvat_rule_prepay", (IFormView)this.getView(), customParams, (IFormPlugin)this);
            this.getView().close();
        }
    }

    public String getTemplateType() {
        return "zzsyjskb";
    }

    public String getDeclarePageEntity() {
        return DECLARE_PAGE_ENTITY;
    }

    public Map<String, Object> createCustomParams(String orgId, String startdate, String enddate, String status, String focuspage) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put(TAXPAYER_TYPE_KEY, this.getPageCache().get(TAXPAYER_TYPE_KEY));
        customParams.put(ORGID_KEY, orgId);
        customParams.put("taxorg", this.getPageCache().get("taxorg"));
        if ("2".equals(focuspage)) {
            customParams.put("templatetype", this.getTemplateType());
            customParams.put("ParentCache", "true");
            customParams.put("refresh", String.valueOf(!"2".equals(status)));
        }
        return customParams;
    }

    public boolean checkBeforeNextStep(String taxOrgId, String startdate, String enddate, String status, String focusPage) {
        if (!this.checkBaseData()) {
            return false;
        }
        Object selected_taxorgid = this.getView().getFormShowParameter().getCustomParams().get("selected_taxorgid");
        String accountOrgId = ((DynamicObject)this.getModel().getValue(ORG_SEL)).getString("id");
        Boolean orgCheckFlag = Objects.nonNull(selected_taxorgid) ? Boolean.valueOf(this.orgCheck((String)selected_taxorgid, true) == false) : Boolean.valueOf(this.orgCheck(accountOrgId, false) == false);
        if (orgCheckFlag.booleanValue()) {
            return false;
        }
        if ("1".equals(focusPage)) {
            PrepayDeclareDTO prepayDeclareDTO = new PrepayDeclareDTO(Long.parseLong(accountOrgId), null, DateUtils.stringToDate((String)startdate), DateUtils.stringToDate((String)enddate), null);
            ApiResult apiResult = CheckDraftService.checkBeforeNextStep((String)this.getModel().getValue(DECLARESERIALNO), prepayDeclareDTO, this.getModel());
            if (apiResult.getSuccess()) {
                return true;
            }
            this.getView().showErrorNotification(apiResult.getMessage());
            return false;
        }
        return true;
    }

    public boolean checkBaseData() {
        if (this.getModel().getValue(ORG_SEL) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"PrepayDeclarationPlugin_19", (String)"taxc-tcvat", (Object[])new Object[0]));
            return false;
        }
        if (this.getModel().getValue(TAXPAYER_PROJECT) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9884\u7f34\u9879\u76ee\u3002", (String)"PrepayDeclarationPlugin_20", (String)"taxc-tcvat", (Object[])new Object[0]));
            return false;
        }
        if (this.getModel().getValue("skssqq") == null || this.getModel().getValue("skssqz") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6240\u5c5e\u7a0e\u671f\u3002", (String)"PrepayDeclarationPlugin_21", (String)"taxc-tcvat", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG_SEL);
        if (null != org && TAXPAYER_PROJECT.equals(name)) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u9884\u7f34\u9879\u76ee\u4fe1\u606f", (String)"PrepayDeclarationPlugin_10", (String)"taxc-tcvat", (Object[])new Object[0]));
            formShowParameter.getListFilterParameter().setFilter(new QFilter(ORG_SEL, "=", (Object)org.getLong("id")));
            formShowParameter.getListFilterParameter().setFilter(new QFilter("projectstatus", "!=", (Object)"close"));
        }
    }

    public void click(EventObject evt) {
        String projectid;
        String key = ((Control)evt.getSource()).getKey();
        String orgId = this.getPageCache().get(ORGID_KEY);
        String startdate = this.getPageCache().get("skssqq");
        String enddate = this.getPageCache().get("skssqz");
        String declareSerialno = (String)this.getModel().getValue(DECLARESERIALNO);
        DynamicObject project = (DynamicObject)this.getModel().getValue(TAXPAYER_PROJECT);
        String string = projectid = null != project ? project.getString("id") : null;
        if (startdate.isEmpty() || enddate.isEmpty()) {
            return;
        }
        String status = new PrepayStatusService().getStatus(orgId, startdate, enddate, projectid, declareSerialno);
        if (key.startsWith("step")) {
            String focuspage;
            String step = key.replace("step", "");
            if (step.equals(focuspage = this.getPageCache().get("focuspage"))) {
                return;
            }
            if (Integer.parseInt(status) >= Integer.parseInt(step)) {
                this.showInnerTbPage(step, orgId);
            }
        }
    }

    public boolean showInnerTbPage(String focuspage, String orgId) {
        if (!this.checkBaseData()) {
            return false;
        }
        orgId = ((DynamicObject)this.getModel().getValue(ORG_SEL)).getString("id");
        DynamicObject taxOrg = this.getTaxOrg(orgId);
        if (null == taxOrg) {
            return false;
        }
        String startdate = this.getPageCache().get("skssqq");
        String enddate = this.getPageCache().get("skssqz");
        DynamicObject project = (DynamicObject)this.getModel().getValue(TAXPAYER_PROJECT);
        if (null == project) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6ca1\u6709\u6b63\u5728\u8fdb\u884c\u4e2d\u7684\u9879\u76ee, \u8bf7\u524d\u5f80\u9884\u7f34\u9879\u76ee\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"PrepayDeclarationPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
            return false;
        }
        String projectid = project.getString("id");
        String declareSerialno = (String)this.getModel().getValue(DECLARESERIALNO);
        FormShowParameter parameter = FormShowParameter.fromJsonString((String)this.getPageCache().get("FormShowParameter"));
        String applyid = (String)parameter.getCustomParams().get("applyid");
        String status = new PrepayStatusService().getStatus(orgId, startdate, enddate, projectid, declareSerialno);
        this.getPageCache().put("status", status);
        if (Integer.parseInt(focuspage) - Integer.parseInt(status) > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b64\u6b65\u9aa4\u672a\u8fdb\u884c\u5b8c\u6bd5\u6216\u5931\u8d25\uff0c\u4e0d\u80fd\u8fdb\u884c\u4e0b\u4e00\u6b65\u64cd\u4f5c!", (String)"PrepayDeclarationPlugin_11", (String)"taxc-tctb-common", (Object[])new Object[0]));
            return false;
        }
        this.setButtonStyle(focuspage);
        FormShowParameter param = this.createShowParameter(focuspage, orgId, startdate, enddate, false);
        Map<String, Object> customParams = this.createCustomParams(orgId, startdate, enddate, status, focuspage);
        customParams.put(DECLARESERIALNO, declareSerialno);
        customParams.put("sblx", "2");
        customParams.put("applyid", applyid);
        customParams.put(TAXPAYER_PROJECT_ID, projectid);
        this.getPageCache().put(TAXPAYER_PROJECT_ID, projectid);
        this.getPageCache().put("applyid", applyid);
        this.getPageCache().put("apanage", projectid);
        this.getPageCache().put(DECLARESERIALNO, declareSerialno);
        this.getPageCache().put("sblx", "2");
        this.getPageCache().put("prepaytype", project.getString("prepaytype"));
        customParams.put("prepaytype", project.getString("prepaytype"));
        customParams.put("status", status);
        String rootPageId = this.getView().getPageId();
        customParams.put("rootPageId", rootPageId);
        customParams.put("skssqq", startdate);
        customParams.put("skssqz", enddate);
        customParams.put("statusclass", this.getStatusService().getClass().getName());
        customParams.put("totalsteps", this.getDeclarePageMap().size());
        customParams.put("focuspage", focuspage);
        customParams.put("curruentclass", ((Object)((Object)this)).getClass().getName());
        boolean readonly = false;
        boolean isDeclare = this.isDeclared(rootPageId, orgId, startdate, enddate, declareSerialno, projectid);
        if (isDeclare) {
            readonly = true;
        }
        this.getView().setVisible(Boolean.valueOf(!readonly), new String[]{"recalc"});
        customParams.put("readonly", readonly);
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey("tabcontent");
        String pageid = param.getPageId();
        this.getPageCache().put("declarepageid", pageid);
        this.lightenForStatus(focuspage, status);
        boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcvat", (String)"zerodeclare", (long)Long.parseLong(orgId));
        if (zerodeclare) {
            this.getView().setVisible(Boolean.valueOf(!zerodeclare), new String[]{"recalc", SUBMIT_KEY, EDIT_KEY});
            String orgName = OrgUtils.getOrgNameById((String)orgId);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u7f16\u5236\u9884\u7f34\u7533\u62a5\u8868\u3002", (String)"PrepayDeclarationPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]), orgName));
            DeclareStepsUtils.resetSteps((int)this.getDeclarePageMap().size(), (String)"0", (String)"0", (IFormView)this.getView());
            return false;
        }
        this.getView().showForm(param);
        return true;
    }

    private boolean isDeclared(String rootPageId, String orgId, String startdate, String enddate, String declareSerialno, String projectid) {
        DynamicObject declare = PrepayDeclareService.queryNsrxx(orgId, startdate, enddate, declareSerialno, projectid);
        IFormView rootView = this.getView().getView(rootPageId);
        IPageCache rootCache = (IPageCache)rootView.getService(IPageCache.class);
        rootCache.put("cache_billstatus", "A");
        if (declare != null) {
            String status = declare.getString("declarestatus");
            String billstatus = declare.getString("billstatus");
            String id = declare.getString("id");
            rootCache.put("cache_billstatus", billstatus);
            rootCache.put("cache_sbbid", id);
            if (StringUtils.isNotBlank((CharSequence)billstatus) && !"A".equals(billstatus)) {
                DynamicObject org = (DynamicObject)rootView.getModel().getValue(ORG_SEL);
                String orgName = null != org ? org.getString("name") : "";
                String statusName = this.getStatusLocaleName(status, billstatus);
                String msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f\u7533\u62a5\u7f16\u7801\u4e3a%3$s\u7684\u7533\u62a5\u8868\u5df2%4$s\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u3002", (String)"PrepayDeclarationPlugin_12", (String)"taxc-tcvat", (Object[])new Object[0]), orgName, startdate, declareSerialno, statusName);
                rootView.showTipNotification(msg, Integer.valueOf(5000));
                this.getView().sendFormAction(rootView);
                return true;
            }
        } else {
            rootCache.put("cache_sbbid", null);
        }
        return false;
    }

    public void clientCallBack(ClientCallBackEvent e) {
        String applyid = this.getPageCache().get("applyid");
        String declareserialno = this.getPageCache().get(DECLARESERIALNO);
        boolean exists = QueryServiceHelper.exists((String)"tcvat_prepay_declare_bill", (QFilter[])new QFilter[]{new QFilter(DECLARESERIALNO, "=", (Object)declareserialno)});
        if (applyid != null && exists) {
            PrepayAccountListService.setPrepareNumber(applyid, declareserialno);
        }
    }

    public void submit(String key) {
        String sbbid = this.getPageCache().get("cache_sbbid");
        if (StringUtils.isEmpty((CharSequence)sbbid)) {
            HashMap<String, String> extraParams = new HashMap<String, String>(16);
            extraParams.put("serialno", this.getPageCache().get(DECLARESERIALNO));
            extraParams.put("sblx", this.getPageCache().get("sblx"));
            extraParams.put("apanage", this.getPageCache().get("apanage"));
            DynamicObject declare = YbnsrService.queryYbnsrDateRange((String)this.getPageCache().get("taxorg"), (String)this.getTemplateType(), (String)DateUtils.format((Date)DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)this.getPageCache().get("skssqq")))), (String)DateUtils.format((Date)DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)this.getPageCache().get("skssqz")))), (int)0, extraParams);
            if (declare != null) {
                sbbid = declare.getString("id");
                this.getPageCache().put("cache_sbbid", sbbid);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)sbbid)) {
            ArrayList<String> pklist = new ArrayList<String>();
            pklist.add(sbbid);
            boolean flag = false;
            if (SUBMIT_KEY.equals(key)) {
                flag = DeclareUtils.submit((IFormView)this.getView(), pklist, (String)key, (String)"tcvat_prepay_declare_bill", (boolean)false);
            } else {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tcvat_prepay_declare_bill");
                DynamicObject[] declare = BusinessDataServiceHelper.load((Object[])pklist.toArray(), (DynamicObjectType)mainEntityType);
                List<Object> ids = Arrays.stream(declare).map(a -> a.getLong("id")).collect(Collectors.toList());
                OperationResult result = OperationServiceHelper.executeOperate((String)key, (String)"tcvat_prepay_declare_bill", (Object[])ids.toArray(), (OperateOption)OperateOption.create());
                flag = result.isSuccess();
                if (flag) {
                    String msg = "audit".equals(key) ? ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f\u3002", (String)"PrepayDeclarationPlugin_22", (String)"taxc-tcvat", (Object[])new Object[0]) : ("unaudit".equals(key) ? ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6210\u529f\u3002", (String)"PrepayDeclarationPlugin_23", (String)"taxc-tcvat", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f\u3002", (String)"PrepayDeclarationPlugin_24", (String)"taxc-tcvat", (Object[])new Object[0]));
                    this.getView().showSuccessNotification(msg);
                    if ("audit".equals(key)) {
                        PrepayDeclareService.refreshElement(ids, key);
                    }
                } else {
                    this.getView().showOperationResult(result);
                }
            }
            if (flag) {
                this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY, SUBMIT_KEY, SAVE_KEY, "recalc", CANCEL_KEY});
                this.setBtnStatus(key);
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u751f\u6210\u7533\u62a5\u8868\u518d\u63d0\u4ea4\u3002", (String)"PrepayDeclarationPlugin_18", (String)"taxc-tctb-common", (Object[])new Object[0]));
        }
    }

    private void setBtnStatus(String itemKey) {
        String focuspage = this.getPageCache().get("focuspage");
        if (itemKey.equals(SUBMIT_KEY)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{SUBMIT_KEY, "unsubmit", "audit", "unaudit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY, SAVE_KEY, "recalc", CANCEL_KEY, "fastsetting"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"unsubmit", "audit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{SUBMIT_KEY, "unaudit"});
        }
        if (itemKey.equals("unsubmit") || itemKey.equals("unaudit")) {
            this.getView().setEnable(Boolean.TRUE, new String[]{SUBMIT_KEY});
            this.getView().setEnable(Boolean.FALSE, new String[]{"unsubmit"});
            if ("1".equals(focuspage)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"recalc", "fastsetting"});
                this.getView().setVisible(Boolean.FALSE, new String[]{SUBMIT_KEY, "unsubmit", "audit", "unaudit", EDIT_KEY});
            } else if ("2".equals(focuspage)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{SUBMIT_KEY, "unsubmit", EDIT_KEY, "recalc"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"audit", "unaudit"});
            }
        }
        if (itemKey.equals("audit")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{SUBMIT_KEY, "unsubmit", "audit", "unaudit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY, SAVE_KEY, "recalc", CANCEL_KEY, "fastsetting"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"unaudit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{SUBMIT_KEY, "unsubmit", "audit"});
        }
    }

    public DynamicObject getDeclareMain(String orgid, String startDate, String endDate, Object type) {
        String sbbid;
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tcvat_prepay_declare_bill", (String)"sbbid", (QFilter[])new QFilter[]{new QFilter(DECLARESERIALNO, "=", this.getModel().getValue(DECLARESERIALNO))});
        if (dynamicObject != null && StringUtils.isNotBlank((CharSequence)(sbbid = dynamicObject.getString("sbbid")))) {
            return QueryServiceHelper.queryOne((String)"tctb_declare_main", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(sbbid))});
        }
        return null;
    }
}

