/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.prepay.declare;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.IFormController;
import kd.taxc.bdtaxr.common.taxdeclare.PrepayStatusService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.beanutils.MethodUtils;

public class PrepayWorkFlowPlugin
extends AbstractBillPlugIn {
    private static Log LOGGER = LogFactory.getLog(PrepayWorkFlowPlugin.class);
    PrepayStatusService prepayStatusService = new PrepayStatusService();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"viewdetails"});
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("viewdetails".equals(c.getKey())) {
            this.showInnerTbPage();
        }
    }

    private void showInnerTbPage() {
        String orgId = ((DynamicObject)this.getModel().getValue("org")).getString("id");
        String startdate = DateUtils.format((Date)((Date)this.getModel().getValue("skssqq")));
        String enddate = DateUtils.format((Date)((Date)this.getModel().getValue("skssqz")));
        DynamicObject project = (DynamicObject)this.getModel().getValue("prepayproject");
        String projectid = project.getString("id");
        String declareSerialno = (String)this.getModel().getValue("declareserialno");
        FormShowParameter parameter = FormShowParameter.fromJsonString((String)this.getPageCache().get("FormShowParameter"));
        String applyid = (String)parameter.getCustomParams().get("applyid");
        String status = this.prepayStatusService.getStatus(orgId, startdate, enddate, projectid, declareSerialno);
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        pageCache.put("status", status);
        pageCache.put("taxorg", orgId);
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bdtaxr_declare_old");
        Map<String, Object> customParams = this.createCustomParams(orgId, status);
        customParams.put("declareserialno", declareSerialno);
        customParams.put("sblx", "2");
        customParams.put("applyid", applyid);
        customParams.put("projectid", projectid);
        pageCache.put("projectid", projectid);
        pageCache.put("applyid", applyid);
        pageCache.put("apanage", projectid);
        pageCache.put("declareserialno", declareSerialno);
        pageCache.put("sblx", "2");
        pageCache.put("prepaytype", project.getString("prepaytype"));
        customParams.put("prepaytype", project.getString("prepaytype"));
        customParams.put("status", status);
        customParams.put("skssqq", startdate);
        customParams.put("skssqz", enddate);
        customParams.put("totalsteps", 2);
        customParams.put("focuspage", "2");
        customParams.put("curruentclass", ((Object)((Object)this)).getClass().getName());
        customParams.put("readonly", true);
        String rootPageId = this.getView().getParentView().getPageId();
        customParams.put("rootPageId", rootPageId);
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.InCurrentForm);
        param.getOpenStyle().setTargetKey("tabcontent");
        String pageid = param.getPageId();
        pageCache.put("declarepageid", pageid);
        this.getView().showForm(param);
    }

    private Map<String, Object> createCustomParams(String orgId, String status) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("taxpayertype", this.getPageCache().get("taxpayertype"));
        customParams.put("orgid", orgId);
        customParams.put("taxorg", this.getPageCache().get("taxorg"));
        customParams.put("templatetype", "zzsyjskb");
        customParams.put("ParentCache", "true");
        customParams.put("refresh", String.valueOf(!"2".equals(status)));
        return customParams;
    }

    public void afterLoadData(EventObject e) {
        List params = (List)SerializationUtils.fromJsonString((String)"[{\"key\":\"viewdetails\",\"methodName\":\"click\",\"args\":[],\"postData\":[{},[]]}]", List.class);
        this.invokeOperation(this.getView(), params);
    }

    private void invokeOperation(IFormView view, List<Map<String, Object>> params) {
        IFormController srv = (IFormController)view.getService(IFormController.class);
        ArrayList<String> errors = new ArrayList<String>(16);
        for (Map<String, Object> param : params) {
            String key = (String)param.get("key");
            String methodName = (String)param.get("methodName");
            Object _args = param.get("args");
            Object post = param.get("postData");
            Object[] args = ((List)_args).toArray();
            List postData = (List)post;
            srv.postData(postData);
            try {
                if (StringUtils.isBlank((CharSequence)key)) {
                    MethodUtils.invokeMethod((Object)srv, (String)methodName, (Object[])args);
                    continue;
                }
                srv.registerListener();
                Control ctl = view.getControl(key);
                if (ctl == null) continue;
                MethodUtils.invokeMethod((Object)ctl, (String)methodName, (Object[])args);
            }
            catch (Exception e) {
                errors.add(e.toString());
            }
        }
        LOGGER.error(((Object)errors).toString());
    }
}

