/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.prepay.declare.query;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateUtilsOld;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcvat.business.dao.declare.DeclareReportDao;
import kd.taxc.tcvat.business.dao.prepay.application.PrepayApplicationDao;
import kd.taxc.tcvat.business.service.prepay.declare.PrepayDeclareService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class PrepayDeclareQueryListPlugin
extends AbstractListPlugin {
    private static final String ORGID_KEY = "orgid";
    private static final String ORGNAME_KEY = "orgname";
    private static final String TBLNEW = "tblnew";
    private static final String PAY_STATUS_UNPAID = "0";
    private static final String PAY_STATUS_PAID = "1";
    private static final String REPLACEMENT = "ewblname";
    private static final String SEPARATOR = System.getProperty("line.separator");
    private DeclareReportDao declareReportDao = new DeclareReportDao();
    private PrepayApplicationDao prepayApplicationDao = new PrepayApplicationDao();

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        ListDataProvider list = new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (CollectionUtils.isNotEmpty((Collection)rows)) {
                    List prayIds = rows.stream().map(s -> s.getString("id")).map(a -> Long.valueOf(a)).collect(Collectors.toList());
                    DynamicObjectCollection praySbs = QueryServiceHelper.query((String)"tcvat_prepay_declare_bill", (String)"id,sbbid", (QFilter[])new QFilter("id", "in", prayIds).toArray());
                    Map<String, String> idMap = praySbs.stream().collect(Collectors.toMap(a -> a.getString("id"), b -> b.getString("sbbid")));
                    List<Long> sbbids = praySbs.stream().map(s -> s.getString("sbbid")).filter(a -> StringUtils.isNotEmpty((CharSequence)a)).map(a -> Long.valueOf(a)).collect(Collectors.toList());
                    if (EmptyCheckUtils.isNotEmpty(sbbids)) {
                        DynamicObjectCollection sbbs = PrepayDeclareQueryListPlugin.this.declareReportDao.queryDeclareReportBySbbid(sbbids);
                        Map<String, DynamicObject> riskMap = sbbs.stream().collect(Collectors.toMap(a -> a.getString("id"), b -> b, (m, n) -> n));
                        for (DynamicObject row : rows) {
                            String sbbid = idMap.get(row.getString("id"));
                            DynamicObject sbbDyo = riskMap.get(sbbid);
                            if (sbbDyo == null) {
                                row.set("declarestatus", (Object)"");
                                row.set("paystatus", (Object)"");
                                continue;
                            }
                            if (row.containsProperty(PrepayDeclareQueryListPlugin.REPLACEMENT)) {
                                String riskContent = sbbDyo.getString("riskcontent");
                                row.set(PrepayDeclareQueryListPlugin.REPLACEMENT, (Object)DeclareUtils.RISK_CONTENT_MAP.getOrDefault(riskContent, ""));
                            }
                            if (row.containsProperty("declarestatus")) {
                                row.set("declarestatus", sbbDyo.get("declarestatus"));
                            }
                            if (!row.containsProperty("paystatus")) continue;
                            row.set("paystatus", (Object)sbbDyo.getString("paystatus"));
                        }
                    }
                }
                return rows;
            }
        };
        ListUserOption user = new ListUserOption();
        user.setMaxReturnData(1000000000);
        list.setListUserOption(user);
        args.setListDataProvider((IListDataProvider)list);
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if ("skssqq".equals(columnDesc.getKey())) {
            String date = DateUtils.getStartToEndDate((Date)data.getDate("skssqq"), (Date)data.getDate("skssqz"), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            e.setFormatValue((Object)date);
        } else if (REPLACEMENT.equals(columnDesc.getKey())) {
            String riskContentNormalStr = DeclareUtils.getRiskContentNormalStr();
            if (riskContentNormalStr.equals(e.getFormatValue())) {
                e.getNoLinkKey().add(REPLACEMENT);
            }
        } else if ("declarestatus".equals(columnDesc.getKey()) || "paystatus".equals(columnDesc.getKey())) {
            ComboProp comboProp = (ComboProp)BusinessDataServiceHelper.newDynamicObject((String)"tcvat_nsrxx").getDynamicObjectType().getProperty(columnDesc.getKey());
            e.setFormatValue((Object)comboProp.getItemByName((String)data.get(columnDesc.getKey())));
        }
    }

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("id desc,entryentity.taxtypes asc");
        List qFilters = e.getQFilters();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(qFilters.size());
        ArrayList<QFilter> declareFilters = new ArrayList<QFilter>(qFilters.size());
        for (QFilter qFilter : qFilters) {
            String property = qFilter.getProperty();
            if ("declarestatus".equals(property)) {
                declareFilters.add(qFilter);
                continue;
            }
            if ("paystatus".equals(property)) {
                declareFilters.add(qFilter);
                continue;
            }
            filters.add(qFilter);
        }
        if (!declareFilters.isEmpty()) {
            DynamicObjectCollection ids = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id", (QFilter[])declareFilters.toArray(new QFilter[0]));
            if (!ids.isEmpty()) {
                filters.add(new QFilter("id", "in", ids.stream().map(i -> i.get("id")).collect(Collectors.toList())));
            } else {
                filters.add(new QFilter("id", "=", (Object)0));
            }
        }
        e.getQFilters().clear();
        e.getQFilters().addAll(filters);
        super.setFilter(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object[] primaryKeyValues;
        boolean hasEmptyCollection;
        if (args.getSource() instanceof Donothing && ((Donothing)args.getSource()).getOperateKey().equals("apply") && (hasEmptyCollection = PrepayDeclareService.hasEmptyCollection(primaryKeyValues = args.getListSelectedData().getPrimaryKeyValues()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f34\u7533\u62a5\u8868\u672a\u751f\u6210\uff0c\u8bf7\u70b9\u51fb\u5e95\u7a3f\u7684\u4e0b\u4e00\u6b65\u751f\u6210\u7533\u62a5\u8868\u540e\u518d\u8fdb\u884c\u624b\u5de5\u7533\u62a5", (String)"PrepayDeclareQueryListPlugin_21", (String)"taxc-tcvat", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult opResult = afterDoOperationEventArgs.getOperationResult();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (opResult == null) {
            return;
        }
        if (!opResult.isSuccess()) {
            String msg;
            if ("unaudit".equals(operateKey)) {
                msg = opResult.getMessage();
                if (msg != null) {
                    return;
                }
            } else if (("pay".equals(operateKey) || "apply".equals(operateKey) || "cancelapply".equals(operateKey) || "cancelpay".equals(operateKey)) && (msg = opResult.getMessage()) != null) {
                String[] messages = msg.split(SEPARATOR);
                if (messages.length == 1) {
                    this.getView().showErrorNotification(msg);
                    return;
                } else {
                    this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                    OperationResult operationResult = new OperationResult();
                    operationResult.setSuccess(false);
                    operationResult.setMessage(msg);
                    this.getView().showOperationResult(operationResult);
                }
                return;
            }
        }
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if ("export".equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            Date date;
            DynamicObject template;
            if (list == null || list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u8bb0\u5f55", (String)"PrepayDeclareQueryListPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            Set collect = Arrays.stream(list.getPrimaryKeyValues()).collect(Collectors.toSet());
            if (collect.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5bfc\u51fa\u591a\u4efd\u7533\u62a5\u8868\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u7533\u62a5\u8bb0\u5f55\u518d\u64cd\u4f5c\u5bfc\u51fa", (String)"PrepayDeclareQueryListPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            String pk = list.get(0).getPrimaryKeyValue().toString();
            DynamicObject prepayBill = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"tcvat_prepay_declare_bill");
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)prepayBill.getLong("sbbid"), (String)"tcvat_nsrxx");
            DynamicObject org = obj.getDynamicObject("org");
            String type = obj.getString("type");
            String fileName = TemplateTypeConstant.getNsrtypemap().getOrDefault(type, type) + "_";
            if (org != null) {
                fileName = fileName + org.getString("name");
                boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcvat", (String)"zerodeclare", (long)org.getLong("id"));
                if (zerodeclare) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u5f15\u51fa\u3002", (String)"PrepayDeclareQueryListPlugin_20", (String)"taxc-tcvat", (Object[])new Object[0]), org.getString("name")));
                    return;
                }
            }
            if ((template = TemplateUtilsOld.getTemplateObject((String)type, (Date)(date = (Date)obj.get("skssqq")), (Date)date)) == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u6a21\u677f\u4e0d\u5b58\u5728", (String)"PrepayDeclareQueryListPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            fileName = fileName + DateUtils.format((Date)date, (String)"yyyy-MM");
            Map valMap = TemplateShowUtils.queryData((String)type, (String)pk, (String)"_");
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", TemplateShowUtils.getDownResultExcelFile((DynamicObject)template, (Map)valMap), 5000);
            String serviceAppId = this.getView().getFormShowParameter().getServiceAppId();
            String entityNum = ((IListView)this.getView()).getBillFormId();
            PermissionUtils.putTempFilePermissionCache((String)urls, (String)serviceAppId, (String)entityNum, (String)"4730fc9f000004ae");
            this.getView().openUrl(urls);
            return;
        }
        if ("apply".equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            Object pk2;
            if (list == null || list.isEmpty()) {
                return;
            }
            List pklist = list.stream().map(ListSelectedRow::getPrimaryKeyValue).distinct().collect(Collectors.toList());
            ArrayList<DynamicObject> declareList = new ArrayList<DynamicObject>(pklist.size());
            ArrayList<DynamicObject> declareMainList = new ArrayList<DynamicObject>(pklist.size());
            for (Object pk2 : pklist) {
                DynamicObject declare2 = BusinessDataServiceHelper.loadSingle(pk2, (String)"tcvat_prepay_declare_bill");
                declare2.set("declarestatus", (Object)"declared");
                declare2.set("modifytime", (Object)new Date());
                declare2.set("modifier", (Object)RequestContext.get().getUserId());
                declare2.set("sbrq", (Object)new Date());
                declare2.set("declarer", (Object)RequestContext.get().getUserId());
                DynamicObject declareMain = BusinessDataServiceHelper.loadSingle((Object)pk2, (String)"tcvat_nsrxx");
                declareMain.set("declarestatus", (Object)"declared");
                declareMain.set("modifytime", (Object)new Date());
                BigDecimal bqybtse = declare2.getBigDecimal("bqybtse");
                if (BigDecimal.ONE.compareTo(bqybtse) >= 0) {
                    declareMain.set("paystatus", (Object)"nopay");
                } else {
                    declareMain.set("paystatus", (Object)"unpaid");
                }
                declareMain.set("billno", (Object)declare2.getString("declareserialno"));
                declareMain.set("modifier", (Object)RequestContext.get().getUserId());
                declareMain.set("taxauthority", declare2.getDynamicObject("prepayproject").getDynamicObject("taxoffice").get("id"));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{declareMain});
                PrepayDeclareService.updateVatinvoice(declare2, true);
                declareList.add(declare2);
                declareMainList.add(declareMain);
            }
            TXHandle h = TX.required();
            pk2 = null;
            try {
                try {
                    if (declareList.size() > 0) {
                        SaveServiceHelper.save((DynamicObject[])declareList.toArray(new DynamicObject[declareList.size()]));
                    }
                    if (declareMainList.size() > 0) {
                        SaveServiceHelper.save((DynamicObject[])declareMainList.toArray(new DynamicObject[declareMainList.size()]));
                    }
                    declareList.forEach(declare -> PrepayDeclareService.updateVatinvoice(declare, true));
                    List sbbIds = declareMainList.stream().filter(d -> !"nopay".equals(d.getString("paystatus"))).map(d -> d.getLong("id")).collect(Collectors.toList());
                    DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"manualDeclare", (Object[])new Object[]{sbbIds});
                }
                catch (Throwable t) {
                    h.markRollback();
                    throw t;
                }
            }
            catch (Throwable t) {
                pk2 = t;
                throw t;
            }
            finally {
                if (h != null) {
                    if (pk2 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable t) {
                            ((Throwable)pk2).addSuppressed(t);
                        }
                    } else {
                        h.close();
                    }
                }
            }
            billlist.refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7533\u62a5\u6210\u529f", (String)"PrepayDeclareQueryListPlugin_5", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("cancelapply".equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            if (list == null || list.isEmpty()) {
                return;
            }
            List<Object> ids = list.stream().map(ListSelectedRow::getPrimaryKeyValue).distinct().collect(Collectors.toList());
            boolean success = false;
            try (TXHandle h = TX.required();){
                try {
                    success = this.cancelApply(ids, "tcvat_prepay_declare_bill", true);
                    if (!success) return;
                    DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"cancelDeclare", (Object[])new Object[]{ids});
                    billlist.refresh();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u7533\u62a5\u6210\u529f", (String)"PrepayDeclareQueryListPlugin_6", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                    return;
                }
                catch (Throwable t) {
                    h.markRollback();
                    throw t;
                }
            }
        } else if (TBLNEW.equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)"tcvat_prepay_declare_home", (IFormView)this.getView(), null, (IFormPlugin)this);
            return;
        } else if ("submit".equals(afterDoOperationEventArgs.getOperateKey())) {
            PrepayDeclareService.syncBillstatus(afterDoOperationEventArgs.getOperationResult().getSuccessPkIds().toArray(), "B");
            return;
        } else if ("audit".equals(afterDoOperationEventArgs.getOperateKey())) {
            PrepayDeclareService.syncBillstatus(afterDoOperationEventArgs.getOperationResult().getSuccessPkIds().toArray(), "C");
            PrepayDeclareService.refreshElement(list);
            return;
        } else if ("unaudit".equals(afterDoOperationEventArgs.getOperateKey())) {
            List pkIds = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds();
            DynamicObjectCollection sbb = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,declarestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkIds)});
            if (sbb.isEmpty()) return;
            ArrayList<Object> ids = new ArrayList<Object>(sbb.size());
            for (DynamicObject dyo : sbb) {
                String declareStatus = dyo.getString("declareStatus");
                if ("declared".equals(declareStatus) || "declaring".equals(declareStatus) || "submitted".equals(declareStatus) || "importing".equals(declareStatus)) continue;
                ids.add(dyo.get("id"));
            }
            DynamicObject[] prepayList = BusinessDataServiceHelper.load((String)"tcvat_prepay_declare_bill", (String)"org,skssqq,skssqz,sblx,billstatus,declarestatus,paystatus", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            if (prepayList == null || prepayList.length <= 0) return;
            Arrays.stream(prepayList).forEach(e -> e.set("billstatus", (Object)"A"));
            SaveServiceHelper.save((DynamicObject[])prepayList);
            billlist.refresh();
            return;
        } else if ("unsubmit".equals(afterDoOperationEventArgs.getOperateKey())) {
            PrepayDeclareService.syncBillstatus(afterDoOperationEventArgs.getOperationResult().getSuccessPkIds().toArray(), "A");
            return;
        } else if ("pay".equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            FormShowParameter param = new FormShowParameter();
            param.setFormId("bdtaxr_paydate_confirm");
            param.getOpenStyle().setShowType(ShowType.NonModal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payDateConfirm");
            param.setCloseCallBack(closeCallBack);
            this.getView().showForm(param);
            return;
        } else {
            DynamicObject[] declareMains;
            if (!"cancelpay".equals(afterDoOperationEventArgs.getOperateKey()) || !afterDoOperationEventArgs.getOperationResult().isSuccess()) return;
            List<Object> pkIds = Arrays.asList(list.getPrimaryKeyValues());
            DynamicObject[] prepayList = BusinessDataServiceHelper.load((String)"tcvat_prepay_declare_bill", (String)"org,skssqq,skssqz,sblx,billstatus,declarestatus,paystatus,payer,paydate,modifier,modifytime,deductionperiod,sssbbid", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
            Arrays.stream(prepayList).forEach(e -> {
                e.set("paystatus", (Object)PAY_STATUS_UNPAID);
                e.set("payer", null);
                e.set("modifytime", (Object)new Date());
                e.set("paydate", null);
                e.set("modifier", (Object)RequestContext.get().getUserId());
            });
            for (DynamicObject declareMain : declareMains = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcvat_nsrxx"))) {
                declareMain.set("modifytime", (Object)new Date());
                declareMain.set("paystatus", (Object)"unpaid");
                declareMain.set("payer", null);
                declareMain.set("modifier", (Object)RequestContext.get().getUserId());
            }
            SaveServiceHelper.save((DynamicObject[])declareMains);
            SaveServiceHelper.save((DynamicObject[])prepayList);
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"cancelPay", (Object[])new Object[]{pkIds});
            billlist.refresh();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("payDateConfirm")) {
            Date payDate = (Date)closedCallBackEvent.getReturnData();
            if (payDate == null) {
                return;
            }
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection list = billList.getSelectedRows();
            List<Object> pkIds = Arrays.asList(list.getPrimaryKeyValues());
            this.pay(billList, pkIds, payDate);
        }
    }

    private void pay(BillList billlist, List<Object> pkIds, Date payDate) {
        DynamicObject[] prepayList = BusinessDataServiceHelper.load((String)"tcvat_prepay_declare_bill", (String)"org,skssqq,skssqz,sblx,billstatus,declarestatus,paystatus,payer,paydate,modifytime,modifier", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
        Arrays.stream(prepayList).forEach(e -> {
            e.set("paystatus", (Object)PAY_STATUS_PAID);
            e.set("payer", (Object)RequestContext.get().getUserId());
            e.set("paydate", (Object)payDate);
            e.set("modifytime", (Object)new Date());
            e.set("modifier", (Object)RequestContext.get().getUserId());
        });
        DynamicObject[] declareMains = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcvat_nsrxx"));
        if (prepayList != null && prepayList.length > 0) {
            for (DynamicObject declareMain : declareMains) {
                declareMain.set("paystatus", (Object)"paid");
                declareMain.set("modifytime", (Object)new Date());
                declareMain.set("modifier", (Object)RequestContext.get().getUserId());
                declareMain.set("paytype", (Object)PAY_STATUS_UNPAID);
                declareMain.set("paydate", (Object)payDate);
                declareMain.set("payer", (Object)RequestContext.get().getUserId());
            }
            SaveServiceHelper.save((DynamicObject[])prepayList);
            SaveServiceHelper.save((DynamicObject[])declareMains);
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"manualPay", (Object[])new Object[]{pkIds});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u624b\u5de5\u7f34\u6b3e\u6210\u529f", (String)"PrepayDeclareQueryListPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]));
            billlist.refresh();
        }
    }

    private boolean cancelApply(List<Object> ids, String entryName, boolean needMessage) {
        DynamicObject[] prepayDynamicObjects = BusinessDataServiceHelper.load((Object[])ids.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entryName));
        ArrayList<DynamicObject> prepayUpdateList = new ArrayList<DynamicObject>(ids.size());
        for (DynamicObject dyo : prepayDynamicObjects) {
            dyo.set("modifytime", (Object)new Date());
            dyo.set("modifier", (Object)RequestContext.get().getUserId());
            dyo.set("declarestatus", (Object)"editing");
            dyo.set("sbrq", null);
            dyo.set("declarer", (Object)0L);
            prepayUpdateList.add(dyo);
            if (!entryName.equals("tcvat_prepay_declare_bill")) continue;
            PrepayDeclareService.updateVatinvoice(dyo, false);
        }
        if (!CollectionUtils.isEmpty(prepayUpdateList)) {
            SaveServiceHelper.save((DynamicObject[])prepayUpdateList.toArray(new DynamicObject[prepayUpdateList.size()]));
        }
        return true;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        if (currentSelectedRowInfo == null) {
            return;
        }
        if (REPLACEMENT.equals(args.getFieldName())) {
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"tcvat_prepay_declare_bill");
            DeclareUtils.showRiskDialog((String)object.getString("sbbid"), (IFormView)this.getView());
        } else {
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"tcvat_prepay_declare_bill");
            String type = "zzsyjskb";
            FormShowParameter param = new FormShowParameter();
            HashMap<String, Object> customParams = new HashMap<String, Object>(4);
            customParams.put("datasource", "hyperlink");
            customParams.put(ORGID_KEY, object.getDynamicObject("accountorg").getString("id"));
            customParams.put("taxorg", object.getDynamicObject("org").getString("id"));
            customParams.put("sblx", "2");
            customParams.put(ORGNAME_KEY, object.getDynamicObject("accountorg").getString("name"));
            customParams.put("declareserialno", object.getString("declareserialno"));
            customParams.put("projectid", object.getDynamicObject("prepayproject").getString("id"));
            Date skssqq = object.getDate("skssqq");
            Date skssqz = object.getDate("skssqz");
            customParams.put("templatetype", type);
            String startDate = DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd");
            customParams.put("skssqq", startDate);
            customParams.put("skssqz", DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
            customParams.put("readonly", Boolean.TRUE);
            DynamicObject application = this.prepayApplicationDao.queryOneIdByDeclarenumber(object.getString("declareserialno"));
            customParams.put("applyid", ObjectUtils.isNotEmpty((Object)application) ? application.getString("id") : application);
            String declarestatus = object.getString("declarestatus");
            String dataType = PAY_STATUS_PAID;
            String accountOrgId = object.getDynamicObject("accountorg").getString("id");
            String taxOrgId = object.getDynamicObject("org").getString("id");
            if (accountOrgId.equals(taxOrgId)) {
                DynamicObjectCollection org = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"id", (Object)taxOrgId));
                if (OrgCheckUtil.orgAuth((String)taxOrgId, (IFormView)this.getView(), (DynamicObjectCollection)org) || OrgCheckUtil.orgEnable((IFormView)this.getView(), (DynamicObjectCollection)org, (boolean)true)) {
                    return;
                }
            }
            if (LicenseCheckServiceHelper.check((Object)taxOrgId, (IFormView)this.getView(), (String)"tcvat")) {
                return;
            }
            if (!PrepayDeclareService.checkCard(taxOrgId, this.getView(), this.getPageCache()).booleanValue()) {
                return;
            }
            this.showDeclarePageByTaxType(StringUtils.trimToEmpty((String)type), param, customParams, declarestatus, dataType);
        }
    }

    private void showDeclarePageByTaxType(String type, FormShowParameter param, Map<String, Object> customParams, String declarestatus, String dataType) {
        if (type.startsWith("zzs")) {
            if (StringUtils.equals((CharSequence)"declared", (CharSequence)declarestatus)) {
                param.setFormId("tcvat_prepay_declare_show");
            } else {
                param.setFormId("tcvat_prepay_declare_home");
            }
        } else if (StringUtils.equals((CharSequence)"declared", (CharSequence)declarestatus)) {
            param.setCaption((String)TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getDeclaredDatdCn());
            param.setFormId("bdtaxr_declare_old");
        } else {
            param.setFormId("bdtaxr_declare_edit");
            param.setCaption((String)TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getTaxDeclareCn());
            customParams.put("type", type);
        }
        if (StringUtils.equals((CharSequence)"2", (CharSequence)dataType) && !StringUtils.equals((CharSequence)"declared", (CharSequence)declarestatus) && !StringUtils.equals((CharSequence)"qysdsnb", (CharSequence)type)) {
            customParams.put("type", type);
            param.setFormId("bdtaxr_declare_edit");
            customParams.put("refresh", Boolean.FALSE);
            customParams.put("license", Boolean.FALSE);
            param.setCaption((String)TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getDeclaredEditingCn());
        }
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }
}

