/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.prepay.rule;

import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcvat.business.service.prepay.PrepayRuleService;
import kd.taxc.tcvat.common.util.TcvatCommonUtil;
import org.apache.commons.lang3.StringUtils;

public class PrepayRulePlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String RULE_TYPE_CODE = "RULE-VAT-PREPAY-0002";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u9884\u7f34\u9879\u76ee\u89c4\u5219\u914d\u7f6e", (String)"PrepayRulePlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
    }

    public void initialize() {
        super.initialize();
        BasedataEdit prepayproject = (BasedataEdit)this.getControl("prepayproject");
        prepayproject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit deductionamountfield = (BasedataEdit)this.getControl("deductionamountfield");
        deductionamountfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit tablefield = (BasedataEdit)this.getControl("deductiontable");
        tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object createorg = customParams.get("createorg");
        if (null != createorg) {
            this.getModel().setValue("org", createorg);
            customParams.remove("createorg");
            customParams.remove("orgid");
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObject projectObject;
        super.afterBindData(e);
        String number = (String)this.getModel().getValue("number");
        String ruletype = (String)this.getView().getFormShowParameter().getCustomParam("ruletype");
        if (StringUtils.isNotEmpty((CharSequence)ruletype) && StringUtils.isEmpty((CharSequence)number)) {
            this.getModel().setValue("ruletype", (Object)ruletype);
            String billno = TcvatCommonUtil.getBillno("tcvat_rule_prepay");
            this.getModel().setValue("number", (Object)billno);
        }
        if (null != (projectObject = (DynamicObject)this.getModel().getValue("prepayproject"))) {
            if ("VAT_YJXMLX_003".equals(projectObject.getString("prepaytype")) || "VAT_YJXMLX_005".equals(projectObject.getString("prepaytype"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"deduction"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"deduction"});
            }
        }
        FieldEdit control = (FieldEdit)this.getControl("taxrate");
        control.setMustInput(PrepayRuleService.mustInput(this.getModel()));
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter formShowParameter;
        String name = evt.getProperty().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (null == org) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"IncomeRulePlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (null != org && "prepayproject".equals(name)) {
            formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u9884\u7f34\u9879\u76ee\u4fe1\u606f", (String)"PrepayRulePlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            formShowParameter.getListFilterParameter().setFilter(new QFilter("org", "=", (Object)org.getLong("id")));
            formShowParameter.getListFilterParameter().setFilter(new QFilter("projectstatus", "!=", (Object)"close"));
        }
        if ("deductionamountfield".equals(name)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("deductionentry");
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("deductiontable", rowIndex);
            if (tabletype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"PrepayRulePlugin_1", (String)"taxc-tctb-common", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter id = new QFilter("tableid", "=", tabletype.get("id"));
            ListShowParameter formShowParameter2 = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter2.getListFilterParameter().setFilter(id);
        }
        if (evt.getProperty().getName().equals("deductiontable")) {
            formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            if (org != null) {
                formShowParameter.setUseOrgId(org.getLong("id"));
            }
            QFilter filter = new QFilter("basedataid.billno", "=", (Object)RULE_TYPE_CODE);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_datasource_pkrules", (String)"id", (QFilter[])new QFilter[]{filter});
            formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", collection.stream().map(e -> e.getLong("id")).collect(Collectors.toList())));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing && "deductionsetting".equals(((Donothing)args.getSource()).getOperateKey())) {
            EntryGrid entryentity = (EntryGrid)this.getControl("deductionentry");
            int focusRow = entryentity.getEntryState().getFocusRow();
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("deductiontable", focusRow);
            if (tabletype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"PrepayRulePlugin_1", (String)"taxc-tctb-common", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.openSettingPage(focusRow, tabletype.getLong("id"), tabletype.getString("name"), "deductionentry", "deductionconditionjson", "decuctionsetting");
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map filterData;
        if ("decuctionsetting".equals(evt.getActionId()) && (filterData = (Map)evt.getReturnData()) != null) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex("deductionentry");
            this.getModel().setValue("deductionfiltercondition", filterData.get("filterdescription"), currentRowIndex);
            this.getModel().setValue("deductionconditionjson", filterData.get("filtervalue"), currentRowIndex);
        }
    }

    protected void openSettingPage(int rowIndex, long entityId, String filterpage, String entityfield, String conditionjson, String actionId) {
        DynamicObject selectedRow = this.getModel().getEntryRowEntity(entityfield, rowIndex);
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("bdtaxr_filtercondition");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCustomParam("entityId", (Object)entityId);
        formshowParameter.setCustomParam("entityNumber", (Object)filterpage);
        formshowParameter.setCustomParam("filterJson", selectedRow.get(conditionjson));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        formshowParameter.setCustomParam("ruletype", (Object)"private");
        if (org != null) {
            formshowParameter.setCustomParam("orgid", (Object)org.getString("id"));
        }
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String eventName = e.getProperty().getName();
        if (e.getProperty().getName().equals("deductiontable")) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("deductionentry");
            this.getModel().setValue("deductionamountfield", null, rowIndex);
            this.getModel().setValue("deductionfiltercondition", null, rowIndex);
            this.getModel().setValue("deductionconditionjson", null, rowIndex);
            this.getModel().setValue("deductionabsolute", (Object)Boolean.FALSE, rowIndex);
        } else if ("deductionamountfield".equals(eventName)) {
            DynamicObject changeAmount = (DynamicObject)e.getChangeSet()[0].getNewValue();
            int rowIndex = this.getModel().getEntryCurrentRowIndex("deductionentry");
            if (changeAmount == null) {
                return;
            }
            String amountValue = changeAmount.getString("fieldname");
            String table = changeAmount.getString("fieldsubname");
            if ("tdm_balance_new".equals(table) && Lists.newArrayList((Object[])new String[]{"closinglocalcurrency", "openinglocalcurrency"}).contains(amountValue)) {
                this.getModel().setValue("deductionabsolute", (Object)Boolean.TRUE, rowIndex);
            } else {
                this.getModel().setValue("deductionabsolute", (Object)Boolean.FALSE, rowIndex);
            }
        }
        if (eventName.equals("prepayproject")) {
            DynamicObject projectInfo = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (projectInfo != null && ("VAT_YJXMLX_003".equals(projectInfo.getString("prepaytype")) || "VAT_YJXMLX_005".equals(projectInfo.getString("prepaytype")))) {
                this.getModel().deleteEntryData("deductionentry");
                this.getView().setVisible(Boolean.FALSE, new String[]{"deduction"});
                this.getModel().getEntryEntity("deductionentry").clear();
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"deduction"});
            }
        }
        if (eventName.equals("datatype") || eventName.equals("deductiondatatype")) {
            FieldEdit control = (FieldEdit)this.getControl("taxrate");
            control.setMustInput(PrepayRuleService.mustInput(this.getModel()));
        }
        if ("org".equals(eventName)) {
            this.getModel().setValue("prepayproject", null);
        }
    }
}

