/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rollout.register;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class InputRolloutDetailListPlugin
extends AbstractFormPlugin {
    public static final String ENTITY_NAME = "tcvat_rollout_register";
    public static final String ENTITY_NAME_ALL_FIELDS = "id,taxperiod,avaliabletaxamount,registeredtaxamount,currentregistertaxamount,registerrule,rolloutrate,consumertype,remark,invoicepkid,creator,createtime,modifier,modifytime,registercoid,registerstatus,registertype,effectivetaxamount,rollouttype,invoiceregistertype,invoicecode,invoiceno,invoicetype,projectincome,incomesummary,apportionrate,apportiontaxamount,apportionstatus,apportiontype,apportioncreatetime,apportionmodifytime,rolloutperiod,rollouttaxperiod,apportionremark,summaryflag,registercoshareid,org,baseinvoicetype,rollouttaxamount,billno,billstatus,isvoucher";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        String source = (String)showParameter.getCustomParam("source");
        if ("undoregister".equals(source)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u53d6\u6d88\u767b\u8bb0", (String)"InputRolloutDetailListPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else if ("rolloutregisterdetail".equals(source)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u767b\u8bb0\u660e\u7ec6", (String)"InputRolloutDetailListPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    public void initialize() {
        BillList billlist = (BillList)this.getControl("billlistap");
        List invoicepkid = (List)this.getView().getFormShowParameter().getCustomParam("invoicePkIdList");
        String source = (String)this.getView().getFormShowParameter().getCustomParam("source");
        if (StringUtils.isBlank((CharSequence)source) || "rolloutregisterdetail".equals(source)) {
            QFilter qFilter = new QFilter("invoicepkid", "in", (Object)invoicepkid);
            QFilter signstatus = new QFilter("summaryflag", "=", (Object)"1");
            billlist.setFilter(qFilter.and(signstatus));
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnok"});
        } else {
            QFilter qFilter = new QFilter("id", "in", (Object)invoicepkid.stream().map(Long::parseLong).toArray());
            QFilter signtype1 = new QFilter("registertype", "=", (Object)"1");
            QFilter signstatus1 = new QFilter("registerstatus", "=", (Object)"1");
            QFilter signstatus = new QFilter("summaryflag", "=", (Object)"1");
            billlist.setFilter(qFilter.and(signtype1).and(signstatus1).and(signstatus));
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection list = billlist.getSelectedRows();
            if (list == null || list.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u53d6\u6d88\u767b\u8bb0\u7684\u8bb0\u5f55", (String)"InputRolloutDetailListPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            List<Object> ids = list.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            this.submitUodoRegisterClick(ids);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("undoregister".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            String customVaule = messageBoxClosedEvent.getCustomVaule();
            Map customMap = (Map)SerializationUtils.fromJsonString((String)customVaule, Map.class);
            this.submitUodoRegisterClick((List)customMap.get("ids"));
        }
    }

    private void submitUodoRegisterClick(List<Object> idList) {
        MainEntityType detailEntityType = EntityMetadataCache.getDataEntityType((String)ENTITY_NAME);
        QFilter idFilter = new QFilter("id", "in", idList);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)ENTITY_NAME_ALL_FIELDS, (QFilter[])new QFilter[]{idFilter});
        OperationResult operationResult = null;
        int isvoucherCount = 0;
        if (dynamicObjects.length > 0) {
            DynamicObject[] invoiceTypeDynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("issystem", "=", (Object)"1")});
            Map<String, String> invoiceTypeMap = Arrays.stream(invoiceTypeDynamicObjects).collect(Collectors.toMap(o -> o.getString("id"), o -> o.getString("number")));
            ArrayList<DynamicObject> insertDynamicObjects = new ArrayList<DynamicObject>(dynamicObjects.length);
            ArrayList<String> signList = new ArrayList<String>(8);
            for (DynamicObject obj : dynamicObjects) {
                if (obj.getBoolean("isvoucher")) {
                    ++isvoucherCount;
                    continue;
                }
                obj.set("registerstatus", (Object)"2");
                obj.set("modifytime", (Object)new Date());
                obj.set("modifier", (Object)RequestContext.get().getUserId());
                signList.add(obj.getString("id"));
                DynamicObject dObj = new DynamicObject((DynamicObjectType)detailEntityType);
                dObj.set("org", obj.get("org"));
                dObj.set("taxperiod", obj.get("taxperiod"));
                dObj.set("rollouttaxperiod", obj.get("rollouttaxperiod"));
                dObj.set("rolloutperiod", obj.get("rolloutperiod"));
                dObj.set("avaliabletaxamount", obj.get("avaliabletaxamount"));
                dObj.set("registeredtaxamount", obj.get("registeredtaxamount"));
                dObj.set("consumertype", obj.get("consumertype"));
                dObj.set("rollouttype", obj.get("rollouttype"));
                dObj.set("remark", obj.get("remark"));
                dObj.set("invoicepkid", obj.get("invoicepkid"));
                dObj.set("rolloutrate", obj.get("rolloutrate"));
                dObj.set("effectivetaxamount", obj.get("effectivetaxamount"));
                dObj.set("registerrule", obj.get("registerrule"));
                dObj.set("createtime", (Object)new Date());
                dObj.set("creator", (Object)RequestContext.get().getUserId());
                dObj.set("modifytime", (Object)new Date());
                dObj.set("modifier", (Object)RequestContext.get().getUserId());
                dObj.set("registercoid", obj.get("id"));
                dObj.set("currentregistertaxamount", (Object)obj.getBigDecimal("currentregistertaxamount").multiply(new BigDecimal(-1)));
                dObj.set("registertype", (Object)"2");
                dObj.set("registerstatus", (Object)"1");
                dObj.set("summaryflag", obj.get("summaryflag"));
                dObj.set("invoicecode", obj.get("invoicecode"));
                dObj.set("invoiceno", obj.get("invoiceno"));
                dObj.set("invoicetype", (Object)invoiceTypeMap.get(obj.getString("baseinvoicetype")));
                dObj.set("baseinvoicetype", obj.get("baseinvoicetype"));
                dObj.set("invoiceregistertype", obj.get("invoiceregistertype"));
                insertDynamicObjects.add(dObj);
            }
            operationResult = OperationServiceHelper.executeOperate((String)"save", (String)ENTITY_NAME, (DynamicObject[])dynamicObjects, (OperateOption)OperateOption.create());
            operationResult = OperationServiceHelper.executeOperate((String)"save", (String)ENTITY_NAME, (DynamicObject[])insertDynamicObjects.toArray(new DynamicObject[insertDynamicObjects.size()]), (OperateOption)OperateOption.create());
            DynamicObject[] apportionDynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"id,apportiontaxamount,registerstatus,registertype,apportionstatus,apportionmodifytime,modifier", (QFilter[])new QFilter[]{new QFilter("registercoshareid", "in", signList)});
            if (apportionDynamicObjects.length > 0) {
                for (DynamicObject dyo : apportionDynamicObjects) {
                    dyo.set("registerstatus", (Object)"2");
                    dyo.set("registertype", (Object)"2");
                    dyo.set("apportionstatus", (Object)"2");
                    dyo.set("apportionmodifytime", (Object)new Date());
                    dyo.set("modifier", (Object)RequestContext.get().getUserId());
                    dyo.set("apportiontaxamount", (Object)dyo.getBigDecimal("apportiontaxamount").multiply(new BigDecimal(-1)));
                }
            }
            DynamicObject[] signDynamicObjects = BusinessDataServiceHelper.load((String)"tcvat_input_invoice_sign", (String)"id,taxperiod,avaliabletaxamount,signedtaxamount,currentsigntaxamount,invoicetype,signrule,consumertype,remark,invoicepkid,signrate,createtime,modifytime,modifier,creator,signcoid,signstatus,invoicecode,invoiceno,taxamount,effectivetaxamount,signtype,type,refundabletaxamount,undistinguishtaxamount,rolloutid,rollouttaxamount,rollouttype,org,baseinvoicetype,deductperiod", (QFilter[])new QFilter[]{new QFilter("rolloutid", "in", signList), new QFilter("signstatus", "=", (Object)"1").and(new QFilter("signtype", "=", (Object)"3")).and(new QFilter("type", "=", (Object)"1"))});
            ArrayList<DynamicObject> updateUndoSignDynamicObjects = new ArrayList<DynamicObject>(dynamicObjects.length);
            if (signDynamicObjects.length > 0) {
                for (DynamicObject obj : signDynamicObjects) {
                    obj.set("signstatus", (Object)"2");
                    obj.set("modifytime", (Object)new Date());
                    obj.set("modifier", (Object)RequestContext.get().getUserId());
                    DynamicObject dObj = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_input_invoice_sign");
                    dObj.set("org", obj.get("org"));
                    dObj.set("taxperiod", obj.get("taxperiod"));
                    dObj.set("avaliabletaxamount", obj.get("avaliabletaxamount"));
                    dObj.set("signedtaxamount", obj.get("signedtaxamount"));
                    dObj.set("invoicetype", (Object)invoiceTypeMap.get(obj.getString("baseinvoicetype")));
                    dObj.set("baseinvoicetype", obj.get("baseinvoicetype"));
                    dObj.set("consumertype", obj.get("consumertype"));
                    dObj.set("remark", obj.get("remark"));
                    dObj.set("invoicepkid", obj.get("invoicepkid"));
                    dObj.set("signrate", obj.get("signrate"));
                    dObj.set("invoicecode", obj.get("invoicecode"));
                    dObj.set("invoiceno", obj.get("invoiceno"));
                    dObj.set("taxamount", obj.get("taxamount"));
                    dObj.set("effectivetaxamount", obj.get("effectivetaxamount"));
                    dObj.set("signrule", obj.get("signrule"));
                    dObj.set("createtime", (Object)new Date());
                    dObj.set("creator", (Object)RequestContext.get().getUserId());
                    dObj.set("modifytime", (Object)new Date());
                    dObj.set("modifier", (Object)RequestContext.get().getUserId());
                    dObj.set("signcoid", obj.get("id"));
                    dObj.set("currentsigntaxamount", (Object)obj.getBigDecimal("currentsigntaxamount").multiply(new BigDecimal(-1)));
                    dObj.set("signtype", (Object)"2");
                    dObj.set("signstatus", (Object)"1");
                    dObj.set("rolloutid", obj.get("rolloutid"));
                    dObj.set("type", obj.get("type"));
                    dObj.set("rollouttype", (Object)obj.getString("rollouttype"));
                    updateUndoSignDynamicObjects.add(dObj);
                }
            }
            try (TXHandle h = TX.required();){
                try {
                    if (apportionDynamicObjects.length > 0) {
                        SaveServiceHelper.save((DynamicObject[])apportionDynamicObjects);
                    }
                    if (signDynamicObjects.length > 0) {
                        SaveServiceHelper.save((DynamicObject[])signDynamicObjects);
                        SaveServiceHelper.save((DynamicObject[])updateUndoSignDynamicObjects.toArray(new DynamicObject[updateUndoSignDynamicObjects.size()]));
                    }
                }
                catch (Throwable t) {
                    h.markRollback();
                    throw t;
                }
            }
        }
        if (null != operationResult && operationResult.isSuccess()) {
            if (isvoucherCount > 0) {
                this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u751f\u6210\u4e0b\u63a8\u51ed\u8bc1\u7684\u6570\u636e, \u4e0d\u5141\u8bb8\u53d8\u66f4\u64cd\u4f5c", (String)"InputRolloutDetailListPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]));
            } else {
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"InputRolloutDetailListPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
            this.getView().close();
        } else {
            this.getView().showOperationResult(operationResult);
        }
    }
}

