/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rollout.register;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcvat.business.service.identification.InputRolloutService;

public class InputRolloutRegisterDialogPlugin
extends AbstractFormPlugin {
    private static final String SIGN_THREE_KEY = "sign3";
    private static final String SIGN_RATE_KEY = "signrate";
    private static final String TAXPERIOD = "taxperiod";
    private static final String ROLLOUT_TAXPERIOD = "rollouttaxperiod";
    private static final String BTN_OK = "btnok";
    private static final String CURRENT_AMOUNT = "currentsigntaxamount";
    private static final String EFFECTIVE_AMOUNT = "effectivetaxamount";
    private static final String SIGN_RULE_RADIO_GROUP_KEY = "ruleradio";
    private static final String CONSUMER_RADIO_GROUP_KEY = "consumerradiogroup";
    private static final String CONSUMER_TYPE = "consumertype";
    private static final String RULE_1 = "1";
    private static final String RULE_2 = "2";
    private static final String RULE_3 = "3";
    private static final String AVALIABLE_AMOUNT = "avaliabletaxamount";
    private static final String SIGNED_AMOUNT = "signedtaxamount";
    private static final String ENTITY_NAME = "tcvat_rollout_register";
    private static final String CACHE_KEY = "input_sign";
    private static final String INVOICE_NO = "invoiceno";
    private static final String INVOICE_ID = "invoicepkid";
    private static final String INVOICE_CODE = "invoicecode";
    private static final String ORG_ID = "org";
    private static final String INVOICE_TYPE = "invoicetype";
    private static final String BASE_INVOICETYPE = "baseinvoicetype";
    private static final String BILL_NO = "billno";
    private static final String BILL_STATUS = "billstatus";
    private static final String IS_VOUCHER = "isvoucher";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"radiofield"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"radiofield1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"radiofield2"});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        for (Map.Entry entry : customParams.entrySet()) {
            String key = (String)entry.getKey();
            if ("rowSize".equals(key) || "valueMap".equals(key)) continue;
            Object value = entry.getValue();
            this.getModel().setValue(key, value);
        }
        this.getModel().setValue(ROLLOUT_TAXPERIOD, (Object)DateUtils.addMonth((Date)new Date(), (int)-1));
        this.getView().setEnable(Boolean.FALSE, new String[]{CURRENT_AMOUNT});
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String radioKey = (String)model.getValue(SIGN_RULE_RADIO_GROUP_KEY);
        BigDecimal percent = (BigDecimal)model.getValue(SIGN_RATE_KEY);
        this.initForRadio(model, view, radioKey, percent);
        this.getPageCache().put("input_signrowSize", String.valueOf(customParams.get("rowSize")));
        this.getPageCache().put("input_signvalueMap", (String)customParams.get("valueMap"));
        customParams.remove("rowSize");
        customParams.remove("valueMap");
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (BTN_OK.equals(control.getKey())) {
            this.submitClick();
        }
    }

    private void submitClick() {
        if (StringUtils.isBlank((Object)this.getModel().getValue(ROLLOUT_TAXPERIOD))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8f6c\u51fa\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"InputRolloutRegisterDialogPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((Object)this.getModel().getValue(CONSUMER_TYPE))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fdb\u9879\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a", (String)"InputRolloutRegisterDialogPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.equals((CharSequence)"7", (CharSequence)((String)this.getModel().getValue(CONSUMER_TYPE))) && StringUtils.isBlank((Object)this.getModel().getValue(CONSUMER_RADIO_GROUP_KEY))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u8fdb\u9879\u7528\u9014\u662f\u65e0\u6cd5\u5212\u5206\u65f6\u4e0b\u62c9\u9009\u9879\u4e0d\u80fd\u4e3a\u7a7a", (String)"InputRolloutRegisterDialogPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        String radiogroupfield = (String)this.getModel().getValue(SIGN_RULE_RADIO_GROUP_KEY);
        BigDecimal percent = (BigDecimal)this.getModel().getValue(SIGN_RATE_KEY);
        if (RULE_2.equals(radiogroupfield) && (percent == null || BigDecimal.ZERO.compareTo(percent) == 0)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u767b\u8bb0\u6bd4\u4f8b", (String)"InputRolloutRegisterDialogPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        BigDecimal avaliabletaxamount = (BigDecimal)this.getModel().getValue(AVALIABLE_AMOUNT);
        if (avaliabletaxamount.compareTo(BigDecimal.ZERO) == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u9009\u6570\u636e\u53ef\u767b\u8bb0\u91d1\u989d\u4e3a0\uff0c\u4e0d\u80fd\u6807\u8bc6", (String)"InputRolloutRegisterDialogPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        BigDecimal currentsigntaxamount = (BigDecimal)this.getModel().getValue(CURRENT_AMOUNT);
        if (currentsigntaxamount.compareTo(BigDecimal.ZERO) <= 0 || currentsigntaxamount.compareTo(avaliabletaxamount) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u6b21\u767b\u8bb0\u7a0e\u989d\u5e94\u5927\u4e8e0\u5e76\u4e14\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u53ef\u767b\u8bb0\u7a0e\u989d", (String)"InputRolloutRegisterDialogPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        if (this.save(this.getPageCache())) {
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String radiogroupfield;
        String name = e.getProperty().getName();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (SIGN_RULE_RADIO_GROUP_KEY.equals(name) || SIGN_RATE_KEY.equals(name)) {
            radiogroupfield = (String)model.getValue(SIGN_RULE_RADIO_GROUP_KEY);
            BigDecimal percent = (BigDecimal)model.getValue(SIGN_RATE_KEY);
            this.initForRadio(model, view, radiogroupfield, percent);
        }
        if (CONSUMER_TYPE.equals(name)) {
            radiogroupfield = (String)model.getValue(CONSUMER_TYPE);
            if ("7".equals(radiogroupfield)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"radiofield"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"radiofield1"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"radiofield2"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"radiofield"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"radiofield1"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"radiofield2"});
            }
        }
    }

    private void initForRadio(IDataModel model, IFormView view, String radioKey, BigDecimal percent) {
        BigDecimal param = (BigDecimal)model.getValue(AVALIABLE_AMOUNT);
        Integer count = (Integer)this.getView().getFormShowParameter().getCustomParams().get("rowSize");
        if (null == count) {
            count = 1;
        }
        if (count > 1) {
            view.setEnable(Boolean.FALSE, new String[]{SIGN_THREE_KEY});
        }
        if (RULE_1.equals(radioKey)) {
            model.setValue(CURRENT_AMOUNT, (Object)param);
            view.setEnable(Boolean.FALSE, new String[]{CURRENT_AMOUNT});
            view.setEnable(Boolean.FALSE, new String[]{SIGN_RATE_KEY});
        } else if (RULE_2.equals(radioKey)) {
            BigDecimal val = percent.multiply(param).divide(new BigDecimal("100"));
            model.setValue(CURRENT_AMOUNT, (Object)val);
            view.setEnable(Boolean.FALSE, new String[]{CURRENT_AMOUNT});
            view.setEnable(Boolean.TRUE, new String[]{SIGN_RATE_KEY});
        } else if (RULE_3.equals(radioKey)) {
            model.setValue(CURRENT_AMOUNT, (Object)"");
            model.setValue(SIGN_RATE_KEY, (Object)"");
            view.setEnable(Boolean.TRUE, new String[]{CURRENT_AMOUNT});
            view.setEnable(Boolean.FALSE, new String[]{SIGN_RATE_KEY});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean save(IPageCache pageCache) {
        String valueString = pageCache.get("input_signvalueMap");
        if (StringUtils.isNotBlank((CharSequence)valueString)) {
            JSONArray jsonArray = JSON.parseArray((String)valueString);
            MainEntityType detailEntityType = EntityMetadataCache.getDataEntityType((String)ENTITY_NAME);
            ArrayList<DynamicObject> detailList = new ArrayList<DynamicObject>();
            String radiogroupfield = (String)this.getModel().getValue(SIGN_RULE_RADIO_GROUP_KEY);
            BigDecimal percent = (BigDecimal)this.getModel().getValue(SIGN_RATE_KEY);
            String consumerType = (String)this.getModel().getValue(CONSUMER_TYPE);
            Object consumerTypeField = this.getModel().getValue(CONSUMER_RADIO_GROUP_KEY);
            Date rolloutTaxPeriodDate = (Date)this.getModel().getValue(ROLLOUT_TAXPERIOD);
            String rolloutTaxPeriod = DateUtils.format((Date)rolloutTaxPeriodDate, (String)"yyyy-MM");
            String rolloutType = InputRolloutService.convertConsumerTypeToRolloutType(consumerType, consumerTypeField);
            HashMap<String, String> invoiceRegisterMap = new HashMap<String, String>(16);
            RequestContext context = RequestContext.get();
            ArrayList<DynamicObject> detailPrepareApportionList = new ArrayList<DynamicObject>();
            DynamicObject[] invoiceTypeDynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("issystem", "=", (Object)RULE_1)});
            Map<String, String> invoiceTypeMap = Arrays.stream(invoiceTypeDynamicObjects).collect(Collectors.toMap(o -> o.getString("number"), o -> o.getString("id")));
            try {
                for (int i = 0; i < jsonArray.size(); ++i) {
                    BigDecimal currentSignTaxamount;
                    JSONObject invoice = jsonArray.getJSONObject(i);
                    DynamicObject detail = new DynamicObject((DynamicObjectType)detailEntityType);
                    String orgId = invoice.getString(ORG_ID);
                    Long id = DBUtils.getLongId((String)ENTITY_NAME);
                    detail.set("id", (Object)id);
                    detail.set(BILL_NO, (Object)id);
                    detail.set(BILL_STATUS, (Object)"C");
                    detail.set(IS_VOUCHER, (Object)Boolean.FALSE);
                    detail.set(ORG_ID, (Object)invoice.getString(ORG_ID));
                    String string = DateUtils.getFirstDateOfMonthStr((Date)rolloutTaxPeriodDate, (String)"yyyy-MM-dd");
                    String endDate = DateUtils.getLastDateOfMonthStr((Date)rolloutTaxPeriodDate, (String)"yyyy-MM-dd");
                    QFilter orgidFilter = new QFilter(ORG_ID, "=", (Object)Long.parseLong(orgId));
                    QFilter typeFilter = new QFilter("type", "=", (Object)"zzsybnsr");
                    QFilter startDateFilter = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)string));
                    QFilter endDateFilter = new QFilter("skssqz", "<=", (Object)DateUtils.stringToDate((String)endDate));
                    QFilter declareStatus = new QFilter("declarestatus", "=", (Object)"declared");
                    DynamicObjectCollection collection = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"declarestatus,org,id", (QFilter[])new QFilter[]{orgidFilter, typeFilter, startDateFilter, endDateFilter, declareStatus});
                    if (collection.size() > 0) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u8f6c\u51fa\u6240\u5c5e\u671f\u7684\u589e\u503c\u7a0e\u5df2\u7533\u62a5\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u8fdb\u9879\u767b\u8bb0", (String)"InputRolloutRegisterDialogPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
                        boolean bl = false;
                        return bl;
                    }
                    detail.set(TAXPERIOD, (Object)invoice.getString(TAXPERIOD));
                    detail.set(INVOICE_ID, (Object)invoice.getString(INVOICE_ID));
                    detail.set(INVOICE_TYPE, (Object)invoice.getString(INVOICE_TYPE));
                    detail.set(BASE_INVOICETYPE, (Object)invoiceTypeMap.get(invoice.getString(INVOICE_TYPE)));
                    detail.set(INVOICE_CODE, (Object)invoice.getString(INVOICE_CODE));
                    detail.set(INVOICE_NO, (Object)invoice.getString(INVOICE_NO));
                    BigDecimal effectiveTaxAmount = BigDecimalUtil.setScale((Object)invoice.getString(EFFECTIVE_AMOUNT));
                    BigDecimal signedTaxAmount = BigDecimalUtil.setScale((Object)invoice.getString(SIGNED_AMOUNT));
                    BigDecimal avaliableTaxAmount = BigDecimalUtil.setScale((Object)invoice.getString(AVALIABLE_AMOUNT));
                    if (BigDecimal.ZERO.compareTo(avaliableTaxAmount) >= 0) continue;
                    if (RULE_1.equals(radiogroupfield)) {
                        currentSignTaxamount = avaliableTaxAmount;
                        signedTaxAmount = avaliableTaxAmount;
                        avaliableTaxAmount = BigDecimal.ZERO;
                    } else if (RULE_2.equals(radiogroupfield)) {
                        currentSignTaxamount = avaliableTaxAmount.multiply(percent).divide(new BigDecimal(100)).setScale(2, 4);
                        avaliableTaxAmount = avaliableTaxAmount.subtract(currentSignTaxamount).setScale(2, 4);
                        signedTaxAmount = signedTaxAmount.add(currentSignTaxamount).setScale(2, 4);
                    } else {
                        currentSignTaxamount = BigDecimalUtil.setScale((Object)this.getModel().getValue(CURRENT_AMOUNT));
                        signedTaxAmount = signedTaxAmount.add(currentSignTaxamount).setScale(2, 4);
                        avaliableTaxAmount = effectiveTaxAmount.subtract(signedTaxAmount).setScale(2, 4);
                    }
                    String invoiceRegisterType = null;
                    if (avaliableTaxAmount.compareTo(effectiveTaxAmount) == 0) {
                        invoiceRegisterType = RULE_3;
                    }
                    if (avaliableTaxAmount.compareTo(effectiveTaxAmount) < 0) {
                        invoiceRegisterType = RULE_2;
                    }
                    if (avaliableTaxAmount.compareTo(BigDecimal.ZERO) == 0) {
                        invoiceRegisterType = RULE_1;
                    }
                    detail.set(EFFECTIVE_AMOUNT, (Object)effectiveTaxAmount);
                    detail.set(AVALIABLE_AMOUNT, (Object)avaliableTaxAmount);
                    detail.set("currentregistertaxamount", (Object)currentSignTaxamount);
                    detail.set("registeredtaxamount", (Object)signedTaxAmount);
                    detail.set("rollouttaxamount", (Object)currentSignTaxamount);
                    detail.set(CONSUMER_TYPE, (Object)consumerType);
                    detail.set("rollouttype", (Object)rolloutType);
                    detail.set("remark", this.getModel().getValue("remark"));
                    detail.set("registerrule", (Object)radiogroupfield);
                    detail.set("rolloutrate", (Object)percent);
                    detail.set("invoiceregistertype", (Object)invoiceRegisterType);
                    detail.set("registerstatus", (Object)RULE_1);
                    detail.set("registertype", (Object)RULE_1);
                    detail.set(ROLLOUT_TAXPERIOD, (Object)rolloutTaxPeriod);
                    detail.set("rolloutperiod", (Object)rolloutTaxPeriodDate);
                    detail.set("createtime", (Object)new Date());
                    detail.set("creator", (Object)context.getUserId());
                    detail.set("modifier", (Object)context.getUserId());
                    detail.set("modifytime", (Object)new Date());
                    detail.set("summaryflag", (Object)RULE_1);
                    if (StringUtils.equals((CharSequence)"7", (CharSequence)consumerType)) {
                        detail.set("rollouttaxamount", (Object)0);
                        detailPrepareApportionList.add(detail);
                    }
                    detailList.add(detail);
                    invoiceRegisterMap.put((String)detail.get(INVOICE_ID), invoiceRegisterType);
                }
                try (TXHandle h = TX.requiresNew();){
                    try {
                        HashMap<String, String> registerIdMap = new HashMap<String, String>(16);
                        if (!detailList.isEmpty()) {
                            DynamicObject[] arrInsertDobj = new DynamicObject[detailList.size()];
                            arrInsertDobj = detailList.toArray(arrInsertDobj);
                            Object[] dynamicObjects = SaveServiceHelper.save((DynamicObject[])arrInsertDobj);
                            if (detailPrepareApportionList.size() > 0) {
                                for (Object object : dynamicObjects) {
                                    if (!(object instanceof DynamicObject)) continue;
                                    DynamicObject dyo = (DynamicObject)object;
                                    registerIdMap.put(dyo.getString(INVOICE_ID), String.valueOf(dyo.getLong("id")));
                                }
                                ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>();
                                for (int i = 0; i < detailPrepareApportionList.size(); ++i) {
                                    DynamicObject detail = (DynamicObject)detailPrepareApportionList.get(i);
                                    if (!StringUtils.equals((CharSequence)"7", (CharSequence)rolloutType)) {
                                        DynamicObject another = InputRolloutService.getDynamicObject(detailEntityType, radiogroupfield, percent, consumerType, rolloutTaxPeriodDate, rolloutTaxPeriod, context, registerIdMap, detail, rolloutType, invoiceTypeMap, this.getModel().getValue("remark"));
                                        arrayList.add(another);
                                        continue;
                                    }
                                    if (!StringUtils.equals((CharSequence)"7", (CharSequence)rolloutType)) continue;
                                    DynamicObject another1 = InputRolloutService.getDynamicObject(detailEntityType, radiogroupfield, percent, consumerType, rolloutTaxPeriodDate, rolloutTaxPeriod, context, registerIdMap, detail, RULE_1, invoiceTypeMap, this.getModel().getValue("remark"));
                                    arrayList.add(another1);
                                    DynamicObject another2 = InputRolloutService.getDynamicObject(detailEntityType, radiogroupfield, percent, consumerType, rolloutTaxPeriodDate, rolloutTaxPeriod, context, registerIdMap, detail, "4", invoiceTypeMap, this.getModel().getValue("remark"));
                                    arrayList.add(another2);
                                }
                                if (!arrayList.isEmpty()) {
                                    DynamicObject[] arrApportionInsertDobj = new DynamicObject[arrayList.size()];
                                    arrApportionInsertDobj = arrayList.toArray(arrApportionInsertDobj);
                                    SaveServiceHelper.save((DynamicObject[])arrApportionInsertDobj);
                                }
                            }
                        }
                        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(invoiceRegisterMap.size());
                        for (Map.Entry entry : invoiceRegisterMap.entrySet()) {
                            DynamicObject[] dynamicObjects;
                            for (DynamicObject object : dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"id,invoiceregistertype", (QFilter[])new QFilter[]{new QFilter(INVOICE_ID, "=", entry.getKey())})) {
                                object.set("invoiceregistertype", entry.getValue());
                                updateList.add(object);
                            }
                        }
                        SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
                    }
                    catch (Throwable t) {
                        h.markRollback();
                        throw t;
                    }
                }
            }
            finally {
                pageCache.remove("input_signvalueMap");
            }
            return true;
        }
        return false;
    }
}

