/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rollout.register;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;

public class InputRolloutReportPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String BUTTON_UNSIGN_KEY = "undoregister";
    private static final String BUTTON_SIGN_KEY = "rolloutregister";
    private static final String BUTTON_REFRESH = "refresh";
    private static final String INPUT_INVOICE_ROLLOUT_FORM_ID = "tcvat_rollout_dialog_new";
    private static final String INPUT_INVOICE_ROLLOUT_DETAIL_FORM_ID = "tcvat_rollout_detail_list";
    private static final String TAX_PERIOD_FIELD = "taxperiod";
    private static final String ORG_FIELD = "org";
    private static final String FIELD_SEPARATER = ",";
    private static final String ENTITY_NAME = "tcvat_rollout_register";

    public void registerListener(EventObject e) {
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        DynamicObject type = hyperLinkClickEvent.getRowData();
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        ArrayList<String> invoicePkIdList = new ArrayList<String>();
        invoicePkIdList.add(type.get("invoicecode") + type.getString("invoiceno"));
        customMap.put("invoicePkIdList", invoicePkIdList);
        customMap.put("source", "rolloutregisterdetail");
        if ("count".equals(type.getString("type"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u8ba1\u680f\u4e0d\u80fd\u505a\u7a7f\u900f\u5904\u7406", (String)"InputRolloutReportPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else {
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)INPUT_INVOICE_ROLLOUT_DETAIL_FORM_ID, (IFormView)this.getView(), (Map)customMap, (IFormPlugin)this);
        }
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        this.initDefaultOrg(contInitEvent.getCommonFilterColumns());
    }

    private void initDefaultOrg(List<FilterColumn> filters) {
        for (int i = 0; i < filters.size(); ++i) {
            CommonFilterColumn commFilter = (CommonFilterColumn)filters.get(i);
            String fieldName = commFilter.getFieldName();
            if (!"orgs".equals(fieldName)) continue;
            Map<String, Object> map = this.createComboItems();
            if (null == map) {
                return;
            }
            List comboList = (List)map.get("comboitems");
            commFilter.setComboItems(comboList);
            if (comboList.isEmpty()) {
                return;
            }
            commFilter.setDefaultValue((String)map.get("default"));
            commFilter.setDefaultValue((String)map.get("default"));
            this.getPageCache().put("orgs", SerializationUtils.toJsonString((Object)Lists.newArrayList((Object[])new String[]{(String)map.get("default")})));
        }
    }

    private Map<String, Object> createComboItems() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String defaultOrg = "";
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)false);
        if (null == col || col.isEmpty()) {
            return null;
        }
        long orgId = RequestContext.get().getOrgId();
        if (!CollectionUtils.isEmpty((Collection)col)) {
            boolean useDefault = false;
            for (DynamicObject obj : col) {
                if (obj.getLong("id") != orgId) continue;
                defaultOrg = String.valueOf(orgId);
                useDefault = true;
                break;
            }
            if (!useDefault) {
                defaultOrg = ((DynamicObject)col.get(0)).getString("id");
            }
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        for (DynamicObject r : col) {
            ComboItem c = new ComboItem();
            String orgPk = r.getString("id");
            c.setCaption(new LocaleString(r.getString("name")));
            c.setValue(orgPk);
            comboItems.add(c);
        }
        map.put("comboitems", comboItems);
        map.put("default", defaultOrg);
        return map;
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterMap = args.getSearchClickEvent().getFilterValues();
        List customList = (List)filterMap.get("customfilter");
        if (null != customList && customList.size() > 0) {
            for (Map map : customList) {
                List valueList;
                List fileName = (List)map.get("FieldName");
                int index = fileName.indexOf("orgs.id");
                if (index != -1) {
                    valueList = (List)map.get("Value");
                    this.getPageCache().put("orgs", SerializationUtils.toJsonString((Object)valueList));
                }
                if ((index = fileName.indexOf("period")) == -1) continue;
                valueList = (List)map.get("Value");
                this.getPageCache().put("period", SerializationUtils.toJsonString((Object)valueList));
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)BUTTON_SIGN_KEY)) {
            ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
            int[] rows = reportlist.getEntryState().getSelectedRows();
            if (rows.length < 1 || rows[0] == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8fdb\u884c\u8f6c\u51fa\u767b\u8bb0\u7684\u6570\u636e\u884c", (String)"InputRolloutReportPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            IReportListModel model = reportlist.getReportModel();
            if (null != model) {
                ArrayList<String> orgList = new ArrayList<String>(rows.length);
                HashMap<String, String> orgMap = new HashMap<String, String>(rows.length);
                HashMap<String, DynamicObjectCollection> dataMap = new HashMap<String, DynamicObjectCollection>();
                for (int i = 0; i < rows.length; ++i) {
                    DynamicObjectCollection collection;
                    DynamicObject rowData = model.getRowData(rows[i]);
                    if ("count".equals(rowData.getString("type"))) {
                        if (rows.length != 1) continue;
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u53ea\u9009\u62e9\u5408\u8ba1\u884c\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e", (String)"InputRolloutReportPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                        return;
                    }
                    String currentTaxPeriod = model.getRowData(rows[i]).getString(TAX_PERIOD_FIELD);
                    String orgid = rowData.getDynamicObject(ORG_FIELD).getString("id");
                    orgList.add(orgid);
                    orgMap.put(orgid, rowData.getDynamicObject(ORG_FIELD).getString("name"));
                    if (null != dataMap.get(orgid + FIELD_SEPARATER + currentTaxPeriod) && ((DynamicObjectCollection)dataMap.get(orgid + FIELD_SEPARATER + currentTaxPeriod)).size() > 0) {
                        collection = (DynamicObjectCollection)dataMap.get(orgid + FIELD_SEPARATER + currentTaxPeriod);
                        collection.add((Object)rowData);
                        dataMap.put(orgid + FIELD_SEPARATER + currentTaxPeriod, collection);
                        continue;
                    }
                    collection = new DynamicObjectCollection();
                    collection.add((Object)rowData);
                    dataMap.put(orgid + FIELD_SEPARATER + currentTaxPeriod, collection);
                }
                HashMap<String, Object> customParams = new HashMap<String, Object>(16);
                BigDecimal effectivetaxamount = BigDecimalUtil.setScale((Object)BigDecimal.ZERO);
                BigDecimal avaliabletaxamount = BigDecimalUtil.setScale((Object)BigDecimal.ZERO);
                BigDecimal signedtaxamount = BigDecimalUtil.setScale((Object)BigDecimal.ZERO);
                ArrayList valueList = new ArrayList();
                int rowSize = 0;
                for (Map.Entry entry : dataMap.entrySet()) {
                    String key = (String)entry.getKey();
                    DynamicObjectCollection dataValue = (DynamicObjectCollection)entry.getValue();
                    for (DynamicObject invoiceData : dataValue) {
                        HashMap<String, String> invoice = new HashMap<String, String>();
                        String invoicePkId = invoiceData.getString("invoicecode") + invoiceData.getString("invoiceno");
                        effectivetaxamount = effectivetaxamount.add(BigDecimalUtil.setScale((Object)invoiceData.getBigDecimal("effectivetaxamount")));
                        avaliabletaxamount = avaliabletaxamount.add(BigDecimalUtil.setScale((Object)invoiceData.getBigDecimal("avaliabletaxamount")));
                        signedtaxamount = signedtaxamount.add(BigDecimalUtil.setScale((Object)invoiceData.getBigDecimal("signedtaxamount")));
                        invoice.put("invoicecode", invoiceData.getString("invoicecode"));
                        invoice.put("invoiceno", invoiceData.getString("invoiceno"));
                        invoice.put("invoicetype", invoiceData.getString("type"));
                        invoice.put("taxamount", invoiceData.getString("taxamount"));
                        invoice.put("effectivetaxamount", invoiceData.getString("effectivetaxamount"));
                        invoice.put("signedtaxamount", invoiceData.getString("signedtaxamount"));
                        invoice.put("avaliabletaxamount", invoiceData.getString("avaliabletaxamount"));
                        invoice.put("invoicepkid", invoicePkId);
                        invoice.put(TAX_PERIOD_FIELD, key.split(FIELD_SEPARATER)[1]);
                        invoice.put(ORG_FIELD, key.split(FIELD_SEPARATER)[0]);
                        valueList.add(invoice);
                        ++rowSize;
                    }
                }
                customParams.put("effectivetaxamount", effectivetaxamount);
                customParams.put("avaliabletaxamount", avaliabletaxamount);
                customParams.put("signedtaxamount", signedtaxamount);
                customParams.put("rowSize", rowSize);
                customParams.put("valueMap", JsonUtil.toJson(valueList));
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)INPUT_INVOICE_ROLLOUT_FORM_ID, (IFormView)this.getView(), customParams, (IFormPlugin)this);
            }
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)BUTTON_UNSIGN_KEY)) {
            List orgList = new ArrayList(10);
            if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("orgs"))) {
                orgList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("orgs"), List.class);
            }
            ArrayList<String> invoicePkIdList = new ArrayList<String>();
            QFilter orgidFilter = new QFilter(ORG_FIELD, "in", (Object)orgList.stream().map(Long::parseLong).toArray());
            QFilter signtype1 = new QFilter("registertype", "=", (Object)"1");
            QFilter signstatus1 = new QFilter("registerstatus", "=", (Object)"1");
            QFilter signstatus = new QFilter("summaryflag", "=", (Object)"1");
            DynamicObjectCollection invoiceCol = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id,org,invoicepkid,rollouttaxperiod", (QFilter[])new QFilter[]{orgidFilter, signtype1, signstatus1, signstatus});
            for (DynamicObject object : invoiceCol) {
                QFilter declareStatus;
                QFilter endDateFilter;
                QFilter startDateFilter;
                QFilter typeFilter;
                String startDate = DateUtils.getFirstDateOfMonthStr((Date)DateUtils.stringToDate((String)object.getString("rollouttaxperiod"), (String)"yyyy-MM"), (String)"yyyy-MM-dd");
                String endDate = DateUtils.getLastDateOfMonthStr((Date)DateUtils.stringToDate((String)object.getString("rollouttaxperiod"), (String)"yyyy-MM"), (String)"yyyy-MM-dd");
                QFilter orgFilter = new QFilter(ORG_FIELD, "=", (Object)Long.parseLong(object.getString(ORG_FIELD)));
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"declarestatus,org,id", (QFilter[])new QFilter[]{orgFilter, typeFilter = new QFilter("type", "=", (Object)"zzsybnsr"), startDateFilter = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)startDate)), endDateFilter = new QFilter("skssqz", "<=", (Object)DateUtils.stringToDate((String)endDate)), declareStatus = new QFilter("declarestatus", "=", (Object)"declared")});
                if (collection.size() != 0) continue;
                invoicePkIdList.add(object.getString("id"));
            }
            if (invoicePkIdList.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u53ef\u64cd\u4f5c\u53d6\u6d88\u7684\u8f6c\u51fa\u767b\u8bb0\u8bb0\u5f55\uff0c\u65e0\u9700\u53d6\u6d88\u767b\u8bb0", (String)"InputRolloutReportPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            this.confirmTips(itemKey, JsonUtil.toJson(invoicePkIdList));
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)BUTTON_REFRESH)) {
            ReportList reportlist = (ReportList)this.getControl("reportlistap");
            reportlist.clearEntryState();
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"selectall")) {
            ReportList reportlist = (ReportList)this.getControl("reportlistap");
            int size = reportlist.getReportModel().getRowCount();
            if (size <= 0) {
                return;
            }
            reportlist.selectRows(IntStream.range(0, size).toArray(), 1);
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"cancelall")) {
            ReportList reportlist = (ReportList)this.getControl("reportlistap");
            reportlist.clearEntryState();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (INPUT_INVOICE_ROLLOUT_FORM_ID.equals(closedCallBackEvent.getActionId()) || INPUT_INVOICE_ROLLOUT_DETAIL_FORM_ID.equals(closedCallBackEvent.getActionId())) {
            this.getView().refresh();
        }
    }

    private void confirmTips(String itemKey, String customValue) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(itemKey, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"InputRolloutReportPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"InputRolloutReportPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u53d6\u6d88\u767b\u8bb0\u540e\uff0c\u8be5\u8f6c\u51fa\u767b\u8bb0\u5bf9\u5e94\u7684\u8f6c\u51fa\u5206\u644a\u7ed3\u679c\u3001\u8f6c\u51fa\u6807\u8bc6\u8bb0\u5f55\u6570\u636e\u5c06\u88ab\u6e05\u7a7a\uff0c\u786e\u8ba4\u6253\u5f00\u53d6\u6d88\u767b\u8bb0\u754c\u9762\u64cd\u4f5c\u53d6\u6d88\u5417\uff1f", (String)"InputRolloutReportPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps, customValue);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (BUTTON_UNSIGN_KEY.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            String customVaule = messageBoxClosedEvent.getCustomVaule();
            JSONArray idArray = JSONObject.parseArray((String)customVaule);
            HashMap<String, String> customParams = new HashMap<String, String>(16);
            customParams.put("source", messageBoxClosedEvent.getCallBackId());
            customParams.put("invoicePkIdList", (String)idArray);
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)INPUT_INVOICE_ROLLOUT_DETAIL_FORM_ID, (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }
}

