/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rule;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tcvat.common.util.TcvatCommonUtil;
import kd.taxc.tcvat.formplugin.rule.AbstractRuleCollectTreeListPlugin;

public class JzjtRuleCollectTreeListPlugin
extends AbstractRuleCollectTreeListPlugin
implements TreeNodeClickListener {
    @Override
    public String getRootNodeName() {
        return ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u6807\u8bc6\u89c4\u5219", (String)"JzjtRuleCollectTreeListPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]);
    }

    @Override
    protected boolean checkBeforeAddRule(Long createOrgId, String ruleType, String formId) {
        super.checkBeforeAddRule(createOrgId, ruleType, formId);
        Boolean hasRule = this.judgeHasRule(createOrgId);
        if (!hasRule.booleanValue()) {
            return false;
        }
        Boolean success = TcvatCommonUtil.isYbnsr(createOrgId).getSuccess();
        if (!success.booleanValue()) {
            String orgName = OrgUtils.getOrgNameById((String)String.valueOf(createOrgId));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u201c%1$s\u201c\u4e3a\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\uff0c\u4e0d\u9002\u7528\u5373\u5f81\u5373\u9000\u89c4\u5219\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"JzjtRuleCollectTreeListPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]), orgName));
            return false;
        }
        return true;
    }

    private Boolean judgeHasRule(Long orgId) {
        if (orgId.compareTo(0L) == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u5de6\u8fb9\u7ec4\u7ec7\u6811\u4e0a\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"RuleInvoicePlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            return false;
        }
        String orgName = OrgUtils.getOrgNameById((String)String.valueOf(orgId));
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(orgId)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RuleInvoicePlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]), orgName));
            return false;
        }
        if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)orgId).getData()).booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"RuleInvoicePlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
            return false;
        }
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(orgId));
        if (EmptyCheckUtils.isNotEmpty((Object)result.getData()) && EmptyCheckUtils.isNotEmpty((Object)((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity"))) {
            DynamicObjectCollection list = ((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity");
            DynamicObject dy = (DynamicObject)list.get(0);
            if (Objects.isNull(((DynamicObject)((List)result.getData()).get(0)).getString("taxorg.unifiedsocialcode"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u201c%s\u201d\u5c1a\u672a\u5f55\u5165\u4f01\u4e1a\u4fe1\u606f\uff0c\u8bf7\u5148\u5230\u57fa\u7840\u6570\u636e-\u7a0e\u52a1\u4fe1\u606f\u754c\u9762\u5f55\u5165\u4f01\u4e1a\u4fe1\u606f\u3002", (String)"RuleInvoicePlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]), orgName));
                return false;
            }
            if (Objects.equals("0", dy.getString("enable"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7\u589e\u503c\u7a0e\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\uff0c\u5982\u9700\u64cd\u4f5c,\u8bf7\u524d\u5f80\u7a0e\u52a1\u4e91-\u57fa\u7840\u8d44\u6599-\u7a0e\u52a1\u4fe1\u606f\u8fdb\u884c\u542f\u7528\u3002", (String)"RuleInvoicePlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]), orgName));
                return false;
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u57fa\u7840\u8d44\u6599-\u7a0e\u52a1\u4fe1\u606f\u4e2d\u5b8c\u5584\u7a0e\u52a1\u4fe1\u606f\u3002", (String)"RuleInvoicePlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    protected String sharePlanFormId() {
        return "";
    }
}

