/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rule;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.history.BaseDataHistoryService;
import kd.taxc.bdtaxr.common.taxdeclare.dto.AdvanceConfDto;
import kd.taxc.bdtaxr.common.taxdeclare.ruleconfig.RuleTemplateService;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public class RuleQueryPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener {
    private static Log logger = LogFactory.getLog(RuleQueryPlugin.class);
    private static final String INCOMEENTRY = "incomeentry";
    private static final String ROLLOUTENTRY = "rolloutentry";
    private static final String DEDUCTENTRY = "deductentry";
    private static final String JZJTSEENTRY = "jzjtseentry";
    private static final String DIFFENTRY = "diffentry";
    private static final String DEDUCTIONTRY = "deductionentry";
    private static final String ACCTENTRYENTITY = "acctentryentity";
    private static final String INVOICEENTRYENTITY = "invoiceentryentity";
    private static final String ZYFPSEENTRYENTITY = "zyfpseentryentity";
    private static final String QTFPBHSSRENTRYENTITY = "qtfpbhssrentryentity";
    private static final String QTFPSEENTRYENTITY = "qtfpseentryentity";
    private static final String WKPFSEENTRYENTITY = "wkpseentryentity";
    private static final String PERPREENTRY = "perpreentry";
    private static final String MDTSENTRY = "mdtsentry";
    private static final String ACCTFLEX = "acctentryflex";
    private static final String INVOICEFLEX = "invoiceentryflex";
    private static final String ZYFPSEFLEX = "zyfpseentryflex";
    private static final String QTFPBHSSRFLEX = "qtfpbhssrentryflex";
    private static final String QTFPSEFLEX = "qtfpseentryflex";
    private static final String WKPFSEFLEX = "wkpseentryflex";
    private static final String ORG = "org";
    private static final String RULE_PURPOSE = "rulepurpose";
    private static final String SHOWDISABLE = "showdisable";
    private static final String TCVAT_N_INCOMERULE = "tcvat_rule_income";
    private static final String TCVAT_N_ROLLOUTRULE = "tcvat_rule_rollout";
    private static final String TCVAT_N_DEDUCTRULE = "tcvat_rule_deduct";
    private static final String TCVAT_N_JZJTSERULE = "tcvat_rule_jzjt_jxse";
    private static final String TCVAT_N_DIFFRULE = "tcvat_rule_diff";
    private static final String TCVAT_N_DEDUCTIONRULE = "tcvat_rule_deduction";
    private static final String TCVAT_N_PERPRERULE = "tcvat_rule_perpre";
    private static final String TCVAT_N_MDTSRULE = "tcvat_rule_mdts";
    private static final String SEARCHMONTH = "searchmonth";
    private static final String INVOICESEQS = "invoiceseqs";
    private static final String QTFPSEQS = "qtfpseqs";
    private static final String WKPSEQS = "wkpseqs";
    private static final String ISWKPWSCL = "iswkpwscl";

    public void initialize() {
        CardEntry incomecardList = (CardEntry)this.getView().getControl(INCOMEENTRY);
        incomecardList.addSelectRowsListener((SelectRowsEventListener)this);
        CardEntry rolloutcardList = (CardEntry)this.getView().getControl(ROLLOUTENTRY);
        rolloutcardList.addSelectRowsListener((SelectRowsEventListener)this);
        CardEntry deductcardList = (CardEntry)this.getView().getControl(DEDUCTENTRY);
        deductcardList.addSelectRowsListener((SelectRowsEventListener)this);
        CardEntry jzjtsecardlist = (CardEntry)this.getView().getControl(JZJTSEENTRY);
        jzjtsecardlist.addSelectRowsListener((SelectRowsEventListener)this);
        CardEntry diffcardList = (CardEntry)this.getView().getControl(DIFFENTRY);
        diffcardList.addSelectRowsListener((SelectRowsEventListener)this);
        CardEntry deductionCardList = (CardEntry)this.getView().getControl(DEDUCTIONTRY);
        deductionCardList.addSelectRowsListener((SelectRowsEventListener)this);
        CardEntry perpreCardList = (CardEntry)this.getView().getControl(PERPREENTRY);
        perpreCardList.addSelectRowsListener((SelectRowsEventListener)this);
        CardEntry mdtsCardList = (CardEntry)this.getView().getControl(MDTSENTRY);
        mdtsCardList.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject org = null;
        try {
            org = (DynamicObject)this.getView().getParentView().getModel().getValue(ORG);
        }
        catch (Exception ee) {
            logger.error((Throwable)ee);
            org = null;
        }
        if (org != null) {
            this.getModel().setValue(ORG, org.get("id"));
        } else {
            this.getModel().setValue(ORG, (Object)PermissionUtils.getDefaultOrgId());
        }
        this.refreshRules();
    }

    public void afterBindData(EventObject e) {
        int count1 = this.getModel().getEntryRowCount(INCOMEENTRY);
        int count2 = this.getModel().getEntryRowCount(ROLLOUTENTRY);
        int count5 = this.getModel().getEntryRowCount(DEDUCTENTRY);
        int count8 = this.getModel().getEntryRowCount(JZJTSEENTRY);
        int count3 = this.getModel().getEntryRowCount(DIFFENTRY);
        int count4 = this.getModel().getEntryRowCount(DEDUCTIONTRY);
        int count6 = this.getModel().getEntryRowCount(PERPREENTRY);
        int count7 = this.getModel().getEntryRowCount(MDTSENTRY);
        if (count1 > 0) {
            this.initSelect(INCOMEENTRY, 0);
        } else if (count2 > 0) {
            this.initSelect(ROLLOUTENTRY, 0);
        } else if (count3 > 0) {
            this.initSelect(DIFFENTRY, 0);
        } else if (count4 > 0) {
            this.initSelect(DEDUCTIONTRY, 0);
        } else if (count5 > 0) {
            this.initSelect(DEDUCTENTRY, 0);
        } else if (count8 > 0) {
            this.initSelect(JZJTSEENTRY, 0);
        } else if (count6 > 0) {
            this.initSelect(PERPREENTRY, 0);
        } else if (count7 > 0) {
            this.initSelect(MDTSENTRY, 0);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (ORG.equals(name) || SHOWDISABLE.equals(name) || SEARCHMONTH.equals(name) || RULE_PURPOSE.equals(name)) {
            if (null == this.getModel().getValue(SEARCHMONTH)) {
                return;
            }
            this.refreshRules();
        }
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        CardEntry cardEntry = (CardEntry)evt.getSource();
        this.getModel().setValue("ruletype", (Object)cardEntry.getEntryKey());
        List rows = evt.getNewRows();
        String isDeclared = this.getPageCache().get("isDeclared");
        if (CollectionUtils.isNotEmpty((Collection)rows)) {
            this.clearEntry(ACCTENTRYENTITY, INVOICEENTRYENTITY, QTFPBHSSRENTRYENTITY, ZYFPSEENTRYENTITY, QTFPSEENTRYENTITY, WKPFSEENTRYENTITY);
            this.getView().setVisible(Boolean.TRUE, new String[]{ACCTFLEX, INVOICEFLEX, QTFPBHSSRFLEX, ZYFPSEFLEX, QTFPSEFLEX, WKPFSEFLEX, INVOICESEQS, QTFPSEQS, WKPSEQS, ISWKPWSCL});
            Object id = this.getModel().getValue(cardEntry.getEntryKey() + "id", ((Integer)rows.get(0)).intValue());
            this.getView().setVisible(Boolean.FALSE, new String[]{"qzkceseqs", "minswitch", "equalsjkce"});
            if (INCOMEENTRY.equals(cardEntry.getEntryKey())) {
                this.clearEntrySelectedStatus(ROLLOUTENTRY, DIFFENTRY, DEDUCTIONTRY, DEDUCTENTRY, JZJTSEENTRY, PERPREENTRY);
                this.setInvoiceEntry(id);
                Label labelap = (Label)this.getControl("labelap");
                String labelText = ResManager.loadKDString((String)"\u672a\u5f00\u7968\u4e0d\u542b\u7a0e\u6536\u5165\u53d6\u6570\u914d\u7f6e", (String)"RuleQueryPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]);
                if ("true".equals(isDeclared)) {
                    String json = this.getPageCache().get("INCOME" + id);
                    if (StringUtils.isNotBlank((CharSequence)json)) {
                        JSONObject object = JSONObject.parseObject((String)json);
                        Boolean wkpseqs = object.getBoolean(WKPSEQS);
                        Boolean iswkpwscl = object.getBoolean(ISWKPWSCL);
                        Boolean qtfpseqs = object.getBoolean(QTFPSEQS);
                        Boolean invoiceseqs = object.getBoolean(INVOICESEQS);
                        if (wkpseqs == null || qtfpseqs == null || invoiceseqs == null) {
                            labelText = ResManager.loadKDString((String)"\u672a\u5f00\u7968\u6536\u5165\u53d6\u6570\u89c4\u5219", (String)"RuleQueryPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]);
                            this.getView().setVisible(Boolean.FALSE, new String[]{QTFPBHSSRFLEX, ZYFPSEFLEX, QTFPSEFLEX, WKPFSEFLEX, INVOICESEQS, QTFPSEQS, WKPSEQS, ISWKPWSCL});
                        } else {
                            this.getView().setVisible(wkpseqs, new String[]{WKPFSEFLEX});
                            this.getModel().setValue(WKPSEQS, (Object)wkpseqs);
                            this.getView().setVisible(wkpseqs, new String[]{ISWKPWSCL});
                            this.getModel().setValue(ISWKPWSCL, (Object)iswkpwscl);
                            this.getView().setVisible(qtfpseqs, new String[]{QTFPSEFLEX});
                            this.getModel().setValue(QTFPSEQS, (Object)qtfpseqs);
                            this.getView().setVisible(invoiceseqs, new String[]{ZYFPSEFLEX});
                            this.getModel().setValue(INVOICESEQS, (Object)invoiceseqs);
                        }
                    }
                } else {
                    EntityEnum[] obj = QueryServiceHelper.queryOne((String)TCVAT_N_INCOMERULE, (String)"qtfpseqs,wkpseqs,iswkpwscl,invoiceseqs", (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
                    Boolean invoiceseqs = obj.getBoolean(INVOICESEQS);
                    this.getView().setVisible(invoiceseqs, new String[]{ZYFPSEFLEX});
                    this.getModel().setValue(INVOICESEQS, (Object)invoiceseqs);
                    Boolean qtfpseqs = obj.getBoolean(QTFPSEQS);
                    this.getView().setVisible(qtfpseqs, new String[]{QTFPSEFLEX});
                    this.getModel().setValue(QTFPSEQS, (Object)qtfpseqs);
                    Boolean wkpseqs = obj.getBoolean(WKPSEQS);
                    Boolean iswkpwscl = obj.getBoolean(ISWKPWSCL);
                    this.getView().setVisible(wkpseqs, new String[]{WKPFSEFLEX});
                    this.getModel().setValue(WKPSEQS, (Object)wkpseqs);
                    this.getView().setVisible(wkpseqs, new String[]{ISWKPWSCL});
                    this.getModel().setValue(ISWKPWSCL, (Object)iswkpwscl);
                }
                labelap.setText(labelText);
                for (EntityEnum entityEnum : EntityEnum.values()) {
                    this.setAccEntry("INCOME", id, TCVAT_N_INCOMERULE, entityEnum.ruleEntity, entityEnum.queryEntity, entityEnum.fieldSuffix);
                }
                Label labelap2 = (Label)this.getControl("labelap2");
                labelap2.setText(ResManager.loadKDString((String)"\u5176\u4ed6\u53d1\u7968\u4e0d\u542b\u7a0e\u6536\u5165\u53d6\u6570\u914d\u7f6e", (String)"RuleQueryPlugin_10", (String)"taxc-tcvat", (Object[])new Object[0]));
                Label labelap3 = (Label)this.getControl("labelap3");
                labelap3.setText(ResManager.loadKDString((String)"\u5176\u4ed6\u53d1\u7968\u7a0e\u989d\u53d6\u6570\u914d\u7f6e", (String)"RuleQueryPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                Label labelap4 = (Label)this.getControl("labelap4");
                labelap4.setText(ResManager.loadKDString((String)"\u672a\u5f00\u7968\u7a0e\u989d\u53d6\u6570\u914d\u7f6e", (String)"RuleQueryPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
            } else if (ROLLOUTENTRY.equals(cardEntry.getEntryKey())) {
                this.clearEntrySelectedStatus(INCOMEENTRY, DIFFENTRY, DEDUCTIONTRY, DEDUCTENTRY, JZJTSEENTRY, PERPREENTRY);
                this.getView().setVisible(Boolean.FALSE, new String[]{INVOICEFLEX, ZYFPSEFLEX, QTFPBHSSRFLEX, QTFPSEFLEX, WKPFSEFLEX, INVOICESEQS, QTFPSEQS, WKPSEQS, ISWKPWSCL});
                Label labelap = (Label)this.getControl("labelap");
                labelap.setText(ResManager.loadKDString((String)"\u53d6\u6570\u89c4\u5219\u914d\u7f6e", (String)"RuleQueryPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.setAccEntry("ROLL_OUT", id, TCVAT_N_ROLLOUTRULE, "entryentity", ACCTENTRYENTITY, "");
            } else if (DIFFENTRY.equals(cardEntry.getEntryKey())) {
                Label labelap2;
                this.clearEntrySelectedStatus(INCOMEENTRY, ROLLOUTENTRY, DEDUCTIONTRY, DEDUCTENTRY);
                this.getView().setVisible(Boolean.FALSE, new String[]{INVOICEFLEX, ZYFPSEFLEX, WKPFSEFLEX, INVOICESEQS, QTFPSEQS, WKPSEQS, ISWKPWSCL});
                DynamicObject ruleConfig = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tcvat_sbx_rule_config");
                String deductproject = ruleConfig.getString("deductproject");
                if ("bqfse".equals(deductproject) || "fseandkce".equals(deductproject)) {
                    Label labelap = (Label)this.getControl("labelap");
                    labelap.setText(ResManager.loadKDString((String)"\u53d1\u751f\u989d\u53d6\u6570\u89c4\u5219\u914d\u7f6e", (String)"RuleQueryPlugin_11", (String)"taxc-tcvat", (Object[])new Object[0]));
                    this.setAccEntry("DIFF", id, TCVAT_N_DIFFRULE, "entryentity", ACCTENTRYENTITY, "");
                    this.getView().setVisible(Boolean.FALSE, new String[]{QTFPSEFLEX});
                    if ("bqfse".equals(deductproject)) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{QTFPBHSSRFLEX});
                    }
                }
                if ("fseandkce".equals(deductproject)) {
                    labelap2 = (Label)this.getControl("labelap2");
                    labelap2.setText(ResManager.loadKDString((String)"\u672c\u671f\u5b9e\u9645\u6263\u9664\u989d\u53d6\u6570\u89c4\u5219\u914d\u7f6e", (String)"RuleQueryPlugin_12", (String)"taxc-tcvat", (Object[])new Object[0]));
                    this.setAccEntry("DIFF", id, TCVAT_N_DIFFRULE, "entryentity1", QTFPBHSSRENTRYENTITY, "1");
                    this.setDiffSwitch(id, "qzkce");
                }
                if ("bqsjkce".equals(deductproject)) {
                    this.setDiffSwitch(id, "minswitch");
                    this.setDiffSwitch(id, "equalsjkce");
                    labelap2 = (Label)this.getControl("labelap2");
                    labelap2.setText(ResManager.loadKDString((String)"\u672c\u671f\u5b9e\u9645\u6263\u9664\u989d\u53d6\u6570\u89c4\u5219\u914d\u7f6e", (String)"RuleQueryPlugin_12", (String)"taxc-tcvat", (Object[])new Object[0]));
                    this.setAccEntry("DIFF", id, TCVAT_N_DIFFRULE, "entryentity1", QTFPBHSSRENTRYENTITY, "1");
                    Label labelap3 = (Label)this.getControl("labelap3");
                    labelap3.setText(ResManager.loadKDString((String)"\u5176\u4e2d\uff1a\u5373\u5f81\u5373\u9000\u672c\u671f\u5b9e\u9645\u6263\u9664\u989d\u53d6\u6570\u89c4\u5219\u914d\u7f6e", (String)"RuleQueryPlugin_55", (String)"taxc-tcvat", (Object[])new Object[0]));
                    this.setAccEntry("DIFF", id, TCVAT_N_DIFFRULE, "entryentity11", QTFPSEENTRYENTITY, "11");
                    this.getView().setVisible(Boolean.FALSE, new String[]{ACCTFLEX});
                }
            } else if (DEDUCTIONTRY.equals(cardEntry.getEntryKey())) {
                this.clearEntrySelectedStatus(INCOMEENTRY, ROLLOUTENTRY, DIFFENTRY, DEDUCTENTRY, JZJTSEENTRY, PERPREENTRY);
                this.getView().setVisible(Boolean.FALSE, new String[]{INVOICEFLEX, ZYFPSEFLEX, QTFPBHSSRFLEX, QTFPSEFLEX, WKPFSEFLEX, INVOICESEQS, QTFPSEQS, WKPSEQS, ISWKPWSCL});
                Label labelap = (Label)this.getControl("labelap");
                labelap.setText(ResManager.loadKDString((String)"\u53d6\u6570\u89c4\u5219\u914d\u7f6e", (String)"RuleQueryPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.setAccEntry("REDUCE", id, TCVAT_N_DEDUCTIONRULE, "entryentity", ACCTENTRYENTITY, "");
            } else if (DEDUCTENTRY.equals(cardEntry.getEntryKey())) {
                this.clearEntrySelectedStatus(INCOMEENTRY, ROLLOUTENTRY, DIFFENTRY, DEDUCTIONTRY, PERPREENTRY, JZJTSEENTRY);
                this.getView().setVisible(Boolean.FALSE, new String[]{INVOICEFLEX, INVOICESEQS, ZYFPSEFLEX, QTFPSEQS, WKPSEQS, QTFPBHSSRFLEX, ISWKPWSCL});
                Label labelap3 = (Label)this.getControl("labelap3");
                labelap3.setText(ResManager.loadKDString((String)"\u8fdb\u9879\u62b5\u6263\u91d1\u989d\u53d6\u6570\u914d\u7f6e", (String)"RuleQueryPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.setAccEntry("DEDUCT", id, TCVAT_N_DEDUCTRULE, "entryentity", QTFPSEENTRYENTITY, "11");
                Label labelap = (Label)this.getControl("labelap");
                labelap.setText(ResManager.loadKDString((String)"\u7a0e\u989d\u53d6\u6570\u914d\u7f6e", (String)"RuleQueryPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.setAccEntry("DEDUCT", id, TCVAT_N_DEDUCTRULE, "entryentity1", "1", ACCTENTRYENTITY, "");
                Label labelap4 = (Label)this.getControl("labelap4");
                labelap4.setText(ResManager.loadKDString((String)"\u4efd\u6570\u53d6\u6570\u914d\u7f6e", (String)"RuleQueryPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.setAccEntry("DEDUCT", id, TCVAT_N_DEDUCTRULE, "entryentity11", "11", WKPFSEENTRYENTITY, "3");
            } else if (JZJTSEENTRY.equals(cardEntry.getEntryKey())) {
                this.clearEntrySelectedStatus(INCOMEENTRY, ROLLOUTENTRY, DIFFENTRY, DEDUCTIONTRY, PERPREENTRY, DEDUCTENTRY);
                this.getView().setVisible(Boolean.FALSE, new String[]{INVOICEFLEX, ZYFPSEFLEX, QTFPBHSSRFLEX, QTFPSEFLEX, INVOICESEQS, QTFPSEQS, WKPSEQS, ISWKPWSCL});
                Label labelap = (Label)this.getControl("labelap");
                labelap.setText(ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u7a0e\u989d\u53d6\u6570\u914d\u7f6e", (String)"RuleQueryPlugin_15", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.setAccEntry("JZJTSE", id, TCVAT_N_JZJTSERULE, "entryentity", ACCTENTRYENTITY, "");
                Label labelap2 = (Label)this.getControl("labelap4");
                labelap2.setText(ResManager.loadKDString((String)"\u65e0\u6cd5\u5212\u5206\u7684\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d\u53d6\u6570\u914d\u7f6e", (String)"RuleQueryPlugin_16", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.setAccEntry("JZJTSE", id, TCVAT_N_JZJTSERULE, "entryentity1", "1", WKPFSEENTRYENTITY, "3");
                if ("true".equals(isDeclared)) {
                    String json = this.getPageCache().get("JZJTSE" + id);
                    if (StringUtils.isNotBlank((CharSequence)json)) {
                        JSONObject object = JSONObject.parseObject((String)json);
                        String jzjtlx = object.getString("jzjtlx");
                        if ("jzjt".equals(jzjtlx)) {
                            this.getView().setVisible(Boolean.FALSE, new String[]{WKPFSEENTRYENTITY, "labelap4"});
                            this.getView().setVisible(Boolean.TRUE, new String[]{ACCTENTRYENTITY, "labelap"});
                        } else if ("wfhf".equals(jzjtlx)) {
                            this.getView().setVisible(Boolean.TRUE, new String[]{WKPFSEENTRYENTITY, "labelap4"});
                            this.getView().setVisible(Boolean.FALSE, new String[]{ACCTENTRYENTITY, "labelap"});
                        }
                    }
                } else {
                    String jzjtlx = (String)this.getModel().getValue("jzjtsejzjtlx", ((Integer)rows.get(0)).intValue());
                    if ("jzjt".equals(jzjtlx)) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{WKPFSEENTRYENTITY, "labelap4"});
                        this.getView().setVisible(Boolean.TRUE, new String[]{ACCTENTRYENTITY, "labelap"});
                    } else if ("wfhf".equals(jzjtlx)) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{WKPFSEENTRYENTITY, "labelap4"});
                        this.getView().setVisible(Boolean.FALSE, new String[]{ACCTENTRYENTITY, "labelap"});
                    }
                }
            } else if (PERPREENTRY.equals(cardEntry.getEntryKey())) {
                this.clearEntrySelectedStatus(INCOMEENTRY, ROLLOUTENTRY, DEDUCTIONTRY, DEDUCTENTRY, JZJTSEENTRY);
                this.getView().setVisible(Boolean.FALSE, new String[]{INVOICEFLEX, ZYFPSEFLEX, QTFPBHSSRFLEX, QTFPSEFLEX, WKPFSEFLEX, INVOICESEQS, QTFPSEQS, WKPSEQS, ISWKPWSCL});
                Label labelap = (Label)this.getControl("labelap");
                labelap.setText(ResManager.loadKDString((String)"\u672c\u671f\u53d1\u751f\u989d\u53d6\u6570\u914d\u7f6e", (String)"RuleQueryPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.setAccEntry("PERPRE", id, TCVAT_N_PERPRERULE, "entryentity", ACCTENTRYENTITY, "");
            } else if (MDTSENTRY.equals(cardEntry.getEntryKey())) {
                this.clearEntrySelectedStatus(INCOMEENTRY, ROLLOUTENTRY, DEDUCTIONTRY, DEDUCTENTRY, JZJTSEENTRY);
                this.getView().setVisible(Boolean.FALSE, new String[]{INVOICEFLEX, ZYFPSEFLEX, QTFPBHSSRFLEX, QTFPSEFLEX, WKPFSEFLEX, INVOICESEQS, QTFPSEQS, WKPSEQS, ISWKPWSCL});
                Label labelap = (Label)this.getControl("labelap");
                labelap.setText(ResManager.loadKDString((String)"\u9000\u7a0e\u53d6\u6570\u914d\u7f6e", (String)"RuleQueryPlugin_13", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.setAccEntry("MDTS", id, TCVAT_N_MDTSRULE, "entryentity", ACCTENTRYENTITY, "");
            }
        }
    }

    private void setDiffSwitch(Object id, String switchName) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"qzkce".equals(switchName) ? "qzkceseqs" : switchName});
        String isDeclared = this.getPageCache().get("isDeclared");
        Boolean flag = false;
        if ("true".equals(isDeclared)) {
            String json = this.getPageCache().get("DIFF" + id);
            if (StringUtils.isNotBlank((CharSequence)json)) {
                JSONObject object = JSONObject.parseObject((String)json);
                flag = object.getBoolean(switchName);
            }
        } else {
            DynamicObject obj = QueryServiceHelper.queryOne((String)TCVAT_N_DIFFRULE, (String)switchName, (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
            flag = obj.getBoolean(switchName);
        }
        this.getModel().setValue("qzkce".equals(switchName) ? "qzkceseqs" : switchName, (Object)flag);
    }

    private void setInvoiceEntry(Object id) {
        String isDeclared = this.getPageCache().get("isDeclared");
        if ("true".equals(isDeclared)) {
            JSONObject object;
            JSONArray entryentity;
            String json = this.getPageCache().get("INCOME" + id);
            if (StringUtils.isNotBlank((CharSequence)json) && (entryentity = (object = JSONObject.parseObject((String)json)).getJSONArray("invoiceentity")) != null && entryentity.size() > 0) {
                IDataModel model = this.getModel();
                model.beginInit();
                model.batchCreateNewEntryRow(INVOICEENTRYENTITY, entryentity.size());
                for (int i = 0; i < entryentity.size(); ++i) {
                    JSONObject entry = entryentity.getJSONObject(i);
                    this.getModel().setValue("invoicebizname", (Object)entry.getString("invoicebizname"), i);
                    if (entry.getJSONObject("table12") != null) {
                        this.getModel().setValue("table12", (Object)entry.getJSONObject("table12").getString("bizname"), i);
                    }
                    if (entry.getJSONObject("amountfield12") != null) {
                        this.getModel().setValue("amountfield12", (Object)entry.getJSONObject("amountfield12").getString("bizsubname"), i);
                    }
                    this.getModel().setValue("datatype12", (Object)entry.getString("datatype12"), i);
                    this.getModel().setValue("datadirection12", (Object)entry.getString("datadirection12"), i);
                    this.getModel().setValue("invoicefiltercondition", (Object)entry.getString("invoicefiltercondition"), i);
                    this.getModel().setValue("differenceinvoice12", (Object)entry.getString("differenceinvoice12"), i);
                }
                model.endInit();
                this.getView().updateView(INVOICEENTRYENTITY);
            }
        } else {
            String selectFields = "invoiceentity.datatype12,invoiceentity.datadirection12,invoiceentity.amountfield12.bizsubname,invoiceentity.invoicebizname,invoiceentity.table12.bizname,invoiceentity.invoicetaxrate,invoiceentity.invoicefiltercondition,invoiceentity.differenceinvoice12";
            QFilter filter = new QFilter("id", "=", id);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)TCVAT_N_INCOMERULE, (String)selectFields, (QFilter[])new QFilter[]{filter});
            this.getModel().beginInit();
            for (DynamicObject object : collection) {
                int index = this.getModel().createNewEntryRow(INVOICEENTRYENTITY);
                this.getModel().setValue("invoicebizname", (Object)object.getString("invoiceentity.invoicebizname"), index);
                this.getModel().setValue("table12", (Object)object.getString("invoiceentity.table12.bizname"), index);
                this.getModel().setValue("amountfield12", (Object)object.getString("invoiceentity.amountfield12.bizsubname"), index);
                this.getModel().setValue("datatype12", (Object)object.getString("invoiceentity.datatype12"), index);
                this.getModel().setValue("datadirection12", (Object)object.getString("invoiceentity.datadirection12"), index);
                this.getModel().setValue("invoicefiltercondition", (Object)object.getString("invoiceentity.invoicefiltercondition"), index);
                this.getModel().setValue("differenceinvoice12", (Object)object.getString("invoiceentity.differenceinvoice12"), index);
            }
            this.getModel().endInit();
            this.getView().updateView(INVOICEENTRYENTITY);
        }
    }

    private void setAccEntry(String key, Object id, String entityName, String ruleEntity, String queryEntity, String fieldSuffix) {
        this.setAccEntry(key, id, entityName, ruleEntity, null, queryEntity, fieldSuffix);
    }

    private void setAccEntry(String key, Object id, String entityName, String ruleEntity, String ruleEntityFiledSuffix, String queryEntity, String fieldSuffix) {
        String isDeclared = this.getPageCache().get("isDeclared");
        String suffix = ruleEntityFiledSuffix;
        if (suffix == null) {
            suffix = ruleEntity.replace("entryentity", "");
        }
        IDataModel model = this.getModel();
        if ("true".equals(isDeclared)) {
            JSONObject object;
            JSONArray entryentity;
            String json = this.getPageCache().get(key + id);
            if (StringUtils.isNotBlank((CharSequence)json) && (entryentity = (object = JSONObject.parseObject((String)json)).getJSONArray(ruleEntity)) != null && entryentity.size() > 0) {
                model.beginInit();
                model.batchCreateNewEntryRow(queryEntity, entryentity.size());
                for (int i = 0; i < entryentity.size(); ++i) {
                    JSONObject entry = entryentity.getJSONObject(i);
                    model.setValue("bizname" + fieldSuffix, (Object)entry.getString("bizname" + suffix), i);
                    model.setValue("table" + fieldSuffix, (Object)entry.getJSONObject("table" + suffix).getString("bizname"), i);
                    model.setValue("amountfield" + fieldSuffix, (Object)entry.getJSONObject("amountfield" + suffix).getString("bizsubname"), i);
                    model.setValue("datatype" + fieldSuffix, (Object)entry.getString("datatype" + suffix), i);
                    model.setValue("datadirection" + fieldSuffix, (Object)entry.getString("datadirection" + suffix), i);
                    model.setValue("filtercondition" + fieldSuffix, (Object)entry.getString("filtercondition" + suffix), i);
                    if (key.equals("DEDUCT")) {
                        if ("entryentity11".equals(ruleEntity)) {
                            model.setValue("amountfield33", (Object)entry.getJSONObject("amountfield" + suffix).getString("bizsubname"), i);
                        } else {
                            model.setValue(queryEntity + "json", (Object)entry.getString("entryentity" + suffix + "confjson"), i);
                            model.setValue("entryentityconf" + fieldSuffix, (Object)entry.getString("entryentityconf" + suffix), i);
                            model.setValue("vatrate" + fieldSuffix, (Object)entry.getString("entryentity" + suffix + "confjson"), i);
                        }
                    } else if ("INCOME".equals(key) && ruleEntity.equals("entryentity")) {
                        model.setValue("acctentryentityjson", (Object)entry.getString("entryentityconfjson"), i);
                    } else if (("INCOME".equals(key) || "REDUCE".equals(key)) && (ruleEntity.equals("entryentity") || ruleEntity.equals("entryentity3") || ruleEntity.equals("entryentity11"))) {
                        model.setValue("vatrate" + fieldSuffix, (Object)entry.getString("vatrate" + suffix), i);
                    } else if ("JZJTSE".equals(key)) {
                        model.setValue("vatrate" + fieldSuffix, (Object)entry.getString("vatrate" + suffix), i);
                    }
                    if ("INCOME".equals(key)) {
                        model.setValue("exratejson" + fieldSuffix, (Object)entry.getString("exratejson" + suffix), i);
                        model.setValue("differenceinvoice" + fieldSuffix, (Object)entry.getString("differenceinvoice" + suffix), i);
                    }
                    if (!"MDTS".equals(key)) continue;
                    model.setValue("vatrate" + fieldSuffix, (Object)entry.getString("vatrate" + suffix), i);
                }
                model.endInit();
                this.getView().updateView(queryEntity);
            }
        } else {
            DynamicObjectCollection collection;
            String entryId = ruleEntity + ".id";
            String bizname = ruleEntity + ".bizname" + suffix;
            String table = ruleEntity + ".table" + suffix + ".bizname";
            String amountfield = ruleEntity + ".amountfield" + suffix + ".bizsubname";
            String datatype = ruleEntity + ".datatype" + suffix;
            String datadirection = ruleEntity + ".datadirection" + suffix;
            String filtercondition = ruleEntity + ".filtercondition" + suffix;
            QFilter filter = new QFilter("id", "=", id);
            filter.and(QFilter.isNotNull((String)entryId));
            model.beginInit();
            String selectFields = bizname + "," + table + "," + amountfield + "," + datatype + "," + datadirection + "," + filtercondition;
            String entryentityconfjson = ruleEntity + ".entryentity" + suffix + "confjson";
            String entryentityconf = ruleEntity + ".entryentity" + suffix + "conf";
            String vatrate = ruleEntity + ".vatrate" + suffix;
            String exratejson = ruleEntity + ".exratejson" + suffix;
            String differenceinvoice = ruleEntity + ".differenceinvoice" + suffix;
            if (key.equals("DEDUCT") && !"entryentity11".equals(ruleEntity)) {
                selectFields = bizname + "," + table + "," + amountfield + "," + datatype + "," + datadirection + "," + filtercondition + "," + entryentityconfjson + "," + entryentityconf;
            } else if ("INCOME".equals(key) && ruleEntity.equals("entryentity")) {
                entryentityconfjson = ruleEntity + ".entryentityconfjson";
                selectFields = bizname + "," + table + "," + amountfield + "," + datatype + "," + datadirection + "," + filtercondition + "," + entryentityconfjson;
            } else if (("INCOME".equals(key) || "REDUCE".equals(key)) && (ruleEntity.equals("entryentity") || ruleEntity.equals("entryentity3") || ruleEntity.equals("entryentity11"))) {
                selectFields = selectFields + "," + vatrate;
            } else if ("JZJTSE".equals(key)) {
                selectFields = selectFields + "," + vatrate;
            }
            if ("INCOME".equals(key)) {
                selectFields = selectFields + "," + exratejson + "," + differenceinvoice;
            }
            if ("MDTS".equals(key)) {
                selectFields = selectFields + "," + vatrate;
            }
            if (CollectionUtils.isNotEmpty((Collection)(collection = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{filter})))) {
                model.batchCreateNewEntryRow(queryEntity, collection.size());
            }
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject object = (DynamicObject)collection.get(i);
                model.setValue("bizname" + fieldSuffix, (Object)object.getString(bizname), i);
                model.setValue("table" + fieldSuffix, object.get(table), i);
                model.setValue("amountfield" + fieldSuffix, object.get(amountfield), i);
                model.setValue("datatype" + fieldSuffix, (Object)object.getString(datatype), i);
                model.setValue("datadirection" + fieldSuffix, (Object)object.getString(datadirection), i);
                model.setValue("filtercondition" + fieldSuffix, (Object)object.getString(filtercondition), i);
                if (key.equals("DEDUCT")) {
                    if ("entryentity11".equals(ruleEntity)) {
                        model.setValue("amountfield33", object.get(amountfield), i);
                    } else {
                        model.setValue(queryEntity + "json", (Object)object.getString(entryentityconfjson), i);
                        model.setValue("vatrate" + fieldSuffix, (Object)object.getString(entryentityconfjson), i);
                        model.setValue("entryentityconf" + fieldSuffix, (Object)object.getString(entryentityconf), i);
                    }
                } else if ("JZJTSE".equals(key)) {
                    model.setValue("vatrate" + fieldSuffix, (Object)object.getString(vatrate), i);
                } else if ("INCOME".equals(key) && ruleEntity.equals("entryentity")) {
                    model.setValue("acctentryentityjson", (Object)object.getString(entryentityconfjson), i);
                    model.setValue("vatrate" + fieldSuffix, (Object)object.getString(entryentityconfjson), i);
                } else if (("INCOME".equals(key) || "REDUCE".equals(key)) && (ruleEntity.equals("entryentity") || ruleEntity.equals("entryentity3") || ruleEntity.equals("entryentity11"))) {
                    model.setValue("vatrate" + fieldSuffix, (Object)object.getString(vatrate), i);
                }
                if ("INCOME".equals(key)) {
                    model.setValue("exratejson" + fieldSuffix, (Object)object.getString(exratejson), i);
                    model.setValue("differenceinvoice" + fieldSuffix, (Object)object.getString(differenceinvoice), i);
                }
                if (!"MDTS".equals(key)) continue;
                model.setValue("vatrate" + fieldSuffix, (Object)object.getString(vatrate), i);
            }
            model.endInit();
            this.getView().updateView(queryEntity);
        }
    }

    private void clearEntrySelectedStatus(String ... entrys) {
        for (String entry : entrys) {
            CardEntry cardEntry = (CardEntry)this.getView().getControl(entry);
            cardEntry.addSelectRowsListener((SelectRowsEventListener)this);
            cardEntry.selectRows(-1);
        }
    }

    private boolean isDeclared(String orgId, Date skssq) {
        DynamicObjectCollection seasonCollection;
        QFilter declareStatusFilter;
        QFilter dataTypeFilter;
        boolean isDeclared = false;
        QFilter orgFilter = new QFilter(ORG, "=", (Object)Long.parseLong(orgId));
        QFilter monthFilter = new QFilter("skssqq", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)skssq)).and("skssqz", "<=", (Object)DateUtils.getLastDateOfMonth((Date)skssq)).and("taxlimit", "=", (Object)"month");
        QFilter seasonFilter = new QFilter("skssqq", ">=", (Object)DateUtils.getFirstDateOfSeason((Date)skssq)).and("skssqz", "<=", (Object)DateUtils.getLastDateOfSeason((Date)skssq)).and("taxlimit", "=", (Object)"season");
        QFilter typeFilter = new QFilter("type", "in", (Object)Lists.newArrayList((Object[])new String[]{"zzsybnsr", "zzsxgmnsr", "zzsybnsr_yz_zjg", "zzsybnsr_yz_fzjg", "zzsybnsr_ybhz", "zzsybnsr_hz_zjg", "zzsybnsr_ybfz"}));
        QFilter[] filters = new QFilter[]{orgFilter, monthFilter, typeFilter, dataTypeFilter = new QFilter("datatype", "=", (Object)"1"), declareStatusFilter = new QFilter("declarestatus", "=", (Object)"declared")};
        DynamicObjectCollection monthCollection = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,declarestatus,taxlimit", (QFilter[])filters);
        isDeclared = CollectionUtils.isNotEmpty((Collection)monthCollection) ? true : CollectionUtils.isNotEmpty((Collection)(seasonCollection = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,declarestatus,taxlimit", (QFilter[])(filters = new QFilter[]{orgFilter, seasonFilter, typeFilter, dataTypeFilter, declareStatusFilter}))));
        return isDeclared;
    }

    private void loadHistory(DynamicObject org, Date startDate, Date endDate) {
        this.clearEntry(INCOMEENTRY, ROLLOUTENTRY, DIFFENTRY, DEDUCTIONTRY, ACCTENTRYENTITY, INVOICEENTRYENTITY, DEDUCTENTRY, JZJTSEENTRY, PERPREENTRY, MDTSENTRY);
        String skssqq = DateUtils.getFirstDateOfMonthStr((Date)startDate, (String)"yyyy-MM-dd");
        String skssqz = DateUtils.getLastDateOfMonthStr((Date)endDate, (String)"yyyy-MM-dd");
        String json = BaseDataHistoryService.queryBaseDataHistory((long)org.getLong("id"), (String)"tcvat_rule", (Date)DateUtils.stringToDate((String)skssqq), (Date)DateUtils.stringToDate((String)skssqz));
        if (!StringUtils.isEmpty((CharSequence)json)) {
            int index;
            JSONObject jsonObject;
            int i;
            if (!json.contains(WKPSEQS)) {
                String labelText = ResManager.loadKDString((String)"\u672a\u5f00\u7968\u6536\u5165\u53d6\u6570\u89c4\u5219", (String)"RuleQueryPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]);
                this.getView().setVisible(Boolean.FALSE, new String[]{QTFPBHSSRFLEX, ZYFPSEFLEX, QTFPSEFLEX, WKPFSEFLEX, ZYFPSEFLEX, INVOICESEQS, QTFPSEQS, WKPSEQS, ISWKPWSCL});
                Label labelap = (Label)this.getControl("labelap");
                labelap.setText(labelText);
            }
            JSONObject object = JSONObject.parseObject((String)json);
            JSONArray incomeRules = object.getJSONArray("INCOME");
            JSONArray rolloutRules = object.getJSONArray("ROLL_OUT");
            JSONArray diffRules = object.getJSONArray("DIFF");
            JSONArray reduceRules = object.getJSONArray("REDUCE");
            JSONArray deductRules = object.getJSONArray("DEDUCT");
            JSONArray jzjtseRules = object.getJSONArray("JZJTSE");
            JSONArray perpreRules = object.getJSONArray("PERPRE");
            JSONArray mdtsRules = object.getJSONArray("MDTS");
            Map jzjtMap = MetadataUtil.getComboItemsMap((String)TCVAT_N_ROLLOUTRULE, (String)"jzjt");
            if (incomeRules != null && incomeRules.size() > 0) {
                this.getModel().beginInit();
                for (i = 0; i < incomeRules.size(); ++i) {
                    jsonObject = incomeRules.getJSONObject(i);
                    this.getPageCache().put("INCOME" + jsonObject.getString("id"), SerializationUtils.toJsonString((Object)jsonObject));
                    index = this.getModel().createNewEntryRow(INCOMEENTRY);
                    this.getModel().setValue("incomeentryid", (Object)jsonObject.getLong("id"), index);
                    this.getModel().setValue("incomerulename", (Object)jsonObject.getJSONObject("name").getString("zh_CN"), index);
                    this.getModel().setValue("incomeruletaxation", (Object)jsonObject.getJSONObject("taxation").getJSONObject("name").getString("zh_CN"), index);
                    this.getModel().setValue("taxrate", (Object)jsonObject.getJSONObject("taxrate").getJSONObject("name").getString("zh_CN"), index);
                    this.getModel().setValue("incomeorg", (Object)jsonObject.getJSONObject(ORG).getString("name"), index);
                    this.getModel().setValue("incomejzjt", jzjtMap.get(jsonObject.getString("jzjt")), index);
                    this.getModel().setValue("incomeruletype", (Object)jsonObject.getString("ruletype"), index);
                    this.getModel().setValue("incomeenable", (Object)jsonObject.getString("enable"), index);
                }
                this.getModel().endInit();
                this.getView().updateView(INCOMEENTRY);
            }
            if (rolloutRules != null && rolloutRules.size() > 0) {
                this.getModel().beginInit();
                for (i = 0; i < rolloutRules.size(); ++i) {
                    jsonObject = rolloutRules.getJSONObject(i);
                    this.getPageCache().put("ROLL_OUT" + jsonObject.getString("id"), SerializationUtils.toJsonString((Object)jsonObject));
                    index = this.getModel().createNewEntryRow(ROLLOUTENTRY);
                    this.getModel().setValue("rolloutentryid", (Object)jsonObject.getLong("id"), index);
                    this.getModel().setValue("rollouttype", (Object)jsonObject.getJSONObject("rollouttype").getString("value"), index);
                    this.getModel().setValue("rolloutrulename", (Object)jsonObject.getJSONObject("name").getString("zh_CN"), index);
                    this.getModel().setValue("rolloutorg", (Object)jsonObject.getJSONObject(ORG).getJSONObject("name").getString("zh_CN"), index);
                    this.getModel().setValue("rolloutjzjt", jzjtMap.get(jsonObject.getString("jzjt")), index);
                    this.getModel().setValue("rolloutruletype", (Object)jsonObject.getString("ruletype"), index);
                    this.getModel().setValue("rolloutenable", (Object)jsonObject.getString("enable"), index);
                }
                this.getModel().endInit();
                this.getView().updateView(ROLLOUTENTRY);
            }
            if (diffRules != null && diffRules.size() > 0) {
                this.getModel().beginInit();
                for (i = 0; i < diffRules.size(); ++i) {
                    jsonObject = diffRules.getJSONObject(i);
                    this.getPageCache().put("DIFF" + jsonObject.getString("id"), SerializationUtils.toJsonString((Object)jsonObject));
                    index = this.getModel().createNewEntryRow(DIFFENTRY);
                    this.getModel().setValue("diffentryid", (Object)jsonObject.getLong("id"), index);
                    this.getModel().setValue("difftype", (Object)jsonObject.getJSONObject("difftype").getString("value"), index);
                    this.getModel().setValue("diffrulename", (Object)jsonObject.getJSONObject("name").getString("zh_CN"), index);
                    this.getModel().setValue("difforg", (Object)jsonObject.getJSONObject(ORG).getJSONObject("name").getString("zh_CN"), index);
                    this.getModel().setValue("diffjzjt", jzjtMap.get(jsonObject.getString("jzjt")), index);
                    this.getModel().setValue("diffruletype", (Object)jsonObject.getString("ruletype"), index);
                    this.getModel().setValue("diffenable", (Object)jsonObject.getString("enable"), index);
                }
                this.getModel().endInit();
                this.getView().updateView(DIFFENTRY);
            }
            if (reduceRules != null && reduceRules.size() > 0) {
                this.getModel().beginInit();
                for (i = 0; i < reduceRules.size(); ++i) {
                    jsonObject = reduceRules.getJSONObject(i);
                    this.getPageCache().put("REDUCE" + jsonObject.getString("id"), SerializationUtils.toJsonString((Object)jsonObject));
                    index = this.getModel().createNewEntryRow(DEDUCTIONTRY);
                    this.getModel().setValue("deductionentryid", (Object)jsonObject.getLong("id"), index);
                    this.getModel().setValue("deductionrulename", (Object)jsonObject.getJSONObject("name").getString("zh_CN"), index);
                    this.getModel().setValue("deductiontype", (Object)jsonObject.getString("reductiontype"), index);
                    this.getModel().setValue("deductionruletype", (Object)jsonObject.getString("ruletype"), index);
                    this.getModel().setValue("deductionenable", (Object)jsonObject.getString("enable"), index);
                }
                this.getModel().endInit();
                this.getView().updateView(DEDUCTIONTRY);
            }
            if (deductRules != null && !deductRules.isEmpty()) {
                this.getModel().beginInit();
                for (i = 0; i < deductRules.size(); ++i) {
                    jsonObject = deductRules.getJSONObject(i);
                    this.getPageCache().put("DEDUCT" + jsonObject.getString("id"), SerializationUtils.toJsonString((Object)jsonObject));
                    index = this.getModel().createNewEntryRow(DEDUCTENTRY);
                    this.getModel().setValue("deductentryid", (Object)jsonObject.getLong("id"), index);
                    this.getModel().setValue("deductrulename", (Object)jsonObject.getJSONObject("name").getString("zh_CN"), index);
                    this.getModel().setValue("deductorg", (Object)jsonObject.getJSONObject(ORG).getJSONObject("name").getString("zh_CN"), index);
                    this.getModel().setValue("deducttype", (Object)jsonObject.getJSONObject("deducttype").getJSONObject("name").getString("zh_CN"), index);
                    this.getModel().setValue("deductjzjt", jzjtMap.get(jsonObject.getString("jzjt")), index);
                    this.getModel().setValue("deductruletype", (Object)jsonObject.getString("ruletype"), index);
                    this.getModel().setValue("deductenable", (Object)jsonObject.getString("enable"), index);
                }
                this.getModel().endInit();
                this.getView().updateView(DEDUCTENTRY);
            }
            if (jzjtseRules != null && !jzjtseRules.isEmpty()) {
                this.getModel().beginInit();
                for (i = 0; i < jzjtseRules.size(); ++i) {
                    jsonObject = jzjtseRules.getJSONObject(i);
                    this.getPageCache().put("JZJTSE" + jsonObject.getString("id"), SerializationUtils.toJsonString((Object)jsonObject));
                    index = this.getModel().createNewEntryRow(JZJTSEENTRY);
                    this.getModel().setValue("jzjtseentryid", (Object)jsonObject.getLong("id"), index);
                    this.getModel().setValue("jzjtserulename", (Object)jsonObject.getJSONObject("name").getString("zh_CN"), index);
                    this.getModel().setValue("jzjtseorg", (Object)jsonObject.getJSONObject(ORG).getJSONObject("name").getString("zh_CN"), index);
                    this.getModel().setValue("jzjtsejzjtlx", (Object)jsonObject.getString("jzjtlx"), index);
                    this.getModel().setValue("jzjtseruletype", (Object)jsonObject.getString("ruletype"), index);
                    this.getModel().setValue("jzjtseenable", (Object)jsonObject.getString("enable"), index);
                }
                this.getModel().endInit();
                this.getView().updateView(JZJTSEENTRY);
            }
            if (perpreRules != null && perpreRules.size() > 0) {
                this.getModel().beginInit();
                for (i = 0; i < perpreRules.size(); ++i) {
                    jsonObject = perpreRules.getJSONObject(i);
                    this.getPageCache().put("PERPRE" + jsonObject.getString("id"), SerializationUtils.toJsonString((Object)jsonObject));
                    index = this.getModel().createNewEntryRow(PERPREENTRY);
                    this.getModel().setValue("perpreentryid", (Object)jsonObject.getLong("id"), index);
                    this.getModel().setValue("perpreproject", (Object)jsonObject.getJSONObject("perpreproduct").getString("value"), index);
                    this.getModel().setValue("perprerulename", (Object)jsonObject.getJSONObject("name").getString("zh_CN"), index);
                    this.getModel().setValue("perpreruletype", (Object)jsonObject.getString("ruletype"), index);
                    this.getModel().setValue("perpreenable", (Object)jsonObject.getString("enable"), index);
                }
                this.getModel().endInit();
                this.getView().updateView(PERPREENTRY);
            }
            if (mdtsRules != null && mdtsRules.size() > 0) {
                ComboProp mdTypeProp = (ComboProp)MetadataServiceHelper.getDataEntityType((String)TCVAT_N_MDTSRULE).getProperty("mdtype");
                this.getModel().beginInit();
                for (int i2 = 0; i2 < mdtsRules.size(); ++i2) {
                    JSONObject jsonObject2 = mdtsRules.getJSONObject(i2);
                    this.getPageCache().put("MDTS" + jsonObject2.getString("id"), SerializationUtils.toJsonString((Object)jsonObject2));
                    int index2 = this.getModel().createNewEntryRow(MDTSENTRY);
                    this.getModel().setValue("mdtsentryid", (Object)jsonObject2.getLong("id"), index2);
                    this.getModel().setValue("mdtsorg", (Object)jsonObject2.getJSONObject(ORG).getJSONObject("name").getString("zh_CN"), index2);
                    this.getModel().setValue("mdtype", (Object)mdTypeProp.getItemByName(jsonObject2.getString("mdtype")), index2);
                    this.getModel().setValue("mdtsrulename", (Object)jsonObject2.getJSONObject("name").getString("zh_CN"), index2);
                    this.getModel().setValue("mdtsruletype", (Object)jsonObject2.getString("ruletype"), index2);
                    this.getModel().setValue("mdtsenable", (Object)jsonObject2.getString("enable"), index2);
                }
                this.getModel().endInit();
                this.getView().updateView(MDTSENTRY);
            }
            if (CollectionUtils.isNotEmpty((Collection)incomeRules)) {
                this.initSelect(INCOMEENTRY, 0);
            } else if (CollectionUtils.isNotEmpty((Collection)rolloutRules)) {
                this.initSelect(ROLLOUTENTRY, 0);
            } else if (CollectionUtils.isNotEmpty((Collection)diffRules)) {
                this.initSelect(DIFFENTRY, 0);
            } else if (CollectionUtils.isNotEmpty((Collection)perpreRules)) {
                this.initSelect(PERPREENTRY, 0);
            } else if (CollectionUtils.isNotEmpty((Collection)mdtsRules)) {
                this.initSelect(MDTSENTRY, 0);
            }
        }
        this.visibleEntry(INCOMEENTRY, ROLLOUTENTRY, DIFFENTRY, DEDUCTIONTRY, DEDUCTENTRY, JZJTSEENTRY, PERPREENTRY, MDTSENTRY);
    }

    private void refreshRules() {
        this.clearEntry(INCOMEENTRY, ROLLOUTENTRY, DIFFENTRY, DEDUCTIONTRY, DEDUCTENTRY, JZJTSEENTRY, ACCTENTRYENTITY, INVOICEENTRYENTITY, QTFPBHSSRENTRYENTITY, ZYFPSEENTRYENTITY, QTFPSEENTRYENTITY, WKPFSEENTRYENTITY, PERPREENTRY, MDTSENTRY);
        this.getView().setVisible(Boolean.TRUE, new String[]{ACCTFLEX, INVOICEFLEX, ZYFPSEFLEX, QTFPBHSSRFLEX, QTFPSEFLEX, WKPFSEFLEX, ZYFPSEFLEX, INVOICESEQS, QTFPSEQS, WKPSEQS, ISWKPWSCL});
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        Date searchMonth = (Date)this.getModel().getValue(SEARCHMONTH);
        Date skssqq = DateUtils.getFirstDateOfMonth((Date)searchMonth);
        Date skssqz = DateUtils.getLastDateOfMonth((Date)searchMonth);
        boolean isShowHis = false;
        if (null != this.getView().getParentView() && (isShowHis = "tcvat_declare_show".equals(this.getView().getParentView().getEntityId()))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
            org = (DynamicObject)this.getView().getParentView().getModel().getValue(ORG);
            skssqq = (Date)this.getView().getParentView().getModel().getValue("skssqq");
            skssqz = (Date)this.getView().getParentView().getModel().getValue("skssqz");
        }
        if (org == null) {
            return;
        }
        boolean isDeclared = false;
        if (!"sjjt".equals(this.getModel().getValue(RULE_PURPOSE))) {
            isDeclared = this.isDeclared(org.getString("id"), searchMonth);
        }
        this.getPageCache().put("isDeclared", String.valueOf(isDeclared || isShowHis));
        if (isDeclared || isShowHis) {
            this.loadHistory(org, skssqq, skssqz);
        } else {
            this.loadCurrent(org);
        }
    }

    private void loadCurrent(DynamicObject org) {
        Boolean showdisable = (Boolean)this.getModel().getValue(SHOWDISABLE);
        String rulePurpose = (String)this.getModel().getValue("rulePurpose");
        Map sharingAndOrgRules = RuleUtils.getSharingAndOrgRules(Collections.singletonList(org.getLong("id")), null, (RuleTypeEnum)RuleTypeEnum.ALL, (Boolean)showdisable, null, (String)rulePurpose);
        Map jzjtMap = MetadataUtil.getComboItemsMap((String)TCVAT_N_ROLLOUTRULE, (String)"jzjt");
        List incomeRuleList = (List)sharingAndOrgRules.get(RuleTypeEnum.INCOME);
        this.loadIncomeRule(incomeRuleList, jzjtMap);
        List rolloutRuleList = (List)sharingAndOrgRules.get(RuleTypeEnum.ROLL_OUT);
        this.loadRollRule(rolloutRuleList, jzjtMap);
        List diffRuleList = (List)sharingAndOrgRules.get(RuleTypeEnum.DIFF);
        this.loadDiffRule(diffRuleList, jzjtMap);
        List deductionRuleList = (List)sharingAndOrgRules.get(RuleTypeEnum.REDUCE);
        this.loadDeductionRule(deductionRuleList);
        List deductRuleList = (List)sharingAndOrgRules.get(RuleTypeEnum.DEDUCT);
        this.loadDeductRule(deductRuleList, jzjtMap);
        List jzjtseRuleList = (List)sharingAndOrgRules.get(RuleTypeEnum.JZJTSE);
        this.loadJzjtseRule(jzjtseRuleList);
        List perpreRuleList = (List)sharingAndOrgRules.get(RuleTypeEnum.PERPRE);
        this.loadPerpreRule(perpreRuleList);
        List mdtsRuleList = (List)sharingAndOrgRules.get(RuleTypeEnum.MDTS);
        this.loadMdtsRule(mdtsRuleList);
        if (CollectionUtils.isNotEmpty((Collection)incomeRuleList)) {
            this.initSelect(INCOMEENTRY, 0);
        } else if (CollectionUtils.isNotEmpty((Collection)rolloutRuleList)) {
            this.initSelect(ROLLOUTENTRY, 0);
        } else if (CollectionUtils.isNotEmpty((Collection)diffRuleList)) {
            this.initSelect(DIFFENTRY, 0);
        } else if (CollectionUtils.isNotEmpty((Collection)deductionRuleList)) {
            this.initSelect(DEDUCTIONTRY, 0);
        } else if (CollectionUtils.isNotEmpty((Collection)deductRuleList)) {
            this.initSelect(DEDUCTENTRY, 0);
        } else if (CollectionUtils.isNotEmpty((Collection)perpreRuleList)) {
            this.initSelect(PERPREENTRY, 0);
        } else if (CollectionUtils.isNotEmpty((Collection)mdtsRuleList)) {
            this.initSelect(MDTSENTRY, 0);
        }
        this.visibleEntry(INCOMEENTRY, ROLLOUTENTRY, DIFFENTRY, DEDUCTIONTRY, DEDUCTENTRY, JZJTSEENTRY, PERPREENTRY, MDTSENTRY);
    }

    private void initSelect(String entry, int row) {
        ArrayList<Integer> newList = new ArrayList<Integer>();
        newList.add(row);
        ArrayList<Integer> oldList = new ArrayList<Integer>();
        oldList.add(-1);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(entry);
        cardEntry.selectRowsChanged(newList, oldList);
        cardEntry.selectCard(Integer.valueOf(row));
    }

    private void loadIncomeRule(List<DynamicObject> ruleList, Map<String, String> jzjtMap) {
        if (CollectionUtils.isNotEmpty(ruleList)) {
            this.getModel().beginInit();
            for (DynamicObject object : ruleList) {
                int index = this.getModel().createNewEntryRow(INCOMEENTRY);
                this.getModel().setValue("incomerulename", (Object)object.getString("name"), index);
                this.getModel().setValue("incomeruletaxation", (Object)object.getDynamicObject("taxation").getString("name"), index);
                this.getModel().setValue("taxrate", (Object)object.getDynamicObject("taxrate").getString("name"), index);
                this.getModel().setValue("incomeorg", (Object)object.getDynamicObject(ORG).getString("name"), index);
                this.getModel().setValue("incomejzjt", (Object)jzjtMap.get(object.getString("jzjt")), index);
                this.getModel().setValue("incomeruletype", (Object)object.getString("ruletype"), index);
                this.getModel().setValue("incomeenable", (Object)object.getString("enable"), index);
                this.getModel().setValue("incomeentryid", object.get("id"), index);
            }
            this.getModel().endInit();
            this.getView().updateView(INCOMEENTRY);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{INCOMEENTRY});
        }
    }

    private void loadRollRule(List<DynamicObject> ruleList, Map<String, String> jzjtMap) {
        if (CollectionUtils.isNotEmpty(ruleList)) {
            this.getModel().beginInit();
            for (DynamicObject object : ruleList) {
                int index = this.getModel().createNewEntryRow(ROLLOUTENTRY);
                this.getModel().setValue("rolloutrulename", (Object)object.getString("name"), index);
                this.getModel().setValue("rollouttype", (Object)object.getDynamicObject("rollouttype").getString("value"), index);
                this.getModel().setValue("rolloutorg", (Object)object.getDynamicObject(ORG).getString("name"), index);
                this.getModel().setValue("rolloutjzjt", (Object)jzjtMap.get(object.getString("jzjt")), index);
                this.getModel().setValue("rolloutruletype", (Object)object.getString("ruletype"), index);
                this.getModel().setValue("rolloutenable", (Object)object.getString("enable"), index);
                this.getModel().setValue("rolloutentryid", object.get("id"), index);
            }
            this.getModel().endInit();
            this.getView().updateView(ROLLOUTENTRY);
        }
    }

    private void loadDiffRule(List<DynamicObject> ruleList, Map<String, String> jzjtMap) {
        if (CollectionUtils.isNotEmpty(ruleList)) {
            this.getModel().beginInit();
            for (DynamicObject object : ruleList) {
                int index = this.getModel().createNewEntryRow(DIFFENTRY);
                this.getModel().setValue("diffrulename", (Object)object.getString("name"), index);
                this.getModel().setValue("difftype", (Object)object.getDynamicObject("difftype").getString("value"), index);
                this.getModel().setValue("difforg", (Object)object.getDynamicObject(ORG).getString("name"), index);
                this.getModel().setValue("diffjzjt", (Object)jzjtMap.get(object.getString("jzjt")), index);
                this.getModel().setValue("diffruletype", (Object)object.getString("ruletype"), index);
                this.getModel().setValue("diffenable", (Object)object.getString("enable"), index);
                this.getModel().setValue("diffentryid", object.get("id"), index);
            }
            this.getModel().endInit();
            this.getView().updateView(DIFFENTRY);
        }
    }

    private void loadDeductionRule(List<DynamicObject> ruleList) {
        if (CollectionUtils.isNotEmpty(ruleList)) {
            this.getModel().beginInit();
            for (DynamicObject object : ruleList) {
                int index = this.getModel().createNewEntryRow(DEDUCTIONTRY);
                this.getModel().setValue("deductionrulename", (Object)object.getString("name"), index);
                this.getModel().setValue("deductiontype", (Object)object.getString("reductiontype"), index);
                this.getModel().setValue("deductionruletype", (Object)object.getString("ruletype"), index);
                this.getModel().setValue("deductionenable", (Object)object.getString("enable"), index);
                this.getModel().setValue("deductionentryid", object.get("id"), index);
            }
            this.getModel().endInit();
            this.getView().updateView(DEDUCTIONTRY);
        }
    }

    private void loadJzjtseRule(List<DynamicObject> ruleList) {
        if (CollectionUtils.isNotEmpty(ruleList)) {
            this.getModel().beginInit();
            for (DynamicObject object : ruleList) {
                int index = this.getModel().createNewEntryRow(JZJTSEENTRY);
                this.getModel().setValue("jzjtserulename", (Object)object.getString("name"), index);
                this.getModel().setValue("jzjtseruletype", (Object)object.getString("ruletype"), index);
                this.getModel().setValue("jzjtseorg", (Object)object.getDynamicObject(ORG).getString("name"), index);
                this.getModel().setValue("jzjtseenable", (Object)object.getString("enable"), index);
                this.getModel().setValue("jzjtsejzjtlx", (Object)object.getString("jzjtlx"), index);
                this.getModel().setValue("jzjtseentryid", object.get("id"), index);
            }
            this.getModel().endInit();
            this.getView().updateView(JZJTSEENTRY);
        }
    }

    private void loadDeductRule(List<DynamicObject> ruleList, Map<String, String> jzjtMap) {
        if (CollectionUtils.isNotEmpty(ruleList)) {
            this.getModel().beginInit();
            for (DynamicObject object : ruleList) {
                int index = this.getModel().createNewEntryRow(DEDUCTENTRY);
                this.getModel().setValue("deductrulename", (Object)object.getString("name"), index);
                this.getModel().setValue("deducttype", (Object)object.getString("deducttype.name"), index);
                this.getModel().setValue("deductruletype", (Object)object.getString("ruletype"), index);
                this.getModel().setValue("deductorg", (Object)object.getDynamicObject(ORG).getString("name"), index);
                this.getModel().setValue("deductjzjt", (Object)jzjtMap.get(object.getString("jzjt")), index);
                this.getModel().setValue("deductenable", (Object)object.getString("enable"), index);
                this.getModel().setValue("deductentryid", object.get("id"), index);
            }
            this.getModel().endInit();
            this.getView().updateView(DEDUCTENTRY);
        }
    }

    private void loadPerpreRule(List<DynamicObject> ruleList) {
        if (CollectionUtils.isNotEmpty(ruleList)) {
            this.getModel().beginInit();
            for (DynamicObject object : ruleList) {
                int index = this.getModel().createNewEntryRow(PERPREENTRY);
                this.getModel().setValue("perprerulename", (Object)object.getString("name"), index);
                this.getModel().setValue("perpreproject", (Object)object.getDynamicObject("perpreproduct").getString("value"), index);
                this.getModel().setValue("perpreruletype", (Object)object.getString("ruletype"), index);
                this.getModel().setValue("perpreenable", (Object)object.getString("enable"), index);
                this.getModel().setValue("perpreentryid", object.get("id"), index);
            }
            this.getModel().endInit();
            this.getView().updateView(PERPREENTRY);
        }
    }

    private void loadMdtsRule(List<DynamicObject> ruleList) {
        if (CollectionUtils.isNotEmpty(ruleList)) {
            ComboProp mdTypeProp = (ComboProp)MetadataServiceHelper.getDataEntityType((String)TCVAT_N_MDTSRULE).getProperty("mdtype");
            this.getModel().beginInit();
            for (DynamicObject object : ruleList) {
                int index = this.getModel().createNewEntryRow(MDTSENTRY);
                this.getModel().setValue("mdtsrulename", (Object)object.getString("name"), index);
                this.getModel().setValue("mdtype", (Object)mdTypeProp.getItemByName(object.getString("mdtype")), index);
                this.getModel().setValue("mdtsruletype", (Object)object.getString("ruletype"), index);
                this.getModel().setValue("mdtsenable", (Object)object.getString("enable"), index);
                this.getModel().setValue("mdtsorg", (Object)object.getDynamicObject(ORG).getString("name"), index);
                this.getModel().setValue("mdtsentryid", object.get("id"), index);
            }
            this.getModel().endInit();
            this.getView().updateView(MDTSENTRY);
        }
    }

    private void visibleEntry(String ... entryNames) {
        for (String entry : entryNames) {
            int count = this.getModel().getEntryRowCount(entry);
            if (count == 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{entry});
                continue;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{entry});
        }
    }

    private void clearEntry(String ... entryNames) {
        for (String entry : entryNames) {
            this.getModel().deleteEntryData(entry);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object ruletype = this.getModel().getValue("ruletype");
        if (args.getSource() instanceof Donothing) {
            String operateKey = ((Donothing)args.getSource()).getOperateKey();
            EntryGrid entryentity = (EntryGrid)this.getControl(operateKey);
            if (null == entryentity) {
                return;
            }
            int focusRow = entryentity.getEntryState().getFocusRow();
            String datatype = "";
            String key = operateKey;
            String entitySuffix = "";
            String vatrate = "";
            if (operateKey.equals(WKPFSEENTRYENTITY)) {
                vatrate = this.getModel().getValue("vatrate3", focusRow).toString();
                datatype = (String)this.getModel().getValue("datatype3", focusRow);
                entitySuffix = "3";
            } else if (operateKey.equals(QTFPBHSSRENTRYENTITY)) {
                datatype = (String)this.getModel().getValue("datatype1", focusRow);
                entitySuffix = "1";
            } else if (operateKey.equals(QTFPSEENTRYENTITY)) {
                datatype = (String)this.getModel().getValue("datatype11", focusRow);
                entitySuffix = "11";
                vatrate = this.getModel().getValue("vatrate11", focusRow).toString();
            } else if (operateKey.equals(ACCTENTRYENTITY)) {
                if (ruletype != null && (ruletype.equals(DEDUCTENTRY) || ruletype.equals(JZJTSEENTRY) || ruletype.equals(MDTSENTRY))) {
                    vatrate = this.getModel().getValue("vatrate", focusRow).toString();
                } else if (ruletype != null && ruletype.equals(INCOMEENTRY)) {
                    vatrate = (String)this.getModel().getValue(operateKey + "json", focusRow);
                    datatype = (String)this.getModel().getValue("datatype", focusRow);
                    entitySuffix = "";
                } else if (ruletype != null && ruletype.equals(DEDUCTIONTRY)) {
                    vatrate = this.getModel().getValue("vatrate", focusRow).toString();
                }
            } else if (operateKey.equals(INVOICEENTRYENTITY)) {
                entitySuffix = "12";
            } else if (operateKey.equals(ZYFPSEENTRYENTITY)) {
                datatype = (String)this.getModel().getValue("datatype2", focusRow);
                entitySuffix = "2";
                vatrate = this.getModel().getValue("vatrate2", focusRow).toString();
            } else {
                vatrate = (String)this.getModel().getValue(operateKey + "json", focusRow);
            }
            if (INCOMEENTRY.equals(ruletype)) {
                this.openAdvancedConfPageNew(vatrate, operateKey, datatype, key, entitySuffix, focusRow);
            } else {
                this.openAdvancedConfPage(vatrate, operateKey);
            }
        }
    }

    private void openAdvancedConfPageNew(String vatrate, String actionId, String datatype, String key, String entitySuffix, int focusRow) {
        AdvanceConfDto advanceConfDto = new AdvanceConfDto();
        advanceConfDto.setDatatype(datatype);
        advanceConfDto.setVatrate(StringUtil.isEmpty((CharSequence)vatrate) ? BigDecimal.ZERO : new BigDecimal(vatrate));
        advanceConfDto.setAdvanceconfKey(key);
        advanceConfDto.setOnlyRead(Boolean.valueOf(true));
        Boolean differenceInvoice = (Boolean)this.getModel().getValue("differenceinvoice" + entitySuffix, focusRow);
        if (!"12".equals(entitySuffix)) {
            String exratejson = (String)this.getModel().getValue("exratejson" + entitySuffix, focusRow);
            advanceConfDto.setConvertExrateJson(exratejson);
        }
        advanceConfDto.setDifferenceInvoice(differenceInvoice);
        String tableName = (String)this.getModel().getValue("table" + entitySuffix, focusRow);
        advanceConfDto.setTableNumber(this.setTableName(tableName));
        RuleTemplateService.openAdvancedConfPage((AdvanceConfDto)advanceConfDto, (IFormView)this.getView(), (int)0, (long)0L, (String)"", (String)actionId, (IFormPlugin)this, (String)"");
    }

    private String setTableName(String tableName) {
        if (tableName.contains(ResManager.loadKDString((String)"\u9500\u9879\u53d1\u7968\u8868", (String)"RuleQueryPlugin_9", (String)"taxc-tcvat", (Object[])new Object[0])) || tableName.contains(ResManager.loadKDString((String)"\u9500\u9879\u5373\u5f81\u5373\u9000\u6807\u8bc6", (String)"RuleQueryPlugin_14", (String)"taxc-tcvat", (Object[])new Object[0]))) {
            return "sim_vatinvoice";
        }
        return tableName;
    }

    private void openAdvancedConfPage(String vatrate, String actionId) {
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("tcvat_advance_config");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formshowParameter.getCustomParams().put("vatrate", vatrate);
        formshowParameter.getCustomParams().put("type", "read");
        this.getView().showForm(formshowParameter);
    }

    static enum EntityEnum {
        QTFPBHSSR("entryentity1", "qtfpbhssrentryentity", "1"),
        QTFPSE("entryentity11", "qtfpseentryentity", "11"),
        WKFPBHSSR("entryentity", "acctentryentity", ""),
        WKPSE("entryentity3", "wkpseentryentity", "3"),
        ZYFPSE("entryentity2", "zyfpseentryentity", "2");

        private String ruleEntity;
        private String queryEntity;
        private String fieldSuffix;

        private EntityEnum(String ruleEntity, String queryEntity, String fieldSuffix) {
            this.ruleEntity = ruleEntity;
            this.queryEntity = queryEntity;
            this.fieldSuffix = fieldSuffix;
        }
    }
}

