/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.tree.SearchUtil;
import kd.taxc.tcvat.business.service.rule.RuleService;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractRuleConfigPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TabSelectListener {
    public static Log logger = LogFactory.getLog(AbstractRuleConfigPlugin.class);
    public static String TREE_ORG = "treeviewap";
    public static final String CURRENT_NODE = "CURRENT_NODE";
    public static final String RULE_TYPE = "ruleType";
    public static final String MENU_TYPE = "menutype";
    public static final String CURRENT_TAB = "CURRENT_TAB";
    public RuleService ruleService = new RuleService();

    public void initialize() {
        TreeView tree = (TreeView)this.getView().getControl(TREE_ORG);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void registerListener(EventObject e) {
        Search sl = (Search)this.getControl("entitysearchap");
        sl.addEnterListener(this::orgSearchListener);
        this.addItemClickListeners(new String[]{"toolbarap"});
        Tab tabap = (Tab)this.getControl("tabap");
        tabap.addTabSelectListener((TabSelectListener)this);
    }

    private void orgSearchListener(SearchEnterEvent event) {
        IPageCache pageCache = this.getPageCache();
        String treeCache = pageCache.get(TREE_ORG);
        if (treeCache == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"AbstractRuleConfigPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeCache, TreeNode.class);
        ArrayList<String> dataKey = new ArrayList<String>();
        dataKey.add("number");
        List nodes = SearchUtil.getList((String)event.getText(), (TreeNode)root, dataKey);
        if (!nodes.isEmpty()) {
            TreeView treeView = (TreeView)this.getView().getControl(TREE_ORG);
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)((TreeNode)nodes.get(0)).getId());
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"AbstractRuleConfigPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        String ruleType = (String)showParameter.getCustomParams().get("ruletype");
        String pageName = "public".equals(ruleType) ? ResManager.loadKDString((String)"\u7533\u62a5\u9879\u89c4\u5219\u914d\u7f6e\uff08\u5171\u4eab\uff09", (String)"AbstractRuleConfigPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7533\u62a5\u9879\u89c4\u5219\u914d\u7f6e", (String)"AbstractRuleConfigPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]);
        showParameter.setCaption(pageName);
    }

    public void afterCreateNewData(EventObject e) {
        String ruletype = this.getView().getFormShowParameter().getCustomParams().getOrDefault("ruletype", "private");
        this.getPageCache().put(RULE_TYPE, ruletype);
        String menuType = (String)this.getView().getFormShowParameter().getCustomParams().get(MENU_TYPE);
        this.getPageCache().put(MENU_TYPE, menuType);
        TreeView treeView = (TreeView)this.getView().getControl(TREE_ORG);
        IFormView view = this.getView();
        IPageCache cache = this.getPageCache();
        OrgUtils.buildOrgTree((IFormView)view, (TreeView)treeView, (IPageCache)cache);
        this.checkNode(treeView, cache);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("refresh".equals(itemKey)) {
            this.refreshData();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        this.refreshData();
    }

    public void refreshData() {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_ORG);
        treeView.deleteAllNodes();
        IFormView view = this.getView();
        IPageCache cache = this.getPageCache();
        OrgUtils.buildOrgTree((IFormView)view, (TreeView)treeView, (IPageCache)cache);
        this.checkNode(treeView, cache);
    }

    public void checkNode(TreeView treeView, IPageCache cache) {
        String status;
        Object orgid = this.getView().getFormShowParameter().getCustomParam("orgid");
        String currentTab = (String)this.getView().getFormShowParameter().getCustomParam(CURRENT_TAB);
        if (currentTab != null) {
            this.getPageCache().put(CURRENT_TAB, currentTab);
            Tab tabap = (Tab)this.getControl("tabap");
            tabap.activeTab(currentTab);
        }
        if (orgid != null) {
            TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)String.valueOf(orgid));
            return;
        }
        if (cache.get(CURRENT_NODE) != null && "1".equals(status = OrgUtils.getOrgStatusById((String)cache.get(CURRENT_NODE))) && ((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)Long.valueOf(cache.get(CURRENT_NODE))).getData()).booleanValue()) {
            TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)cache.get(CURRENT_NODE));
            return;
        }
        DynamicObject org = null;
        try {
            org = (DynamicObject)this.getView().getParentView().getModel().getValue("org");
        }
        catch (Exception ee) {
            logger.error((Throwable)ee);
            org = null;
        }
        if (org != null && "1".equals(org.getString("enable")) && ((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).getData()).booleanValue()) {
            TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)org.getString("id"));
        } else {
            orgid = RequestContext.get().getOrgId();
            try {
                String status2 = OrgUtils.getOrgStatusById((String)String.valueOf(orgid));
                if ("1".equals(status2)) {
                    HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
                    if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(orgid)) {
                        String orgname = OrgUtils.getOrgNameById((String)String.valueOf(orgid));
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractRuleConfigPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]), orgname));
                        return;
                    }
                    TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)String.valueOf(orgid));
                    return;
                }
            }
            catch (Exception e) {
                logger.error("\u5f53\u524d\u7528\u6237\u4e1a\u52a1\u5355\u5143 \u4e0d\u5728 \u7a0e\u52a1\u4e91\u91cc ", (Throwable)e);
            }
            TreeUtils.checkFirstNode((IPageCache)cache, (TreeView)treeView);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String args = e.getEventArgs();
        Map argsMap = (Map)SerializationUtils.fromJsonString((String)args, Map.class);
        String eventName = e.getEventName();
        if ("addNewRule".equals(eventName)) {
            Tab tabap = (Tab)this.getControl("tabap");
            String currentTab = ObjectUtils.isNotEmpty((Object)tabap) ? tabap.getCurrentTab() : "";
            String formId = this.getNewRuleFormId(currentTab);
            this.openRuleForm(formId, null, (String)argsMap.get("ruletype"));
        }
    }

    public abstract String getNewRuleFormId(String var1);

    public void openRuleForm(String formId, Object pkid, String ruletype) {
        String orgId = this.getPageCache().get(CURRENT_NODE);
        String taxPayerType = this.getPageCache().get("taxpayertype");
        if (StringUtils.isEmpty((CharSequence)orgId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u5de6\u8fb9\u7ec4\u7ec7\u6811\u4e0a\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"AbstractRuleConfigPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        if (!this.checkBeforeOpenRuleForm(ruletype, orgId)) {
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId(formId);
        if (pkid == null) {
            showParameter.setBillStatus(BillOperationStatus.ADDNEW);
        } else {
            showParameter.setBillStatus(BillOperationStatus.EDIT);
            showParameter.setPkId(pkid);
        }
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("orgid", orgId);
        customParams.put("ruletype", (String)this.getView().getFormShowParameter().getCustomParams().get("ruletype"));
        customParams.put("taxpayertype", taxPayerType);
        showParameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, formId);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setStatus("1".equals(ruletype) ? OperationStatus.VIEW : OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public boolean checkBeforeOpenRuleForm(String ruletype, String orgId) {
        return true;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        DynamicObject dy;
        HasPermOrgResult hasPermOrgResult;
        String nodeId = evt.getNodeId().toString();
        IPageCache pageCache = this.getPageCache();
        String current = this.getPageCache().get(CURRENT_NODE);
        TreeView treeView = (TreeView)this.getControl(TREE_ORG);
        TreeNode treeNode = TreeUtils.getTreeNode((IPageCache)pageCache, (TreeView)treeView, (String)nodeId);
        if (treeNode == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u5de6\u8fb9\u7ec4\u7ec7\u6811\u4e0a\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"AbstractRuleConfigPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        if (nodeId.equals(current)) {
            current = null;
            this.getPageCache().put(CURRENT_NODE, "0");
        }
        if (!(hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView())).hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(nodeId))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractRuleConfigPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]), treeNode.getText()));
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
            return;
        }
        if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)Long.valueOf(nodeId)).getData()).booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"AbstractRuleConfigPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(Long.parseLong(nodeId)));
        if (EmptyCheckUtils.isNotEmpty((Object)result.getData()) && EmptyCheckUtils.isNotEmpty((Object)((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity"))) {
            DynamicObjectCollection list = ((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity");
            dy = (DynamicObject)list.get(0);
            if (Objects.isNull(((DynamicObject)((List)result.getData()).get(0)).getString("taxorg.unifiedsocialcode"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u201c%s\u201d\u5c1a\u672a\u5f55\u5165\u4f01\u4e1a\u4fe1\u606f\uff0c\u8bf7\u5148\u5230\u57fa\u7840\u6570\u636e-\u7a0e\u52a1\u4fe1\u606f\u754c\u9762\u5f55\u5165\u4f01\u4e1a\u4fe1\u606f", (String)"AbstractRuleConfigPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]), treeNode.getText()));
                TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
                return;
            }
            if (Objects.equals("0", dy.getString("enable"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7\u589e\u503c\u7a0e\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\uff0c\u5982\u9700\u64cd\u4f5c,\u8bf7\u524d\u5f80\u7a0e\u52a1\u4e91-\u57fa\u7840\u8d44\u6599-\u7a0e\u52a1\u4fe1\u606f\u8fdb\u884c\u542f\u7528\u3002", (String)"AbstractRuleConfigPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]), treeNode.getText()));
                TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
                return;
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u57fa\u7840\u8d44\u6599-\u7a0e\u52a1\u4fe1\u606f\u4e2d\u5b8c\u5584\u7a0e\u52a1\u4fe1\u606f", (String)"AbstractRuleConfigPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]));
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
            return;
        }
        pageCache.put("taxpayertype", dy.getString("taxpayertype"));
        if (!this.checkbeforeTreeNodeClick(nodeId)) {
            return;
        }
        pageCache.put(CURRENT_NODE, nodeId);
        String tab = pageCache.get(CURRENT_TAB);
        boolean existTypeChange = RuleService.loadTaxPayerTypeChangeRecord(this.getPageCache().get(CURRENT_NODE), this.getPageCache().get(RULE_TYPE));
        pageCache.put("existTypeChange", existTypeChange ? "true" : "false");
        this.loadTab(tab);
    }

    public boolean checkbeforeTreeNodeClick(String nodeId) {
        return true;
    }

    public abstract void loadTab(String var1);

    public List<QFilter> ruleCardQueryCondition() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter org = new QFilter("org", "=", (Object)Long.parseLong(this.getPageCache().get(CURRENT_NODE) == null ? "0" : this.getPageCache().get(CURRENT_NODE)));
        QFilter ruleTypeFilter = new QFilter("ruletype", "=", (Object)this.getPageCache().get(RULE_TYPE));
        filters.add(org);
        filters.add(ruleTypeFilter);
        return filters;
    }
}

