/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rules;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.taxcmain.TaxcMainBusiness;
import kd.taxc.bdtaxr.common.constant.tctb.TaxcMainConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.DataType;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.impt.TcvatRuleEntryEntityEnum;
import kd.taxc.bdtaxr.common.utils.ServiceInvokeUtils;
import kd.taxc.tcvat.common.util.TcvatCommonUtil;
import kd.taxc.tcvat.formplugin.rules.VatRateSetHandler;
import org.apache.commons.lang3.ObjectUtils;

public class ApportionTZRulePlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String AMOUNT_FIELD = "amountfield";
    private static final String APPORTION_RULE_ENTITY_INH = "tcvat_rule_apportion_inh";
    private static final String APPORTION_RULE_ENTITY = "tcvat_rule_apportion";

    public void afterCreateNewData(EventObject e) {
        DynamicObject org;
        Map customParams;
        Object createorg;
        if (APPORTION_RULE_ENTITY_INH.equals(this.getView().getFormShowParameter().getFormId())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
            String billno = TcvatCommonUtil.getBillno(APPORTION_RULE_ENTITY);
            this.getModel().setValue("number", (Object)billno);
        }
        if (null != (createorg = (customParams = this.getView().getFormShowParameter().getCustomParams()).get("createorg"))) {
            this.getModel().setValue("org", createorg);
            customParams.remove("createorg");
        }
        if (null != (org = (DynamicObject)this.getModel().getValue("org"))) {
            List ybnsrIdList;
            TaxResult listTaxResult = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj((String)TaxcMainConstant.ENTITYNAME, (String)TaxcMainConstant.TAXC_MAIN_CARD_FILED, (String)"TaxcMainMService", (String)"queryTaxcMainZzsByOrgId", (Object[])new Object[]{Collections.singletonList(org.getLong("id")), TaxationsysMappingEnum.CHN.getId()});
            if (listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData()) && (ybnsrIdList = TaxcMainBusiness.queryTaxcMainByIsYbnsr((List)((List)listTaxResult.getData()))) != null && !ybnsrIdList.isEmpty()) {
                return;
            }
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u975e\u4e00\u822c\u7eb3\u7a0e\u4eba\uff0c\u4e0d\u9002\u7528\u8fdb\u9879\u8f6c\u51fa\u6bd4\u4f8b\u5206\u644a\u89c4\u5219\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"ApportionTZRulePlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]), new Object[0]));
            this.getModel().setValue("org", (Object)0L);
        }
        this.getModel().clearNoDataRow();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (APPORTION_RULE_ENTITY_INH.equals(this.getView().getFormShowParameter().getFormId())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit tablefield = (BasedataEdit)this.getControl("table");
        tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit amountfield = (BasedataEdit)this.getControl(AMOUNT_FIELD);
        amountfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit amountfield1 = (BasedataEdit)this.getControl("amountfield1");
        amountfield1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit amountfield11 = (BasedataEdit)this.getControl("amountfield11");
        amountfield11.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit amountfield12 = (BasedataEdit)this.getControl("amountfield12");
        amountfield12.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String eventName = e.getProperty().getName();
        if ("table".equals(eventName)) {
            DynamicObject table1 = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (table1 != null) {
                Object id = table1.get("id");
                int rowIndex = e.getChangeSet()[0].getRowIndex();
                if (Objects.equals(id, Long.parseLong("1366529236009019392"))) {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{AMOUNT_FIELD, "absolute", "datatype", "datadirection", "filtercondition", "operationcolumnap"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"operationcolumnap"});
                    this.getModel().setValue(AMOUNT_FIELD, (Object)Long.parseLong("1366529236017408023"), rowIndex);
                    String o = ResManager.loadKDString((String)"\u767b\u8bb0\u65b9\u5f0f \u7b49\u4e8e \u65e0\u6cd5\u5212\u5206  ", (String)"ApportionTZRulePlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]);
                    this.getModel().setValue("filtercondition", (Object)o, rowIndex);
                    this.getModel().setValue("conditionjson", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"29UY3DYUT+4=\"}],\"CompareType\":\"105\",\"Id\":\"29UY3DYR74WC\",\"Logic\":\"0\",\"FieldName\":\"output_signtype\"}]}", rowIndex);
                } else {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{AMOUNT_FIELD, "absolute", "datatype", "datadirection", "filtercondition", "operationcolumnap"});
                }
            }
        } else if (eventName.startsWith("isfromdraft")) {
            String suffix = eventName.replace("isfromdraft", "");
            ChangeData changeData = e.getChangeSet()[0];
            Boolean newValue = (Boolean)changeData.getNewValue();
            if (newValue.booleanValue()) {
                this.getModel().deleteEntryData("entryentity" + suffix);
            }
        } else if ("wfhfzclx".equals(eventName)) {
            ChangeData changeData = e.getChangeSet()[0];
            String newValue = (String)changeData.getNewValue();
            if ("1".equals(newValue)) {
                this.getModel().deleteEntryData("entryentity11");
                this.getModel().setValue("isfromdraft11", (Object)Boolean.TRUE);
            } else if ("4".equals(newValue)) {
                this.getModel().deleteEntryData("entryentity12");
                this.getModel().setValue("isfromdraft12", (Object)Boolean.TRUE);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if ("table".equals(evt.getProperty().getName())) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                formShowParameter.setUseOrgId(org.getLong("id"));
            }
            QFilter filter = new QFilter("basedataid.billno", "=", (Object)"RULE-VAT-APPORTION-0002");
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_datasource_pkrules", (String)"id", (QFilter[])new QFilter[]{filter});
            List qFilters = formShowParameter.getListFilterParameter().getQFilters();
            List collect = qFilters.stream().filter(q -> "id".equals(q.getProperty())).collect(Collectors.toList());
            qFilters.removeAll(collect);
            qFilters.add(new QFilter("id", "in", collection.stream().map(e -> e.getLong("id")).collect(Collectors.toList())));
        }
        if (evt.getProperty().getName().startsWith(AMOUNT_FIELD)) {
            String key = evt.getProperty().getName();
            String suffix = key.replace(AMOUNT_FIELD, "");
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity" + suffix);
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table" + suffix, rowIndex);
            if (tabletype == null) {
                evt.setCancel(true);
                return;
            }
            QFilter id = new QFilter("tableid", "=", tabletype.get("id"));
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(id);
            String tableName = tabletype.getString("name");
            if ("tdm_balance_new".equals(tableName)) {
                QFilter fieldFilter = new QFilter("fieldname", "=", (Object)"debitlocalcurrency").or(new QFilter("fieldname", "=", (Object)"openinglocalcurrency")).or(new QFilter("fieldname", "=", (Object)"closinglocalcurrency")).or(new QFilter("fieldname", "=", (Object)"creditlocalcurrency"));
                formShowParameter.getListFilterParameter().setFilter(fieldFilter);
            } else if ("gl_voucher".equals(tableName)) {
                QFilter fieldFilter = new QFilter("fieldname", "=", (Object)"debitlocal").or(new QFilter("fieldname", "=", (Object)"creditlocal"));
                formShowParameter.getListFilterParameter().setFilter(fieldFilter);
            } else if ("gl_balance".equals(tableName)) {
                QFilter fieldFilter = new QFilter("fieldname", "=", (Object)"beginlocal").or(new QFilter("fieldname", "=", (Object)"endlocal")).or(new QFilter("fieldname", "=", (Object)"debitlocal")).or(new QFilter("fieldname", "=", (Object)"creditlocal"));
                formShowParameter.getListFilterParameter().setFilter(fieldFilter);
            } else if ("tdm_recording_voucher_new".equals(tableName)) {
                QFilter fieldFilter = new QFilter("fieldname", "=", (Object)"debitlocalcurrency").or(new QFilter("fieldname", "=", (Object)"creditlocalcurrency"));
                formShowParameter.getListFilterParameter().setFilter(fieldFilter);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (operateKey.startsWith("newentry")) {
            int[] selectRows;
            String suffix = operateKey.replace("newentry", "");
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity" + suffix);
            for (int selectRow : selectRows = entryGrid.getSelectRows()) {
                this.getModel().setValue("bizname" + suffix, this.getModel().getValue("name"), selectRow);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            String operateKey = ((Donothing)args.getSource()).getOperateKey();
            EntryGrid entryentity = (EntryGrid)this.getControl(operateKey);
            if (null == entryentity) {
                return;
            }
            int focusRow = entryentity.getEntryState().getFocusRow();
            String entitySuffix = operateKey.replace("entryentity", "");
            String datatype = (String)this.getModel().getValue("datatype" + entitySuffix, focusRow);
            if (datatype.equals(DataType.ZJQS.getCode()) && APPORTION_RULE_ENTITY.equals(this.getView().getEntityId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219\u884c\u7684\u53d6\u6570\u65b9\u5f0f\u7b49\u4e8e\u201d\u76f4\u63a5\u53d6\u6570\u201c\uff0c\u65e0\u9700\u914d\u7f6e\u201d\u9ad8\u7ea7\u914d\u7f6e\u201c\u3002", (String)"ApportionTZRulePlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            String vatrate = (String)this.getModel().getValue(operateKey + "confjson", focusRow);
            this.openAdvancedConfPage(vatrate, operateKey);
        }
        if (args.getSource() instanceof Save) {
            VatRateSetHandler.doSetVatRateWhileZJQS(this.getModel(), TcvatRuleEntryEntityEnum.TCVAT_RULE_APPORTION);
        }
    }

    private void openAdvancedConfPage(String vatrate, String actionId) {
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("tcvat_advance_config");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formshowParameter.getCustomParams().put("vatrate", vatrate);
        this.getView().showForm(formshowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map filterData;
        String actionId = evt.getActionId();
        if (evt.getActionId().startsWith("entryentity") && (filterData = (Map)evt.getReturnData()) != null) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(evt.getActionId());
            this.getModel().setValue(actionId + "conf", (Object)"rate", currentRowIndex);
            this.getModel().setValue(actionId + "confjson", filterData.get("vatrate"), currentRowIndex);
        }
    }
}

