/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rules;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.DataType;
import kd.taxc.bdtaxr.common.impt.TcvatRuleEntryEntityEnum;
import kd.taxc.tcvat.business.service.rule.RuleService;
import kd.taxc.tcvat.formplugin.rules.VatRateSetHandler;

public class DeductionRulePlugin
extends AbstractBillPlugIn
implements AfterF7SelectListener,
BeforeF7SelectListener {
    private RuleService ruleService = new RuleService();

    public void afterCreateNewData(EventObject e) {
        Object createorg;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object ruletype = customParams.get("ruletype");
        if (null == ruletype) {
            this.getModel().setValue("ruletype", (Object)"private");
        }
        if (null != (createorg = customParams.get("createorg"))) {
            this.getModel().setValue("org", createorg);
            customParams.remove("createorg");
            customParams.remove("orgid");
        }
        this.setTaxPayerType();
        this.getView().setEnable(Boolean.FALSE, new String[]{"reductiontype"});
    }

    public void setTaxPayerType() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (null == org) {
            return;
        }
        String taxpayertype = this.ruleService.getTaxPayerTypeBYOrgId(org.getLong("id"));
        this.getModel().setValue("taxPayerType", (Object)taxpayertype);
        if (Objects.nonNull(taxpayertype) && "xgmnsr".equals(taxpayertype)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"jzjt"});
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit deductiontype = (BasedataEdit)this.getControl("deductiontype");
        deductiontype.setDisplayProp("number|name");
        deductiontype.addAfterF7SelectListener((AfterF7SelectListener)this);
        deductiontype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("deductiontype".equals(name)) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(new QFilter("taxcategory", "=", (Object)new BigDecimal(1)));
        }
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        ListSelectedRowCollection listSelectedRows = evt.getListSelectedRowCollection();
        if (!CollectionUtils.isEmpty((Collection)listSelectedRows)) {
            this.setDeductionType(listSelectedRows.get(0).getPrimaryKeyValue());
            this.getView().setEnable(Boolean.FALSE, new String[]{"reductiontype"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save) {
            DynamicObjectCollection dynamicObjectCollection;
            if (this.getModel().getEntryRowCount("entryentity") == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u914d\u7f6e\u4e00\u6761\u89c4\u5219\u3002", (String)"DeductionRulePlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if ((dynamicObjectCollection = this.getModel().getEntryEntity("entryentity")).size() > 0) {
                int i = 1;
                for (DynamicObject object : dynamicObjectCollection) {
                    if (object.getString("datatype").equals("bhsjhsse") && object.getBigDecimal("vatrate").compareTo(BigDecimal.ZERO) == 0) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u89c4\u5219\u7684\u7b2c%s\u884c\u7684\u201c\u53d6\u6570\u65b9\u5f0f\u201d\u7b49\u4e8e\u542b\u7a0e\u4ef7\u6362\u7b97\u7a0e\u989d\uff0c\u9ad8\u7ea7\u914d\u7f6e\u4e2d\u7684\u201c\u589e\u503c\u7a0e\u7a0e\u7387/\u5f81\u6536\u7387\u201d\u5fc5\u987b\u5927\u4e8e0", (String)"DeductionRulePlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]), i));
                        args.setCancel(true);
                    }
                    ++i;
                }
            }
            VatRateSetHandler.doSetVatRateWhileZJQS(this.getModel(), TcvatRuleEntryEntityEnum.TCVAT_RULE_DEDUCTION);
        } else if (args.getSource() instanceof Donothing && "entryentity".equals(((Donothing)args.getSource()).getOperateKey())) {
            String operateKey = ((Donothing)args.getSource()).getOperateKey();
            EntryGrid entryentity = (EntryGrid)this.getControl(operateKey);
            if (null == entryentity) {
                return;
            }
            int focusRow = entryentity.getEntryState().getFocusRow();
            String entitySuffix = operateKey.replace("entryentity", "");
            String datatype = (String)this.getModel().getValue("datatype" + entitySuffix, focusRow);
            if (datatype.equals(DataType.ZJQS.getCode()) && "tcvat_rule_deduction".equals(this.getView().getEntityId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219\u884c\u7684\u53d6\u6570\u65b9\u5f0f\u7b49\u4e8e\u201d\u76f4\u63a5\u53d6\u6570\u201c\uff0c\u65e0\u9700\u914d\u7f6e\u201d\u9ad8\u7ea7\u914d\u7f6e\u201c\u3002", (String)"DeductionRulePlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            Object vatrate = this.getModel().getValue("vatrate", focusRow);
            this.openAdvancedConfPage(vatrate, operateKey);
        }
    }

    private void setDeductionType(Object id) {
        String fields = "deductiontype";
        QFilter idFilter = new QFilter("id", "=", id);
        DynamicObjectCollection deductionPolicy = QueryServiceHelper.query((String)"tpo_taxdeduction", (String)fields, (QFilter[])new QFilter[]{idFilter});
        if (deductionPolicy.size() > 0) {
            DynamicObject object = (DynamicObject)deductionPolicy.get(0);
            this.getModel().setValue("reductiontype", object.get("deductiontype"));
        }
    }

    private void openAdvancedConfPage(Object vatrate, String actionId) {
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("tcvat_advance_config");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formshowParameter.getCustomParams().put("vatrate", vatrate);
        this.getView().showForm(formshowParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String eventName = e.getProperty().getName();
        if ("org".equals(eventName)) {
            this.setTaxPayerType();
        }
        if ("" != e.getChangeSet()[0].getOldValue() && "taxpayertype".equals(eventName)) {
            this.getPageCache().put("taxpayertype", (String)e.getChangeSet()[0].getNewValue());
            this.getModel().setValue("deductiontype", null);
        }
        if ("deductiontype".equals(eventName)) {
            DynamicObject newValue;
            if ("xgmnsr".equals(this.getModel().getValue("taxpayertype")) && (newValue = (DynamicObject)e.getChangeSet()[0].getNewValue()) != null && newValue.getLong("id") == 790468283538082818L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u51cf\u514d\u653f\u7b56\u4ee3\u7801\u201c01011608\u201d\u7684\u7533\u62a5\u903b\u8f91\u5df2\u9884\u7f6e\u5728\u7533\u62a5\u8868\u4e2d\uff0c\u65e0\u9700\u4e3a\u8be5\u4ee3\u7801\u914d\u7f6e\u53d6\u6570\u89c4\u5219\u3002", (String)"DeductionRulePlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.getModel().setValue(eventName, null);
            }
            if (null == e.getChangeSet()[0].getNewValue()) {
                this.getModel().setValue("reductiontype", null);
            } else {
                this.getModel().setValue("reductiontype", ((DynamicObject)e.getChangeSet()[0].getNewValue()).get("deductiontype"));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map filterData;
        String actionId = evt.getActionId();
        if (actionId.startsWith("entryentity") && (filterData = (Map)evt.getReturnData()) != null) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(evt.getActionId());
            this.getModel().setValue("vatrate", filterData.get("vatrate"), currentRowIndex);
        }
    }
}

