/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rules;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.enums.DataType;
import kd.taxc.bdtaxr.common.impt.TcvatRuleEntryEntityEnum;
import kd.taxc.bdtaxr.common.taxdeclare.dto.AdvanceConfDto;
import kd.taxc.bdtaxr.common.taxdeclare.ruleconfig.RuleTemplateService;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.service.rule.IncomeRuleService;
import kd.taxc.tcvat.business.service.rule.RuleService;
import kd.taxc.tcvat.formplugin.rules.VatRateSetHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class IncomeRulePlugin
extends AbstractBillPlugIn
implements BasedataFuzzySearchListener,
BeforeF7SelectListener,
AfterF7SelectListener {
    private IncomeRuleService incomeRuleService = new IncomeRuleService();
    private RuleService ruleService = new RuleService();
    private static final Map<String, Map<String, String>> SIM_VAT = new HashMap<String, Map<String, String>>(2);
    private static Map<String, List<Long>> ruleTypeIdMap = new HashMap<String, List<Long>>(2);
    private static final ArrayList<String> export_taxation;
    private static final String MS = "MS";
    private static final String BUSINESS_TYPE = "businesstype";
    private static final Map<String, String> VATRATEMAP;
    private static final Map<String, String> entryMap;
    private static final Log LOGGER;

    public void registerListener(EventObject event) {
        BasedataEdit edit = (BasedataEdit)this.getView().getControl(BUSINESS_TYPE);
        edit.addBasedataFuzzySearchListener((BasedataFuzzySearchListener)this);
        MulBasedataEdit businesstype = (MulBasedataEdit)this.getControl(BUSINESS_TYPE);
        businesstype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        businesstype.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit taxation = (BasedataEdit)this.getControl("taxation");
        taxation.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxrate = (BasedataEdit)this.getControl("taxrate");
        taxrate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit table = (BasedataEdit)this.getControl("table");
        BasedataEdit table1 = (BasedataEdit)this.getControl("table1");
        BasedataEdit table2 = (BasedataEdit)this.getControl("table2");
        BasedataEdit table3 = (BasedataEdit)this.getControl("table3");
        BasedataEdit table11 = (BasedataEdit)this.getControl("table11");
        BasedataEdit table12 = (BasedataEdit)this.getControl("table12");
        table.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        table1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        table2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        table3.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        table11.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        table12.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void handleData(BasedataFuzzySearchEvent basedataFuzzySearchEvent) {
        basedataFuzzySearchEvent.getQueryData().clear();
    }

    public void setTaxPayerType() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (null == org) {
            return;
        }
        String taxpayertype = this.ruleService.getTaxPayerTypeBYOrgId(org.getLong("id"));
        this.getModel().setValue("taxPayerType", (Object)taxpayertype);
    }

    public void afterCreateNewData(EventObject e) {
        Object createorg;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object ruletype = customParams.get("ruletype");
        if (null == ruletype) {
            this.getModel().setValue("ruletype", (Object)"private");
        }
        if (null != (createorg = customParams.get("createorg"))) {
            this.getModel().setValue("org", createorg);
            customParams.remove("createorg");
            customParams.remove("orgid");
        }
        this.setTaxPayerType();
        this.getView().setVisible(Boolean.FALSE, new String[]{"advconap11", "advconap3"});
    }

    public void afterBindData(EventObject e) {
        this.setNrjzjtjsVisible();
        String taxPayerType2 = (String)this.getModel().getValue("taxpayertype");
        DynamicObject taxation = (DynamicObject)this.getModel().getValue("taxation");
        if (null != taxation && taxation.getString("number").equals(MS)) {
            this.getModel().setValue("taxrate", (Object)101);
            this.getView().setEnable(Boolean.FALSE, new String[]{"taxrate"});
            BasedataEdit control = (BasedataEdit)this.getView().getControl("deductiontype");
            control.setMustInput(true);
            this.getView().setVisible(Boolean.FALSE, new String[]{"jzjt"});
            this.getModel().setValue("jzjt", (Object)"0");
            this.getView().setVisible(Boolean.TRUE, new String[]{"deductiontype"});
        } else if (null != taxation && export_taxation.contains(taxation.getString("number"))) {
            if (this.getModel().getValue("taxrate") != null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"taxrate"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"jzjt", "deductiontype"});
                this.getModel().setValue("jzjt", (Object)"0");
                this.getModel().setValue("deductiontype", null);
            }
        } else {
            if ("xgmnsr".equals(taxPayerType2)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"jzjt"});
            }
            this.getModel().setValue("deductiontype", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"deductiontype"});
        }
        this.getView().setVisible((Boolean)this.getModel().getValue("qtfpseqs"), new String[]{"advconap11"});
        this.getView().setVisible((Boolean)this.getModel().getValue("wkpseqs"), new String[]{"advconap3"});
        DynamicObjectCollection entryentity1 = this.getModel().getEntryEntity("entryentity1");
        for (int i = 0; i < entryentity1.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryentity1.get(i);
            if (ObjectUtils.isEmpty((Object)dynamicObject) || ObjectUtils.isEmpty((Object)dynamicObject.getDynamicObject("table1")) || dynamicObject.getDynamicObject("table1") == null || !SIM_VAT.containsKey(String.valueOf(dynamicObject.getDynamicObject("table1").getLong("id")))) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"absolute1", "datatype1"});
        }
        DynamicObject taxrate = (DynamicObject)this.getModel().getValue("taxrate");
        if (taxrate != null) {
            BigDecimal oldRate = BigDecimalUtil.toBigDecimal((Object)taxrate.getString("number").replace("%", "")).divide(BigDecimalUtil.toBigDecimal((Object)100));
            this.getPageCache().put("oldRate", oldRate.toString());
        } else {
            this.getPageCache().put("oldRate", "0");
        }
    }

    public void setNrjzjtjsVisible() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            String taxpayertype = (String)this.getModel().getValue("taxpayertype");
            long orgid = org.getLong("id");
            Object jzjttscl = SystemParamUtil.getAppParameter((String)"tcvat", (String)"jzjttscl", (long)orgid);
            boolean jzjttsclB = "ybnsr".equals(taxpayertype) && jzjttscl != null && (Boolean)jzjttscl != false;
            this.getView().setVisible(Boolean.valueOf(jzjttsclB), new String[]{"nrjzjtjs"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter formShowParameter;
        String name = evt.getProperty().getName();
        if ("taxation".equals(name)) {
            formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            String taxationstr = (String)this.getModel().getValue("taxationstr");
            if (StringUtils.isNotBlank((String)taxationstr)) {
                QFilter qFilter = new QFilter("number", "in", (Object)taxationstr.split(","));
                if (this.incomeRuleService.isExporting(this.getModel().getValue("exporting"))) {
                    qFilter.or("number", "in", IncomeRuleService.export_taxation);
                }
                formShowParameter.getListFilterParameter().setFilter(qFilter);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6536\u4e1a\u52a1\u5206\u7c7b\u3002", (String)"IncomeRulePlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
        if ("taxrate".equals(name)) {
            formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            String taxratestr = (String)this.getModel().getValue("taxratestr");
            if (StringUtils.isNotBlank((String)taxratestr)) {
                DynamicObject taxation = (DynamicObject)this.getModel().getValue("taxation");
                formShowParameter.getListFilterParameter().setFilter(this.incomeRuleService.getTaxRateNumberFilter(taxratestr, taxation));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6536\u4e1a\u52a1\u5206\u7c7b\u3002", (String)"IncomeRulePlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
        if (BUSINESS_TYPE.equals(name)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (null == org) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"IncomeRulePlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            evt.getFormShowParameter().setCustomParam("org_id", (Object)org.getString("id"));
        }
        if (name.startsWith("table")) {
            formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                formShowParameter.setUseOrgId(org.getLong("id"));
            }
            QFilter filter = new QFilter("basedataid.id", "in", ruleTypeIdMap.get(name));
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_datasource_pkrules", (String)"id", (QFilter[])new QFilter[]{filter});
            formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", collection.stream().map(e -> e.getLong("id")).collect(Collectors.toList())));
        }
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        ListSelectedRowCollection listSelectedRows = evt.getListSelectedRowCollection();
        if (!CollectionUtils.isEmpty((Collection)listSelectedRows)) {
            String taxPayerType = (String)this.getModel().getValue("taxpayertype");
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            Map<String, DynamicObject> taxrates = this.incomeRuleService.megerTaxBusinessType(listSelectedRows, org.getString("id"), taxPayerType);
            List<String> taxRateList = this.incomeRuleService.getTaxRateList(taxrates, taxPayerType);
            if (!CollectionUtils.isEmpty(taxRateList)) {
                this.getModel().setValue("taxratestr", (Object)String.join((CharSequence)",", taxRateList));
                DynamicObject taxrate = (DynamicObject)this.getModel().getValue("taxrate");
                if (null != taxrate && null != taxRateList && !taxRateList.contains(taxrate.get("number")) && !"0%".equals(taxrate.get("number"))) {
                    this.getModel().setValue("taxrate", null);
                    this.getModel().deleteEntryData("invoiceentity");
                }
            }
            List<String> taxActionList = this.incomeRuleService.getTaxActionList(taxrates, taxPayerType, this.getModel().getValue("exporting"));
            this.getModel().setValue("taxationstr", (Object)String.join((CharSequence)",", taxActionList));
            DynamicObject taxation = (DynamicObject)this.getModel().getValue("taxation");
            if (taxation != null && !taxActionList.contains(taxation.get("number"))) {
                this.getModel().setValue("taxation", null);
                this.getModel().createNewEntryRow("invoiceentity");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            DynamicObject tabletype;
            int focusRow;
            EntryGrid entryentity;
            String operateKey = ((Donothing)args.getSource()).getOperateKey();
            if ("invoicesetting".equals(operateKey) || "setting2".equals(operateKey)) {
                entryentity = (EntryGrid)this.getControl("invoicesetting".equals(operateKey) ? "invoiceentity" : "entryentity2");
                focusRow = entryentity.getEntryState().getFocusRow();
                tabletype = (DynamicObject)this.getModel().getValue("invoicesetting".equals(operateKey) ? "table12" : "table2", focusRow);
                if (tabletype == null && "setting2".equals(operateKey)) {
                    args.setCancel(true);
                    return;
                }
                if (tabletype == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"IncomeRulePlugin_13", (String)"taxc-tcvat", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.openSettingPage(focusRow, tabletype, "invoicesetting".equals(operateKey) ? "12" : "2");
            }
            if ("invoicesetadvancedconf".equals(operateKey) || "setadvancedconf2".equals(operateKey)) {
                entryentity = "invoicesetadvancedconf".equals(operateKey) ? (EntryGrid)this.getControl("invoiceentity") : (EntryGrid)this.getControl("entryentity2");
                focusRow = entryentity.getEntryState().getFocusRow();
                DynamicObject dynamicObject = tabletype = "invoicesetadvancedconf".equals(operateKey) ? (DynamicObject)this.getModel().getValue("table12", focusRow) : (DynamicObject)this.getModel().getValue("table2", focusRow);
                if (tabletype == null) {
                    if ("invoicesetadvancedconf".equals(operateKey)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"IncomeRulePlugin_13", (String)"taxc-tcvat", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    return;
                }
                String entityname = tabletype.getString("entityname");
                if ("sim_vatinvoice_vehicles".equals(entityname)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u7b49\u4e8e\u673a\u52a8\u8f66\u9500\u552e\u53d1\u7968\u65f6\uff0c\u4e0d\u652f\u6301\u9ad8\u7ea7\u914d\u7f6e\u3002", (String)"IncomeRulePlugin_12", (String)"taxc-tcvat", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
        } else if (args.getSource() instanceof Save) {
            DynamicObject taxation;
            if (this.incomeRuleService.validateEntityEmpty(this.getModel().getEntryEntity("invoiceentity"), this.getModel().getEntryEntity("entryentity"), this.getModel().getEntryEntity("entryentity1"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u914d\u7f6e\u4e00\u6761\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u6536\u5165\u53d6\u6570\u89c4\u5219\u6216\u5176\u4ed6\u53d1\u7968\u4e0d\u542b\u7a0e\u6536\u5165\u53d6\u6570\u89c4\u5219\u6216\u672a\u5f00\u7968\u4e0d\u542b\u7a0e\u6536\u5165\u53d6\u6570\u89c4\u5219\u3002", (String)"IncomeRulePlugin_14", (String)"taxc-tcvat", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (null != (taxation = (DynamicObject)this.getModel().getValue("taxation"))) {
                String msg;
                DynamicObject taxrate = (DynamicObject)this.getModel().getValue("taxrate");
                if ((taxation.getString("number").equals(MS) || "0%".equals(taxrate.get("number"))) && !"".equals(msg = this.validDataType())) {
                    this.getView().showTipNotification(msg);
                    args.setCancel(true);
                }
            }
            VatRateSetHandler.doSetVatRateWhileZJQS(this.getModel(), TcvatRuleEntryEntityEnum.TCVAT_RULE_INCOME);
        }
    }

    private void openSettingPage(int focusRow, DynamicObject tabletype, String suffix) {
        String actionId;
        String conditionjson;
        String entityfield;
        if ("12".equals(suffix)) {
            entityfield = "invoiceentity";
            conditionjson = "invoiceconditionjson";
            actionId = "invoicesetting";
        } else {
            entityfield = "entryentity" + suffix;
            conditionjson = "conditionjson" + suffix;
            actionId = "setting" + suffix;
        }
        String ischild = tabletype.getString("ischild");
        String entityNumber = tabletype.getString("name");
        if ("false".equals(ischild) && StringUtil.isNotBlank((CharSequence)tabletype.getString("subname"))) {
            entityNumber = tabletype.getString("subname");
        }
        this.openSettingPage(focusRow, tabletype.getLong("id"), entityNumber, entityfield, conditionjson, actionId, suffix);
    }

    private String validDataType() {
        String msg = "";
        for (Map.Entry<String, String> entry : entryMap.entrySet()) {
            for (int i = 0; i < this.getModel().getEntryRowCount(entry.getKey()); ++i) {
                String dataType = this.getModel().getEntryRowEntity(entry.getKey(), i).get(entry.getValue()).toString();
                if ("jsflqs".equals(dataType)) {
                    msg = ResManager.loadKDString((String)"\u7a0e\u7387\u4e3a0%\uff0c\u53d6\u6570\u65b9\u5f0f\u4e0d\u80fd\u9009\u62e9\u542b\u7a0e\u4ef7\u6362\u7b97\u4e0d\u542b\u7a0e\u4ef7\u3002", (String)"IncomeRulePlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]);
                    break;
                }
                if (!"cysldsqs".equals(dataType)) continue;
                msg = ResManager.loadKDString((String)"\u7a0e\u7387\u4e3a0%\uff0c\u53d6\u6570\u65b9\u5f0f\u4e0d\u80fd\u9009\u62e9\u7a0e\u989d\u6362\u7b97\u4e0d\u542b\u7a0e\u4ef7\u3002", (String)"IncomeRulePlugin_9", (String)"taxc-tcvat", (Object[])new Object[0]);
                break;
            }
            if ("".equals(msg)) continue;
            break;
        }
        return msg;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Object ruleId;
        boolean exists;
        FormOperate operate;
        String operateKey = args.getOperateKey();
        if (operateKey.startsWith("newentry") || operateKey.startsWith("newinvoiceentry")) {
            String suffix = operateKey.replace("newentry", "");
            EntryGrid entryGrid = operateKey.startsWith("newinvoiceentry") ? (EntryGrid)this.getControl("invoiceentity") : (EntryGrid)this.getControl("entryentity" + suffix);
            int[] selectRows = entryGrid.getSelectRows();
            ArrayList<String> logs = new ArrayList<String>();
            for (int selectRow : selectRows) {
                this.getModel().setValue(operateKey.startsWith("newinvoiceentry") ? "invoicebizname" : "bizname" + suffix, this.getModel().getValue("name"), selectRow);
                if (!"".equals(suffix)) continue;
                BigDecimal rate = BigDecimal.ZERO;
                DynamicObject taxrate = (DynamicObject)this.getModel().getValue("taxrate");
                if (taxrate != null) {
                    try {
                        rate = BigDecimalUtil.toBigDecimal((Object)taxrate.getString("number").replace("%", "")).divide(BigDecimal.valueOf(100L));
                    }
                    catch (NumberFormatException ex) {
                        logs.add("IncomeRulePlugin:" + taxrate.getString("number") + ex.getMessage());
                    }
                }
                this.getModel().setValue("entryentityconf", (Object)"rate", selectRow);
                this.getModel().setValue("entryentityconfjson", (Object)rate, selectRow);
            }
            LOGGER.info("IncomeRulePlugin NumberFormatException = {}", logs);
        }
        if ("newinvoiceentry".equals(operateKey)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("invoiceentity");
            DynamicObject taxrate = (DynamicObject)this.getModel().getValue("taxrate");
            if (taxrate != null) {
                this.getModel().setValue("invoicetaxrate", (Object)taxrate.getString("number"), rowIndex);
            }
        }
        if ("enable".equals((operate = (FormOperate)args.getSource()).getOperateKey()) && null != args.getOperationResult() && args.getOperationResult().getAllErrorOrValidateInfo().size() == 0 && (exists = QueryServiceHelper.exists((String)"tcvat_rule_wkpsr", (QFilter[])new QFilter[]{new QFilter("rulename", "in", ruleId = this.getModel().getValue("id")), new QFilter("enable", "=", (Object)"0")}))) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("enable", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u540c\u65f6\u542f\u7528\u5173\u8054\u7684\u672a\u5f00\u7968\u6536\u5165\u53f0\u8d26\u89c4\u5219\uff1f", (String)"IncomeRulePlugin_10", (String)"taxc-tcvat", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
        }
        if ("invoicesetadvancedconf".equals(operateKey)) {
            EntryGrid entryentity = (EntryGrid)this.getControl("invoiceentity");
            int focusRow = entryentity.getEntryState().getFocusRow();
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table12", focusRow);
            if (tabletype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"IncomeRulePlugin_13", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            Boolean DifferenceInvoice = (Boolean)this.getModel().getValue("differenceinvoice12", focusRow);
            AdvanceConfDto advanceConfDto = new AdvanceConfDto();
            advanceConfDto.setAdvanceconfKey(operateKey);
            advanceConfDto.setDatatype(DataType.ZJQS.getCode());
            advanceConfDto.setDifferenceInvoice(DifferenceInvoice);
            advanceConfDto.setTableNumber(tabletype.getString("entityname"));
            RuleTemplateService.openAdvancedConfPage((AdvanceConfDto)advanceConfDto, (IFormView)this.getView(), (int)focusRow, (long)tabletype.getLong("id"), (String)"invoiceentity", (String)"invoicesetadvancedconf", (IFormPlugin)this, (String)"bqhj");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if ("enable".equals(callBackId)) {
            Long ruleId = (Long)this.getModel().getValue("id");
            if (MessageBoxResult.Yes == evt.getResult()) {
                DynamicObject wkpsrRule = BusinessDataServiceHelper.loadSingle((String)"tcvat_rule_wkpsr", (String)"id,enable", (QFilter[])new QFilter[]{new QFilter("rulename", "=", (Object)ruleId), new QFilter("enable", "=", (Object)"0")});
                OperationResult resultesult = OperationServiceHelper.executeOperate((String)"enable", (String)"tcvat_rule_wkpsr", (Object[])new Long[]{wkpsrRule.getLong("id")}, (OperateOption)OperateOption.create());
                if (resultesult.isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u672a\u5f00\u7968\u6536\u5165\u89c4\u5219\u542f\u7528\u6210\u529f\u3002", (String)"IncomeRulePlugin_11", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
            }
        }
    }

    private void setMS(DynamicObject taxation) {
        if (taxation.getString("number").equals(MS)) {
            this.getModel().setValue("taxrate", (Object)101);
            this.getView().setEnable(Boolean.FALSE, new String[]{"taxrate"});
            BasedataEdit control = (BasedataEdit)this.getView().getControl("deductiontype");
            control.setMustInput(true);
            this.getView().setVisible(Boolean.FALSE, new String[]{"jzjt"});
            this.getModel().setValue("jzjt", (Object)"0");
            this.getModel().setValue("deductiontype", null);
            this.getView().setVisible(Boolean.TRUE, new String[]{"deductiontype"});
        } else {
            String typepayertype = (String)this.getModel().getValue("taxpayertype");
            if (!"xgmnsr".equals(typepayertype)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"jzjt"});
            } else if (taxation.getString("number").equals("JYZS_1")) {
                this.getModel().setValue("taxrate", (Object)1);
                this.getView().setEnable(Boolean.FALSE, new String[]{"taxrate"});
            }
            this.getModel().setValue("deductiontype", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"deductiontype"});
            BasedataEdit control = (BasedataEdit)this.getView().getControl("deductiontype");
            control.setMustInput(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object qtfpseqs;
        String eventName = e.getProperty().getName();
        if ("org".equals(eventName)) {
            this.setTaxPayerType();
        }
        if ("taxation".equals(eventName)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"taxrate"});
            DynamicObject taxation = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject taxrate = (DynamicObject)this.getModel().getValue("taxrate");
            if (taxation == null) {
                return;
            }
            this.setMS(taxation);
            String taxationNumber = taxation.getString("number");
            if (export_taxation.contains(taxationNumber)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"taxrate"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"jzjt"});
                this.getModel().setValue("jzjt", (Object)"0");
                if (taxationNumber.equals("Export_02")) {
                    this.getModel().setValue("taxrate", (Object)103);
                } else if (taxationNumber.equals("Export_01")) {
                    this.getModel().setValue("taxrate", (Object)102);
                }
                return;
            }
            if (taxrate == null) {
                return;
            }
            String taxrateNumber = taxrate.getString("number");
            String taxationstr = (String)this.getModel().getValue("taxationstr");
            if (taxationNumber.equals("YBJS") && !taxationstr.contains(taxrateNumber)) {
                this.getModel().setValue("taxrate", null);
            } else if (taxationNumber.equals("JYZS_3") && !taxrateNumber.equals("%3")) {
                this.getModel().setValue("taxrate", null);
            } else if (taxationNumber.equals("JYZS_5") && !taxrateNumber.equals("%5")) {
                this.getModel().setValue("taxrate", null);
            } else if (taxationNumber.equals(MS) && !taxrateNumber.equals("%0")) {
                this.getModel().setValue("taxrate", (Object)101);
            }
        } else if ("taxrate".equals(eventName)) {
            DynamicObject taxrate = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldTaxrate = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (oldTaxrate != null) {
                String number = oldTaxrate.getString("number").replace("%", "");
                this.getPageCache().put("oldRate", number);
            }
            this.setInvoiceTaxTate(taxrate);
            this.setAdvanceConfig(taxrate);
        } else if ("taxpayertype".equals(eventName)) {
            if (Objects.equals(this.getModel().getValue("taxpayertype"), "xgmnsr")) {
                this.getModel().setValue("exporting", (Object)"0");
            }
            this.setNrjzjtjsVisible();
        } else if ("exporting".equals(eventName) && Objects.equals(this.getModel().getValue("exporting"), "0") && Objects.equals(this.getModel().getValue("taxpayertype"), "ybnsr")) {
            this.getModel().setValue("taxation", null);
            this.getModel().setValue("taxrate", null);
            this.getModel().setValue("deductiontype", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"deductiontype"});
        }
        if ("" != e.getChangeSet()[0].getOldValue() && "taxpayertype".equals(eventName)) {
            this.getModel().setValue(BUSINESS_TYPE, null);
            this.getModel().setValue("taxation", null);
            this.getModel().setValue("taxrate", null);
            this.getModel().setValue("deductiontype", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"deductiontype"});
            this.getView().setVisible("xgmnsr".equals(e.getChangeSet()[0].getNewValue()) ? Boolean.FALSE : Boolean.TRUE, new String[]{"jzjt"});
        }
        if (Objects.equals("invoiceseqs", eventName) && Objects.equals(qtfpseqs = this.getModel().getValue("invoiceseqs"), Boolean.FALSE)) {
            this.getModel().deleteEntryData("entryentity2");
        }
        if (Objects.equals("qtfpseqs", eventName)) {
            qtfpseqs = this.getModel().getValue("qtfpseqs");
            if (Objects.equals(qtfpseqs, Boolean.FALSE)) {
                this.getModel().deleteEntryData("entryentity11");
            }
            this.getView().setVisible(Boolean.valueOf(Objects.equals(qtfpseqs, Boolean.TRUE)), new String[]{"advconap11"});
        }
        if (Objects.equals("wkpseqs", eventName)) {
            qtfpseqs = this.getModel().getValue("wkpseqs");
            if (Objects.equals(qtfpseqs, Boolean.FALSE)) {
                this.getModel().deleteEntryData("entryentity3");
            }
            this.getView().setVisible(Boolean.valueOf(Objects.equals(qtfpseqs, Boolean.TRUE)), new String[]{"advconap3"});
        }
        if (Objects.equals("table1", eventName) || Objects.equals("table11", eventName) || Objects.equals("table12", eventName) || Objects.equals("table2", eventName)) {
            DynamicObject table1 = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (table1 == null) {
                return;
            }
            String suffix = eventName.replace("table", "");
            Object id = table1.get("id");
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            String tableId = String.valueOf(table1.get("id"));
            if (SIM_VAT.containsKey(tableId)) {
                String amountId = SIM_VAT.get(tableId).get("amount");
                String taxamountId = SIM_VAT.get(tableId).get("taxamount");
                if ("1".equals(suffix) || "12".equals(suffix)) {
                    this.getModel().setValue("amountfield" + suffix, (Object)Long.parseLong(amountId), rowIndex);
                } else {
                    this.getModel().setValue("amountfield" + suffix, (Object)Long.parseLong(taxamountId), rowIndex);
                }
                if ("12".equals(suffix) || "2".equals(suffix)) {
                    String o = ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b.\u540d\u79f0 \u5728\u2026\u2026\u4e2d \u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968;\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968;\u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09  \u5e76\u4e14            \u53d1\u7968\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u6b63\u5e38;\u7ea2\u51b2  ", (String)"TcvatIncomeInvoiceUpgradeService_2", (String)"taxc-tcvat", (Object[])new Object[0]);
                    this.getModel().setValue("12".equals(suffix) ? "invoicefiltercondition" : "filtercondition2", (Object)o, rowIndex);
                    this.getModel().setValue("12".equals(suffix) ? "invoiceconditionjson" : "conditionjson2", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"BaseDataIds\":[{\"_Type_\":\"FilterValue\",\"Value\":\"961639304377984000\",\"Id\":\"3PKLSCPZ04=T\"},{\"_Type_\":\"FilterValue\",\"Value\":\"961640097369875456\",\"Id\":\"3PKLSCPZ272K\"},{\"_Type_\":\"FilterValue\",\"Value\":\"1376129725579325440\",\"Id\":\"3PKLSCPZ04=U\"}],\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968\",\"Id\":\"3PKLSCPZ272I\"},{\"_Type_\":\"FilterValue\",\"Value\":\"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\",\"Id\":\"3PKLSCPZ04=S\"},{\"_Type_\":\"FilterValue\",\"Value\":\"\u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09\",\"Id\":\"3PKLSCPZ272J\"}],\"CompareType\":\"17\",\"Id\":\"3PKLSCPZ04=R\",\"Logic\":\"0\",\"FieldName\":\"baseinvoicetype.name\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3PKLSCPZ04=V\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"3PKLSCPZ272M\"}],\"CompareType\":\"17\",\"Id\":\"3PKLSCPZ272L\",\"Logic\":\"0\",\"FieldName\":\"invoicestatus\"}]}", rowIndex);
                } else {
                    String o = ResManager.loadKDString((String)"\u57fa\u7840\u53d1\u7968\u79cd\u7c7b\u540d\u79f0 \u5728\u2026\u2026\u4e2d \u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968\uff08\u901a\u884c\u8d39\uff09;\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968;\u6570\u7535\u7968\uff08\u666e\u901a\u53d1\u7968\uff09;\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\uff08\u5377\u7968\uff09;\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968  \u5e76\u4e14            \u53d1\u7968\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u6b63\u5e38;\u7ea2\u51b2  ", (String)"IncomeRulePlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]);
                    this.getModel().setValue("filtercondition" + suffix, (Object)o, rowIndex);
                    this.getModel().setValue("conditionjson" + suffix, (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"BaseDataIds\":[{\"_Type_\":\"FilterValue\",\"Value\":\"961634333825754112\",\"Id\":\"2OM051N+7IOB\"},{\"_Type_\":\"FilterValue\",\"Value\":\"961639799666521088\",\"Id\":\"2OM051N+9K3L\"},{\"_Type_\":\"FilterValue\",\"Value\":\"1376129501813207040\",\"Id\":\"2OM051N+7IOC\"},{\"_Type_\":\"FilterValue\",\"Value\":\"961642468384760832\",\"Id\":\"2OM051N+9K3M\"},{\"_Type_\":\"FilterValue\",\"Value\":\"961640365939504128\",\"Id\":\"2OM051N+7IOD\"}],\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968\uff08\u901a\u884c\u8d39\uff09\",\"Id\":\"2OM051MWN4Y1\"},{\"_Type_\":\"FilterValue\",\"Value\":\"\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\",\"Id\":\"2OM051MWL3GU\"},{\"_Type_\":\"FilterValue\",\"Value\":\"\u6570\u7535\u7968\uff08\u666e\u901a\u53d1\u7968\uff09\",\"Id\":\"2OM051MWN4Y2\"},{\"_Type_\":\"FilterValue\",\"Value\":\"\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\uff08\u5377\u7968\uff09\",\"Id\":\"2OM051N+7IOA\"},{\"_Type_\":\"FilterValue\",\"Value\":\"\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968\",\"Id\":\"2OM051N+9K3K\"}],\"CompareType\":\"17\",\"Id\":\"2OM051MWL3GT\",\"Logic\":\"0\",\"FieldName\":\"baseinvoicetype.name\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"2OM051N+7IOE\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"2OM051N+9K3O\"}],\"CompareType\":\"17\",\"Id\":\"2OM051N+9K3N\",\"Logic\":\"0\",\"FieldName\":\"invoicestatus\"}]}", rowIndex);
                }
            }
            if (Objects.equals(id, Long.parseLong("1543335746595744768"))) {
                if ("1".equals(suffix) || "12".equals(suffix)) {
                    this.getModel().setValue("amountfield" + suffix, (Object)Long.parseLong("1543335746671242291"), rowIndex);
                } else {
                    this.getModel().setValue("amountfield" + suffix, (Object)Long.parseLong("1543335746671242292"), rowIndex);
                }
                String o = ResManager.loadKDString((String)"\u53d1\u7968\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u6b63\u5e38;\u7ea2\u51b2   ", (String)"IncomeRulePlugin_17", (String)"taxc-tcvat", (Object[])new Object[0]);
                String j = "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"2W/TO1/X4HVG\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"2W/TO1/X2F1Q\"}],\"CompareType\":\"17\",\"Id\":\"2W/TO1/X2F1P\",\"Logic\":\"0\",\"FieldName\":\"invoicestatus\"}]}";
                if ("12".equals(suffix)) {
                    this.getModel().setValue("invoicefiltercondition", (Object)o, rowIndex);
                    this.getModel().setValue("invoiceconditionjson", (Object)j, rowIndex);
                } else {
                    this.getModel().setValue("filtercondition" + suffix, (Object)o, rowIndex);
                    this.getModel().setValue("conditionjson" + suffix, (Object)j, rowIndex);
                }
            }
        }
        if (Objects.equals("amountfield1", eventName)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            DynamicObject table1 = (DynamicObject)this.getModel().getValue("table1", e.getChangeSet()[0].getRowIndex());
            if (table1 == null) {
                return;
            }
            if (SIM_VAT.containsKey(String.valueOf(table1.getLong("id")))) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"absolute1"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"datatype1"});
                DynamicObject amount = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (null == amount) {
                    return;
                }
                String fieldname = amount.getString("fieldname");
                if ("amount".equals(fieldname)) {
                    this.getModel().setValue("datatype1", (Object)"zjqs");
                }
                if ("tax".equals(fieldname)) {
                    this.getModel().setValue("datatype1", (Object)"cysldsqs");
                }
            } else {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"absolute1", "datatype1"});
            }
        }
    }

    private void setAdvanceConfig(DynamicObject taxrate) {
        if (taxrate == null) {
            return;
        }
        BigDecimal rate = BigDecimal.ZERO;
        try {
            rate = new BigDecimal(taxrate.getString("number").replace("%", "")).divide(new BigDecimal("100"));
        }
        catch (NumberFormatException ex) {
            LOGGER.error("IncomeRulePlugin:" + taxrate.getString("number"), (Throwable)ex);
        }
        for (Map.Entry<String, String> entry : VATRATEMAP.entrySet()) {
            int entryentityCount = this.getModel().getEntryRowCount(entry.getKey());
            for (int i = 0; i < entryentityCount; ++i) {
                BigDecimal rowRate = BigDecimalUtil.toBigDecimal((Object)this.getModel().getValue(entry.getValue(), i)).setScale(2);
                String oldRateStr = this.getPageCache().get("oldRate") != null ? this.getPageCache().get("oldRate") : "-1";
                BigDecimal oldRate = BigDecimalUtil.toBigDecimal((Object)oldRateStr).divide(BigDecimalUtil.toBigDecimal((Object)100));
                if (oldRate.compareTo(rowRate) != 0) continue;
                this.getModel().setValue(entry.getValue(), (Object)rate, i);
            }
        }
    }

    private void setInvoiceTaxTate(DynamicObject taxrate) {
        int invoiceentityCount = this.getModel().getEntryRowCount("invoiceentity");
        for (int i = 0; i < invoiceentityCount; ++i) {
            if (taxrate != null) {
                this.getModel().setValue("invoicetaxrate", (Object)taxrate.getString("number"), i);
                continue;
            }
            this.getModel().setValue("invoicetaxrate", null, i);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        int currentRowIndex;
        String actionId = evt.getActionId();
        Map filterData = (Map)evt.getReturnData();
        if (filterData == null) {
            return;
        }
        if ("invoicesetting".equals(actionId)) {
            currentRowIndex = this.getModel().getEntryCurrentRowIndex("invoiceentity");
            this.getModel().setValue("invoicefiltercondition", filterData.get("filterdescription"), currentRowIndex);
            this.getModel().setValue("invoiceconditionjson", filterData.get("filtervalue"), currentRowIndex);
        } else if ("setting2".equals(actionId)) {
            currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity2");
            this.getModel().setValue("filtercondition2", filterData.get("filterdescription"), currentRowIndex);
            this.getModel().setValue("conditionjson2", filterData.get("filtervalue"), currentRowIndex);
        }
        if ("invoicesetadvancedconf".equals(actionId)) {
            currentRowIndex = this.getModel().getEntryCurrentRowIndex("invoiceentity");
            this.getModel().setValue("differenceinvoice12", filterData.get("differenceinvoice"), currentRowIndex);
        }
    }

    protected void openSettingPage(int rowIndex, long entityId, String entityNumber, String entityfield, String conditionjson, String actionId, String entitySuffix) {
        boolean specialInvoiceSetting;
        DynamicObject selectedRow = this.getModel().getEntryRowEntity(entityfield, rowIndex);
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("bdtaxr_filtercondition");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCustomParam("entityId", (Object)entityId);
        formshowParameter.setCustomParam("entityNumber", (Object)entityNumber);
        formshowParameter.setCustomParam("filterJson", selectedRow.get(conditionjson));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Object ruleType = this.getView().getFormShowParameter().getCustomParams().get("ruletype");
        if (null != ruleType) {
            formshowParameter.setCustomParam("ruletype", ruleType);
        }
        if (org != null) {
            formshowParameter.setCustomParam("orgid", (Object)org.getString("id"));
        }
        if (Objects.equals(entityNumber, "sim_vatinvoice_vehicles") && Lists.newArrayList((Object[])new String[]{"1", "11", "12"}).contains(entitySuffix)) {
            formshowParameter.setCustomParam("NO_SPECIAL", (Object)"true");
            formshowParameter.setCustomParam("NO_TAXRATE", (Object)"true");
        }
        boolean bl = specialInvoiceSetting = "sim_vatinvoice".equals(entityNumber) && Lists.newArrayList((Object[])new String[]{"2", "12"}).contains(entitySuffix);
        if (specialInvoiceSetting) {
            formshowParameter.setCustomParam("only_special", (Object)"true");
            formshowParameter.setCustomParam("NO_TAXRATE", (Object)"true");
        }
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    static {
        HashMap<String, String> simVatMap = new HashMap<String, String>(2);
        simVatMap.put("amount", "1163062995136359509");
        simVatMap.put("taxamount", "1163062995136359510");
        SIM_VAT.put("1163062995127970816", simVatMap);
        HashMap<String, String> simVatJzjtMap = new HashMap<String, String>(2);
        simVatJzjtMap.put("amount", "1835580806685626453");
        simVatJzjtMap.put("taxamount", "1835580806685626454");
        SIM_VAT.put("1835580761286481920", simVatJzjtMap);
        ruleTypeIdMap.put("table2", Arrays.asList(1043426415279747072L, 1916782356107445248L));
        ruleTypeIdMap.put("table12", Arrays.asList(1043426415279747072L, 1916782356107445248L));
        ruleTypeIdMap.put("table1", Arrays.asList(1043426415279747072L, 1916782639197675520L));
        ruleTypeIdMap.put("table11", Arrays.asList(1043426415279747072L, 1916782639197675520L));
        ruleTypeIdMap.put("table", Arrays.asList(1043426415279747072L, 1916782912498648064L));
        ruleTypeIdMap.put("table3", Arrays.asList(1043426415279747072L, 1916782912498648064L));
        export_taxation = Lists.newArrayList((Object[])new String[]{"Export_02", "Export_01"});
        VATRATEMAP = new HashMap<String, String>(){
            {
                this.put("entryentity", "entryentityconfjson");
            }
        };
        entryMap = new HashMap<String, String>(2){
            {
                this.put("entryentity1", "datatype1");
            }
        };
        LOGGER = LogFactory.getLog(IncomeRulePlugin.class);
    }
}

