/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rules;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.org.OrgChangeRecordUtil;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.tcvat.business.service.engine.task.InvoiceAutoSignTask;
import kd.taxc.tcvat.business.service.engine.task.PartitionSaveTask;
import kd.taxc.tcvat.common.util.UUID;
import org.apache.commons.compress.utils.Lists;

public class InvoiceAutoSignPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(InvoiceAutoSignPlugin.class);
    private static final String SEPARATOR = System.getProperty("line.separator");

    public void registerListener(EventObject e) {
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        String itemKey = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(itemKey)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (Objects.isNull(org)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u540e\u70b9\u51fb\u786e\u5b9a\u3002", (String)"InvoiceAutoSignPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            if (Objects.isNull(this.getModel().getValue("dksq"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62b5\u6263\u7a0e\u671f\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u540e\u70b9\u51fb\u786e\u5b9a\u3002", (String)"InvoiceAutoSignPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            Date dksq = DateUtils.getFirstDateOfMonth((Date)((Date)this.getModel().getValue("dksq")));
            Long orgId = org.getLong("id");
            DynamicObject dynamicObject = OrgChangeRecordUtil.loadChangeRecord((String)String.valueOf(orgId), (Date)DateUtils.getFirstDateOfMonth((Date)dksq), (Date)DateUtils.getLastDateOfMonth((Date)dksq));
            if (Objects.isNull(dynamicObject) || !"ybnsr".equals(dynamicObject.getString("taxpayertype"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u5728\u6240\u5c5e\u7a0e\u671f\u5185\u4e3a\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\uff0c\u4e0d\u9002\u7528\u5373\u5f81\u5373\u9000\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"InvoiceAutoSignPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            Map orgRules = RuleUtils.getJxdkOrgRules((RuleTypeEnum)RuleTypeEnum.JXXM, (Long)orgId, (Boolean)false);
            List dynamicObjects = (List)orgRules.get(RuleTypeEnum.JXXM);
            if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6807\u8bc6\u5931\u8d25\u3002\u65e0\u6807\u8bc6\u89c4\u5219\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8bbe\u7f6e\u4e2d\u914d\u7f6e\u5373\u5f81\u5373\u9000\u6807\u8bc6\u89c4\u5219\u3002", (String)"InvoiceAutoSignPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection invoiceTypes = QueryServiceHelper.query((String)"bd_invoicetype", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("issystem", "=", (Object)"1")});
            Map<String, String> invoiceTypeMap = invoiceTypes.stream().collect(Collectors.toMap(o -> o.getString("id"), o -> o.getString("number")));
            ArrayList invoiceList = new ArrayList();
            ConcurrentHashMap<String, String[]> errorInfo = new ConcurrentHashMap<String, String[]>();
            CopyOnWriteArraySet correctSet = new CopyOnWriteArraySet();
            ConcurrentHashMap result = new ConcurrentHashMap();
            CopyOnWriteArraySet<String> errorSet = new CopyOnWriteArraySet<String>();
            dynamicObjects.forEach(one -> {
                InvoiceAutoSignTask autoSignTask = new InvoiceAutoSignTask(invoiceTypeMap, result, (Map<String, String[]>)errorInfo, correctSet, (Set<String>)errorSet, (DynamicObject)one, UUID.randomUUID(), one.getDynamicObjectCollection("entryentity"), "tcvat_input_invoice_sign", dksq, orgId);
                List invoiceFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)autoSignTask);
                invoiceList.addAll(this.getFutureList(invoiceFutures));
            });
            List<DynamicObject> resultList = invoiceList.stream().filter(p -> !errorSet.contains(p.getString("invoicepkid"))).collect(Collectors.toList());
            Set signedinvoice = Sets.newHashSet();
            List invoicenos = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(resultList)) {
                Map<String, Object> signed = this.isSigned(resultList, orgId, DateUtils.format((Date)dksq, (String)"yyyy-MM"));
                signedinvoice = (Set)signed.get("resignedset");
                invoicenos = (List)signed.get("needsignset");
            }
            logger.info("\u9700\u8981\u6253\u6807\u8bc6\u7684\u6570\u636e\u96c6\u5408\u4e3a\uff1a{}", (Object)invoicenos);
            if (CollectionUtils.isNotEmpty((Collection)invoicenos)) {
                this.dealSignAmount(invoicenos);
                ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(invoicenos));
            }
            this.generateView(errorInfo, signedinvoice, invoicenos, errorSet);
        }
    }

    private void dealSignAmount(List<DynamicObject> signs) {
        signs.forEach(object -> {
            QFilter filter = new QFilter("invoice_no", "=", object.get("invoiceno")).and("invoice_code", "=", object.get("invoicecode"));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"total_tax_amount,effective_tax_amount", (QFilter[])new QFilter[]{filter});
            if (dynamicObject != null) {
                object.set("taxamount", (Object)BigDecimalUtil.setScale((Object)dynamicObject.getString("total_tax_amount")));
                BigDecimal effectiveTaxAmount = BigDecimalUtil.setScale((Object)dynamicObject.getString("effective_tax_amount"));
                object.set("effectivetaxamount", (Object)effectiveTaxAmount);
                object.set("signedtaxamount", (Object)effectiveTaxAmount);
                object.set("avaliabletaxamount", (Object)BigDecimal.ZERO);
                QFilter filter1 = new QFilter("invoicepkid", "=", object.get("invoicepkid"));
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"tcvat_input_invoice_sign", (String)"currentsigntaxamount", (QFilter[])new QFilter[]{filter1});
                BigDecimal signedtaxamount = collection.stream().map(p -> p.getBigDecimal("currentsigntaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                object.set("currentsigntaxamount", (Object)BigDecimalUtil.setScale((Object)effectiveTaxAmount.subtract(signedtaxamount)));
            }
        });
    }

    private void generateView(Map<String, String[]> errorInfo, Set<String> signedinvoice, List<DynamicObject> invoicenos, Set<String> errorSet) {
        if (errorSet.isEmpty() && signedinvoice.isEmpty()) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"InvoiceAutoSignPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.getView().close();
            return;
        }
        StringBuilder nr = new StringBuilder();
        errorInfo.forEach((k, v) -> nr.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\uff1a%1$s\u88ab\u3010%2$s\u3011\u548c\u3010%3$s\u3011\u89c4\u5219\u6807\u8bc6\u591a\u6b21\uff1b%4$s", (String)"InvoiceAutoSignPlugin_16", (String)"taxc-tcvat", (Object[])new Object[0]), k, v[0], v[1], SEPARATOR)));
        signedinvoice.forEach(s -> nr.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\uff1a%1$s\u5df2\u88ab\u6807\u8bc6\uff1b%2$s", (String)"InvoiceAutoSignPlugin_17", (String)"taxc-tcvat", (Object[])new Object[0]), s, SEPARATOR)));
        StringBuilder bt = new StringBuilder();
        bt.append(String.format(ResManager.loadKDString((String)"\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761\u3002", (String)"InvoiceAutoSignPlugin_18", (String)"taxc-tcvat", (Object[])new Object[0]), invoicenos.size(), errorSet.size() + signedinvoice.size()));
        if (StringUtil.isNotBlank((CharSequence)nr)) {
            bt.append(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\u4e3a\uff1a", (String)"InvoiceAutoSignPlugin_14", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(true);
        parameters.setCaption(ResManager.loadKDString((String)"\u63d0\u793a\u4fe1\u606f", (String)"InvoiceAutoSignPlugin_15", (String)"taxc-tcvat", (Object[])new Object[0]));
        parameters.setCustomParam("operateName", (Object)"");
        parameters.setCustomParam("title", (Object)bt.toString());
        parameters.setCustomParam("errorMsg", (Object)nr.toString());
        parameters.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "doneover"));
        this.getView().showForm(parameters);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String callBackId = event.getActionId();
        if ("doneover".equals(callBackId)) {
            this.getView().close();
        }
    }

    private Map<String, Object> isSigned(List<DynamicObject> resultList, Long orgId, String taxperiod) {
        List invoicepkids = resultList.stream().map(p -> p.getString("invoicepkid")).collect(Collectors.toList());
        QFilter filter = new QFilter("invoicepkid", "in", invoicepkids);
        filter.and("org", "=", (Object)orgId).and("taxperiod", "=", (Object)taxperiod);
        DynamicObjectCollection signed = QueryServiceHelper.query((String)"tcvat_input_invoice_sign", (String)"invoicepkid,invoiceno,signtype", (QFilter[])new QFilter[]{filter}, (String)"createtime desc");
        Map<String, List<DynamicObject>> invoicepkid = signed.stream().collect(Collectors.groupingBy(s -> s.getString("invoicepkid")));
        ArrayList resignedsetPkid = new ArrayList();
        invoicepkid.forEach((k, v) -> {
            if ("1".equals(((DynamicObject)v.get(0)).getString("signtype"))) {
                resignedsetPkid.add(k);
            }
        });
        Set signedinvoice = resultList.parallelStream().filter(f -> resignedsetPkid.contains(f.get("invoicepkid"))).map(p -> p.getString("invoiceno")).collect(Collectors.toSet());
        List invoicenos = resultList.parallelStream().filter(p -> !resignedsetPkid.contains(p.getString("invoicepkid"))).collect(Collectors.toList());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("resignedset", signedinvoice);
        result.put("needsignset", invoicenos);
        return result;
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object selectedOrg = formShowParameter.getCustomParams().get("selected_org");
        if (Objects.isNull(selectedOrg)) {
            return;
        }
        String s = selectedOrg.toString().replaceAll("\"", "");
        String[] substring = s.substring(1, s.length() - 1).split(",");
        if (substring.length != 1 || StringUtil.isBlank((CharSequence)substring[0])) {
            return;
        }
        TaxResult listTaxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgIdsAndIsTaxpayerAndIsYbnsr(Collections.singletonList(Long.parseLong(substring[0])));
        if (CollectionUtils.isNotEmpty((Collection)((Collection)listTaxResult.getData()))) {
            this.getModel().setValue("org", (Object)substring[0]);
        }
    }

    private List<DynamicObject> getFutureList(List<Future<Object>> futures) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        try {
            for (Future<Object> future : futures) {
                list.addAll((Collection)future.get());
            }
        }
        catch (Exception e) {
            logger.error("getFutureList error " + e);
        }
        return list;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        if (name.equals("org")) {
            TaxResult listTaxResult = TaxcCombineDataServiceHelper.queryTaxcOrgIdsWithPerm((Long)RequestContext.get().getCurrUserId());
            TaxResult listTaxResult1 = TaxcMainDataServiceHelper.queryTaxcMainByOrgIdsAndIsTaxpayerAndIsYbnsr((List)((List)listTaxResult.getData()));
            ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
            parameter.getListFilterParameter().setFilter(new QFilter("id", "in", listTaxResult1.getData()));
        }
    }
}

