/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rules;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.DataType;
import kd.taxc.bdtaxr.common.enums.RuleCodeEnum;
import kd.taxc.bdtaxr.common.impt.TcvatRuleEntryEntityEnum;
import kd.taxc.tcvat.formplugin.rules.VatRateSetHandler;

public class JzjtjxseRulePlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final List<String> pops = Lists.newArrayList((Object[])new String[]{"table", "table1"});
    private static final String ENTRYENTITY = "entryentity";
    private static final String TCVAT_ADVANCE_CONFIG = "tcvat_advance_config";
    private static final String TCTB_DATASOURCE_PKRULES = "tctb_datasource_pkrules";

    public void registerListener(EventObject event) {
        pops.forEach(s -> {
            BasedataEdit object = (BasedataEdit)this.getControl((String)s);
            object.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        });
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object createorg = customParams.get("createorg");
        if (null != createorg) {
            this.getModel().setValue("org", createorg);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.controlEntryShow();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("jzjtlx".equals(name)) {
            this.controlEntryShow();
        }
    }

    public void controlEntryShow() {
        String jzjtlx = (String)this.getModel().getValue("jzjtlx");
        if ("jzjt".equals(jzjtlx)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
            if (this.getModel().getEntryRowCount("entryentity1") > 0) {
                this.getModel().deleteEntryData("entryentity1");
            }
        } else if ("wfhf".equals(jzjtlx)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconap1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap"});
            if (this.getModel().getEntryRowCount(ENTRYENTITY) > 0) {
                this.getModel().deleteEntryData(ENTRYENTITY);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap", "advconap1"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (operateKey.startsWith("newentry")) {
            int[] selectRows;
            String suffix = operateKey.replace("newentry", "");
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY + suffix);
            for (int selectRow : selectRows = entryGrid.getSelectRows()) {
                this.getModel().setValue("bizname" + suffix, this.getModel().getValue("name"), selectRow);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            String operateKey = ((Donothing)args.getSource()).getOperateKey();
            String entitySuffix = "";
            if (operateKey.startsWith("setadvancedconf")) {
                entitySuffix = operateKey.replace("setadvancedconf", "");
                EntryGrid entryentity = (EntryGrid)this.getControl(ENTRYENTITY + entitySuffix);
                int focusRow = entryentity.getEntryState().getFocusRow();
                BigDecimal vatrate = (BigDecimal)this.getModel().getValue("vatrate" + entitySuffix, focusRow);
                String datatype = (String)this.getModel().getValue("datatype" + entitySuffix, focusRow);
                if (datatype.equals(DataType.ZJQS.getCode())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219\u884c\u7684\u53d6\u6570\u65b9\u5f0f\u7b49\u4e8e\u201d\u76f4\u63a5\u53d6\u6570\u201c\uff0c\u65e0\u9700\u914d\u7f6e\u201d\u9ad8\u7ea7\u914d\u7f6e\u201c\u3002", (String)"JzjtjxseRulePlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                    return;
                }
                this.openAdvancedConfPage(vatrate.toPlainString(), operateKey);
            }
        }
        if (args.getSource() instanceof Save) {
            VatRateSetHandler.doSetVatRateWhileZJQS(this.getModel(), TcvatRuleEntryEntityEnum.TCVAT_RULE_JZJTSE);
        }
    }

    private void openAdvancedConfPage(String vatrate, String actionId) {
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId(TCVAT_ADVANCE_CONFIG);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formshowParameter.getCustomParams().put("vatrate", vatrate);
        this.getView().showForm(formshowParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        String name = evt.getProperty().getName();
        if (name.startsWith("table")) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                formShowParameter.setUseOrgId(org.getLong("id"));
            }
            String formId = this.getView().getFormShowParameter().getFormId();
            String ruleType = RuleCodeEnum.getRuleType((String)formId);
            QFilter filter = new QFilter("basedataid.billno", "=", (Object)ruleType);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)TCTB_DATASOURCE_PKRULES, (String)"id", (QFilter[])new QFilter[]{filter});
            formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", collection.stream().map(e -> e.getLong("id")).collect(Collectors.toList())));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map filterData;
        String actionId = evt.getActionId();
        if (actionId.startsWith("setadvancedconf") && (filterData = (Map)evt.getReturnData()) != null) {
            String entitySuffix = actionId.replace("setadvancedconf", "");
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY + entitySuffix);
            this.getModel().setValue("vatrate" + entitySuffix, filterData.get("vatrate"), currentRowIndex);
        }
    }
}

