/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rules;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.taxcmain.TaxcMainBusiness;
import kd.taxc.bdtaxr.common.constant.tctb.TaxcMainConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.utils.ServiceInvokeUtils;
import kd.taxc.tcvat.business.service.ncp.NcpkcStandardService;
import org.apache.commons.lang3.ObjectUtils;

public class ProductRulePlugin
extends AbstractBillPlugIn
implements BasedataFuzzySearchListener,
BeforeF7SelectListener,
AfterF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(ProductRulePlugin.class);
    private static final String CPMC = "cpmc";
    private NcpkcStandardService ncpkcStandardService = new NcpkcStandardService();

    public void handleData(BasedataFuzzySearchEvent basedataFuzzySearchEvent) {
        basedataFuzzySearchEvent.getQueryData().clear();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit cpmcEdit = (BasedataEdit)this.getControl(CPMC);
        cpmcEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        cpmcEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject cpmc;
        BillShowParameter parameter;
        OperationStatus status;
        DynamicObject org;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object ruletype = customParams.get("ruletype");
        if (null == ruletype) {
            this.getModel().setValue("ruletype", (Object)"private");
        } else {
            this.getModel().setValue("ruletype", ruletype);
        }
        Object createorg = customParams.get("createorg");
        if (null != createorg) {
            this.getModel().setValue("org", createorg);
            customParams.remove("createorg");
            customParams.remove("orgid");
        }
        if (null != (org = (DynamicObject)this.getModel().getValue("org"))) {
            List ybnsrIdList;
            DynamicObject dy;
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(org.getLong("id")));
            if (EmptyCheckUtils.isNotEmpty((Object)result.getData()) && EmptyCheckUtils.isNotEmpty((Object)((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity")) && Objects.equals("none", (dy = (DynamicObject)((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity").get(0)).getString("farmdeducttype"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u4e2d\u4e0d\u9002\u7528\u519c\u4ea7\u54c1\u6838\u5b9a\u6263\u9664\u65b9\u6cd5\uff0c\u5982\u9700\u4f7f\u7528\u8bf7\u524d\u5f80\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f-\u589e\u503c\u7a0e\u7a0e\u79cd\u4fe1\u606f\u4e2d\u7ef4\u62a4\u6838\u5b9a\u6263\u9664\u53c2\u6570\u3002", (String)"ProductRulePlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.getModel().setValue("org", (Object)0L);
                return;
            }
            TaxResult listTaxResult = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj((String)TaxcMainConstant.ENTITYNAME, (String)TaxcMainConstant.TAXC_MAIN_CARD_FILED, (String)"TaxcMainMService", (String)"queryTaxcMainZzsByOrgId", (Object[])new Object[]{Collections.singletonList(org.getLong("id")), TaxationsysMappingEnum.CHN.getId()});
            if (listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData()) && ((ybnsrIdList = TaxcMainBusiness.queryTaxcMainByIsYbnsr((List)((List)listTaxResult.getData()))) == null || ybnsrIdList.isEmpty())) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u975e\u4e00\u822c\u7eb3\u7a0e\u4eba\uff0c\u4e0d\u9002\u7528\u4ea7\u54c1\u9879\u76ee\u89c4\u5219\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"ProductRulePlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]), new Object[0]));
                this.getModel().setValue("org", (Object)0L);
                return;
            }
        }
        if (OperationStatus.EDIT == (status = (parameter = (BillShowParameter)this.getView().getFormShowParameter()).getStatus()) && (cpmc = (DynamicObject)this.getModel().getValue(CPMC)) != null) {
            this.updateNcpkcStandardValue(cpmc.getLong("id"));
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        boolean exists;
        String name = evt.getProperty().getName();
        if (CPMC.equals(name) && !(exists = this.ncpkcStandardService.existsProductName(((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u519c\u4ea7\u54c1\u6263\u9664\u6807\u51c6\u9879\u76ee\u7ef4\u62a4\u6263\u9664\u6807\u51c6\u3002", (String)"ProductRulePlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        ListSelectedRow listSelectedRow;
        BasedataEdit edit = (BasedataEdit)evt.getSource();
        if (CPMC.equals(edit.getKey()) && (listSelectedRow = evt.getListSelectedRow()) != null) {
            Long cpmcId = (Long)listSelectedRow.getPrimaryKeyValue();
            this.updateNcpkcStandardValue(cpmcId);
        }
    }

    private void updateNcpkcStandardValue(Long cpmcId) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject object = this.ncpkcStandardService.queryNcpkcStandardDataByCpmcIdAndDate(null == org ? 0L : org.getLong("id"), cpmcId, new Date());
        if (object != null) {
            this.getModel().setValue("unit", object.get("unitId"));
            BigDecimal rate = object.getBigDecimal("rate");
            String rateStr = rate.multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP).toPlainString() + "%";
            this.getModel().setValue("rate", (Object)rateStr);
        } else {
            this.getModel().setValue("unit", null);
            this.getModel().setValue("rate", null);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String eventName = e.getProperty().getName();
        if ("org".equals(eventName)) {
            DynamicObject newOrg = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (null != org) {
                List ybnsrIdList;
                DynamicObject dy;
                TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(org.getLong("id")));
                if (EmptyCheckUtils.isNotEmpty((Object)result.getData()) && EmptyCheckUtils.isNotEmpty((Object)((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity")) && Objects.equals("none", (dy = (DynamicObject)((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity").get(0)).getString("farmdeducttype"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u4e2d\u4e0d\u9002\u7528\u519c\u4ea7\u54c1\u6838\u5b9a\u6263\u9664\u65b9\u6cd5\uff0c\u5982\u9700\u4f7f\u7528\u8bf7\u524d\u5f80\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f-\u589e\u503c\u7a0e\u7a0e\u79cd\u4fe1\u606f\u4e2d\u7ef4\u62a4\u6838\u5b9a\u6263\u9664\u53c2\u6570\u3002", (String)"ProductRulePlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                    this.getModel().setValue("org", (Object)0L);
                    return;
                }
                TaxResult listTaxResult = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj((String)TaxcMainConstant.ENTITYNAME, (String)TaxcMainConstant.TAXC_MAIN_CARD_FILED, (String)"TaxcMainMService", (String)"queryTaxcMainZzsByOrgId", (Object[])new Object[]{Collections.singletonList(org.getLong("id")), TaxationsysMappingEnum.CHN.getId()});
                if (listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData()) && ((ybnsrIdList = TaxcMainBusiness.queryTaxcMainByIsYbnsr((List)((List)listTaxResult.getData()))) == null || ybnsrIdList.isEmpty())) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u975e\u4e00\u822c\u7eb3\u7a0e\u4eba\uff0c\u4e0d\u9002\u7528\u4ea7\u54c1\u9879\u76ee\u89c4\u5219\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"ProductRulePlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]), new Object[0]));
                    this.getModel().setValue("org", (Object)0L);
                    return;
                }
            }
        }
    }
}

