/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rules;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.tree.SearchUtil;
import kd.taxc.tcvat.formplugin.rules.AbstractRuleConfigPlugin;

public class RefundRuleConfigPlugin
extends AbstractRuleConfigPlugin {
    private static Log logger = LogFactory.getLog(RefundRuleConfigPlugin.class);
    private Set<String> refundKeys = new HashSet<String>(Arrays.asList("refundadd", "refundup", "refunddown", "refundlabel", "cardflexpanelap2", "cardflexpanelap3", "cardflexpanelap4", "cardflexpanelap7", "refund_image", "labelap_modifydate", "labelap_refundtype", "labelap_enable", "labelap_disable"));
    private static final String RULE_TYPE_REFUND = "refund";
    private static final String ENTITY_REFUNDRULE = "tcvat_rule_refund";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(this.refundKeys.toArray(new String[0]));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("CURRENT_TAB", "refundruletab");
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        String ruleType = (String)showParameter.getCustomParams().get("ruletype");
        String pageName = "public".equals(ruleType) ? ResManager.loadKDString((String)"\u7559\u62b5\u9000\u7a0e\u89c4\u5219\u914d\u7f6e\uff08\u5171\u4eab\uff09", (String)"RefundRuleConfigPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7559\u62b5\u9000\u7a0e\u89c4\u5219\u914d\u7f6e", (String)"RefundRuleConfigPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]);
        showParameter.setCaption(pageName);
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        this.getPageCache().put("CURRENT_TAB", tabKey);
        if ("refundruletab".equals(tabKey)) {
            this.loadrefundrule(this.ruleCardQueryCondition());
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (this.refundKeys.contains(key)) {
            Object pkid;
            EntryGrid apportionentity = (EntryGrid)this.getControl("refundentity");
            int[] selectRows = apportionentity.getSelectRows();
            Object object = pkid = selectRows.length > 0 ? this.getModel().getValue("refundid", selectRows[0]) : null;
            if (key.contains(RULE_TYPE_REFUND)) {
                pkid = null;
            }
            String formId = ENTITY_REFUNDRULE;
            this.openRuleForm(formId, pkid, RULE_TYPE_REFUND);
        }
        if ("searchbefore".equals(key) || "searchnext".equals(key)) {
            String[] btns = new String[]{"searchbefore", "searchnext"};
            SearchUtil.getLeftOrRight((IPageCache)this.getPageCache(), (IFormView)this.getView(), (String)key, (TreeView)((TreeView)this.getControl(TREE_ORG)), (String[])btns, (String)TREE_ORG);
        }
    }

    @Override
    public String getNewRuleFormId(String currentTab) {
        String formId = ENTITY_REFUNDRULE;
        if ("refundruletab".equals(currentTab)) {
            formId = ENTITY_REFUNDRULE;
        }
        return formId;
    }

    @Override
    public boolean checkBeforeOpenRuleForm(String ruletype, String orgId) {
        return this.checkXgmnsr(orgId);
    }

    @Override
    public boolean checkbeforeTreeNodeClick(String nodeId) {
        return this.checkXgmnsr(nodeId);
    }

    public boolean checkXgmnsr(String nodeId) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(Long.valueOf(nodeId)));
        if (EmptyCheckUtils.isNotEmpty((Object)result.getData()) && EmptyCheckUtils.isNotEmpty((Object)((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity"))) {
            DynamicObject object = (DynamicObject)((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity").get(0);
            String taxpayertype = object.getString("taxpayertype");
            if ("xgmnsr".equals(taxpayertype)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u4e3a\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\uff0c\u4e0d\u9002\u7528\u7559\u62b5\u9000\u7a0e\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"RefundRuleConfigPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void loadTab(String tab) {
        if (null != tab) {
            if ("refundruletab".equals(tab)) {
                this.loadrefundrule(this.ruleCardQueryCondition());
            }
        } else {
            this.loadrefundrule(this.ruleCardQueryCondition());
        }
    }

    public void loadrefundrule(List<QFilter> filters) {
        logger.info(SerializationUtils.toJsonString((Object)this.getModel().getDataEntity(true)));
        if (this.getModel().getDataEntityType().getProperty("refundentity") != null) {
            this.getModel().deleteEntryData("refundentity");
            DynamicObjectCollection rules = QueryServiceHelper.query((String)ENTITY_REFUNDRULE, (String)"id,org.name as org,org.status as status,ruletype,enable,name,modifytime,refundtype.name refundtype", (QFilter[])filters.toArray(new QFilter[0]), (String)"ruletype desc");
            this.getModel().beginInit();
            for (DynamicObject rule : rules) {
                int row = this.getModel().createNewEntryRow("refundentity");
                this.getModel().setValue("refundid", rule.get("id"), row);
                this.getModel().setValue("refundrulename", (Object)rule.getString("name"), row);
                this.getModel().setValue("refundmodifydate", rule.get("modifytime"), row);
                this.getModel().setValue("refundenable", rule.get("enable"), row);
                this.getModel().setValue("refundtype", (Object)rule.getString("refundtype"), row);
                String ruletype = rule.getString("ruletype");
                this.getModel().setValue("refundruletype", (Object)ruletype, row);
                this.setBackgroundAndImage(row, RULE_TYPE_REFUND, "private");
            }
            this.getModel().endInit();
            this.getView().updateView("refundentity");
        }
    }

    private void setBackgroundAndImage(int row, String type, String ruletype) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>(16);
        HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>(16);
        if ("private".equals(ruletype)) {
            propertiesMap.put("bc", "#FFF2E9");
            propertiesMap.put("src", "/icons/pc/label/swy_zy_61_61.png");
        } else {
            propertiesMap.put("bc", "#E7F0FF");
            propertiesMap.put("src", "/icons/pc/label/swy_fp_61_61.png");
        }
        pmap.put(type + "_flex", propertiesMap);
        pmap.put(type + "_image", propertiesMap);
        ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        client.invokeControlMethod(type + "entity", "setCustomProperties", new Object[]{row, pmap});
    }
}

