/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rules;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.tree.SearchUtil;
import kd.taxc.tcvat.business.service.rule.RuleService;
import kd.taxc.tcvat.formplugin.rules.AbstractRuleConfigPlugin;

public class RuleConfigsPlugin
extends AbstractRuleConfigPlugin {
    private static Log logger = LogFactory.getLog(RuleConfigsPlugin.class);
    private String ENTITY_INCOMERULE = "tcvat_rule_income";
    private String ENTITY_ROLLOUT = "tcvat_rule_rollout";
    private String ENTITY_DEDUCT = "tcvat_rule_deduct";
    private String ENTITY_DIFF = "tcvat_rule_diff";
    private String ENTITY_DEDUCTION = "tcvat_rule_deduction";
    private String ENTITY_PERPRE = "tcvat_rule_perpre";
    private String ENTITY_MDTS = "tcvat_rule_mdts";
    private String RULE_TYPE_INCOME = "income";
    private String RULE_TYPE_ROLLOUT = "rollout";
    private String RULE_TYPE_DEDUCT = "deduct";
    private String RULE_TYPE_DIFF = "diff";
    private String RULE_TYPE_DEDUCTION = "deduction";
    private String RULE_TYPE_PERPRE = "perpre";
    private String RULE_TYPE_MDTS = "mdts";
    private Set<String> incomeKeys = new HashSet<String>(Arrays.asList("incomeadd", "incomeup", "incomedown", "incomelabel", "cardflexpanelap2", "cardflexpanelap3", "cardflexpanelap4", "cardflexpanelap5", "cardflexpanelap6", "cardflexpanelap7", "income_image", "labelap_modifydate", "labelap_jzjt", "labelap_taxrate", "labelap_enable", "labelap_disable", "labelap_rulepurpose"));
    private Set<String> deductKeys = new HashSet<String>(Arrays.asList("adddeduct", "adddeductup", "adddeductdown", "adddeductlabel", "deductcardflexpanelap1", "deductcardflexpanelap2", "deductcardflexpanelap3", "deductcardflexpanelap4", "deductcardflexpanelap5", "deductcardflexpanelap6", "deduct_image", "deduct_labelap_modifydate", "deduct_labelap_jzjt", "deduct_labelap_taxrate", "deduct_enable", "deduct_disable", "labelap_rulepurpose2"));
    private Set<String> rolloutKeys = new HashSet<String>(Arrays.asList("rolloutadd", "rolloutup", "rolloutdown", "rolloutlabel", "cardflexpanelap11", "cardflexpanelap21", "cardflexpanelap31", "cardflexpanelap41", "cardflexpanelap51", "cardflexpanelap61", "cardflexpanelap71", "rollout_image", "labelap_modifydate1", "labelap_jzjt1", "labelap_rollouttype", "labelap_enable1", "labelap_disable1", "labelap_rulepurpose1"));
    private Set<String> diffKeys = new HashSet<String>(Arrays.asList("diffadd", "diffup", "diffdown", "difflabel", "cardflexpanelap12", "cardflexpanelap22", "cardflexpanelap32", "cardflexpanelap42", "cardflexpanelap52", "cardflexpanelap62", "cardflexpanelap72", "diff_image", "labelap_modifydate2", "labelap_jzjt2", "labelap_difftype", "labelap_enable2", "labelap_disable2", "labelap_rulepurpose3"));
    private Set<String> deductionKeys = new HashSet<String>(Arrays.asList("deductionadd", "deductionup", "deductiondown", "deductionlabel", "cardflexpanelap40", "cardflexpanelap43", "cardflexpanelap44", "cardflexpanelap421", "cardflexpanelap46", "cardentryflexpanelap45", "cardflexpanelap47", "deduction_image", "labelap_modifydate4", "labelap_jzjt4", "labelap_deductiontype", "labelap_enable4", "labelap_disable4", "labelap_rulepurpose4"));
    private Set<String> prepayKeys = new HashSet<String>(Arrays.asList("prepayadd", "prepayup", "prepaydown", "prepaylabel", "cardflexpanelap13", "cardflexpanelap23", "cardflexpanelap33", "cardflexpanelap451", "cardentryflexpanelap63", "cardflexpanelap73", "labelap_modifydate3", "labelap_enable3", "prepay_image", "labelap_disable3"));
    private Set<String> perpreKeys = new HashSet<String>(Arrays.asList("perpreadd", "perpreup", "perpredown", "perprelabel", "cardflexpanelap401", "cardflexpanelap431", "cardflexpanelap441", "cardflexpanelap4211", "cardflexpanelap461", "cardentryflexpanelap451", "cardflexpanelap471", "perpre_image", "labelap_modifydate41", "labelap_perpretype", "perpre_enable", "perpre_disable"));
    private Set<String> mdtsKeys = new HashSet<String>(Arrays.asList("mdtsadd", "mdtsup", "mdtsdown", "mdtslabel", "cardflexpanelap4011", "cardflexpanelap4311", "cardflexpanelap4411", "cardflexpanelap42111", "cardflexpanelap4611", "cardentryflexpanelap4511", "cardflexpanelap4711", "mdts_image", "labelap_modifydate411", "labelap_mdtstype", "mdts_enable", "mdts_disable"));
    private RuleService ruleService = new RuleService();

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(this.incomeKeys.toArray(new String[0]));
        this.addClickListeners(this.rolloutKeys.toArray(new String[0]));
        this.addClickListeners(this.deductKeys.toArray(new String[0]));
        this.addClickListeners(this.diffKeys.toArray(new String[0]));
        this.addClickListeners(this.deductionKeys.toArray(new String[0]));
        this.addClickListeners(this.prepayKeys.toArray(new String[0]));
        this.addClickListeners(this.perpreKeys.toArray(new String[0]));
        this.addClickListeners(this.mdtsKeys.toArray(new String[0]));
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        String ruleType = (String)showParameter.getCustomParams().get("ruletype");
        String pageName = "public".equals(ruleType) ? ResManager.loadKDString((String)"\u7533\u62a5\u9879\u89c4\u5219\u914d\u7f6e\uff08\u5171\u4eab\uff09", (String)"RuleConfigsPlugin_26", (String)"taxc-tcvat", (Object[])new Object[0]) : ("prepay".equals(showParameter.getCustomParams().get("menutype")) ? ResManager.loadKDString((String)"\u9884\u7f34\u9879\u76ee", (String)"RuleConfigsPlugin_20", (String)"taxc-tcvat", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7533\u62a5\u9879\u89c4\u5219\u914d\u7f6e", (String)"RuleConfigsPlugin_27", (String)"taxc-tcvat", (Object[])new Object[0]));
        showParameter.setCaption(ResManager.loadKDString((String)pageName, (String)"RuleConfigsPlugin_18", (String)"RuleConfigsPlugin_21", (Object[])new Object[0]));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"prepayruletab"});
        this.getPageCache().put("CURRENT_TAB", "incomeruletab");
    }

    public void click(EventObject evt) {
        EntryGrid deductionentity;
        String key = ((Control)evt.getSource()).getKey();
        String issystem = "0";
        Object pkid = null;
        if (this.incomeKeys.contains(key)) {
            EntryGrid incomeentity = (EntryGrid)this.getControl("incomeentity");
            int[] selectRows = incomeentity.getSelectRows();
            Object object = pkid = selectRows.length > 0 ? this.getModel().getValue("incomeid", selectRows[0]) : null;
            if (key.contains("income")) {
                pkid = null;
            }
            this.openRuleForm(this.ENTITY_INCOMERULE, pkid, this.RULE_TYPE_INCOME);
        } else if (this.rolloutKeys.contains(key)) {
            EntryGrid rolloutentity = (EntryGrid)this.getControl("rolloutentity");
            int[] selectRows = rolloutentity.getSelectRows();
            Object object = pkid = selectRows.length > 0 ? this.getModel().getValue("rolloutid", selectRows[0]) : null;
            if (key.contains("rollout")) {
                pkid = null;
            }
            this.openRuleForm(this.ENTITY_ROLLOUT, pkid, this.RULE_TYPE_ROLLOUT);
        } else if (this.deductKeys.contains(key)) {
            EntryGrid deductentity = (EntryGrid)this.getControl("deductentity");
            int[] selectRows = deductentity.getSelectRows();
            if (selectRows.length > 0) {
                pkid = this.getModel().getValue("deductid", selectRows[0]);
                issystem = Optional.ofNullable((String)this.getModel().getValue("ruleissystem", selectRows[0])).orElse("0");
            }
            if (key.contains("adddeduct")) {
                pkid = null;
            }
            this.openRuleForm(this.ENTITY_DEDUCT, pkid, issystem);
        } else if (this.diffKeys.contains(key)) {
            EntryGrid diffentity = (EntryGrid)this.getControl("diffentity");
            int[] selectRows = diffentity.getSelectRows();
            Object object = pkid = selectRows.length > 0 ? this.getModel().getValue("diffid", selectRows[0]) : null;
            if (key.contains("diff")) {
                pkid = null;
            }
            this.openRuleForm(this.ENTITY_DIFF, pkid, this.RULE_TYPE_DIFF);
        } else if (this.deductionKeys.contains(key)) {
            deductionentity = (EntryGrid)this.getControl("deductionentity");
            int[] selectRows = deductionentity.getSelectRows();
            Object object = pkid = selectRows.length > 0 ? this.getModel().getValue("deductionid", selectRows[0]) : null;
            if (key.contains("deduction")) {
                pkid = null;
            }
            this.openRuleForm(this.ENTITY_DEDUCTION, pkid, this.RULE_TYPE_DEDUCTION);
        } else if (this.perpreKeys.contains(key)) {
            deductionentity = (EntryGrid)this.getControl("perpreentity");
            int[] selectRows = deductionentity.getSelectRows();
            if (selectRows.length > 0) {
                pkid = this.getModel().getValue("perpreid", selectRows[0]);
                issystem = Optional.ofNullable((String)this.getModel().getValue("ruleissystem", selectRows[0])).orElse("0");
            }
            if (key.contains("perpre")) {
                pkid = null;
            }
            this.openRuleForm(this.ENTITY_PERPRE, pkid, issystem);
        } else if (this.mdtsKeys.contains(key)) {
            deductionentity = (EntryGrid)this.getControl("mdtsentity");
            int[] selectRows = deductionentity.getSelectRows();
            Object object = pkid = selectRows.length > 0 ? this.getModel().getValue("mdtsid", selectRows[0]) : null;
            if (key.contains("mdts")) {
                pkid = null;
            }
            this.openRuleForm(this.ENTITY_MDTS, pkid, this.RULE_TYPE_MDTS);
        }
        if ("searchbefore".equals(key) || "searchnext".equals(key)) {
            String[] btns = new String[]{"searchbefore", "searchnext"};
            SearchUtil.getLeftOrRight((IPageCache)this.getPageCache(), (IFormView)this.getView(), (String)key, (TreeView)((TreeView)this.getControl(TREE_ORG)), (String[])btns, (String)TREE_ORG);
        }
    }

    @Override
    public void treeNodeClick(TreeNodeEvent evt) {
        DynamicObject dy;
        DynamicObjectCollection list;
        HasPermOrgResult hasPermOrgResult;
        String nodeId = evt.getNodeId().toString();
        IPageCache pageCache = this.getPageCache();
        String current = this.getPageCache().get("CURRENT_NODE");
        TreeView treeView = (TreeView)this.getControl(TREE_ORG);
        TreeNode treeNode = TreeUtils.getTreeNode((IPageCache)pageCache, (TreeView)treeView, (String)nodeId);
        if (nodeId.equals(current)) {
            current = null;
            this.getPageCache().put("CURRENT_NODE", "0");
        }
        if (!(hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView())).hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(nodeId))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RuleConfigsPlugin_12", (String)"taxc-tcvat", (Object[])new Object[0]), treeNode.getText()));
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
            return;
        }
        if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)Long.valueOf(nodeId)).getData()).booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"RuleConfigsPlugin_28", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(Long.parseLong(nodeId)));
        if (EmptyCheckUtils.isNotEmpty((Object)result.getData()) && EmptyCheckUtils.isNotEmpty((Object)((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity"))) {
            list = ((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity");
            dy = (DynamicObject)list.get(0);
            if (Objects.isNull(((DynamicObject)((List)result.getData()).get(0)).getString("taxorg.unifiedsocialcode"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u201c%s\u201d\u5c1a\u672a\u5f55\u5165\u4f01\u4e1a\u4fe1\u606f\uff0c\u8bf7\u5148\u5230\u57fa\u7840\u6570\u636e-\u7a0e\u52a1\u4fe1\u606f\u754c\u9762\u5f55\u5165\u4f01\u4e1a\u4fe1\u606f", (String)"RuleConfigsPlugin_13", (String)"taxc-tcvat", (Object[])new Object[0]), treeNode.getText()));
                TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
                return;
            }
            if (Objects.equals("0", dy.getString("enable"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7\u589e\u503c\u7a0e\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\uff0c\u5982\u9700\u64cd\u4f5c,\u8bf7\u524d\u5f80\u7a0e\u52a1\u4e91-\u57fa\u7840\u8d44\u6599-\u7a0e\u52a1\u4fe1\u606f\u8fdb\u884c\u542f\u7528\u3002", (String)"RuleConfigsPlugin_11", (String)"taxc-tcvat", (Object[])new Object[0]), treeNode.getText()));
                TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
                return;
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u57fa\u7840\u8d44\u6599-\u7a0e\u52a1\u4fe1\u606f\u4e2d\u5b8c\u5584\u7a0e\u52a1\u4fe1\u606f", (String)"RuleConfigsPlugin_22", (String)"taxc-tcvat", (Object[])new Object[0]));
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
            return;
        }
        pageCache.put("taxpayertype", dy.getString("taxpayertype"));
        pageCache.put("CURRENT_NODE", nodeId);
        String tab = pageCache.get("CURRENT_TAB");
        boolean existTypeChange = RuleService.loadTaxPayerTypeChangeRecord(this.getPageCache().get("CURRENT_NODE"), this.getPageCache().get("ruleType"));
        boolean isybnsr = this.ruleService.isybnsr(list, this.getPageCache().get("ruleType"), existTypeChange);
        this.getView().setVisible(Boolean.valueOf(isybnsr), new String[]{"rolloutruletab", "deductruletab", "perpreruletab", "mdtsruletab"});
        pageCache.put("existTypeChange", existTypeChange ? "true" : "false");
        this.loadTab(tab);
    }

    @Override
    public void loadTab(String tab) {
        if (null != tab) {
            if ("incomeruletab".equals(tab)) {
                this.loadincomerule(this.ruleCardQueryCondition());
            } else if ("rolloutruletab".equals(tab)) {
                this.loadrolloutrule(this.ruleCardQueryCondition());
            } else if ("deductruletab".equals(tab)) {
                this.loaddeductrule(this.ruleCardQueryCondition());
            } else if ("diffruletab".equals(tab)) {
                this.loaddiffrule(this.ruleCardQueryCondition());
            } else if ("taxdeductiontab".equals(tab)) {
                this.loadDeductionRule(this.ruleCardQueryCondition());
            } else if ("perpreruletab".equals(tab)) {
                this.loadPerpreRule(this.ruleCardQueryCondition());
            } else if ("mdtsruletab".equals(tab)) {
                this.loadMdtsRule(this.ruleCardQueryCondition());
            }
        } else {
            this.loadincomerule(this.ruleCardQueryCondition());
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        this.getPageCache().put("CURRENT_TAB", tabKey);
        if ("incomeruletab".equals(tabKey)) {
            this.loadincomerule(this.ruleCardQueryCondition());
        } else if ("deductruletab".equals(tabKey)) {
            this.loaddeductrule(this.ruleCardQueryCondition());
        } else if ("rolloutruletab".equals(tabKey)) {
            this.loadrolloutrule(this.ruleCardQueryCondition());
        } else if ("diffruletab".equals(tabKey)) {
            this.loaddiffrule(this.ruleCardQueryCondition());
        } else if ("taxdeductiontab".equals(tabKey)) {
            this.loadDeductionRule(this.ruleCardQueryCondition());
        } else if ("perpreruletab".equals(tabKey)) {
            this.loadPerpreRule(this.ruleCardQueryCondition());
        } else if ("mdtsruletab".equals(tabKey)) {
            this.loadMdtsRule(this.ruleCardQueryCondition());
        }
    }

    @Override
    public List<QFilter> ruleCardQueryCondition() {
        List<QFilter> filters = super.ruleCardQueryCondition();
        boolean existTypeChange = null != this.getPageCache().get("existTypeChange") ? "true".equals(this.getPageCache().get("existTypeChange")) : RuleService.loadTaxPayerTypeChangeRecord(this.getPageCache().get("CURRENT_NODE") == null ? "0" : this.getPageCache().get("CURRENT_NODE"), this.getPageCache().get("ruleType"));
        QFilter taxPayerTypeFilter = existTypeChange ? new QFilter("taxpayertype", "in", Arrays.asList("ybnsr", "xgmnsr")) : new QFilter("taxpayertype", "=", (Object)this.getPageCache().get("taxpayertype"));
        filters.add(taxPayerTypeFilter);
        return filters;
    }

    @Override
    public String getNewRuleFormId(String currentTab) {
        String formId = this.ENTITY_INCOMERULE;
        if ("incomeruletab".equals(currentTab)) {
            formId = this.ENTITY_INCOMERULE;
        } else if ("deductruletab".equals(currentTab)) {
            formId = this.ENTITY_DEDUCT;
        } else if ("rolloutruletab".equals(currentTab)) {
            formId = this.ENTITY_ROLLOUT;
        } else if ("taxdeductiontab".equals(currentTab)) {
            formId = this.ENTITY_DEDUCTION;
        } else if ("diffruletab".equals(currentTab)) {
            formId = this.ENTITY_DIFF;
        } else if ("perpreruletab".equals(currentTab)) {
            formId = this.ENTITY_PERPRE;
        } else if ("mdtsruletab".equals(currentTab)) {
            formId = this.ENTITY_MDTS;
        }
        return formId;
    }

    private void loadincomerule(List<QFilter> filters) {
        logger.info(SerializationUtils.toJsonString((Object)this.getModel().getDataEntity(true)));
        if (this.getModel().getDataEntityType().getProperty("incomeentity") != null) {
            this.getModel().deleteEntryData("incomeentity");
            Map jzjtMap = MetadataUtil.getComboItemsMap((String)this.ENTITY_INCOMERULE, (String)"jzjt");
            DynamicObjectCollection rules = QueryServiceHelper.query((String)this.ENTITY_INCOMERULE, (String)"id,org.name as org,org.status as status,ruletype,enable,name,modifytime,jzjt,taxrate.number as taxrate,taxation.name as taxation, taxpayertype,rulepurpose", (QFilter[])filters.toArray(new QFilter[0]), (String)"ruletype desc");
            CardEntry incomeentity = (CardEntry)this.getControl("incomeentity");
            this.getModel().beginInit();
            for (DynamicObject rule : rules) {
                int row = this.getModel().createNewEntryRow("incomeentity");
                this.getModel().setValue("incomeid", rule.get("id"), row);
                this.getModel().setValue("incomerulename", (Object)rule.getString("name"), row);
                this.getModel().setValue("incomemodifydate", rule.get("modifytime"), row);
                this.getModel().setValue("incomeenable", rule.get("enable"), row);
                this.getModel().setValue("ruletaxation", rule.get("taxation"), row);
                String ruletype = rule.getString("ruletype");
                this.getModel().setValue("incomeruletype", (Object)ruletype, row);
                this.getModel().setValue("taxrate", rule.get("taxrate"), row);
                this.getModel().setValue("jzjt", jzjtMap.get(rule.get("jzjt")), row);
                this.getModel().setValue("incomerulepurpose", (Object)this.ruleService.getRulePurposeName(this.ENTITY_INCOMERULE, rule.getString("rulepurpose")), row);
                if ("xgmnsr".equals(rule.getString("taxpayertype"))) {
                    incomeentity.setChildVisible(false, row, new String[]{"cardflexpanelap4"});
                    this.getModel().setValue("income_label1", (Object)ResManager.loadKDString((String)"\u5c0f\u89c4\u6a21", (String)"RuleConfigsPlugin_17", (String)"taxc-tcvat", (Object[])new Object[0]), row);
                }
                this.setBackgroundAndImage(row, "income", rule.getString("taxpayertype"));
            }
            this.getModel().endInit();
            this.getView().updateView("incomeentity");
        }
    }

    private void loaddeductrule(List<QFilter> filters) {
        logger.info(SerializationUtils.toJsonString((Object)this.getModel().getDataEntity(true)));
        if (this.getModel().getDataEntityType().getProperty("deductentity") != null) {
            this.getModel().deleteEntryData("deductentity");
            Map jzjtMap = MetadataUtil.getComboItemsMap((String)this.ENTITY_DEDUCT, (String)"jzjt");
            DynamicObjectCollection rules = QueryServiceHelper.query((String)this.ENTITY_DEDUCT, (String)"id,org.name as org,org.status as status,ruletype,enable,name,modifytime,jzjt, taxpayertype,deducttype.name as deductname,issystem,rulepurpose", (QFilter[])filters.toArray(new QFilter[0]), (String)"enable desc, issystem desc");
            this.getModel().beginInit();
            for (DynamicObject rule : rules) {
                int row = this.getModel().createNewEntryRow("deductentity");
                this.getModel().setValue("deductid", rule.get("id"), row);
                this.getModel().setValue("deductrulename", (Object)rule.getString("name"), row);
                this.getModel().setValue("deductmodifydate", rule.get("modifytime"), row);
                this.getModel().setValue("ruleissystem", rule.get("issystem"), row);
                this.getModel().setValue("deductenable", rule.get("enable"), row);
                String ruletype = rule.getString("ruletype");
                this.getModel().setValue("deductruletype", (Object)ruletype, row);
                this.getModel().setValue("deducttype", (Object)rule.getString("deductname"), row);
                this.getModel().setValue("deductjzjt", jzjtMap.get(rule.getString("jzjt")), row);
                this.getModel().setValue("deductrulepurpose", (Object)this.ruleService.getRulePurposeName(this.ENTITY_DEDUCT, rule.getString("rulepurpose")), row);
                this.setBackgroundAndImage(row, "deduct", rule.getString("taxpayertype"));
            }
            this.getModel().endInit();
            this.getView().updateView("deductentity");
        }
    }

    private void loadrolloutrule(List<QFilter> filters) {
        if (this.getModel().getDataEntityType().getProperty("rolloutentity") != null) {
            this.getModel().deleteEntryData("rolloutentity");
            Map jzjtMap = MetadataUtil.getComboItemsMap((String)this.ENTITY_ROLLOUT, (String)"jzjt");
            String fields = "id,org.name as org,org.status as status,ruletype,enable,name,modifytime,jzjt,rollouttype.value as rollouttype,taxpayertype,rulepurpose";
            DynamicObjectCollection rules = QueryServiceHelper.query((String)this.ENTITY_ROLLOUT, (String)fields, (QFilter[])filters.toArray(new QFilter[0]), (String)"ruletype desc");
            this.getModel().beginInit();
            for (DynamicObject rule : rules) {
                int row = this.getModel().createNewEntryRow("rolloutentity");
                this.getModel().setValue("rolloutid", rule.get("id"), row);
                this.getModel().setValue("rolloutrulename", (Object)rule.getString("name"), row);
                this.getModel().setValue("rolloutmodifydate", rule.get("modifytime"), row);
                String ruletype = rule.getString("ruletype");
                this.getModel().setValue("rolloutruletype", (Object)ruletype, row);
                this.getModel().setValue("rollouttype", (Object)rule.getString("rollouttype"), row);
                this.getModel().setValue("rolloutenable", (Object)rule.getString("enable"), row);
                this.getModel().setValue("jzjt1", jzjtMap.get(rule.get("jzjt")), row);
                this.getModel().setValue("rolloutrulepurpose", (Object)this.ruleService.getRulePurposeName(this.ENTITY_ROLLOUT, rule.getString("rulepurpose")), row);
                this.setBackgroundAndImage(row, "rollout", rule.getString("taxpayertype"));
                if (!"xgmnsr".equals(rule.getString("taxpayertype"))) continue;
                this.getModel().setValue("rollout_label1", (Object)ResManager.loadKDString((String)"\u5c0f\u89c4\u6a21", (String)"RuleConfigsPlugin_17", (String)"taxc-tcvat", (Object[])new Object[0]), row);
            }
            this.getModel().endInit();
            this.getView().updateView("rolloutentity");
        }
    }

    private void loaddiffrule(List<QFilter> filters) {
        if (this.getModel().getDataEntityType().getProperty("diffentity") != null) {
            this.getModel().deleteEntryData("diffentity");
            Map jzjtMap = MetadataUtil.getComboItemsMap((String)this.ENTITY_DIFF, (String)"jzjt");
            String fields = "id,org.name as org,org.status as status,ruletype,enable,name,modifytime,jzjt,difftype.value as difftype,taxpayertype,rulepurpose";
            DynamicObjectCollection rules = QueryServiceHelper.query((String)this.ENTITY_DIFF, (String)fields, (QFilter[])filters.toArray(new QFilter[0]), (String)"ruletype desc");
            CardEntry diffentity = (CardEntry)this.getControl("diffentity");
            this.getModel().beginInit();
            for (DynamicObject rule : rules) {
                int row = this.getModel().createNewEntryRow("diffentity");
                this.getModel().setValue("diffid", rule.get("id"), row);
                this.getModel().setValue("diffrulename", (Object)rule.getString("name"), row);
                this.getModel().setValue("diffmodifydate", rule.get("modifytime"), row);
                String ruletype = rule.getString("ruletype");
                this.getModel().setValue("diffruletype", (Object)ruletype, row);
                this.getModel().setValue("difftype", (Object)rule.getString("difftype"), row);
                this.getModel().setValue("diffenable", (Object)rule.getString("enable"), row);
                this.getModel().setValue("jzjt2", jzjtMap.get(rule.get("jzjt")), row);
                this.getModel().setValue("diffrulepurpose", (Object)this.ruleService.getRulePurposeName(this.ENTITY_DIFF, rule.getString("rulepurpose")), row);
                if ("xgmnsr".equals(rule.getString("taxpayertype"))) {
                    diffentity.setChildVisible(false, row, new String[]{"cardflexpanelap42"});
                    this.getModel().setValue("diff_label1", (Object)ResManager.loadKDString((String)"\u5c0f\u89c4\u6a21", (String)"RuleConfigsPlugin_17", (String)"taxc-tcvat", (Object[])new Object[0]), row);
                }
                this.setBackgroundAndImage(row, "diff", rule.getString("taxpayertype"));
            }
            this.getModel().endInit();
            this.getView().updateView("diffentity");
            if ("xgmnsr".equals(this.getPageCache().get("taxpayertype"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"cardflexpanelap4"});
            }
        }
    }

    private void loadDeductionRule(List<QFilter> filters) {
        if (this.getModel().getDataEntityType().getProperty("deductionentity") != null) {
            this.getModel().deleteEntryData("deductionentity");
            String fields = "id,org.name as org,org.status as status,ruletype,enable,name,modifytime,reductiontype,taxpayertype,rulepurpose";
            DynamicObjectCollection rules = QueryServiceHelper.query((String)this.ENTITY_DEDUCTION, (String)fields, (QFilter[])filters.toArray(new QFilter[0]), (String)"ruletype desc");
            CardEntry diffentity = (CardEntry)this.getControl("deductionentity");
            this.getModel().beginInit();
            for (DynamicObject rule : rules) {
                int row = this.getModel().createNewEntryRow("deductionentity");
                this.getModel().setValue("deductionid", rule.get("id"), row);
                this.getModel().setValue("deductionrulename", (Object)rule.getString("name"), row);
                this.getModel().setValue("deductionmodifydate", rule.get("modifytime"), row);
                String ruletype = rule.getString("ruletype");
                this.getModel().setValue("deductionruletype", (Object)ruletype, row);
                this.getModel().setValue("deductiontype", (Object)rule.getString("reductiontype"), row);
                this.getModel().setValue("deductionenable", (Object)rule.getString("enable"), row);
                this.getModel().setValue("deductionrulepurpose", (Object)this.ruleService.getRulePurposeName(this.ENTITY_DEDUCTION, rule.getString("rulepurpose")), row);
                if ("xgmnsr".equals(rule.getString("taxpayertype"))) {
                    diffentity.setChildVisible(false, row, new String[]{"cardflexpanelap421"});
                    this.getModel().setValue("deduction_label1", (Object)ResManager.loadKDString((String)"\u5c0f\u89c4\u6a21", (String)"RuleConfigsPlugin_17", (String)"taxc-tcvat", (Object[])new Object[0]), row);
                }
                this.setBackgroundAndImage(row, "deduction", rule.getString("taxpayertype"));
            }
            this.getModel().endInit();
            this.getView().updateView("deductionentity");
            if ("xgmnsr".equals(this.getPageCache().get("taxpayertype"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"cardflexpanelap4"});
            }
        }
    }

    private void loadPerpreRule(List<QFilter> filters) {
        if (this.getModel().getDataEntityType().getProperty("perpreentity") != null) {
            this.getModel().deleteEntryData("perpreentity");
            String fields = "id,ruletype,enable,name,modifytime,perpreproduct.value as perpreproduct,taxpayertype,rulepurpose,issystem";
            DynamicObjectCollection rules = QueryServiceHelper.query((String)this.ENTITY_PERPRE, (String)fields, (QFilter[])filters.toArray(new QFilter[0]), (String)"ruletype desc");
            this.getModel().beginInit();
            for (DynamicObject rule : rules) {
                int row = this.getModel().createNewEntryRow("perpreentity");
                this.getModel().setValue("perpreid", rule.get("id"), row);
                this.getModel().setValue("perprerulename", (Object)rule.getString("name"), row);
                this.getModel().setValue("perpremodifydate", rule.get("modifytime"), row);
                String ruletype = rule.getString("ruletype");
                this.getModel().setValue("perpreruletype", (Object)ruletype, row);
                this.getModel().setValue("perprerulepurpose", (Object)this.ruleService.getRulePurposeName(this.ENTITY_PERPRE, rule.getString("rulepurpose")), row);
                this.getModel().setValue("perpreproject", rule.get("perpreproduct"), row);
                this.getModel().setValue("perpreenable", (Object)rule.getString("enable"), row);
                this.getModel().setValue("prepayissystem", rule.get("issystem"), row);
                if ("xgmnsr".equals(rule.getString("taxpayertype"))) {
                    this.getModel().setValue("perpre_label1", (Object)ResManager.loadKDString((String)"\u5c0f\u89c4\u6a21", (String)"RuleConfigsPlugin_17", (String)"taxc-tcvat", (Object[])new Object[0]), row);
                }
                this.setBackgroundAndImage(row, "perpre", rule.getString("taxpayertype"));
            }
            this.getModel().endInit();
            this.getView().updateView("perpreentity");
        }
    }

    private void loadMdtsRule(List<QFilter> filters) {
        if (this.getModel().getDataEntityType().getProperty("mdtsentity") != null) {
            this.getModel().deleteEntryData("mdtsentity");
            String fields = "id,ruletype,enable,name,modifytime,mdtype,taxpayertype,rulepurpose";
            DynamicObjectCollection rules = QueryServiceHelper.query((String)this.ENTITY_MDTS, (String)fields, (QFilter[])filters.toArray(new QFilter[0]), (String)"ruletype desc");
            ComboProp mdTypeProp = (ComboProp)MetadataServiceHelper.getDataEntityType((String)this.ENTITY_MDTS).getProperty("mdtype");
            this.getModel().beginInit();
            for (DynamicObject rule : rules) {
                int row = this.getModel().createNewEntryRow("mdtsentity");
                this.getModel().setValue("mdtsid", rule.get("id"), row);
                this.getModel().setValue("mdtsrulename", (Object)rule.getString("name"), row);
                this.getModel().setValue("mdtsmodifydate", rule.get("modifytime"), row);
                String ruletype = rule.getString("ruletype");
                this.getModel().setValue("mdtsruletype", (Object)ruletype, row);
                this.getModel().setValue("mdtsrulepurpose", (Object)this.ruleService.getRulePurposeName(this.ENTITY_MDTS, rule.getString("rulepurpose")), row);
                this.getModel().setValue("mdtype", (Object)mdTypeProp.getItemByName(rule.getString("mdtype")), row);
                this.getModel().setValue("mdtsenable", (Object)rule.getString("enable"), row);
                if ("xgmnsr".equals(rule.getString("taxpayertype"))) {
                    this.getModel().setValue("mdts_label1", (Object)ResManager.loadKDString((String)"\u5c0f\u89c4\u6a21", (String)"RuleConfigsPlugin_17", (String)"taxc-tcvat", (Object[])new Object[0]), row);
                }
                this.setBackgroundAndImage(row, "mdts", rule.getString("taxpayertype"));
            }
            this.getModel().endInit();
            this.getView().updateView("mdtsentity");
        }
    }

    private void setBackgroundAndImage(int row, String type, String taxPayerType) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>(16);
        HashMap<String, String> propertiesMap1 = new HashMap<String, String>(16);
        HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>(16);
        if ("xgmnsr".equals(taxPayerType)) {
            propertiesMap.put("bc", "rgba(255,246,239,1)");
            propertiesMap1.put("bgik", "linear-gradient(337deg,rgba(250,201,134,0.15) 0%,rgba(245,145,64,0.15) 100%)");
            propertiesMap1.put("fc", "#FF903D");
        } else {
            propertiesMap.put("bc", "rgba(241,247,255,1)");
            propertiesMap1.put("bgik", "linear-gradient(327deg,rgba(100,171,255,0.15) 0%,rgba(52,140,242,0.15) 100%)");
            propertiesMap1.put("fc", "#55A0F5");
        }
        pmap.put(type + "_flex", propertiesMap);
        pmap.put(type + "_image", propertiesMap);
        pmap.put(type + "_bc", propertiesMap1);
        ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        client.invokeControlMethod(type + "entity", "setCustomProperties", new Object[]{row, pmap});
    }
}

