/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rules;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.tree.SearchUtil;
import kd.taxc.tcvat.business.service.rule.RuleService;
import kd.taxc.tcvat.formplugin.rules.AbstractRuleConfigPlugin;

public class RuleTZConfigsPlugin
extends AbstractRuleConfigPlugin {
    private static Log logger = LogFactory.getLog(RuleTZConfigsPlugin.class);
    private static final String ENTITY_APPORTIONRULE = "tcvat_rule_apportion";
    private static final String ENTITY_APPORTIONRULE_INH = "tcvat_rule_apportion_inh";
    private static final String ENTITY_WKPSRRULE = "tcvat_rule_wkpsr";
    private static final String ENTITY_WKPSRRULE_INH = "tcvat_rule_wkpsr_inh";
    private static final String RULE_TYPE_APPORTION = "apportion";
    private static final String RULE_TYPE_WKPSR = "wkpsr";
    private Set<String> apportionKeys = new HashSet<String>(Arrays.asList("apportionadd", "apportionup", "apportiondown", "apportionlabel", "cardflexpanelap2", "cardflexpanelap3", "cardflexpanelap4", "cardflexpanelap5", "cardentryflexpanelap6", "cardflexpanelap7", "apportion_image", "labelap_modifydate", "labelap_enable", "labelap_disable", "labelap_zclx", ""));
    private Set<String> wkpsrKeys = new HashSet<String>(Arrays.asList("wkpsradd", "wkpsrup", "wkpsrdown", "wkpsrlabel", "cardflexpanelap11", "cardflexpanelap21", "cardflexpanelap31", "cardflexpanelap41", "cardflexpanelap411", "cardentryflexpanelap61", "cardflexpanelap72", "labelap_enable2", "labelap_disable2", "wkpsr_image", "wkpsr_bc"));

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(this.apportionKeys.toArray(new String[0]));
        this.addClickListeners(this.wkpsrKeys.toArray(new String[0]));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("CURRENT_TAB", "apportiontab");
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        String ruleType = (String)showParameter.getCustomParams().get("ruletype");
        String pageName = "public".equals(ruleType) ? ResManager.loadKDString((String)"\u53f0\u8d26\u9879\u76ee\u89c4\u5219\u914d\u7f6e\uff08\u5171\u4eab\uff09", (String)"RuleTZConfigsPlugin_11", (String)"taxc-tcvat", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53f0\u8d26\u9879\u76ee\u89c4\u5219\u914d\u7f6e", (String)"RuleTZConfigsPlugin_12", (String)"taxc-tcvat", (Object[])new Object[0]);
        showParameter.setCaption(pageName);
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        this.getPageCache().put("CURRENT_TAB", tabKey);
        if ("apportiontab".equals(tabKey)) {
            this.loadApportionRule(this.ruleCardQueryCondition());
        } else if ("wkpsrtab".equals(tabKey)) {
            this.loadWkpsrRule(this.ruleCardQueryCondition());
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (this.apportionKeys.contains(key)) {
            Object pkid;
            EntryGrid apportionentity = (EntryGrid)this.getControl("apportionentity");
            int[] selectRows = apportionentity.getSelectRows();
            Object object = pkid = selectRows.length > 0 ? this.getModel().getValue("apportionid", selectRows[0]) : null;
            if (key.contains(RULE_TYPE_APPORTION)) {
                pkid = null;
            }
            String formId = "public".equals(this.getPageCache().get("ruleType")) ? ENTITY_APPORTIONRULE_INH : ENTITY_APPORTIONRULE;
            this.openRuleForm(formId, pkid, RULE_TYPE_APPORTION);
        } else if (this.wkpsrKeys.contains(key)) {
            Object pkid;
            EntryGrid wkpsrentity = (EntryGrid)this.getControl("wkpsrentity");
            int[] selectRows = wkpsrentity.getSelectRows();
            Object object = pkid = selectRows.length > 0 ? this.getModel().getValue("wkpsrid", selectRows[0]) : null;
            if (key.contains(RULE_TYPE_WKPSR)) {
                pkid = null;
            }
            String formId = "public".equals(this.getPageCache().get("ruleType")) ? ENTITY_WKPSRRULE_INH : ENTITY_WKPSRRULE;
            this.openRuleForm(formId, pkid, RULE_TYPE_WKPSR);
        }
        if ("searchbefore".equals(key) || "searchnext".equals(key)) {
            String[] btns = new String[]{"searchbefore", "searchnext"};
            SearchUtil.getLeftOrRight((IPageCache)this.getPageCache(), (IFormView)this.getView(), (String)key, (TreeView)((TreeView)this.getControl(TREE_ORG)), (String[])btns, (String)TREE_ORG);
        }
    }

    @Override
    public String getNewRuleFormId(String currentTab) {
        String formId = ENTITY_APPORTIONRULE;
        String ruleType = this.getPageCache().get("ruleType");
        if ("apportiontab".equals(currentTab)) {
            formId = "public".equals(ruleType) ? ENTITY_APPORTIONRULE_INH : ENTITY_APPORTIONRULE;
        } else if ("wkpsrtab".equals(currentTab)) {
            formId = "public".equals(ruleType) ? ENTITY_WKPSRRULE_INH : ENTITY_WKPSRRULE;
        }
        return formId;
    }

    @Override
    public void loadTab(String tab) {
        if (null != tab) {
            if ("apportiontab".equals(tab)) {
                this.loadApportionRule(this.ruleCardQueryCondition());
            } else if ("wkpsrtab".equals(tab)) {
                this.loadWkpsrRule(this.ruleCardQueryCondition());
            }
        } else {
            this.loadApportionRule(this.ruleCardQueryCondition());
        }
    }

    @Override
    public List<QFilter> ruleCardQueryCondition() {
        List<QFilter> filters = super.ruleCardQueryCondition();
        boolean existTypeChange = null != this.getPageCache().get("existTypeChange") ? "true".equals(this.getPageCache().get("existTypeChange")) : RuleService.loadTaxPayerTypeChangeRecord(this.getPageCache().get("CURRENT_NODE") == null ? "0" : this.getPageCache().get("CURRENT_NODE"), this.getPageCache().get("ruleType"));
        QFilter taxPayerTypeFilter = existTypeChange ? new QFilter("taxpayertype", "in", Arrays.asList("ybnsr", "xgmnsr")) : new QFilter("taxpayertype", "=", (Object)this.getPageCache().get("taxpayertype"));
        filters.add(taxPayerTypeFilter);
        return filters;
    }

    @Override
    public boolean checkBeforeOpenRuleForm(String ruletype, String orgId) {
        boolean isybnsr;
        DynamicObjectCollection list = null;
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(Long.parseLong(orgId)));
        if (EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            list = ((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity");
        }
        if (!(isybnsr = this.ruleService.isybnsr(list, null, false))) {
            if (RULE_TYPE_APPORTION.equals(ruletype)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fdb\u9879\u8f6c\u51fa\u4ec5\u9002\u7528\u4e00\u822c\u7eb3\u7a0e\u4eba\u3002", (String)"RuleTZConfigsPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]));
                return false;
            }
            if (RULE_TYPE_WKPSR.equals(ruletype)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u5f00\u7968\u6536\u5165\u53f0\u8d26\u6682\u4e0d\u652f\u6301\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u3002", (String)"RuleTZConfigsPlugin_10", (String)"taxc-tcvat", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private void loadApportionRule(List<QFilter> filters) {
        logger.info(SerializationUtils.toJsonString((Object)this.getModel().getDataEntity(true)));
        if (this.getModel().getDataEntityType().getProperty("apportionentity") != null) {
            this.getModel().deleteEntryData("apportionentity");
            Map zclxMap = MetadataUtil.getComboItemsMap((String)ENTITY_APPORTIONRULE, (String)"wfhfzclx");
            DynamicObjectCollection rules = QueryServiceHelper.query((String)ENTITY_APPORTIONRULE, (String)"id,org.name as org,org.status as status,ruletype,enable,name,modifytime,taxpayertype,wfhfzclx", (QFilter[])filters.toArray(new QFilter[0]), (String)"ruletype desc");
            this.getModel().beginInit();
            for (DynamicObject rule : rules) {
                int row = this.getModel().createNewEntryRow("apportionentity");
                this.getModel().setValue("apportionid", rule.get("id"), row);
                this.getModel().setValue("apportionrulename", (Object)rule.getString("name"), row);
                this.getModel().setValue("apportionmodifydate", rule.get("modifytime"), row);
                this.getModel().setValue("apportionenable", rule.get("enable"), row);
                String ruletype = rule.getString("ruletype");
                this.getModel().setValue("apportionruletype", (Object)ruletype, row);
                this.getModel().setValue("zclx", zclxMap.get(rule.getString("wfhfzclx")), row);
                this.setBackgroundAndImage(row, RULE_TYPE_APPORTION, rule.getString("taxpayertype"));
            }
            this.getModel().endInit();
            this.getView().updateView("apportionentity");
        }
    }

    private void loadWkpsrRule(List<QFilter> filters) {
        logger.info(SerializationUtils.toJsonString((Object)this.getModel().getDataEntity(true)));
        if (this.getModel().getDataEntityType().getProperty("wkpsrentity") != null) {
            this.getModel().deleteEntryData("wkpsrentity");
            Map jzjtMap = MetadataUtil.getComboItemsMap((String)"tcvat_rule_income", (String)"jzjt");
            DynamicObjectCollection rules = QueryServiceHelper.query((String)ENTITY_WKPSRRULE, (String)"id,org.name as org,org.status as status,ruletype,enable,modifytime,rulename.taxation.name as ruletaxation,rulename.name as name,rulename.taxpayertype as taxpayertype,rulename.jzjt as jzjt,rulename.taxrate.name as taxrate", (QFilter[])filters.toArray(new QFilter[0]), (String)"ruletype desc");
            this.getModel().beginInit();
            for (DynamicObject rule : rules) {
                int row = this.getModel().createNewEntryRow("wkpsrentity");
                this.getModel().setValue("wkpsrid", rule.get("id"), row);
                this.getModel().setValue("wkpsrrulename", (Object)rule.getString("name"), row);
                this.getModel().setValue("wkpsrmodifydate", rule.get("modifytime"), row);
                this.getModel().setValue("wkpsrenable", rule.get("enable"), row);
                String ruletype = rule.getString("ruletype");
                this.getModel().setValue("wkpsrruletype", (Object)ruletype, row);
                this.getModel().setValue("taxrate", rule.get("taxrate"), row);
                this.getModel().setValue("ruletaxation", rule.get("ruletaxation"), row);
                this.getModel().setValue("jzjt", jzjtMap.get(rule.getString("jzjt")), row);
                this.setBackgroundAndImage(row, RULE_TYPE_WKPSR, rule.getString("taxpayertype"));
            }
            this.getModel().endInit();
            this.getView().updateView("wkpsrentity");
        }
    }

    private void setBackgroundAndImage(int row, String type, String taxPayerType) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>(16);
        HashMap<String, String> propertiesMap1 = new HashMap<String, String>(16);
        HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>(16);
        propertiesMap.put("bc", "rgba(241,247,255,1)");
        propertiesMap1.put("bgik", "linear-gradient(327deg,rgba(100,171,255,0.15) 0%,rgba(52,140,242,0.15) 100%)");
        propertiesMap1.put("fc", "#55A0F5");
        pmap.put(type + "_flex", propertiesMap);
        pmap.put(type + "_image", propertiesMap);
        pmap.put(type + "_bc", propertiesMap1);
        ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        client.invokeControlMethod(type + "entity", "setCustomProperties", new Object[]{row, pmap});
    }
}

