/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rules;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;

public class TcvatAdvanceConfForm
extends AbstractFormPlugin {
    private static final String KEY_BTNCANCEL = "btncancel";
    private static final String KEY_BTNOK = "btnok";
    public static final String VATRATE = "vatrate";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_BTNCANCEL, KEY_BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object value = customParams.get(VATRATE);
        if ("read".equals(customParams.get("type"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"operatepanel"});
            this.getView().setEnable(Boolean.FALSE, new String[]{VATRATE});
        }
        if (ObjectUtils.isEmpty(value)) {
            return;
        }
        BigDecimal vatrateValue = new BigDecimal(customParams.get(VATRATE).toString());
        this.getModel().setValue(VATRATE, (Object)vatrateValue);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (KEY_BTNOK.equalsIgnoreCase(key)) {
            this.returnDataToParent();
        }
        if (KEY_BTNCANCEL.equalsIgnoreCase(key)) {
            this.getView().close();
        }
    }

    private void returnDataToParent() {
        Map<String, Object> ret = this.getConfig();
        this.getView().returnDataToParent(ret);
        this.getView().close();
    }

    private Map<String, Object> getConfig() {
        BigDecimal vatrate = (BigDecimal)this.getModel().getValue(VATRATE);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(VATRATE, vatrate);
        return data;
    }
}

