/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.smallscaletaxpayer;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.draft.org.OrgChangeRecordUtil;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.account.PolicyConfirmService;

public class SmallScalePolicyConfirmation
extends AbstractBillPlugIn {
    private static final String ORGID_KEY = "orgid";
    private static final String RULE_CONFIG = "tcvat_rule_configs";
    private static final String STATUS_KEY = "status";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.initDatas(customParams);
        this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
    }

    public void afterLoadData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        PolicyConfirmService.controlEdit(customParams, this.getView());
        this.initDatas(customParams);
        this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
    }

    private void openRulesPage(String ruledata) {
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("ruledata", ruledata);
        customParams.put("taxpayertype", "xgmnsr");
        PageShowCommon.showForm((String)"flexpanelap", (String)"tcvat_policy_rules", (IFormView)this.getView(), customParams);
    }

    public void itemClick(ItemClickEvent evt) {
        if (evt.getItemKey().equals("fastsetting")) {
            HashMap<String, String> customParams = new HashMap<String, String>();
            Object org = this.getModel().getValue(ORGID_KEY);
            if (org != null) {
                customParams.put(ORGID_KEY, ((DynamicObject)org).getString("id"));
            }
            PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)RULE_CONFIG, (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }

    public void initDatas(Map<String, Object> customParams) {
        IDataModel dataModel = this.getModel();
        String skssqq = (String)customParams.get("skssqq");
        String skssqz = (String)customParams.get("skssqz");
        String orgid = customParams.get(ORGID_KEY) != null ? (String)customParams.get(ORGID_KEY) : "0";
        dataModel.setValue(ORGID_KEY, (Object)orgid);
        Object status = customParams.get(STATUS_KEY);
        this.getModel().setValue("reportperiod", (Object)DateUtils.stringToDate((String)skssqq, (String)"yyyy-MM"));
        customParams.put("page", "tcvat_xgm_policy_confirm");
        if ("1".equals(status)) {
            DynamicObject changetRecordObject = OrgChangeRecordUtil.loadChangeRecord((String)orgid, (Date)DateUtils.stringToDate((String)skssqq, (String)"yyyy-MM-dd"), (Date)DateUtils.stringToDate((String)skssqz, (String)"yyyy-MM-dd"));
            DynamicObject category = TaxBaseDataUtils.queryCategoryByTaxtype((Long)Long.parseLong(orgid), (String)"zzs");
            if (category != null) {
                DynamicObject taxMain = (DynamicObject)category.getParent();
                this.getModel().setValue("registertype", taxMain.get("registertype"));
                this.getModel().setValue("codeandname", taxMain.get("codeandname"));
            }
            this.getModel().setValue("taxplayeraptitude", (Object)("zzs" + changetRecordObject.getString("taxpayertype")));
            this.getModel().setValue("levytype", (Object)changetRecordObject.getString("levytype"));
            String deadLine = TaxDeclareHelper.getDeadLine((String)customParams.get("draftpurpose"), orgid, DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz));
            this.getModel().setValue("deadline", (Object)deadLine);
        }
        this.getModel().setValue("draftpurpose", customParams.get("draftpurpose"));
        String rulePurpose = (String)customParams.get("rulePurpose");
        Map rules = RuleUtils.getSharingAndOrgRules((Long)Long.parseLong(orgid), (RuleTypeEnum)RuleTypeEnum.ALL, (String)"xgmnsr", (String)rulePurpose);
        String ruledata = SerializationUtils.toJsonString((Object)rules);
        this.getModel().setValue("ruledata_tag", (Object)ruledata);
        this.getModel().setValue(STATUS_KEY, (Object)"1");
        this.openRulesPage(ruledata);
    }
}

