/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.taxrefund;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckFormPlugin;
import kd.taxc.bdtaxr.common.taxorg.TaxOrgUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.tcvat.common.util.TcvatCommonUtil;

public class JzjtFilingPlugin
extends AbstractLicenseCheckFormPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(JzjtFilingPlugin.class);

    public void registerListener(EventObject event) {
        BasedataEdit jmxmmc = (BasedataEdit)this.getControl("jmxmmc");
        jmxmmc.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object org = this.getModel().getValue("org");
        if (!Objects.isNull(org)) {
            Long orgId = ((DynamicObject)org).getLong("id");
            HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
            Long userdOrgId = OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)orgId, (DynamicObjectCollection)col);
            TaxResult taxcMainByOrgId = TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)userdOrgId);
            if (taxcMainByOrgId.isSuccess() && ((Boolean)taxcMainByOrgId.getData()).booleanValue() && TcvatCommonUtil.isYbnsr(userdOrgId).getSuccess().booleanValue()) {
                DynamicObject taxorg = (DynamicObject)TaxcOrgDataServiceHelper.queryTaxcOrgByOrgId((Long)userdOrgId).getData();
                String nsrsbno = TaxOrgUtil.getUnifiedsocialcode((DynamicObject)taxorg);
                this.getModel().setValue("nsrsbno", (Object)nsrsbno);
            } else {
                TaxResult listTaxResult = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId());
                logger.info("\u5373\u5f81\u5373\u9000\u5907\u6848\u67e5\u8be2\u5230\u7684\u7eb3\u7a0e\u4e3b\u4f53\u4e3a\uff1a{}", (Object)listTaxResult);
                if (CollectionUtils.isNotEmpty((Collection)((Collection)listTaxResult.getData()))) {
                    for (Long temp : (List)listTaxResult.getData()) {
                        if (!TcvatCommonUtil.isYbnsr(temp).getSuccess().booleanValue()) continue;
                        DynamicObject taxorg = (DynamicObject)TaxcOrgDataServiceHelper.queryTaxcOrgByOrgId((Long)temp).getData();
                        String nsrsbno = TaxOrgUtil.getUnifiedsocialcode((DynamicObject)taxorg);
                        this.getModel().setValue("org", (Object)temp);
                        this.getModel().setValue("nsrsbno", (Object)nsrsbno);
                        return;
                    }
                }
                this.getModel().setValue("org", null);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u5148\u7ef4\u62a4\u7a0e\u52a1\u7ec4\u7ec7\u548c\u5bf9\u5e94\u7684\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u3002", (String)"JzjtFilingPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object org;
        String name = e.getProperty().getName();
        if ("bayxqz".equals(name)) {
            Date bayxqz = (Date)e.getChangeSet()[0].getNewValue();
            if (Objects.isNull(bayxqz)) {
                return;
            }
            Object obj = this.getModel().getValue("bayxqq");
            if (!Objects.isNull(obj) && ((Date)obj).after(bayxqz)) {
                this.getModel().setValue("bayxqz", null);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u6b62\u65e5\u671f\u5c0f\u4e8e\u6709\u6548\u671f\u8d77\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"JzjtFilingPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        } else if ("bayxqq".equals(name)) {
            Date bayxqq = (Date)e.getChangeSet()[0].getNewValue();
            if (Objects.isNull(bayxqq)) {
                return;
            }
            Object obj = this.getModel().getValue("bayxqz");
            if (!Objects.isNull(obj) && ((Date)obj).before(bayxqq)) {
                this.getModel().setValue("bayxqq", null);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u6b62\u65e5\u671f\u5c0f\u4e8e\u6709\u6548\u671f\u8d77\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"JzjtFilingPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        } else if ("org".equals(name) && !Objects.isNull(org = this.getModel().getValue("org"))) {
            DynamicObject taxorg = (DynamicObject)TaxcOrgDataServiceHelper.queryTaxcOrgByOrgId((Long)((DynamicObject)org).getLong("id")).getData();
            String nsrsbno = TaxOrgUtil.getUnifiedsocialcode((DynamicObject)taxorg);
            this.getModel().setValue("nsrsbno", (Object)nsrsbno);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        if (name.equals("org")) {
            TaxResult listTaxResult = TaxcCombineDataServiceHelper.queryTaxcOrgIdsWithPerm((Long)RequestContext.get().getCurrUserId());
            logger.info("\u5373\u5f81\u5373\u9000\u5907\u6848\u4e2dF7\u7684listTaxResult\uff1a{}", listTaxResult.getData());
            if (CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData()))) {
                event.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u5ba1\u6838\u53ef\u7528\u7684\u7ec4\u7ec7\uff0c\u8bf7\u5148\u5bf9\u7a0e\u52a1\u7ec4\u7ec7\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"JzjtFilingPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            TaxResult listTaxResult1 = TaxcMainDataServiceHelper.queryTaxcMainByOrgIdsAndIsTaxpayerAndIsYbnsr((List)((List)listTaxResult.getData()));
            logger.info("\u5373\u5f81\u5373\u9000\u5907\u6848\u4e2dF7\u7684\u8fc7\u6ee4\u5c0f\u89c4\u6a21\u540elistTaxResult\uff1a{}", listTaxResult1.getData());
            ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
            parameter.getListFilterParameter().setFilter(new QFilter("id", "in", listTaxResult1.getData()));
        } else if (name.equals("jmxmmc")) {
            FormShowParameter formShowParameter = event.getFormShowParameter();
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u51cf\u514d\u9879\u76ee\u540d\u79f0", (String)"JzjtFilingPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }
}

