/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.taxrefund;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.taxrefund.AccountServiceHelper;

public class RecalcAccountPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        OrgEdit org = (OrgEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"org"});
        this.addClickListeners(new String[]{"date"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button btn = (Button)evt.getSource();
        String itemKey = btn.getKey();
        if ("btnok".equals(itemKey)) {
            Date skssqz;
            Date skssqq;
            Date date = (Date)this.getModel().getValue("date");
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            Long orgId = org.getLong("id");
            String taxlimit = TaxDeclareHelper.getOrgLimit(orgId);
            if ("aysb".equals(taxlimit)) {
                skssqq = DateUtils.getFirstDateOfMonth((Date)date);
                skssqz = DateUtils.trunc((Date)DateUtils.getLastDateOfMonth((Date)date));
            } else {
                skssqq = DateUtils.getFirstDateOfSeason((Date)date);
                skssqz = DateUtils.trunc((Date)DateUtils.getLastDateOfSeason((Date)date));
            }
            boolean existAccountData = AccountServiceHelper.existAccountDataWithDate(orgId, skssqq, skssqz);
            if (!existAccountData) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u6ca1\u6709\u53ef\u91cd\u65b0\u8ba1\u7b97\u7684\u5355\u636e\u3002", (String)"RecalcAccountPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> custom = new HashMap<String, Object>();
            custom.put("orgid", String.valueOf(orgId));
            custom.put("type", "recalc");
            custom.put("skssqq", skssqq);
            custom.put("skssqz", skssqz);
            this.getView().returnDataToParent(custom);
            this.getView().close();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        HasPermOrgResult permOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView().getParentView());
        if (EmptyCheckUtils.isNotEmpty((Object)permOrgResult) && !permOrgResult.hasAllOrgPerm() && EmptyCheckUtils.isNotEmpty((Object)permOrgResult.getHasPermOrgs())) {
            List orgList = permOrgResult.getHasPermOrgs();
            QFilter idsFilter = new QFilter("id", "in", (Object)orgList);
            ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(idsFilter);
        }
    }
}

