/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.taxrefund;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcvat.business.service.taxrefund.TaxRefundAccountService;
import kd.taxc.tcvat.business.service.taxrefund.TaxRefundApplyService;
import kd.taxc.tcvat.formplugin.taxrefund.AbstractRefundListPlugin;

public class TaxAccountListPlugin
extends AbstractRefundListPlugin {
    private static final Log LOGGER = LogFactory.getLog(TaxAccountListPlugin.class);
    private TaxRefundAccountService taxRefundAccountService = new TaxRefundAccountService();
    private TaxRefundApplyService taxRefundApplyService = new TaxRefundApplyService();

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperateKey().equals("recalc")) {
            String formId = (String)this.getView().getFormShowParameter().getCustomParams().get("billFormId");
            HashMap<String, String> custom = new HashMap<String, String>();
            custom.put("formid", formId);
            PageShowCommon.showForm((OperationStatus)OperationStatus.ADDNEW, (ShowType)ShowType.Modal, (String)"tcvat_taxrefund_recalc", (IFormView)this.getView(), custom, (IFormPlugin)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if ("tcvat_taxrefund_recalc".equals(evt.getActionId())) {
            Map map = (Map)evt.getReturnData();
            if (null == map) {
                return;
            }
            Date skssqq = (Date)map.get("skssqq");
            Date skssqz = (Date)map.get("skssqz");
            String orgId = (String)map.get("orgid");
            try {
                this.taxRefundAccountService.taxRefundRecaleEngine(skssqq, skssqz, orgId);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u91cd\u65b0\u8ba1\u7b97\u6210\u529f\u3002", (String)"TaxAccountListPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]), OrgUtils.getOrgNameById((String)orgId)));
            BillList billListap = (BillList)this.getControl("billlistap");
            billListap.refresh();
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (args.getFieldName().equals("ldtssqbbm")) {
            args.setCancel(true);
            String applyBillNo = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getBillNo();
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put("querytype", "tcvat_taxrefund");
            DynamicObject taxRefundAccount = this.taxRefundAccountService.queryTaxRefundAccountByBillNo(applyBillNo);
            DynamicObject taxRefundApply = this.taxRefundApplyService.queryTaxRefundApplyByBillNo(taxRefundAccount.getString("ldtssqbbm"));
            if (null != taxRefundApply) {
                customParams.put("orgid", taxRefundApply.getString("org"));
                customParams.put("skssqq", taxRefundApply.getString("skssqq"));
                customParams.put("skssqz", taxRefundApply.getString("skssqz"));
                PageShowCommon.showForm((OperationStatus)OperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, (String)"tcvat_taxrefund_edit", (IFormView)this.getView(), customParams, (IFormPlugin)this);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"TaxAccountListPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        }
    }
}

