/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.taxrefund.apply;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.multidideclare.MultiDiTemplateHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportMultiPlugin;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.taxrefund.AccountServiceHelper;
import kd.taxc.tcvat.business.service.taxrefund.RefundApplyVerifyService;
import kd.taxc.tcvat.business.service.taxrefund.TaxRefundApplyService;

public class TaxrefundEditMultiPlugin
extends AbstractDeclareReportMultiPlugin {
    private static Log logger = LogFactory.getLog(TaxrefundEditMultiPlugin.class);
    private static String ID = "id";
    private static String VERSION = "version";
    private static String ORG = "org";
    private TaxRefundApplyService taxRefundApplyService = new TaxRefundApplyService();

    public void initialize() {
        super.initialize();
    }

    public void initPeriod(IDataModel getModel, IPageCache getPageCache, String orgId, Map<String, Object> customParams) {
        Date date = new Date();
        String taxlimit = TaxDeclareHelper.getOrgLimit(Long.valueOf(orgId));
        Map preTaxPeriodMap = DateUtils.getPrePeriodByTaxLimit((Date)date, (String)TaxDeclareHelper.getPreTaxLimitType(taxlimit));
        Date skssqq = (Date)preTaxPeriodMap.get("startDate");
        Date skssqz = (Date)preTaxPeriodMap.get("endDate");
        this.getModel().setValue("skssqq", (Object)skssqq);
        this.getPageCache().put("skssqq", DateUtils.format((Date)skssqq));
        this.getModel().setValue("skssqz", (Object)skssqz);
        this.getPageCache().put("skssqz", DateUtils.format((Date)skssqz));
        this.getDraftNumber(DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqq")), DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqz")));
    }

    protected boolean isDefaultOrg() {
        return false;
    }

    protected String getModelNumber() {
        return MultiTableEnum.TSD001.getModel();
    }

    protected String[] getTaxLimits() {
        return new String[]{"month", "season"};
    }

    public boolean checkOrgTaxConfig(String orgid, String skssqq, String skssqz) {
        Date endDate;
        Date startDate = DateUtils.stringToDate((String)skssqq);
        String msg = RefundApplyVerifyService.commonValid(orgid, "tcvat_taxrefund_edit", startDate, endDate = DateUtils.stringToDate((String)skssqz));
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.getView().showErrorNotification(msg);
            this.getPageCache().put("oldorgid", null);
            return false;
        }
        return true;
    }

    public void init() {
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        Date skssqq = (Date)this.getModel().getValue("skssqq");
        Date skssqz = (Date)this.getModel().getValue("skssqz");
        if (null == org) {
            return;
        }
        DynamicObject dynamicObject = this.taxRefundApplyService.queryTaxRefundApply(org.getLong("id"), skssqq, skssqz);
        if (null != dynamicObject) {
            DynamicObjectCollection entryentity = (DynamicObjectCollection)dynamicObject.get("entryentity");
            this.getModel().setValue("bljd", (Object)((DynamicObject)entryentity.get(0)).getString("bljd"));
            this.getModel().setValue("billstatus", (Object)dynamicObject.getString("billstatus"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean needMsg;
        Date skssqz;
        Date skssqq;
        String orgid;
        String msg;
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        ChangeData[] changeData = e.getChangeSet();
        if (appid == null || changeData == null || changeData.length == 0) {
            return;
        }
        if (e.getProperty().getName().equals("org")) {
            DynamicObject org;
            String orgid2;
            String msg2;
            if (this.getModel().getDataEntity().getDate("skssqq") == null || this.getModel().getDataEntity().getDate("skssqz") == null) {
                this.getPageCache().put("orgid", this.getModel().getDataEntity().getString("org.id"));
                return;
            }
            Date skssqq2 = (Date)this.getModel().getValue("skssqq");
            Date skssqz2 = (Date)this.getModel().getValue("skssqz");
            Object object = changeData[0].getNewValue();
            if (StringUtils.isBlank((Object)object) && null != changeData[0].getOldValue()) {
                msg = RefundApplyVerifyService.commonValid(((DynamicObject)changeData[0].getOldValue()).getString("id"), "tcvat_taxrefund_edit", skssqq2, skssqz2);
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    return;
                }
                this.getModel().setValue(ORG, changeData[0].getOldValue());
            }
            if (StringUtils.isNotBlank((CharSequence)(msg2 = RefundApplyVerifyService.commonValid(orgid2 = (org = (DynamicObject)this.getModel().getValue(ORG)).getString(ID), "tcvat_taxrefund_edit", skssqq2, skssqz2)))) {
                this.getView().showErrorNotification(msg2);
                this.getModel().setValue(ORG, null);
                this.getPageCache().put("orgid", null);
                return;
            }
            this.getPageCache().put("orgid", orgid2);
            DynamicObject oldValueObj = (DynamicObject)changeData[0].getOldValue();
            this.getPageCache().put("oldorgid", null == oldValueObj ? null : oldValueObj.getString(ID));
            this.getDraftNumber(DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqq")), DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqz")));
            this.loadData(this.getModel().getDataEntity().getDate("skssqq"), this.getModel().getDataEntity().getDate("skssqz"), Boolean.FALSE, this.isNeedRefresh());
        }
        if (e.getProperty().getName().equals("skssqq")) {
            if (null == this.getModel().getValue(ORG)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"TaxrefundEditMultiPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            if (this.getModel().getValue("skssqq") == null) {
                this.getModel().setValue("skssqq", changeData[0].getOldValue());
                return;
            }
            if (this.getModel().getValue("skssqz") == null) {
                return;
            }
            orgid = ((DynamicObject)this.getModel().getValue(ORG)).getString(ID);
            msg = RefundApplyVerifyService.validTaxAccount(orgid, skssqq = (Date)this.getModel().getValue("skssqq"), skssqz = (Date)this.getModel().getValue("skssqz"));
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                this.getView().showErrorNotification(msg);
                return;
            }
            this.getDraftNumber(DateUtils.format((Date)((Date)changeData[0].getNewValue())), DateUtils.format((Date)((Date)this.getModel().getValue("skssqz"))));
            needMsg = StringUtil.isNotBlank((CharSequence)this.getPageCache().get("needMsg")) ? Boolean.valueOf(this.getPageCache().get("needMsg")) : Boolean.TRUE;
            this.loadData((Date)changeData[0].getNewValue(), this.getModel().getDataEntity().getDate("skssqz"), needMsg, this.isNeedRefresh());
        }
        if (e.getProperty().getName().equals("skssqz")) {
            if (null == this.getModel().getValue(ORG)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"TaxrefundEditMultiPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            if (this.getModel().getValue("skssqz") == null) {
                this.getModel().setValue("skssqz", changeData[0].getOldValue());
                return;
            }
            if (this.getModel().getValue("skssqq") == null) {
                return;
            }
            orgid = ((DynamicObject)this.getModel().getValue(ORG)).getString(ID);
            msg = RefundApplyVerifyService.validTaxAccount(orgid, skssqq = (Date)this.getModel().getValue("skssqq"), skssqz = (Date)this.getModel().getValue("skssqz"));
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                this.getView().showErrorNotification(msg);
                return;
            }
            this.getDraftNumber(DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqq")), DateUtils.format((Date)((Date)changeData[0].getNewValue())));
            needMsg = StringUtil.isNotBlank((CharSequence)this.getPageCache().get("needMsg")) ? Boolean.valueOf(this.getPageCache().get("needMsg")) : Boolean.TRUE;
            this.loadData(this.getModel().getDataEntity().getDate("skssqq"), (Date)changeData[0].getNewValue(), needMsg, this.isNeedRefresh());
        }
        this.getPageCache().remove("needMsg");
        this.init();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if ("unaudit".equals(evt.getOperationKey())) {
            String billno = this.getModel().getDataEntity().getString("billno");
            Map deleResult = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tpo", (String)"TaxRefundInfoService", (String)"deleteTaxRefundInfo", (Object[])new Object[]{Lists.newArrayList((Object[])new String[]{billno})});
            if (!((Boolean)deleResult.get("success")).booleanValue()) {
                HashMap result = new HashMap();
                List errors = (List)deleResult.get("data");
                errors.forEach(one -> {
                    String failnum = (String)one.get("failnum");
                    String errormsg = (String)one.get("errormsg");
                    result.put(failnum, errormsg);
                });
                if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{(CharSequence)result.get(billno)})) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u7533\u62a5\u8868\u7f16\u53f7\uff1a%s \u7684\u4e0b\u6e38\u9000\u7a0e\u4fe1\u606f\u4e3a\u672a\u9000\u7a0e\u6216\u672a\u751f\u6210\u51ed\u8bc1\u65f6\u624d\u80fd\u64cd\u4f5c", (String)"TaxrefundEditMultiPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]), billno));
                    evt.setCancel(true);
                    return;
                }
            }
        }
        super.beforeItemClick(evt);
    }

    private void getDraftNumber(String sksqq, String sksqz) {
        String billno = this.getBillNumber(sksqq, sksqz);
        this.getModel().setValue("billno", (Object)billno);
        this.getModel().setDataChanged(false);
        this.getPageCache().put("billno", billno);
    }

    private boolean isNeedRefresh() {
        return !QueryServiceHelper.exists((String)MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), (QFilter[])new QFilter[]{this.setDefaultQfilter()});
    }

    private QFilter setDefaultQfilter() {
        String version = this.getPageCache().get(VERSION);
        return new QFilter(ORG, "=", (Object)Long.valueOf(this.getModel().getDataEntity().getString("org.id"))).and("skssqq", "=", (Object)DateUtils.stringToDate((String)DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqq")))).and("skssqz", "=", (Object)DateUtils.stringToDate((String)DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqz")))).and("templatetype", "=", (Object)this.getTemplateType()).and("accountsettype", "=", (Object)version);
    }

    public String getTaxType() {
        return null;
    }

    public String getTemplateType() {
        return "tcvat_taxrefund";
    }

    public void clientCallBackMethod(Map<String, String> dataMap, String sheetid) {
    }

    protected Map<String, String> getBizParams() {
        HashMap<String, String> bizParamsMap = new HashMap<String, String>(1);
        bizParamsMap.put("billno", this.getModel().getDataEntity().getString("billno"));
        return bizParamsMap;
    }

    protected DeclareRequestModel setRequestModel(DeclareRequestModel requestModel) {
        HashMap<String, String> extendParams = requestModel.getExtendParams();
        if (extendParams == null) {
            extendParams = new HashMap<String, String>(1);
        }
        extendParams.putAll(this.getBizParams());
        requestModel.setExtendParams(extendParams);
        if (requestModel.getRefresh().booleanValue()) {
            requestModel.getBusinessMap().putAll(this.getFetchConfigParams(requestModel));
        }
        return requestModel;
    }

    protected Long getCustomOrg(Map<String, Object> customParams) {
        Long orgId = RequestContext.get().getOrgId();
        this.getPageCache().put("orgid", String.valueOf(orgId));
        return orgId;
    }

    protected Map<String, Object> paraCustomParams(Map<String, Object> customParams) {
        String billno = customParams.get("billno") == null ? null : customParams.get("billno").toString();
        this.getModel().setValue("billno", (Object)billno);
        this.getPageCache().put("billno", billno);
        return customParams;
    }

    protected QFilter getDeclareMainQueryParams() {
        return null;
    }

    protected String getUniKey() {
        logger.info("getUniKey");
        String orgId = this.getPageCache().get("orgid");
        String skssq = DateUtils.format((Date)((Date)this.getModel().getValue("skssqq")));
        String skssz = DateUtils.format((Date)((Date)this.getModel().getValue("skssqz")));
        String version = this.getPageCache().get(VERSION);
        return String.format("%s_%s_%s_%s_%s", orgId, skssq, skssz, version, this.getTemplateType());
    }

    protected boolean viewDialog() {
        return Boolean.FALSE;
    }

    private String getBillNumber(String skssqq, String skssqz) {
        DynamicObject dynamicObject = this.checkRecordIsexist(MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), this.getPageCache().get("orgid"), this.getTemplateType(), skssqq, skssqz);
        if (dynamicObject == null) {
            return this.createNumber();
        }
        return dynamicObject.getString("billno");
    }

    private String createNumber() {
        return DeclareServiceHelper.generateSBBNo((String)"tcvat_tax_refund_apply");
    }

    private DynamicObject checkRecordIsexist(String maintable, String orgid, String type, String startDate, String endDate) {
        return YbnsrService.queryMultiDeclareMain((String)maintable, (long)Long.parseLong(orgid), (String)type, (String)startDate, (String)endDate, (QFilter)this.getDeclareMainQueryParams());
    }

    private Map<String, String> getFetchConfigParams(DeclareRequestModel requestModel) {
        DynamicObject templateObject = MultiDiTemplateHelper.getTemplateByConfig((Long)requestModel.getModelId(), (String)requestModel.getTemplateType(), (String)String.valueOf(requestModel.getOrgId()), (Date)DateUtils.stringToDate((String)requestModel.getSkssqq()), (Date)DateUtils.stringToDate((String)requestModel.getSkssqz()));
        if (templateObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5c5e\u671f\u65e0\u53ef\u7528\u6a21\u677f", (String)"TaxrefundEditMultiPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        Long templateId = templateObject.getLong(ID);
        QFilter templateIdQ = new QFilter("template", "=", (Object)templateId);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"tpo_template_rule_fetch", (String)"reportitem,formula", (QFilter[])new QFilter[]{templateIdQ});
        List formulaList = col.stream().map(o -> o.getLong("formula")).collect(Collectors.toList());
        QFilter idQ = new QFilter(ID, "in", formulaList);
        QFilter dataTypeQ = new QFilter("datatype", "=", (Object)"number");
        QFilter formulaQ = new QFilter("formula", "like", (Object)"{P[%");
        DynamicObjectCollection ruleFetchCol = QueryServiceHelper.query((String)"tpo_rule_fetch", (String)"name,formula", (QFilter[])new QFilter[]{idQ, formulaQ, dataTypeQ});
        List ids = ruleFetchCol.stream().filter(row -> this.isPositiveInteger("^\\+{0,1}[1-9]\\d*", row.getString("name"))).map(o -> o.getString("name")).collect(Collectors.toList());
        HashMap<String, String> cellitemMap = new HashMap<String, String>(12);
        for (DynamicObject rule : ruleFetchCol) {
            String ruleKey;
            if (!this.isPositiveInteger("^\\+{0,1}[1-9]\\d*", rule.getString("name")) || !ids.contains(ruleKey = rule.getString("name"))) continue;
            String formula = rule.getString("formula");
            String[] mul = formula.substring(3).split("]}");
            cellitemMap.put(ruleKey, mul[0]);
        }
        return cellitemMap;
    }

    private boolean isPositiveInteger(String regex, String orginal) {
        return this.taxRefundApplyService.isMatch(regex, orginal);
    }

    protected void viewDraft() {
        if (null == this.getModel().getValue(ORG)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"TaxrefundEditMultiPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        String orgid = org.getString(ID);
        String startDate = DateUtils.format((Date)((Date)this.getModel().getValue("skssqq")));
        String endDate = DateUtils.format((Date)((Date)this.getModel().getValue("skssqz")));
        DynamicObject accountData = AccountServiceHelper.getAccountDataWithDate(Long.valueOf(orgid), DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate));
        Map<String, String> map = RefundApplyVerifyService.checkDataInit(Long.valueOf(orgid), accountData);
        if (StringUtils.equalsIgnoreCase((CharSequence)map.get("code"), (CharSequence)"true")) {
            this.getView().showErrorNotification(map.get("failInfo"));
            return;
        }
        PageShowCommon.showBill((ShowType)ShowType.MainNewTabPage, (String)"tcvat_tax_refund_manage_a", (Object)accountData.getLong("id"), (IFormView)this.getView(), null, (OperationStatus)OperationStatus.EDIT);
    }

    protected void customEvent(String orgId, String startDate, String endDate, String operationKey) {
        if ("audit".equals(operationKey)) {
            List<DynamicObject> writeBackAccountList = this.taxRefundApplyService.taxRefundApplyAudit(Long.valueOf(orgId), DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate));
            SaveServiceHelper.save((DynamicObject[])writeBackAccountList.toArray(new DynamicObject[0]));
        }
        if ("unaudit".equals(operationKey)) {
            this.taxRefundApplyService.taxRefundApplyUnaudit(Long.valueOf(orgId), DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate));
        }
        this.init();
    }
}

