/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.zlb;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.Map;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.bdtaxr.common.formula.cache.CacheUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcvat.business.service.zlb.ZlbService;

public class TcvatZlbXgmnsrPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String draftpurpose = params.getOrDefault("draftpurpose", "nssb");
        String templateType = "sjjt".equals(draftpurpose) ? "draft_zzsxgmnsr_sjjt" : "draft_zzsxgmnsr";
        FormShowParameter formShowParameter = new FormShowParameter();
        params.put("needwarn", "true");
        params.put("needremark", "false");
        params.put("ParentCache", "true");
        params.put("changedsave", "false");
        params.put("templatetype", templateType);
        formShowParameter.setCustomParams(params);
        formShowParameter.setFormId("bdtaxr_declare_old");
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("splitpanelap1");
        String pageid = formShowParameter.getPageId();
        IPageCache parCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        parCache.put("declarepageid", pageid);
        parCache.put("templatetype", templateType);
        this.getView().showForm(formShowParameter);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        Map dataResult = CacheUtils.getInstance().getDataResult(pageCache);
        BigDecimal bhsxse = ZlbService.calcTotalAmount(dataResult, "tcvat_zlb_xgmnsr#1#hj");
        this.getModel().setValue("bhsxse", (Object)bhsxse);
        BigDecimal msxse = ZlbService.calcTotalAmount(dataResult, "tcvat_zlb_xgmnsr#2#hj");
        this.getModel().setValue("msxse", (Object)msxse);
        BigDecimal ynsehj = ZlbService.calcTotalAmount(dataResult, "tcvat_zlb_xgmnsr#8#hj");
        this.getModel().setValue("ynsehj", (Object)ynsehj);
        BigDecimal xsehj = bhsxse.add(msxse);
        if (xsehj.compareTo(new BigDecimal("0.00")) != 0) {
            BigDecimal sfl = BigDecimalUtil.divideObject((Object)ynsehj, (Object)bhsxse.add(msxse), (int)4).multiply(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP);
            this.getModel().setValue("sfl", (Object)(sfl.toPlainString() + "%"));
        } else {
            this.getModel().setValue("sfl", (Object)"0.00%");
        }
        String draftpurpose = (String)this.getView().getFormShowParameter().getCustomParam("draftpurpose");
        if (!"true".equals(this.getView().getFormShowParameter().getCustomParam("readonly")) && "sjjt".equals(draftpurpose)) {
            String templatetype = (String)this.getView().getFormShowParameter().getCustomParam("templatetype");
            BigDecimal jtynsesum = ZlbService.calcXgmSjjtYnseSum(dataResult);
            String orgid = (String)this.getView().getFormShowParameter().getCustomParam("orgid");
            String skssqq = (String)this.getView().getFormShowParameter().getCustomParam("skssqq");
            String skssqz = (String)this.getView().getFormShowParameter().getCustomParam("skssqz");
            ZlbService.updateJtynse(draftpurpose, templatetype, jtynsesum, orgid, skssqq, skssqz);
        }
    }
}

