/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.zlb;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.service.DeclareService;
import kd.taxc.bdtaxr.common.draft.DraftService;
import kd.taxc.bdtaxr.common.formula.biz.FormulaService;
import kd.taxc.bdtaxr.common.formula.cache.CacheUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.pluginService.taxdeclare.TaxDeclarePluginService;
import kd.taxc.tcvat.business.service.draft.TcvatDraftService;
import kd.taxc.tcvat.business.service.draft.strategy.TcvatStrategy;
import kd.taxc.tcvat.business.service.zlb.ZlbService;
import kd.taxc.tcvat.common.dto.draft.DraftDto;

public class TcvatZlbYbnsrYbhzPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final Log LOGGER = LogFactory.getLog(TcvatZlbYbnsrYbhzPlugin.class);
    private static final String TABAP = "tabap";
    private static final String TCVAT_ZLB_YZ_APPORTION = "tcvat_zlb_yz_apportion";
    private static final String TCVAT_ZLB_APPORTBILL = "tcvat_zlb_apportbill";
    public static final Map<String, String> tabToPageMap = new HashMap<String, String>(){
        {
            this.put("taxcalculatetable", "tcvat_ybhz_tax_claculate");
            this.put("taxassigntable", "tcvat_ybhz_tax_assign");
            this.put("taxapportiontable", "tcvat_ybhz_tax_apportion");
            this.put("taxapportiontable3", "tcvat_ybhz_yz_apportion");
        }
    };
    public static String CUSTOM_CONTROL = "customcontrolap";
    private DraftDto draftDto = new DraftDto();
    private DraftService draftService = new DraftService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addTabSelectListener(this, TABAP);
    }

    public void addTabSelectListener(TabSelectListener form, String ... tabName) {
        for (int i = 0; i < tabName.length; ++i) {
            Tab tab = (Tab)this.getControl(tabName[i]);
            if (tab == null) continue;
            tab.addTabSelectListener(form);
        }
    }

    public void customEvent(CustomEventArgs e) {
        try {
            String args = e.getEventArgs();
            String eventName = e.getEventName();
            Map argsMap = (Map)SerializationUtils.fromJsonString((String)args, Map.class);
            if ("jumptotctrcrisk".equals(eventName)) {
                String tctrcResultId = (String)argsMap.get("data");
                this.jumpToTctrcRisk(tctrcResultId);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
        }
    }

    private void jumpToTctrcRisk(String tctrcResultId) {
        FormShowParameter param = TaxDeclarePluginService.jumpToTctrcRiskParam((String)tctrcResultId);
        if (param == null) {
            return;
        }
        this.getView().showForm(param);
    }

    public void tabSelected(TabSelectEvent evt) {
        this.showFormInnerTabPage(evt.getTabKey());
    }

    private void showFormInnerTabPage(String tbName) {
        String flag = "loadtb-" + tbName;
        String id = this.getPageCache().get(flag);
        String zlbChanged = this.getPageCache().get("zlbChanged");
        if (id == null || zlbChanged != null) {
            FormShowParameter parameter = new FormShowParameter();
            String pageId = parameter.getPageId();
            parameter.setFormId(tabToPageMap.get(tbName));
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey(tbName);
            FormShowParameter upStepParameter = this.getView().getFormShowParameter();
            parameter.setCustomParam("orgid", upStepParameter.getCustomParam("orgid"));
            parameter.setCustomParam("readonly", upStepParameter.getCustomParam("readonly"));
            parameter.setCustomParam("status", upStepParameter.getCustomParam("status"));
            parameter.setCustomParam("deadLine", upStepParameter.getCustomParam("deadLine"));
            String skssqq = (String)upStepParameter.getCustomParam("skssqq");
            parameter.setCustomParam("skssqq", (Object)skssqq);
            String skssqz = (String)upStepParameter.getCustomParam("skssqz");
            parameter.setCustomParam("skssqz", (Object)skssqz);
            parameter.setCustomParam("taxpayertype", upStepParameter.getCustomParam("taxPayerType"));
            parameter.setCustomParam("declaremap", upStepParameter.getCustomParam("declaremap"));
            parameter.setCustomParam("prelevyrate", upStepParameter.getCustomParam("prelevyrate"));
            parameter.setCustomParam("draftpurpose", upStepParameter.getCustomParam("draftpurpose"));
            this.getView().showForm(parameter);
            this.getPageCache().put(flag, pageId);
            this.getPageCache().remove("zlbChanged");
        } else {
            this.getView().sendFormAction(this.getView().getView(id));
        }
    }

    public void afterCreateNewData(EventObject e) {
        Tab tab = (Tab)this.getControl(TABAP);
        Object taxPayerType = this.getView().getFormShowParameter().getCustomParam("taxPayerType");
        if ("zzsybnsr_yz_zjg".equals(taxPayerType)) {
            Object prelevyrate = this.getView().getFormShowParameter().getCustomParam("prelevyrate");
            if ("3".equals(prelevyrate)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"taxassigntable", "taxapportiontable"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"taxapportiontable3"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"taxassigntable", "taxapportiontable3"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"taxapportiontable"});
            }
        } else if ("zzsybnsr_hz_zjg".equals(taxPayerType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap51", "taxassigntable", "taxapportiontable", "taxapportiontable3"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"taxapportiontable", "taxapportiontable3"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"taxassigntable"});
        }
        String refresh = (String)this.getView().getFormShowParameter().getCustomParam("refresh");
        String draftPurpose = (String)this.getView().getFormShowParameter().getCustomParam("draftpurpose");
        this.refreshData(this.getView().getFormShowParameter().getCustomParams(), refresh, draftPurpose);
        if ("sjjt".equals(draftPurpose)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"taxassigntable", "taxapportiontable", "taxapportiontable3"});
        }
        this.showFormInnerTabPage(tab.getCurrentTab());
        this.showRiskControl(this.getView().getFormShowParameter().getCustomParams());
    }

    private void refreshData(Map<String, Object> customParams, String refresh, String draftPurpose) {
        String orgId = (String)customParams.get("orgid");
        String startdate = (String)customParams.get("skssqq");
        String enddate = (String)customParams.get("skssqz");
        String templateType = (String)customParams.get("templatetype");
        if (StringUtil.isNotBlank((CharSequence)refresh) && refresh.equals("true")) {
            String taxPayerType = (String)customParams.get("taxPayerType");
            String prelevyrate = (String)customParams.get("prelevyrate");
            this.draftDto.setOrgId(StringUtils.isBlank((CharSequence)orgId) ? 0L : Long.parseLong(orgId));
            this.draftDto.setStartDate(DateUtils.stringToDate2((String)startdate));
            this.draftDto.setStartDate(DateUtils.stringToDate2((String)enddate));
            this.draftDto.setTaxPayerType(taxPayerType);
            this.draftDto.setPrelevyrate(prelevyrate);
            TcvatStrategy strategy = TcvatDraftService.getStrategy(this.draftDto);
            try {
                strategy.calculate(orgId, startdate, enddate, templateType, this.getCache());
            }
            catch (Exception e) {
                LOGGER.error("TcvatZlbYbnsrYbhzPlugin -> \u5237\u65b0\u603b\u89c8\u8868\u51fa\u9519", (Throwable)e);
            }
        } else {
            String zlbsbbTemplateType = null;
            if ("nssb".equals(draftPurpose)) {
                zlbsbbTemplateType = "draft_zzsybnsr_ybhz";
            } else if ("sjjt".equals(draftPurpose)) {
                zlbsbbTemplateType = "draft_zzsybnsr_ybhz_sjjt";
            }
            if (zlbsbbTemplateType != null) {
                List tctrcResult = new DeclareService().queryTctrcResult(orgId, zlbsbbTemplateType, startdate, enddate);
                String sbbid = "0";
                String draftId = (String)customParams.get("draftId");
                this.draftService.saveRiskItem(DraftService.getDraftTable((String)draftPurpose), draftId, sbbid, null, tctrcResult, 1);
            }
        }
    }

    public void showRiskControl(Map<String, Object> customParams) {
        String draftPurpose = (String)customParams.get("draftpurpose");
        String orgId = (String)customParams.get("orgid");
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (orgId != null && !"null".equals(orgId)) {
            String draftId = (String)customParams.get("draftId");
            Map riskInfo = this.draftService.queryRiskInfo(draftId, DraftService.getDraftTable((String)draftPurpose));
            if (riskInfo != null) {
                List checkFormulaList = riskInfo.getOrDefault("riskwarning", new ArrayList());
                List tctrcwarningList = riskInfo.getOrDefault("tctrcwarning", new ArrayList());
                map.put("riskwarning", checkFormulaList);
                map.put("tctrcwarning", tctrcwarningList);
                boolean isnothaslicense = LicenseCheckServiceHelper.check((Object)orgId, null, (String)"tctrc");
                map.put("haslicense", isnothaslicense ? "0" : "1");
            }
        } else {
            map.put("riskwarning", new ArrayList());
        }
        map.put("timeMillis", System.currentTimeMillis());
        map.put("onlyRiskWarning", "1");
        CustomControl control = (CustomControl)this.getControl(CUSTOM_CONTROL);
        control.setData(map);
    }

    private IPageCache getCache() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String parentpageId = (String)customParams.get("rootPageId");
        if (StringUtils.isNotEmpty((CharSequence)parentpageId)) {
            IFormView parentView = this.getView().getView(parentpageId);
            IPageCache f = (IPageCache)parentView.getService(IPageCache.class);
            return f;
        }
        return this.getPageCache();
    }

    public void clientCallBack(ClientCallBackEvent e) {
        QFilter filter;
        IPageCache pageCache = this.getCache();
        Map dataResult = CacheUtils.getInstance().getDataResult(pageCache);
        if (dataResult == null || dataResult.isEmpty()) {
            FormShowParameter upStepParameter = this.getView().getFormShowParameter();
            Object draftpurpose = this.getView().getFormShowParameter().getCustomParams().get("draftpurpose");
            String templateType = "draft_zzsybnsr_ybhz";
            if ("sjjt".equals(draftpurpose)) {
                templateType = "draft_zzsybnsr_ybhz_sjjt";
            }
            String originaltype = (String)this.getView().getFormShowParameter().getCustomParams().get("templatetype");
            pageCache.put("originaltype", originaltype);
            dataResult = FormulaService.query((IPageCache)pageCache, (String)templateType, (String)((String)upStepParameter.getCustomParam("orgid")), (String)((String)upStepParameter.getCustomParam("skssqq")), (String)((String)upStepParameter.getCustomParam("skssqz")), (boolean)false);
            CacheUtils.getInstance().setDataAndOrginalResult(pageCache, dataResult);
        }
        BigDecimal xsehj = ZlbService.calcTotalAmount(dataResult, "tcvat_zlb_zzsybnsr_ybhz#5#ybxm", "tcvat_zlb_zzsybnsr_ybhz#5#jzjtxm");
        this.getModel().setValue("xsehj", (Object)xsehj);
        this.getModel().setValue("xxsehj", (Object)ZlbService.calcTotalAmount(dataResult, "tcvat_zlb_zzsybnsr_ybhz#8#ybxm", "tcvat_zlb_zzsybnsr_ybhz#8#jzjtxm"));
        this.getModel().setValue("jxsehj", (Object)ZlbService.calcTotalAmount(dataResult, "tcvat_zlb_zzsybnsr_ybhz#9#ybxm", "tcvat_zlb_zzsybnsr_ybhz#9#jzjtxm"));
        this.getModel().setValue("jxsezc", (Object)ZlbService.calcTotalAmount(dataResult, "tcvat_zlb_zzsybnsr_ybhz#10#ybxm", "tcvat_zlb_zzsybnsr_ybhz#10#jzjtxm"));
        this.getModel().setValue("jjdjse", (Object)ZlbService.calcTotalAmount(dataResult, "tcvat_zlb_zzsybnsr_ybhz#19#ybxm", "tcvat_zlb_zzsybnsr_ybhz#19#jzjtxm"));
        this.getModel().setValue("jzse", (Object)ZlbService.calcTotalAmount(dataResult, "tcvat_zlb_zzsybnsr_ybhz#24#ybxm", "tcvat_zlb_zzsybnsr_ybhz#24#jzjtxm"));
        BigDecimal ynse = ZlbService.calcTotalAmount(dataResult, "tcvat_zlb_zzsybnsr_ybhz#29#ybxm", "tcvat_zlb_zzsybnsr_ybhz#29#jzjtxm");
        this.getModel().setValue("ynse", (Object)ynse);
        if (xsehj.intValue() != 0) {
            BigDecimal sfl = BigDecimalUtil.divideObject((Object)ynse.multiply(new BigDecimal(100)), (Object)xsehj, (int)2);
            this.getModel().setValue("sfl", (Object)(sfl.toPlainString() + "%"));
        } else {
            this.getModel().setValue("sfl", (Object)"0.00%");
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        if ("3".equals(pageCache.get("prelevyrate"))) {
            filter = new QFilter("org", "=", (Object)orgid).and(new QFilter("startdate", "=", (Object)skssqq)).and(new QFilter("enddate", "=", (Object)skssqz));
            DynamicObjectCollection list = QueryServiceHelper.query((String)TCVAT_ZLB_YZ_APPORTION, (String)"suborg,levelname,declaretype,normaltaxsale,normaltaxamount,simpletaxamount,totaltaxamount", (QFilter[])new QFilter[]{filter}, (String)"declaretype desc");
            if (null != list) {
                BigDecimal zjgTax = BigDecimal.ZERO;
                BigDecimal fzTax = BigDecimal.ZERO;
                for (DynamicObject obj : list) {
                    if ("2".equals(obj.getString("declaretype"))) {
                        zjgTax = zjgTax.add(obj.getBigDecimal("totaltaxamount").setScale(2, 4));
                        continue;
                    }
                    fzTax = fzTax.add(obj.getBigDecimal("totaltaxamount").setScale(2, 4));
                }
                this.getModel().setValue("zjg", (Object)zjgTax);
                this.getModel().setValue("fzjg", (Object)fzTax);
            }
        } else if ("1".equals(pageCache.get("prelevyrate")) || "2".equals(pageCache.get("prelevyrate"))) {
            filter = new QFilter("org", "=", (Object)orgid).and(new QFilter("startdate", "=", (Object)skssqq)).and(new QFilter("enddate", "=", (Object)skssqz));
            BigDecimal ynsehj = ZlbService.calcTotalAmount(dataResult, "tcvat_zlb_zzsybnsr_ybhz#29#ybxm", "tcvat_zlb_zzsybnsr_ybhz#29#jzjtxm");
            DynamicObject yzseObj = QueryServiceHelper.queryOne((String)TCVAT_ZLB_APPORTBILL, (String)"sum(ynse) as yzse", (QFilter[])new QFilter[]{filter});
            BigDecimal fjg = BigDecimal.ZERO;
            if (yzseObj != null) {
                fjg = yzseObj.getBigDecimal("yzse");
            }
            BigDecimal zjg = ynsehj.subtract(fjg);
            this.getModel().setValue("zjg", (Object)zjg);
            this.getModel().setValue("fzjg", (Object)fjg);
        } else {
            QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
            QFilter SkssqFilter = new QFilter("startdate", "=", (Object)skssqq).and(new QFilter("enddate", "=", (Object)skssqz));
            DynamicObject[] assignCollection = BusinessDataServiceHelper.load((String)"tcvat_ybhz_zlb_jgfpb", (String)"id,org,xssr,fpbl,fpse,jzjtxssr,jzjtfpbl,jzjtfpse,ysfwxssr,ysfwfpbl,ysfwfpse,ysfwjzjtxssr,ysfwjzjtfpbl,ysfwjzjtfpse,pbsehj,suborgname,startdate,enddate,suborg,declaration,seqx", (QFilter[])new QFilter[]{orgFilter, SkssqFilter});
            BigDecimal[] zjg = new BigDecimal[]{BigDecimal.ZERO};
            BigDecimal[] fzjg = new BigDecimal[]{BigDecimal.ZERO};
            Arrays.stream(assignCollection).forEach(a -> {
                if ("2".equals(a.getString("declaration"))) {
                    zjg[0] = zjg[0].add(a.getBigDecimal("fpse").add(a.getBigDecimal("jzjtfpse")).add(a.getBigDecimal("ysfwfpse")).add(a.getBigDecimal("ysfwjzjtfpse")));
                } else {
                    fzjg[0] = fzjg[0].add(a.getBigDecimal("fpse").add(a.getBigDecimal("jzjtfpse")).add(a.getBigDecimal("ysfwfpse")).add(a.getBigDecimal("ysfwjzjtfpse")));
                }
            });
            this.getModel().setValue("zjg", (Object)zjg[0]);
            this.getModel().setValue("fzjg", (Object)fzjg[0]);
        }
        String draftpurpose = (String)this.getView().getFormShowParameter().getCustomParam("draftpurpose");
        if (!"true".equals(this.getView().getFormShowParameter().getCustomParam("readonly")) && "sjjt".equals(draftpurpose)) {
            String templatetype = (String)this.getView().getFormShowParameter().getCustomParam("templatetype");
            BigDecimal jtynsesum = ZlbService.calcHzSjjtYnseSum(dataResult);
            String orgidStr = (String)this.getView().getFormShowParameter().getCustomParam("orgid");
            String skssqqStr = (String)this.getView().getFormShowParameter().getCustomParam("skssqq");
            String skssqzStr = (String)this.getView().getFormShowParameter().getCustomParam("skssqz");
            ZlbService.updateJtynse(draftpurpose, templatetype, jtynsesum, orgidStr, skssqqStr, skssqzStr);
        }
        this.showRiskControl(this.getView().getFormShowParameter().getCustomParams());
    }
}

